/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation;

import com.sun.javafx.animation.Interpolator;
import com.sun.javafx.animation.TimingTarget;
import com.sun.scenario.ToolkitAccessor;
import com.sun.scenario.animation.AbstractMasterTimer;
import com.sun.scenario.animation.Animation;
import com.sun.scenario.animation.Interpolators;
import com.sun.scenario.animation.RunQueue;
import com.sun.scenario.animation.Schedule;
import com.sun.scenario.animation.ScheduledAnimation;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Clip
extends Animation
implements com.sun.javafx.animation.Clip {
    private ArrayList<TimingTarget> targets = new ArrayList();
    private Animation.Status desiredStatus = Animation.Status.STOPPED;
    private float repeatCount = 1.0f;
    private RepeatBehavior repeatBehavior = RepeatBehavior.REVERSE;
    private EndBehavior endBehavior = EndBehavior.HOLD;
    private long duration;
    private int resolution;
    private long lastPulse;
    private Interpolator interpolator = Interpolators.getEasingInstance();
    private boolean autoReverse;
    private Direction direction;
    private long offsetT;
    private long lastElapsed;
    private boolean offsetValid;
    private Schedule relBegin;
    private Schedule relEnd;

    private void validateRepeatCount(float f) {
        if (f < 0.0f && f != -1.0f) {
            throw new IllegalArgumentException("repeatCount (" + f + ") cannot be < 0");
        }
    }

    public static Clip create(long l, TimingTarget timingTarget) {
        return new Clip(l, 1.0f, timingTarget);
    }

    public static Clip create(long l, float f, TimingTarget timingTarget) {
        return new Clip(l, f, timingTarget);
    }

    Clip(long l, float f, TimingTarget timingTarget) {
        this.validateRepeatCount(f);
        this.duration = l;
        this.repeatCount = f;
        this.resolution = ToolkitAccessor.getMasterTimer().PULSE_DURATION;
        this.addTarget(timingTarget);
    }

    public Direction getDirection() {
        return this.direction != null ? this.direction : Direction.FORWARD;
    }

    private boolean isReverse() {
        return this.direction == Direction.REVERSE;
    }

    public boolean isAutoReverse() {
        return this.autoReverse;
    }

    public void setAutoReverse(boolean bl) {
        this.throwExceptionIfRunning();
        this.autoReverse = bl;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    @Override
    public void setInterpolator(Interpolator interpolator) {
        this.throwExceptionIfRunning();
        this.interpolator = interpolator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTarget(TimingTarget timingTarget) {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            if (!this.targets.contains(timingTarget)) {
                this.targets.add(timingTarget);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTarget(TimingTarget timingTarget) {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            this.targets.remove(timingTarget);
        }
    }

    public int getResolution() {
        return this.resolution;
    }

    @Override
    public void setResolution(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("resolution must be >= 0");
        }
        this.throwExceptionIfRunning();
        this.resolution = n;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long l) {
        this.throwExceptionIfRunning();
        this.duration = l;
    }

    public float getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(float f) {
        this.validateRepeatCount(f);
        this.throwExceptionIfRunning();
        this.repeatCount = f;
    }

    public RepeatBehavior getRepeatBehavior() {
        return this.repeatBehavior;
    }

    public void setRepeatBehavior(RepeatBehavior repeatBehavior) {
        this.throwExceptionIfRunning();
        this.repeatBehavior = repeatBehavior != null ? repeatBehavior : RepeatBehavior.REVERSE;
    }

    public EndBehavior getEndBehavior() {
        return this.endBehavior;
    }

    public void setEndBehavior(EndBehavior endBehavior) {
        this.throwExceptionIfRunning();
        this.endBehavior = endBehavior;
    }

    public void addBeginAnimation(Animation animation) {
        this.addBeginAnimation(animation, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBeginAnimation(Animation animation, long l) {
        Schedule schedule;
        this.throwExceptionIfRunning();
        Schedule schedule2 = schedule = this.getRelBegin();
        synchronized (schedule2) {
            schedule.insert(animation, l);
        }
    }

    private synchronized Schedule getRelBegin() {
        if (this.relBegin == null) {
            this.relBegin = new Schedule();
        }
        return this.relBegin;
    }

    public Iterable<Animation> beginAnimations() {
        return this.getRelBegin().animations(this);
    }

    public Iterable<? extends ScheduledAnimation> beginEntries() {
        return this.getRelBegin().entries(this);
    }

    void scheduleBeginAnimations(long l) {
        if (this.relBegin != null) {
            this.relBegin.scheduleRelativeTo(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBeginAnimation(Animation animation) {
        this.throwExceptionIfRunning();
        if (this.relBegin != null) {
            Schedule schedule = this.relBegin;
            synchronized (schedule) {
                this.relBegin.remove(animation);
            }
        }
    }

    public void addEndAnimation(Animation animation) {
        this.addEndAnimation(animation, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEndAnimation(Animation animation, long l) {
        Schedule schedule;
        this.throwExceptionIfRunning();
        Schedule schedule2 = schedule = this.getRelEnd();
        synchronized (schedule2) {
            schedule.insert(animation, l);
        }
    }

    private synchronized Schedule getRelEnd() {
        if (this.relEnd == null) {
            this.relEnd = new Schedule();
        }
        return this.relEnd;
    }

    public Iterable<Animation> endAnimations() {
        return this.getRelEnd().animations(this);
    }

    public Iterable<? extends ScheduledAnimation> endEntries() {
        return this.getRelEnd().entries(this);
    }

    void scheduleEndAnimations(long l) {
        if (this.relEnd != null) {
            this.relEnd.scheduleRelativeTo(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEndAnimation(Animation animation) {
        this.throwExceptionIfRunning();
        if (this.relEnd != null) {
            Schedule schedule = this.relEnd;
            synchronized (schedule) {
                this.relEnd.remove(animation);
            }
        }
    }

    @Override
    void scheduleTo(long l, long l2, RunQueue runQueue) {
        this.throwExceptionIfRunning();
        runQueue.insert(this, l);
    }

    void runTo(long l, long l2, RunQueue runQueue) {
        this.begin();
        if (this.relBegin != null) {
            this.relBegin.transferUpTo(l, l2, runQueue);
        }
        this.desiredStatus = Animation.Status.RUNNING;
        Animation.Status status = this.timePulse(l2 - l);
        this.desiredStatus = Animation.Status.STOPPED;
        if (status == Animation.Status.STOPPED) {
            this.stop();
            if (this.relEnd != null) {
                long l3 = l + (long)((double)this.getDuration() * (double)this.getRepeatCount());
                this.relEnd.transferUpTo(l3, l2, runQueue);
            }
        }
    }

    @Override
    void startAt(long l) {
        if (!this.autoReverse) {
            this.throwExceptionIfRunning();
        }
        this.desiredStatus = Animation.Status.RUNNING;
        AbstractMasterTimer.addToRunQueue(this, l);
    }

    @Override
    public void start() {
        if (this.autoReverse) {
            this.offsetValid = false;
            Direction direction = this.direction = this.direction == null ? Direction.FORWARD : this.direction.opposite();
            if (!this.isRunning()) {
                if (this.direction == Direction.REVERSE) {
                    long l = this.duration;
                    double d = this.repeatCount;
                    this.offsetT = l == -1L || d == -1.0 ? Long.MAX_VALUE : (long)((double)l * d);
                    this.offsetValid = true;
                } else {
                    this.offsetT = 0L;
                }
                this.lastElapsed = 0L;
                super.start();
            }
        } else {
            super.start();
        }
    }

    @Override
    public boolean isRunning() {
        if (this.desiredStatus == Animation.Status.RUNNING) {
            return true;
        }
        if (this.relBegin != null) {
            for (Schedule schedule : this.relBegin) {
                if (!((Animation)schedule.getAnimation()).isRunning()) continue;
                return true;
            }
        }
        if (this.relEnd != null) {
            for (Schedule schedule : this.relEnd) {
                if (!((Animation)schedule.getAnimation()).isRunning()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void stop() {
        this.desiredStatus = Animation.Status.STOPPED;
        AbstractMasterTimer.stop(this);
    }

    @Override
    public void cancel() {
        this.desiredStatus = Animation.Status.CANCELED;
        AbstractMasterTimer.removeFromRunQueue(this);
        if (this.relBegin != null) {
            for (Schedule schedule : this.relBegin) {
                ((Animation)schedule.getAnimation()).cancel();
            }
        }
        if (this.relEnd != null) {
            for (Schedule schedule : this.relEnd) {
                ((Animation)schedule.getAnimation()).cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        boolean bl = AbstractMasterTimer.pause(this);
        if (bl) {
            ArrayList<TimingTarget> arrayList = this.targets;
            synchronized (arrayList) {
                for (int i = 0; i < this.targets.size(); ++i) {
                    TimingTarget timingTarget = this.targets.get(i);
                    timingTarget.pause();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        boolean bl = AbstractMasterTimer.resume(this);
        if (bl) {
            ArrayList<TimingTarget> arrayList = this.targets;
            synchronized (arrayList) {
                for (int i = 0; i < this.targets.size(); ++i) {
                    TimingTarget timingTarget = this.targets.get(i);
                    timingTarget.resume();
                }
            }
        }
    }

    public long getLastPulse() {
        return this.lastPulse;
    }

    @Override
    Animation.Status timePulse(long l) {
        this.lastPulse = l / (long)this.resolution * (long)this.resolution;
        if (this.desiredStatus != Animation.Status.RUNNING) {
            return this.desiredStatus;
        }
        if (this.autoReverse) {
            if (!this.offsetValid) {
                this.offsetT = this.isReverse() ? l + this.lastElapsed : l - this.lastElapsed;
                this.offsetValid = true;
            }
            l = this.isReverse() ? this.offsetT - l : (l -= this.offsetT);
        }
        if (this.isReverse()) {
            if (l <= 0L) {
                l = 0L;
                this.desiredStatus = Animation.Status.STOPPED;
            }
        } else {
            long l2;
            long l3 = this.duration;
            double d = this.repeatCount;
            if (l3 != -1L && d != -1.0 && l >= (l2 = (long)((double)l3 * d))) {
                l = l2;
                this.desiredStatus = Animation.Status.STOPPED;
            }
        }
        this.lastElapsed = l;
        this.process(l);
        return this.desiredStatus;
    }

    private void process(long l) {
        float f;
        if (this.duration == -1L) {
            f = 0.0f;
        } else if (this.duration == 0L) {
            f = 1.0f;
        } else {
            double d = (double)l / (double)this.duration;
            if (this.repeatBehavior == RepeatBehavior.REVERSE) {
                if ((d %= 2.0) > 1.0) {
                    d = 2.0 - d;
                }
            } else {
                d %= 1.0;
            }
            f = (float)d;
        }
        f = this.interpolator.interpolate(f);
        this.fireTimingEvent(f, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTimingEvent(float f, long l) {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            for (int i = 0; i < this.targets.size(); ++i) {
                TimingTarget timingTarget = this.targets.get(i);
                timingTarget.timingEvent(f, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void begin() {
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            for (int i = 0; i < this.targets.size(); ++i) {
                TimingTarget timingTarget = this.targets.get(i);
                timingTarget.begin();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void end() {
        float f = this.isReverse() ? 1.0f : 0.0f;
        long l = (long)((double)this.duration * (double)this.repeatCount);
        ArrayList<TimingTarget> arrayList = this.targets;
        synchronized (arrayList) {
            for (int i = 0; i < this.targets.size(); ++i) {
                TimingTarget timingTarget = this.targets.get(i);
                if (this.endBehavior == EndBehavior.RESET) {
                    timingTarget.timingEvent(f, l);
                }
                timingTarget.end();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        FORWARD,
        REVERSE;


        Direction opposite() {
            return this == FORWARD ? REVERSE : FORWARD;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EndBehavior {
        HOLD,
        RESET;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RepeatBehavior {
        LOOP,
        REVERSE;

    }
}

