/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.CoreEffect;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FloatMap;

public class DisplacementMap
extends CoreEffect {
    private FloatMap mapData;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float offsetX = -0.5f;
    private float offsetY = -0.5f;
    private boolean wrap;

    public DisplacementMap(FloatMap floatMap) {
        this(floatMap, DefaultInput);
    }

    public DisplacementMap(FloatMap floatMap, Effect effect) {
        super(effect);
        this.setMapData(floatMap);
        this.updatePeerKey("DisplacementMap");
    }

    public final FloatMap getMapData() {
        return this.mapData;
    }

    public void setMapData(FloatMap floatMap) {
        if (floatMap == null) {
            throw new IllegalArgumentException("Map data must be non-null");
        }
        FloatMap floatMap2 = this.mapData;
        this.mapData = floatMap;
        this.firePropertyChange("mapData", floatMap2, floatMap);
    }

    public final Effect getContentInput() {
        return this.getInputs().get(0);
    }

    public void setContentInput(Effect effect) {
        this.setInput(0, effect);
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float f) {
        float f2 = this.scaleX;
        this.scaleX = f;
        this.firePropertyChange("scaleX", Float.valueOf(f2), Float.valueOf(f));
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float f) {
        float f2 = this.scaleY;
        this.scaleY = f;
        this.firePropertyChange("scaleY", Float.valueOf(f2), Float.valueOf(f));
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(float f) {
        float f2 = this.offsetX;
        this.offsetX = f;
        this.firePropertyChange("offsetX", Float.valueOf(f2), Float.valueOf(f));
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(float f) {
        float f2 = this.offsetY;
        this.offsetY = f;
        this.firePropertyChange("offsetY", Float.valueOf(f2), Float.valueOf(f));
    }

    public boolean getWrap() {
        return this.wrap;
    }

    public void setWrap(boolean bl) {
        boolean bl2 = this.wrap;
        this.wrap = bl;
        this.firePropertyChange("wrap", bl2, bl);
    }

    public boolean operatesInUserSpace() {
        return true;
    }

    public Point2D transform(Point2D point2D, Effect effect) {
        return new Point2D(Float.NaN, Float.NaN);
    }

    public Point2D untransform(Point2D point2D, Effect effect) {
        Bounds2D bounds2D = this.getBounds(BaseTransform.IDENTITY_TRANSFORM, effect);
        float f = bounds2D.getWidth();
        float f2 = bounds2D.getHeight();
        float f3 = (point2D.x - bounds2D.x1) / f;
        float f4 = (point2D.y - bounds2D.y1) / f2;
        if (f3 >= 0.0f && f4 >= 0.0f && f3 < 1.0f && f4 < 1.0f) {
            int n = (int)(f3 * (float)this.mapData.getWidth());
            int n2 = (int)(f4 * (float)this.mapData.getHeight());
            float f5 = this.mapData.getSample(n, n2, 0);
            float f6 = this.mapData.getSample(n, n2, 1);
            f3 += this.scaleX * (f5 + this.offsetX);
            f4 += this.scaleY * (f6 + this.offsetY);
            if (this.wrap) {
                f3 = (float)((double)f3 - Math.floor(f3));
                f4 = (float)((double)f4 - Math.floor(f4));
            }
            point2D = new Point2D(f3 * f + bounds2D.x1, f4 * f2 + bounds2D.y1);
        }
        return this.getDefaultedInput(0, effect).untransform(point2D, effect);
    }
}

