/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.hw.d3d;

import com.sun.scenario.effect.impl.BufferUtil;
import com.sun.scenario.effect.impl.hw.Shader;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class D3DShader
implements Shader {
    private static IntBuffer itmp;
    private static FloatBuffer ftmp;
    private long pData;
    private final Map<String, Integer> registers;
    private boolean valid;

    D3DShader(long l, ByteBuffer byteBuffer, Map<String, Integer> map) {
        this.pData = D3DShader.init(l, byteBuffer);
        this.valid = this.pData != 0L;
        this.registers = map;
    }

    private static native long init(long var0, ByteBuffer var2);

    private static native long enable(long var0);

    private static native long disable(long var0);

    private static native long dispose(long var0);

    private static native long setConstantsF(long var0, int var2, FloatBuffer var3, int var4, int var5);

    private static native long setConstantsI(long var0, int var2, IntBuffer var3, int var4, int var5);

    @Override
    public void enable() {
        this.valid &= D3DShader.enable(this.pData) >= 0L;
    }

    @Override
    public void disable() {
        this.valid &= D3DShader.disable(this.pData) >= 0L;
    }

    private static void checkTmpIntBuf() {
        if (itmp == null) {
            itmp = BufferUtil.newIntBuffer(4);
        }
        itmp.clear();
    }

    @Override
    public void setConstant(String string, int n) {
        this.setConstant(string, (float)n);
    }

    @Override
    public void setConstant(String string, int n, int n2) {
        this.setConstant(string, (float)n, (float)n2);
    }

    @Override
    public void setConstant(String string, int n, int n2, int n3) {
        this.setConstant(string, (float)n, (float)n2, (float)n3);
    }

    @Override
    public void setConstant(String string, int n, int n2, int n3, int n4) {
        this.setConstant(string, (float)n, (float)n2, (float)n3, (float)n4);
    }

    @Override
    public void setConstants(String string, IntBuffer intBuffer, int n, int n2) {
        throw new InternalError("Not yet implemented");
    }

    private static void checkTmpFloatBuf() {
        if (ftmp == null) {
            ftmp = BufferUtil.newFloatBuffer(4);
        }
        ftmp.clear();
    }

    @Override
    public void setConstant(String string, float f) {
        D3DShader.checkTmpFloatBuf();
        ftmp.put(f);
        this.setConstants(string, ftmp, 0, 1);
    }

    @Override
    public void setConstant(String string, float f, float f2) {
        D3DShader.checkTmpFloatBuf();
        ftmp.put(f);
        ftmp.put(f2);
        this.setConstants(string, ftmp, 0, 1);
    }

    @Override
    public void setConstant(String string, float f, float f2, float f3) {
        D3DShader.checkTmpFloatBuf();
        ftmp.put(f);
        ftmp.put(f2);
        ftmp.put(f3);
        this.setConstants(string, ftmp, 0, 1);
    }

    @Override
    public void setConstant(String string, float f, float f2, float f3, float f4) {
        D3DShader.checkTmpFloatBuf();
        ftmp.put(f);
        ftmp.put(f2);
        ftmp.put(f3);
        ftmp.put(f4);
        this.setConstants(string, ftmp, 0, 1);
    }

    @Override
    public void setConstants(String string, FloatBuffer floatBuffer, int n, int n2) {
        this.valid &= D3DShader.setConstantsF(this.pData, this.getRegister(string), floatBuffer, n, n2) >= 0L;
    }

    private int getRegister(String string) {
        Integer n = this.registers.get(string);
        if (n == null) {
            throw new IllegalArgumentException("Register not found for: " + string);
        }
        return n;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void dispose() {
        if (this.pData != 0L) {
            D3DShader.dispose(this.pData);
            this.pData = 0L;
        }
        this.valid = false;
    }
}

