/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.scenegraph;

import com.sun.embeddedswing.EmbeddedToolkit;
import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.Settings;
import com.sun.scenario.animation.AnimationPulse;
import com.sun.scenario.scenegraph.JSGPanelRepainter;
import com.sun.scenario.scenegraph.SGComponent;
import com.sun.scenario.scenegraph.SGGroup;
import com.sun.scenario.scenegraph.SGNode;
import com.sun.scenario.utils.Utils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class JSGPanel
extends JComponent {
    private static final boolean incrementalRepaintOpt;
    private static final Logger fpsLog;
    private static final String TRACKFPS_PROP = "com.sun.scenario.animation.trackfps";
    private static boolean trackFPS;
    private FPSData fpsData;
    private static PropertyChangeListener pcl;
    private static final boolean hiliteDirty = false;
    private SGNode scene = null;
    private boolean sceneIsNew = false;
    private SGGroup sceneGroup = null;
    private Dimension validatedPreferredSize = null;
    private WeakReference<SGComponent> popupRef = null;
    private Rectangle dmgrect;
    public static final Object VSYNC_ENABLED_KEY;
    private final HierarchyListener hierarchyListener = new HierarchyListener(){

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            Component component = null;
            if ((hierarchyEvent.getChangeFlags() & 1L) != 0L && (Boolean.TRUE.equals(JSGPanel.this.getClientProperty(VSYNC_ENABLED_KEY)) || Settings.getBoolean("com.sun.scenario.animation.vsync")) && !Settings.getBoolean("com.sun.scenario.animation.fullspeed") && !EmbeddedToolkit.isEmbedded(JSGPanel.this) && (component = SwingUtilities.getRoot(JSGPanel.this)) != null) {
                try {
                    setVsyncRequested_METHOD.invoke((Object)SwingUtilities3_CLASS, component, Boolean.TRUE);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
    };
    private static final Class<?> SwingUtilities3_CLASS;
    private static final Method setVsyncRequested_METHOD;

    public JSGPanel() {
        this.setOpaque(true);
        this.initVsyncedPainting();
    }

    public final SGGroup getSceneGroup() {
        return this.sceneGroup;
    }

    public final SGNode getScene() {
        return this.scene;
    }

    void removeScene() {
        this.scene = null;
        this.sceneGroup = null;
        this.fpsData = null;
        this.markDirty();
    }

    public void setScene(SGNode sGNode) {
        SGGroup sGGroup;
        JSGPanel jSGPanel = sGNode.getPanel();
        if (jSGPanel != null && jSGPanel.getScene() == sGNode) {
            jSGPanel.removeScene();
        }
        if ((sGGroup = sGNode.getParent()) != null) {
            sGGroup.remove(sGNode);
        }
        if (trackFPS || fpsLog.isLoggable(Level.FINE)) {
            this.fpsData = new FPSData();
        }
        this.scene = sGNode;
        this.sceneIsNew = true;
        this.sceneGroup = new SGGroup();
        this.sceneGroup.add(-1, sGNode);
        this.sceneGroup.setParent(this);
        this.markDirty();
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets insets = this.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        SGNode sGNode = this.getScene();
        if (sGNode == null) {
            return new Dimension(n + 640, n2 + 480);
        }
        Bounds2D bounds2D = new Bounds2D();
        Affine2D affine2D = new Affine2D();
        sGNode.getCumulativeTransform(affine2D);
        sGNode.getClippedBounds(bounds2D, affine2D);
        int n3 = (int)Math.ceil(bounds2D.x2);
        int n4 = (int)Math.ceil(bounds2D.y2);
        return new Dimension(n + n3, n2 + n4);
    }

    public void doMouseEvent(MouseEvent mouseEvent) {
    }

    public SGComponent pickSGComponent(Point2D point2D) {
        SGComponent sGComponent = null;
        if (this.popupRef != null && (sGComponent = (SGComponent)this.popupRef.get()) != null && sGComponent.isVisible() && sGComponent.getPanel() == this) {
            com.sun.javafx.geom.Point2D point2D2 = new com.sun.javafx.geom.Point2D((float)point2D.getX(), (float)point2D.getY());
            com.sun.javafx.geom.Point2D point2D3 = new com.sun.javafx.geom.Point2D();
            sGComponent.globalToLocal(point2D2, point2D3);
            if (sGComponent.contains(point2D3.x, point2D3.y)) {
                return sGComponent;
            }
        }
        return null;
    }

    public void registerPopupNode(SGComponent sGComponent) {
        this.popupRef = new WeakReference<SGComponent>(sGComponent);
    }

    protected void paintBackground(Graphics graphics) {
        if (this.isOpaque()) {
            Graphics graphics2 = graphics.create();
            graphics2.setColor(this.getBackground());
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            }
            graphics2.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2.dispose();
        }
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D;
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        }
        if (!rectangle.isEmpty()) {
            graphics2D = (Graphics2D)graphics.create();
            this.paintBackground(graphics2D);
            SGGroup sGGroup = this.getSceneGroup();
            if (sGGroup != null) {
                AnimationPulse.getDefaultBean().recordScenePaintingStart();
                Bounds2D bounds2D = new Bounds2D(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                AffineTransform affineTransform = graphics2D.getTransform();
                Affine2D affine2D = new Affine2D(affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY(), affineTransform.getTranslateX(), affineTransform.getTranslateY());
                SGNode.transform(bounds2D, (BaseTransform)affine2D);
                graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                sGGroup.render(graphics2D, bounds2D, affine2D);
                AnimationPulse.getDefaultBean().recordScenePaintingEnd();
            }
            graphics2D.dispose();
        }
        if (this.dmgrect != null) {
            graphics2D = (Graphics2D)graphics.create();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
            graphics2D.setColor(Color.red);
            graphics2D.fillRect(this.dmgrect.x, this.dmgrect.y, this.dmgrect.width, this.dmgrect.height);
            graphics2D.dispose();
        }
    }

    private static void overflowSafeIntersect(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n = Math.max(rectangle.x, rectangle2.x);
        int n2 = Math.max(rectangle.y, rectangle2.y);
        long l = Math.min((long)rectangle.x + (rectangle.width == Integer.MAX_VALUE ? 0x1FFFFFFFCL : (long)rectangle.width), (long)rectangle2.x + (rectangle2.width == Integer.MAX_VALUE ? 0x1FFFFFFFCL : (long)rectangle2.width));
        long l2 = Math.min((long)rectangle.y + (rectangle.height == Integer.MAX_VALUE ? 0x1FFFFFFFCL : (long)rectangle.height), (long)rectangle2.y + (rectangle2.height == Integer.MAX_VALUE ? 0x1FFFFFFFCL : (long)rectangle2.height));
        long l3 = l - (long)n;
        int n3 = -1;
        if (l3 >= Integer.MAX_VALUE) {
            n3 = Integer.MAX_VALUE;
        } else if (l3 >= 0L) {
            n3 = (int)l3;
        }
        long l4 = l2 - (long)n2;
        int n4 = -1;
        if (l4 >= Integer.MAX_VALUE) {
            n4 = Integer.MAX_VALUE;
        } else if (l4 >= 0L) {
            n4 = (int)l4;
        }
        rectangle3.setBounds(n, n2, n3, n4);
    }

    final void repaintDirtyRegions(boolean bl) {
        if (this.getSceneGroup() != null && !this.getSceneGroup().isClean()) {
            Object object;
            Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            Rectangle rectangle2 = null;
            if (incrementalRepaintOpt) {
                object = new Bounds2D(0.0f, 0.0f, this.getWidth(), this.getHeight());
                rectangle2 = this.accumulateDirtyRegions((Bounds2D)object, new Affine2D());
                if (this.sceneIsNew) {
                    rectangle2 = rectangle;
                }
            } else {
                rectangle2 = rectangle;
            }
            this.sceneIsNew = false;
            if (rectangle2 != null) {
                JSGPanel.overflowSafeIntersect(rectangle2, rectangle, rectangle2);
                if (bl) {
                    AnimationPulse.getDefaultBean().recordPaintingStart();
                    this.paintImmediately(rectangle2);
                    AnimationPulse.getDefaultBean().recordPaintingEnd();
                } else {
                    this.repaint(rectangle2);
                }
                if (trackFPS || fpsLog.isLoggable(Level.FINE)) {
                    if (this.fpsData == null) {
                        this.fpsData = new FPSData();
                    }
                    this.fpsData.nextFrame();
                }
            }
            if (!this.isPreferredSizeSet() && !((Dimension)(object = this.getPreferredSize())).equals(this.validatedPreferredSize)) {
                this.validatedPreferredSize = object;
                this.revalidate();
            }
        }
    }

    protected void markDirty() {
        JSGPanelRepainter.getJSGPanelRepainter().addDirtyPanel(this);
    }

    private Rectangle accumulateDirtyRegions(Bounds2D bounds2D, BaseTransform baseTransform) {
        assert (this.getSceneGroup() != null);
        Bounds2D bounds2D2 = new Bounds2D();
        bounds2D2 = this.getSceneGroup().accumulateDirtyRegions(bounds2D, bounds2D2, baseTransform);
        if (bounds2D2 == null) {
            bounds2D2 = bounds2D;
        }
        return new Rectangle((int)bounds2D2.x1, (int)bounds2D2.y1, (int)Math.ceil(bounds2D2.getWidth()), (int)Math.ceil(bounds2D2.getHeight()));
    }

    public Icon toIcon() {
        return null;
    }

    public BufferedImage getIconImage() {
        return null;
    }

    private void initVsyncedPainting() {
        if (setVsyncRequested_METHOD != null) {
            this.addHierarchyListener(this.hierarchyListener);
        }
    }

    static {
        fpsLog = Logger.getLogger("com.sun.scenario.animation.fps");
        trackFPS = Settings.getBoolean(TRACKFPS_PROP, false);
        pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals(JSGPanel.TRACKFPS_PROP)) {
                    trackFPS = Settings.getBoolean(JSGPanel.TRACKFPS_PROP);
                }
            }
        };
        Object object = JSGPanel.class.getPackage().getName();
        incrementalRepaintOpt = !Settings.getBoolean((String)object + ".fullrepaint");
        Settings.addPropertyChangeListener(TRACKFPS_PROP, pcl);
        VSYNC_ENABLED_KEY = new StringBuilder("VSYNC_ENABLED_KEY");
        object = null;
        Method method = null;
        try {
            object = Utils.platformClassForName("com.sun.java.swing.SwingUtilities3", true);
            method = ((Class)object).getMethod("setVsyncRequested", Container.class, Boolean.TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method == null) {
            object = null;
        }
        SwingUtilities3_CLASS = object;
        setVsyncRequested_METHOD = method;
    }

    private class FPSData {
        private static final long PRINT_FREQ = 3000L;
        private long prevMillis = System.currentTimeMillis();
        private long frames = 0L;
        private float fps;

        public void nextFrame() {
            long l = System.currentTimeMillis();
            long l2 = l - this.prevMillis;
            if (l2 > 3000L) {
                float f = this.fps;
                this.fps = 1000.0f * (float)this.frames / (float)l2;
                if (fpsLog.isLoggable(Level.FINE)) {
                    String string = String.valueOf(this.fps);
                    String string2 = string.substring(0, Math.min(string.indexOf(46) + 3, string.length()));
                    fpsLog.log(Level.FINE, string2 + " FPS");
                }
                if (trackFPS) {
                    JSGPanel.this.firePropertyChange("fpsData", f, this.fps);
                }
                this.prevMillis = l;
                this.frames = 0L;
            } else {
                ++this.frames;
            }
        }
    }
}

