/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.scenegraph;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.PGImageView;
import com.sun.scenario.scenegraph.SGLeaf;
import com.sun.scenario.utils.Utils;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;

public class SGImage
extends SGLeaf
implements PGImageView {
    private Image image;
    private final Rectangle2D.Float dimension = new Rectangle2D.Float();
    private Rectangle2D.Float viewport = new Rectangle2D.Float();
    private Rectangle2D userViewport = null;
    private static final Object DEFAULT_HINT = Utils.isAtLeastJava6 ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
    private Object interpolationHint = DEFAULT_HINT;
    private boolean imageOpaque;
    private static BufferedImage hitBI;

    public static boolean getDefaultImageSmooth() {
        return DEFAULT_HINT != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
    }

    public void setImage(Object object) {
        this.setImage((Image)object);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        boolean bl = this.image != null && image != null ? image.getWidth(null) != this.image.getWidth(null) || image.getHeight(null) != this.image.getHeight(null) : true;
        this.image = image;
        if (this.userViewport == null) {
            if (this.image != null) {
                this.viewport.width = this.image.getWidth(null);
                this.viewport.height = this.image.getHeight(null);
            } else {
                this.viewport.width = 0.0f;
                this.viewport.height = 0.0f;
            }
        }
        this.imageOpaque = image instanceof BufferedImage ? !((BufferedImage)image).getColorModel().hasAlpha() : (image instanceof VolatileImage ? ((VolatileImage)image).getTransparency() == 1 : false);
        if (bl) {
            this.contentBoundsChanged(true);
        } else {
            this.visualsChanged(true);
        }
    }

    public boolean isSmooth() {
        return this.interpolationHint != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
    }

    public void setSmooth(boolean bl) {
        Object object;
        Object object2 = object = bl ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
        if (object != this.interpolationHint) {
            this.interpolationHint = object;
            this.visualsChanged(true);
        }
    }

    public void setViewport(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        float f7 = this.image != null ? (float)this.image.getWidth(null) : 0.0f;
        float f8 = this.image != null ? (float)this.image.getHeight(null) : 0.0f;
        float f9 = f;
        float f10 = f2;
        if (f5 > 0.0f && f6 > 0.0f) {
            f7 = f5;
            f8 = f6;
            this.viewport.x = f3;
            this.viewport.y = f4;
            this.viewport.width = f5;
            this.viewport.height = f6;
        } else {
            this.viewport.x = 0.0f;
            this.viewport.y = 0.0f;
            this.viewport.width = f7;
            this.viewport.height = f8;
        }
        if (f <= 0.0f && f2 <= 0.0f) {
            f9 = f7;
            f10 = f8;
        } else if (bl) {
            if ((double)f <= 0.0) {
                f9 = f8 > 0.0f ? f7 * (f2 / f8) : 0.0f;
                f10 = f2;
            } else if ((double)f2 <= 0.0) {
                f9 = f;
                f10 = f7 > 0.0f ? f8 * (f / f7) : 0.0f;
            } else {
                if (f7 == 0.0f) {
                    f7 = f;
                }
                if (f8 == 0.0f) {
                    f8 = f2;
                }
                float f11 = Math.min(f / f7, f2 / f8);
                f9 = f7 * f11;
                f10 = f8 * f11;
            }
        } else if ((double)f2 <= 0.0) {
            f10 = f8;
        } else if ((double)f <= 0.0) {
            f9 = f7;
        }
        if (f10 < 1.0f) {
            f10 = 1.0f;
        }
        if (f9 < 1.0f) {
            f9 = 1.0f;
        }
        this.setDimensions(f9, f10);
        this.contentBoundsChanged(true);
    }

    public void setX(float f) {
        if (f != this.dimension.x) {
            this.dimension.x = f;
            this.contentBoundsChanged(true);
        }
    }

    public void setY(float f) {
        if (f != this.dimension.y) {
            this.dimension.y = f;
            this.contentBoundsChanged(true);
        }
    }

    public void setDimensions(float f, float f2) {
        if (f <= 0.0f || f2 <= 0.0f) {
            throw new IllegalArgumentException("empty dimensions");
        }
        if (this.dimension.width != f || this.dimension.height != f2) {
            this.dimension.width = f;
            this.dimension.height = f2;
            this.contentBoundsChanged(true);
        }
    }

    public void paint(Graphics2D graphics2D, BaseTransform baseTransform) {
        if (this.image != null) {
            AffineTransform affineTransform;
            Object object;
            double d = this.dimension.getX();
            double d2 = this.dimension.getY();
            double d3 = this.viewport.width;
            double d4 = this.viewport.height;
            boolean bl = this.dimension.getWidth() > 0.0 && this.dimension.getHeight() > 0.0;
            boolean bl2 = bl && (d3 != this.dimension.getWidth() || d4 != this.dimension.getHeight());
            graphics2D = (Graphics2D)graphics2D.create();
            graphics2D.translate(d, d2);
            if (bl2 && d3 != 0.0 && d4 != 0.0) {
                double d5 = this.dimension.getWidth() / d3;
                double d6 = this.dimension.getHeight() / d4;
                graphics2D.scale(d5, d6);
            }
            if ((object = this.interpolationHint) != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR && (affineTransform = graphics2D.getTransform()).getType() <= 1) {
                object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            graphics2D.drawImage(this.image, 0, 0, (int)this.viewport.width, (int)this.viewport.height, (int)this.viewport.x, (int)this.viewport.y, (int)(this.viewport.x + this.viewport.width), (int)(this.viewport.y + this.viewport.height), null);
        }
    }

    public final Bounds2D computeBounds(Bounds2D bounds2D, BaseTransform baseTransform) {
        if (this.image == null) {
            bounds2D.setBounds(0.0f, 0.0f, 0.0f, 0.0f);
            return bounds2D;
        }
        float f = this.dimension.x;
        float f2 = this.dimension.y;
        boolean bl = this.dimension.getWidth() > 0.0 && this.dimension.getHeight() > 0.0;
        float f3 = bl ? this.dimension.width : this.viewport.width;
        float f4 = bl ? this.dimension.height : this.viewport.height;
        bounds2D.setBounds(f, f2, f + f3, f2 + f4);
        baseTransform.transform(bounds2D, bounds2D);
        return bounds2D;
    }

    private boolean imageContains(double d, double d2) {
        BufferedImage bufferedImage;
        boolean bl = this.dimension.width > 0.0f && this.dimension.height > 0.0f;
        float f = bl ? this.dimension.width : this.viewport.width;
        float f2 = bl ? this.dimension.height : this.viewport.height;
        d = (double)this.viewport.x + d * (double)this.viewport.width / (double)f;
        d2 = (double)this.viewport.y + d2 * (double)this.viewport.height / (double)f2;
        if (d < 0.0 || d2 < 0.0 || d >= (double)this.image.getWidth(null) || d2 >= (double)this.image.getHeight(null)) {
            return false;
        }
        if (this.imageOpaque) {
            return true;
        }
        int n = (int)d;
        int n2 = (int)d2;
        if (this.image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)this.image;
        } else {
            VolatileImage volatileImage;
            if (hitBI == null) {
                hitBI = new BufferedImage(1, 1, 2);
            }
            bufferedImage = hitBI;
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.drawImage(this.image, -n, -n2, null);
            if (this.image instanceof VolatileImage && (volatileImage = (VolatileImage)this.image).contentsLost()) {
                return false;
            }
            n = 0;
            n2 = 0;
        }
        return (bufferedImage.getRGB(n, n2) >> 24 & 0xFF) > 0;
    }

    public boolean computeContains(float f, float f2) {
        if (this.image == null) {
            return false;
        }
        if (super.computeContains(f, f2)) {
            return this.imageContains(f - this.cachedBounds.x1, f2 - this.cachedBounds.y1);
        }
        return false;
    }

    public boolean hasOverlappingContents() {
        return false;
    }
}

