/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.scenegraph;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.text.FontManager;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.sg.PGText;
import com.sun.scenario.paint.ProportionalPaint;
import com.sun.scenario.scenegraph.SGAbstractShape;
import com.sun.scenario.scenegraph.SGNode;
import com.sun.scenario.utils.Utils;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SGText
extends SGAbstractShape
implements PGText {
    private static Bounds2D TEMP_BOUNDS;
    private static Affine2D TEMP_TX;
    private static AffineTransform TEMP_AWT_TX;
    private static Point2D.Float temp;
    private static Font defaultFont;
    private static Object antialiasingHintDT;
    private static Object gammaHintDT;
    private static RenderingHints.Key gammaHintKey;
    private static DesktopAAHintsTracker hintsTracker;
    private static boolean useVB;
    private static Graphics2D g2dForMetrics;
    private static int notifyLayout;
    private static boolean nogridfitSupported;
    private static final Method FONT_HAS_LAYOUT_ATTRIBUTES;
    private static final RenderingHints.Key KEY_TEXT_LCD_CONTRAST;
    private static final Object VALUE_TEXT_ANTIALIAS_GASP;
    private static final Constructor FRC_CONSTRUCTOR;
    private static final Method FRC_GET_ANTI_ALIASING_HINT;
    private static final Method FRC_GET_FRACTIONAL_METRICS_HINT;
    private static final Method SG2D_GET_TRANSPARENCY;
    private static final Field SD_SURFACEDATA;
    private Font font = defaultFont;
    private String text;
    private final boolean overline = false;
    private boolean underline = false;
    private boolean strikethrough = false;
    private float wrappingWidth = 0.0f;
    private Object antialiasingHintApp = antialiasingHintDT;
    private final Point2D.Float location = new Point2D.Float();
    private VAlign verticalAlignment = VAlign.BASELINE;
    private HAlign horizontalAlignment = HAlign.LEFT;
    private boolean nogridfit = false;
    private boolean complexText;
    private boolean useLayout;
    private Shape cachedOutline;
    private FontRenderContext cachedFRC;
    private boolean rotatedFont;
    private TextLayout[] cachedLayouts;
    private Point2D.Float[] cachedPositions;
    private Integer[] lastIndices;
    private int[] eols;
    private float tabAdvance;
    private float maxAdvance;
    private Selection selection;
    private InputMethodText imtext;
    private static final int LOGICAL_BOUNDS = 0;
    private static final int VISUAL_BOUNDS = 1;
    private static final int LOGICAL_LAYOUT_BOUNDS = 2;
    int textBoundsType = 0;
    Bounds2D cachedLayoutBounds = new Bounds2D();

    @Override
    protected void geomChanged(boolean bl) {
        if (this.selection != null) {
            this.selection.validFillPaint = null;
            this.selection.validDrawPaint = null;
        }
        this.cachedLayoutBounds.invalidate();
        super.geomChanged(bl);
    }

    @Override
    protected Paint getRelativePaint(ProportionalPaint proportionalPaint) {
        this.updateBounds();
        double d = this.cachedBounds.x1;
        double d2 = this.cachedBounds.y1;
        double d3 = (double)this.cachedBounds.x2 - d;
        double d4 = (double)this.cachedBounds.y2 - d2;
        if (this.verticalAlignment != VAlign.BASELINE) {
            d2 -= (double)this.getYAdjustment(this.getFontRenderContext(BaseTransform.IDENTITY_TRANSFORM));
        }
        return proportionalPaint.getPaint(d, d2, d3, d4);
    }

    @Override
    public void setText(String string) {
        if (this.text == null && string != null || this.text != null && string == null || this.text != null && !this.text.equals(string)) {
            this.text = string;
            this.complexText = SGText.isComplexText(string);
            this.eols = SGText.getEols(string);
            this.flushCachedValues();
            this.updateUseLayout();
            this.geomChanged(true);
        }
    }

    @Override
    public void setFont(Object object) {
        if (object != this.font) {
            Font font;
            if (object == null) {
                throw new IllegalArgumentException("null font");
            }
            this.font = font = (Font)object;
            if (nogridfitSupported) {
                this.nogridfit = font.getFamily(Locale.ENGLISH).startsWith("Amble") || FontManager.getInstance().findPathByName(font.getFontName(Locale.ENGLISH)) != null;
            }
            this.flushCachedValues();
            this.rotatedFont = false;
            this.updateUseLayout();
            TransformAttribute transformAttribute = (TransformAttribute)font.getAttributes().get(TextAttribute.TRANSFORM);
            if (transformAttribute != null && !transformAttribute.isIdentity()) {
                AffineTransform affineTransform = transformAttribute.getTransform();
                this.rotatedFont = (affineTransform.getType() & 0x18) != 0;
            }
            this.geomChanged(true);
        }
    }

    @Override
    public void setLocation(float f, float f2) {
        if (f != this.location.x || f2 != this.location.y) {
            this.location.setLocation(f, f2);
            this.geomChanged(true);
        }
    }

    @Override
    public void setTextOrigin(int n) {
        VAlign vAlign = VAlign.values()[n];
        if (vAlign != this.verticalAlignment) {
            this.verticalAlignment = vAlign;
            this.flushCachedValues();
            this.updateUseLayout();
            this.geomChanged(true);
        }
    }

    @Override
    public void setWrappingWidth(float f) {
        if (f <= 0.0f || f == Float.MAX_VALUE) {
            f = 0.0f;
        }
        if (f != this.wrappingWidth) {
            this.wrappingWidth = f;
            this.flushCachedValues();
            this.updateUseLayout();
            this.geomChanged(true);
        }
    }

    @Override
    public void setUnderline(boolean bl) {
        if (bl != this.underline) {
            this.underline = bl;
            this.flushCachedValues();
            this.updateUseLayout();
            this.geomChanged(true);
        }
    }

    @Override
    public void setStrikethrough(boolean bl) {
        if (bl != this.strikethrough) {
            this.strikethrough = bl;
            this.flushCachedValues();
            this.updateUseLayout();
            this.geomChanged(true);
        }
    }

    @Override
    public void setTextAlignment(int n) {
        HAlign hAlign = HAlign.LEFT;
        if (n == 1) {
            hAlign = HAlign.CENTER;
        } else if (n == 2) {
            hAlign = HAlign.RIGHT;
        } else if (n == 3) {
            hAlign = HAlign.JUSTIFY;
        }
        if (hAlign != this.horizontalAlignment) {
            this.horizontalAlignment = hAlign;
            this.flushCachedValues();
            this.updateUseLayout();
            this.visualsChanged(true);
        }
    }

    @Override
    public void setInputMethodText(int n, Object object) {
        if (n < 0 || object == null) {
            if (this.imtext == null) {
                return;
            }
            this.imtext = null;
        } else {
            AttributedString attributedString = (AttributedString)object;
            if (this.imtext == null || this.imtext.as != attributedString) {
                if (this.imtext == null) {
                    this.imtext = new InputMethodText();
                }
                this.imtext.start = n;
                this.imtext.as = attributedString;
            }
        }
        this.flushCachedValues();
        this.updateUseLayout();
        this.geomChanged(true);
    }

    @Override
    public void setLogicalSelection(int n, int n2) {
        if (n < 0 || n2 < 0 || n2 < n || n > this.text.length()) {
            if (this.selection != null) {
                this.selection = null;
                this.updateUseLayout();
            }
            return;
        }
        if (this.selection == null || this.selection.start != n || this.selection.end != n2) {
            if (this.selection == null) {
                this.selection = new Selection();
                if (!this.useLayout) {
                    this.updateUseLayout();
                }
            }
            this.selection.start = Math.max(Math.min(n, n2), 0);
            this.selection.end = Math.min(Math.max(n, n2), this.text.length());
            this.selection.shape = null;
            this.visualsChanged(true);
        }
    }

    public void setSelectionPaint(Paint paint, Paint paint2) {
        if (this.selection == null) {
            this.selection = new Selection();
        }
        this.selection.setDrawPaint(paint);
        this.selection.setFillPaint(paint2);
        this.visualsChanged(true);
    }

    @Override
    public Object getHitInfo(float f, float f2) {
        SGText.temp.x = f;
        SGText.temp.y = f2;
        TextHitInfo textHitInfo = this.hitTestChar(temp);
        return textHitInfo;
    }

    @Override
    public Object getCaretShape(int n, boolean bl) {
        return this.getCaretShape(bl ? TextHitInfo.leading(n) : TextHitInfo.trailing(n));
    }

    @Override
    public Shape getSelectionShape() {
        if (this.selection != null) {
            if (this.selection.shape == null && this.selection.end > this.selection.start) {
                this.selection.shape = this.getRangeShape(this.selection.start, this.selection.end);
            }
            return this.selection.shape;
        }
        return null;
    }

    @Override
    public Shape getRangeShape(int n, int n2) {
        if (this.isTextEmpty() || this.mode == PGShape.Mode.EMPTY) {
            return null;
        }
        Shape shape = null;
        if (this.useLayout) {
            this.updateBounds();
            GeneralPath generalPath = new GeneralPath();
            int n3 = this.getLayoutIndex(TextHitInfo.leading(n));
            int n4 = this.getLayoutIndex(TextHitInfo.leading(n2));
            for (int i = n3; i <= n4; ++i) {
                int n5;
                int n6;
                AffineTransform affineTransform = AffineTransform.getTranslateInstance((double)this.location.x + this.cachedPositions[i].getX(), (double)(this.location.y + this.getYAdjustment(this.cachedFRC)) + this.cachedPositions[i].getY());
                if (i == 0) {
                    n6 = n;
                    n5 = Math.min(this.lastIndices[i], n2);
                } else {
                    n6 = Math.max(n, this.lastIndices[i - 1]) - this.lastIndices[i - 1];
                    n5 = Math.min(n2, this.lastIndices[i]) - this.lastIndices[i - 1];
                }
                generalPath.append(this.cachedLayouts[i].getLogicalHighlightShape(n6, n5).getPathIterator(affineTransform), false);
            }
            shape = generalPath;
        } else {
            FontRenderContext fontRenderContext = this.getFontRenderContext(BaseTransform.IDENTITY_TRANSFORM);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance((double)this.location.x + this.getGlyphVector(fontRenderContext).getGlyphPosition(n).getX(), this.location.y + this.getYAdjustment(fontRenderContext));
            shape = affineTransform.createTransformedShape(this.font.getStringBounds(this.text, n, n2, fontRenderContext));
        }
        return shape;
    }

    @Override
    public Shape getShape() {
        return this.getOutline(this.getFontRenderContext(BaseTransform.IDENTITY_TRANSFORM));
    }

    @Override
    public final void setAntialiased(boolean bl) {
        if (bl) {
            this.setAntialiasingHintInt(antialiasingHintDT);
        } else {
            this.setAntialiasingHintInt(RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
    }

    @Override
    public boolean computeContains(float f, float f2) {
        FontRenderContext fontRenderContext = this.getFontRenderContext(this.tx);
        Shape shape = this.getLineOutline(fontRenderContext, this.location.x, this.location.y + this.getYAdjustment(fontRenderContext));
        if (this.mode == PGShape.Mode.FILL) {
            return shape.contains(f, f2);
        }
        if (this.mode == PGShape.Mode.STROKE) {
            shape = this.drawStroke.createStrokedShape(shape);
            return shape.contains(f, f2);
        }
        if (shape.contains(f, f2)) {
            return true;
        }
        shape = this.drawStroke.createStrokedShape(shape);
        return shape.contains(f, f2);
    }

    @Override
    public void setTextBoundsType(int n) {
        if (this.textBoundsType == n) {
            return;
        }
        boolean bl = n == 1 || this.textBoundsType == 1;
        this.textBoundsType = n;
        if (bl) {
            this.geomChanged(true);
        }
    }

    @Override
    public final Bounds2D computeLayoutBounds(Bounds2D bounds2D) {
        if (this.mode == PGShape.Mode.EMPTY || this.isTextEmpty()) {
            bounds2D.setBounds(this.location.x, this.location.y, this.location.x, this.location.y);
            return bounds2D;
        }
        if (this.cachedLayoutBounds.isInvalid()) {
            BaseTransform baseTransform = BaseTransform.IDENTITY_TRANSFORM;
            bounds2D = useVB || this.textBoundsType == 1 ? this.computeBoundsVisual(bounds2D, baseTransform) : this.computeBoundsLogical(bounds2D, baseTransform);
            this.cachedLayoutBounds.setBounds(bounds2D);
        } else {
            bounds2D.setBounds(this.cachedLayoutBounds);
        }
        return bounds2D;
    }

    @Override
    public final Bounds2D computeBounds(Bounds2D bounds2D, BaseTransform baseTransform) {
        if (this.mode == PGShape.Mode.EMPTY || this.isTextEmpty()) {
            bounds2D.setBounds(this.location.x, this.location.y, this.location.x, this.location.y);
            return bounds2D;
        }
        if (baseTransform.isIdentity()) {
            if (useVB || this.textBoundsType == 1) {
                if (this.cachedLayoutBounds.isInvalid()) {
                    this.computeLayoutBounds(this.cachedLayoutBounds);
                }
                bounds2D.setBounds(this.cachedLayoutBounds);
                return bounds2D;
            }
            if (this.textBoundsType == 0) {
                if (this.cachedLayoutBounds.isInvalid()) {
                    this.computeLayoutBounds(this.cachedLayoutBounds);
                }
                return this.padBounds(this.cachedLayoutBounds, bounds2D);
            }
            return this.computeBoundsVisual(bounds2D, baseTransform);
        }
        if (useVB || this.textBoundsType != 0) {
            return this.computeBoundsVisual(bounds2D, baseTransform);
        }
        bounds2D = this.computeBoundsLogical(bounds2D, baseTransform);
        return this.padBounds(bounds2D, bounds2D);
    }

    Bounds2D padBounds(Bounds2D bounds2D, Bounds2D bounds2D2) {
        if (bounds2D2 != bounds2D) {
            bounds2D2.setBounds(bounds2D);
        }
        FontMetrics fontMetrics = g2dForMetrics.getFontMetrics(this.font);
        if (this.underline) {
            float f;
            float f2;
            FontRenderContext fontRenderContext = this.getFontRenderContext(BaseTransform.IDENTITY_TRANSFORM);
            LineMetrics lineMetrics = this.font.getLineMetrics("", fontRenderContext);
            float f3 = lineMetrics.getUnderlineThickness();
            int n = this.cachedPositions.length;
            float f4 = (float)this.cachedPositions[n - 1].getY() + this.location.y;
            if (this.underline && f4 + (f2 = (f = lineMetrics.getUnderlineOffset()) + f3) > bounds2D2.y2) {
                bounds2D2.y2 = f4 + f2;
            }
        }
        if (this.font.canDisplay('H')) {
            float f = (float)fontMetrics.charWidth('H') / 4.0f;
            bounds2D2.x1 -= f;
            bounds2D2.x2 += f;
        }
        return bounds2D2;
    }

    public final Bounds2D computeBoundsLogical(Bounds2D bounds2D, BaseTransform baseTransform) {
        if (this.isDegradedTransform(baseTransform)) {
            baseTransform = BaseTransform.IDENTITY_TRANSFORM;
        }
        FontRenderContext fontRenderContext = this.getFontRenderContext(baseTransform);
        if (!this.useLayout) {
            if (!this.font.isTransformed() && this.font.getSize() > 1) {
                Object object = SGText.getAntiAliasingHint(fontRenderContext);
                g2dForMetrics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
                g2dForMetrics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, fontRenderContext.usesFractionalMetrics() ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                g2dForMetrics.setTransform(SGText.getScaleTX(fontRenderContext.getTransform()));
                FontMetrics fontMetrics = g2dForMetrics.getFontMetrics(this.font);
                float f = fontMetrics.stringWidth(this.text);
                float f2 = fontMetrics.getAscent();
                float f3 = fontMetrics.getDescent() + fontMetrics.getLeading();
                bounds2D.setBounds(-0.0f, -f2, f, f3);
            } else {
                Rectangle2D rectangle2D = this.getGlyphVector(fontRenderContext).getLogicalBounds();
                bounds2D.setBounds((float)rectangle2D.getMinX(), (float)rectangle2D.getMinY(), (float)rectangle2D.getMaxX(), (float)rectangle2D.getMaxY());
            }
        } else {
            this.updateTextLayouts(fontRenderContext);
            if (this.cachedLayouts.length == 1) {
                TextLayout textLayout = this.cachedLayouts[0];
                float f = this.wrappingWidth > 0.0f ? this.wrappingWidth : textLayout.getAdvance();
                float f4 = textLayout.getAscent();
                float f5 = textLayout.getDescent() + textLayout.getLeading();
                bounds2D.setBounds(0.0f, -f4, f, f5);
            } else if (this.wrappingWidth > 0.0f) {
                TextLayout textLayout = this.cachedLayouts[0];
                float f = textLayout.getAscent();
                float f6 = textLayout.getDescent() + textLayout.getLeading();
                int n = this.cachedPositions.length;
                float f7 = (float)this.cachedPositions[n - 1].getY();
                Object object = SGText.getAntiAliasingHint(fontRenderContext);
                g2dForMetrics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
                g2dForMetrics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, fontRenderContext.usesFractionalMetrics() ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                g2dForMetrics.setTransform(SGText.getScaleTX(fontRenderContext.getTransform()));
                FontMetrics fontMetrics = g2dForMetrics.getFontMetrics(this.font);
                float f8 = fontMetrics.charWidth('M');
                float f9 = f8 > this.wrappingWidth ? f8 : this.wrappingWidth;
                bounds2D.setBounds(0.0f, -f, f9, f7 + f6);
            } else {
                float f = 0.0f;
                float f10 = 0.0f;
                float f11 = 0.0f;
                float f12 = 0.0f;
                for (int i = 0; i < this.cachedLayouts.length; ++i) {
                    Point2D.Float float_ = this.cachedPositions[i];
                    TextLayout textLayout = this.cachedLayouts[i];
                    float f13 = textLayout.getAdvance();
                    if (i == 0) {
                        f10 = textLayout.getAscent();
                        f11 = textLayout.getDescent() + textLayout.getLeading();
                    }
                    if (i == this.cachedLayouts.length - 1) {
                        f12 = (float)((Point2D)float_).getY();
                    }
                    f = (float)Math.max((double)f, ((Point2D)float_).getX() + (double)f13);
                }
                bounds2D.setBounds(0.0f, -f10, f, f12 + f11);
            }
        }
        float f = this.getYAdjustment(fontRenderContext);
        bounds2D.y1 += f;
        bounds2D.y2 += f;
        bounds2D.x1 += this.location.x;
        bounds2D.y1 += this.location.y;
        bounds2D.x2 += this.location.x;
        bounds2D.y2 += this.location.y;
        SGNode.transform(bounds2D, baseTransform);
        return bounds2D;
    }

    public final Bounds2D computeBoundsVisual(Bounds2D bounds2D, BaseTransform baseTransform) {
        if (this.isDegradedTransform(baseTransform)) {
            baseTransform = BaseTransform.IDENTITY_TRANSFORM;
        }
        FontRenderContext fontRenderContext = this.getFontRenderContext(baseTransform);
        if (this.mode == PGShape.Mode.FILL || this.drawStroke instanceof BasicStroke) {
            if (this.strikethrough && !this.underline && Utils.getJavaVersionAsFloat() < 160.12f) {
                Rectangle2D rectangle2D = this.getOutline(fontRenderContext, 0.0f, 0.0f).getBounds2D();
                bounds2D.setBounds((float)rectangle2D.getMinX(), (float)rectangle2D.getMinY(), (float)rectangle2D.getMaxX(), (float)rectangle2D.getMaxY());
            } else if (this.useLayout) {
                this.updateTextLayouts(fontRenderContext);
                bounds2D.invalidate();
                float f = this.getOverlineThickness(fontRenderContext);
                Rectangle2D.Float float_ = null;
                for (int i = 0; i < this.cachedLayouts.length; ++i) {
                    TextLayout textLayout = this.cachedLayouts[i];
                    Rectangle2D rectangle2D = textLayout.getBounds();
                    Point2D.Float float_2 = this.cachedPositions[i];
                    rectangle2D.setFrame(rectangle2D.getX() + ((Point2D)float_2).getX(), rectangle2D.getY() + ((Point2D)float_2).getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                    if (bounds2D.isInvalid()) {
                        bounds2D.setBounds((float)rectangle2D.getMinX(), (float)rectangle2D.getMinY(), (float)rectangle2D.getMaxX(), (float)rectangle2D.getMaxY());
                        continue;
                    }
                    bounds2D.x1 = Math.min(bounds2D.x1, (float)rectangle2D.getMinX());
                    bounds2D.y1 = Math.min(bounds2D.y1, (float)rectangle2D.getMinY());
                    bounds2D.x2 = Math.max(bounds2D.x2, (float)rectangle2D.getMaxX());
                    bounds2D.y2 = Math.max(bounds2D.y2, (float)rectangle2D.getMaxY());
                }
                if (bounds2D.isInvalid()) {
                    bounds2D.makeEmpty();
                }
            } else {
                Rectangle2D rectangle2D = this.getGlyphVector(fontRenderContext).getVisualBounds();
                bounds2D.setBounds((float)rectangle2D.getMinX(), (float)rectangle2D.getMinY(), (float)rectangle2D.getMaxX(), (float)rectangle2D.getMaxY());
            }
            if (this.drawStroke != null) {
                float f = ((BasicStroke)this.drawStroke).getLineWidth();
                bounds2D.x1 -= f;
                bounds2D.y1 -= f;
                bounds2D.x2 += f;
                bounds2D.y2 += f;
            }
        } else {
            Shape shape = this.getOutline(fontRenderContext, 0.0f, 0.0f);
            shape = this.drawStroke.createStrokedShape(shape);
            Rectangle2D rectangle2D = shape.getBounds2D();
            bounds2D.setBounds((float)rectangle2D.getMinX(), (float)rectangle2D.getMinY(), (float)rectangle2D.getMaxX(), (float)rectangle2D.getMaxY());
        }
        float f = this.getYAdjustment(fontRenderContext);
        bounds2D.y1 += f;
        bounds2D.y2 += f;
        bounds2D.x1 += this.location.x;
        bounds2D.y1 += this.location.y;
        bounds2D.x2 += this.location.x;
        bounds2D.y2 += this.location.y;
        SGNode.transform(bounds2D, baseTransform);
        bounds2D.x1 -= 2.0f;
        bounds2D.y1 -= 2.0f;
        bounds2D.x2 += 2.0f;
        bounds2D.y2 += 2.0f;
        return bounds2D;
    }

    @Override
    public void setSelectionPaint(Object object, Object object2) {
        this.setSelectionPaint((Paint)object, (Paint)object2);
    }

    @Override
    public void paint(Graphics2D graphics2D, BaseTransform baseTransform) {
        if (this.mode == PGShape.Mode.EMPTY || this.isTextEmpty()) {
            return;
        }
        SGText.toFXTransform(graphics2D.getTransform(), TEMP_TX);
        if (this.isDegradedTransform(TEMP_TX)) {
            return;
        }
        Shape shape = this.getSelectionShape();
        if (shape != null) {
            Shape shape2 = graphics2D.getClip();
            Area area = null;
            if (shape2 != null) {
                area = new Area(shape2);
            } else {
                Bounds2D bounds2D = this.getContentBounds(TEMP_BOUNDS, BaseTransform.IDENTITY_TRANSFORM);
                bounds2D.x1 -= 100.0f;
                bounds2D.y1 -= 100.0f;
                bounds2D.x2 += 100.0f;
                bounds2D.y2 += 100.0f;
                area = new Area(new Rectangle2D.Float(bounds2D.x1, bounds2D.y1, bounds2D.x2 - bounds2D.x1, bounds2D.y2 - bounds2D.y1));
            }
            area.subtract(new Area(shape));
            graphics2D.setClip(area);
            this.paintImpl(graphics2D, this.getDrawPaint(), this.getFillPaint());
            graphics2D.setClip(shape2);
            graphics2D.clip(shape);
            this.paintImpl(graphics2D, this.selection.getDrawPaint(), this.selection.getFillPaint());
            graphics2D.setClip(shape2);
        } else {
            this.paintImpl(graphics2D, this.getDrawPaint(), this.getFillPaint());
        }
    }

    private void paintImpl(Graphics2D graphics2D, Paint paint, Paint paint2) {
        graphics2D.setFont(this.font);
        if (this.mode == PGShape.Mode.FILL) {
            if (paint2 != null) {
                Object object = this.getAntialiasingHintInt(graphics2D.getTransform(), graphics2D);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                if (this.nogridfit) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                } else {
                    graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
                }
                float f = this.location.x;
                float f2 = this.location.y;
                if (this.verticalAlignment != VAlign.BASELINE) {
                    f2 += this.getYAdjustment(graphics2D.getFontRenderContext());
                }
                graphics2D.setPaint(paint2);
                if (this.useLayout) {
                    FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                    this.updateTextLayouts(fontRenderContext);
                    Rectangle2D rectangle2D = null;
                    if (object == RenderingHints.VALUE_TEXT_ANTIALIAS_ON && this.isAntialiased() && (this.underline || this.strikethrough)) {
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    float f3 = 0.0f;
                    for (int i = 0; i < this.cachedLayouts.length; ++i) {
                        TextLayout textLayout = this.cachedLayouts[i];
                        Point2D.Float float_ = this.cachedPositions[i];
                        float f4 = f + (float)((Point2D)float_).getX();
                        float f5 = f2 + (float)((Point2D)float_).getY();
                        textLayout.draw(graphics2D, f4, f5);
                        if (rectangle2D == null) continue;
                        graphics2D.fill(SGText.getOverlineRect(f4, f5, textLayout, f3, rectangle2D));
                    }
                } else {
                    graphics2D.drawString(this.text, f, f2);
                }
                if (this.nogridfit) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
                }
            }
        } else {
            if (this.isAntialiased()) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (this.nogridfit) {
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            }
            float f = this.location.x;
            float f6 = this.location.y;
            if (this.verticalAlignment != VAlign.BASELINE) {
                f6 += this.getYAdjustment(graphics2D.getFontRenderContext());
            }
            Shape shape = this.getOutline(graphics2D.getFontRenderContext(), f, f6);
            if (this.mode == PGShape.Mode.STROKE_FILL && paint2 != null) {
                graphics2D.setPaint(paint2);
                graphics2D.fill(shape);
            }
            if (paint != null) {
                graphics2D.setPaint(paint);
                graphics2D.setStroke(this.drawStroke);
                try {
                    graphics2D.draw(shape);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.nogridfit) {
                graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT);
            }
        }
    }

    private void flushCachedValues() {
        this.cachedLayouts = null;
        this.cachedPositions = null;
        this.lastIndices = null;
        this.cachedOutline = null;
        this.cachedFRC = null;
        if (this.selection != null) {
            this.selection.shape = null;
        }
    }

    private void printLayoutFlags() {
        System.out.println("Layout being used. State is: eols = " + this.eols + " wrappingWidth=" + this.wrappingWidth + " complexText= " + this.complexText + " fontLayoutAttrs=" + SGText.hasLayoutAttributes(this.font) + " overline=" + false + " strikethrough=" + this.strikethrough + " underline=" + this.underline + " selection=" + this.selection + " imtext=" + this.imtext);
    }

    private void updateUseLayout() {
        boolean bl = this.useLayout = !this.isTextEmpty() && (this.complexText || this.eols != null || SGText.hasLayoutAttributes(this.font) || this.strikethrough || this.underline || this.wrappingWidth > 0.0f || this.selection != null || this.imtext != null);
        if (this.useLayout && notifyLayout != 0) {
            switch (notifyLayout) {
                case 2: {
                    Thread.dumpStack();
                }
                case 1: {
                    this.printLayoutFlags();
                    break;
                }
                case 4: {
                    Thread.dumpStack();
                    this.printLayoutFlags();
                    System.exit(0);
                }
            }
        }
    }

    private TextHitInfo hitTestChar(Point2D point2D) {
        if (this.isTextEmpty()) {
            return null;
        }
        TextHitInfo textHitInfo = null;
        if (this.useLayout) {
            int n;
            this.updateBounds();
            for (n = 0; n < this.cachedPositions.length; ++n) {
                double d;
                double d2;
                if (!(point2D.getY() - (double)this.location.y - (double)this.getYAdjustment(this.cachedFRC) < this.cachedPositions[n].getY())) continue;
                double d3 = this.cachedPositions[n].getX() + (double)this.cachedLayouts[n].getAdvance();
                if (point2D.getX() - (double)this.location.x <= d3 || n < this.cachedPositions.length - 1 && (this.cachedPositions[n].getY() != this.cachedPositions[n + 1].getY() || (d2 = point2D.getX() - (double)this.location.x - d3) < (d = this.cachedPositions[n + 1].getX() - point2D.getX() + (double)this.location.x))) break;
            }
            if (n == this.cachedPositions.length) {
                for (n = this.cachedPositions.length - 1; !(n <= 0 || this.cachedPositions[n].getX() <= point2D.getX() || n > 0 && this.cachedPositions[n].getX() <= this.cachedPositions[n - 1].getX()); --n) {
                }
            }
            AffineTransform affineTransform = AffineTransform.getTranslateInstance((double)(-this.location.x) - this.cachedPositions[n].getX(), (double)(-this.location.y - this.getYAdjustment(this.cachedFRC)) - this.cachedPositions[n].getY());
            Point2D.Float float_ = new Point2D.Float();
            affineTransform.transform(point2D, float_);
            textHitInfo = this.cachedLayouts[n].hitTestChar((float)((Point2D)float_).getX(), (float)((Point2D)float_).getY());
            TextHitInfo textHitInfo2 = textHitInfo = n == 0 ? textHitInfo : textHitInfo.getOffsetHit(this.lastIndices[n - 1]);
            if (textHitInfo.getCharIndex() == this.text.length()) {
                textHitInfo = TextHitInfo.leading(this.text.length());
            }
        } else {
            double d = point2D.getX() - (double)this.location.x;
            if (d < 0.0) {
                textHitInfo = TextHitInfo.leading(0);
            } else {
                GlyphVector glyphVector = this.getGlyphVector(this.getFontRenderContext(BaseTransform.IDENTITY_TRANSFORM));
                float f = 0.0f;
                int n = 0;
                while (n < glyphVector.getNumGlyphs()) {
                    float f2 = glyphVector.getGlyphMetrics(n).getAdvance();
                    if (d >= (double)f && d < (double)(f + f2)) {
                        if (d < (double)(f + f2 / 2.0f)) {
                            textHitInfo = TextHitInfo.leading(n);
                            break;
                        }
                        textHitInfo = TextHitInfo.trailing(n);
                        break;
                    }
                    ++n;
                    f += f2;
                }
                if (textHitInfo == null) {
                    textHitInfo = TextHitInfo.trailing(n - 1);
                }
            }
        }
        return textHitInfo;
    }

    private Shape getCaretShape(TextHitInfo textHitInfo) {
        if (textHitInfo.getCharIndex() > this.text.length()) {
            textHitInfo = textHitInfo.isLeadingEdge() ? TextHitInfo.leading(this.text.length()) : TextHitInfo.trailing(this.text.length());
        }
        Shape shape = null;
        if (this.useLayout) {
            this.updateBounds();
            int n = this.getLayoutIndex(textHitInfo);
            AffineTransform affineTransform = AffineTransform.getTranslateInstance((double)this.location.x + this.cachedPositions[n].getX(), (double)(this.location.y + this.getYAdjustment(this.cachedFRC)) + this.cachedPositions[n].getY());
            shape = affineTransform.createTransformedShape(this.cachedLayouts[n].getCaretShape(n == 0 ? textHitInfo : textHitInfo.getOffsetHit(-this.lastIndices[n - 1].intValue())));
        } else {
            float f;
            boolean bl = this.isTextEmpty() || this.mode == PGShape.Mode.EMPTY;
            String string = bl ? "x" : this.text;
            int n = Math.min(textHitInfo.getInsertionIndex(), string.length());
            FontRenderContext fontRenderContext = this.getFontRenderContext(BaseTransform.IDENTITY_TRANSFORM);
            Rectangle2D rectangle2D = this.font.getStringBounds(string, 0, Math.max(1, n), fontRenderContext);
            LineMetrics lineMetrics = this.font.getLineMetrics(string, 0, Math.max(1, n), fontRenderContext);
            rectangle2D.setRect(n == 0 ? 0.0 : rectangle2D.getWidth(), rectangle2D.getMinY(), 0.0, lineMetrics.getHeight());
            if (bl) {
                switch (this.verticalAlignment) {
                    case TOP: {
                        f = lineMetrics.getAscent();
                        break;
                    }
                    case BOTTOM: {
                        f = -lineMetrics.getDescent();
                        break;
                    }
                    default: {
                        f = 0.0f;
                        break;
                    }
                }
            } else {
                f = this.getYAdjustment(fontRenderContext);
            }
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(this.location.x, this.location.y + f);
            shape = affineTransform.createTransformedShape(rectangle2D);
        }
        return shape;
    }

    private int getLayoutIndex(TextHitInfo textHitInfo) {
        int n;
        int n2 = textHitInfo.getCharIndex();
        if ((n2 = Math.min(Math.max(0, n2), this.text.length())) < 0 || n2 > this.text.length()) {
            throw new IllegalArgumentException("out of range");
        }
        for (n = 0; n < this.lastIndices.length && n2 >= this.lastIndices[n]; ++n) {
        }
        return Math.min(n, this.lastIndices.length - 1);
    }

    private final boolean isAntialiased() {
        return this.antialiasingHintApp != RenderingHints.VALUE_ANTIALIAS_OFF && this.antialiasingHintApp != RenderingHints.VALUE_ANTIALIAS_DEFAULT;
    }

    private void setAntialiasingHintInt(Object object) {
        if (!RenderingHints.KEY_TEXT_ANTIALIASING.isCompatibleValue(object)) {
            throw new IllegalArgumentException("invalid hint");
        }
        if (object != this.antialiasingHintApp) {
            this.antialiasingHintApp = object;
            this.flushCachedValues();
            this.contentBoundsChanged(true);
        }
    }

    private Object getAntialiasingHintInt(AffineTransform affineTransform, Graphics2D graphics2D) {
        Object object = this.antialiasingHintApp;
        if (this.isAntialiased() && object != RenderingHints.VALUE_TEXT_ANTIALIAS_ON) {
            if (this.rotatedFont) {
                object = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
            } else {
                int n;
                int n2 = n = affineTransform != null ? affineTransform.getType() : 0;
                if ((n & 0x18) != 0 || SGText.isDestTranslucent(graphics2D)) {
                    object = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
                }
            }
        }
        return object;
    }

    private GlyphVector getGlyphVector(FontRenderContext fontRenderContext) {
        return this.font.createGlyphVector(fontRenderContext, this.text);
    }

    private float getOverlineThickness(FontRenderContext fontRenderContext) {
        return 0.0f;
    }

    private float getAscent(TextLayout textLayout, FontRenderContext fontRenderContext) {
        return textLayout.getAscent();
    }

    private void updateTextLayouts(FontRenderContext fontRenderContext) {
        if (this.isTextEmpty()) {
            throw new IllegalStateException("no text specified");
        }
        if (this.cachedLayouts == null || this.cachedFRC == null || !SGText.isFRCCompatible(this.cachedFRC, fontRenderContext)) {
            this.cachedFRC = fontRenderContext;
            HashMap<AttributedCharacterIterator.Attribute, Object> hashMap = new HashMap<AttributedCharacterIterator.Attribute, Object>();
            hashMap.put(TextAttribute.FONT, this.font);
            if (this.underline) {
                hashMap.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (this.strikethrough) {
                hashMap.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            AttributedString attributedString = this.createAttributedString(hashMap);
            int n = this.text.length() + 1;
            if (this.eols == null && this.wrappingWidth == 0.0f) {
                this.cachedLayouts = new TextLayout[1];
                this.cachedLayouts[0] = new TextLayout(attributedString.getIterator(), fontRenderContext);
                this.cachedPositions = new Point2D.Float[]{new Point2D.Float(0.0f, 0.0f)};
                this.lastIndices = new Integer[]{n};
            } else {
                int[] nArray = this.eols;
                if (nArray == null) {
                    nArray = new int[]{n};
                }
                this.tabAdvance = (float)this.font.getStringBounds("        ", fontRenderContext).getWidth();
                this.maxAdvance = 0.0f;
                float f = 0.0f;
                ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>();
                ArrayList<Point2D.Float> arrayList2 = new ArrayList<Point2D.Float>();
                ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
                for (int i = 0; i < nArray.length; ++i) {
                    int n2 = i == 0 ? 0 : Math.min(nArray[i - 1] + 1, n);
                    int n3 = Math.min(nArray[i] + 1, n);
                    f += this.updateParagraphs(attributedString, n2, n3, f, arrayList, arrayList2, arrayList3, fontRenderContext);
                }
                this.adjustLayoutPositions(arrayList, arrayList2);
                this.cachedLayouts = new TextLayout[arrayList.size()];
                arrayList.toArray(this.cachedLayouts);
                this.cachedPositions = new Point2D.Float[this.cachedLayouts.length];
                arrayList2.toArray(this.cachedPositions);
                this.lastIndices = new Integer[this.cachedLayouts.length];
                arrayList3.toArray(this.lastIndices);
            }
        }
    }

    private float updateParagraphs(AttributedString attributedString, int n, int n2, float f, List<TextLayout> list, List<Point2D.Float> list2, List<Integer> list3, FontRenderContext fontRenderContext) {
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator(null, n, n2);
        ArrayList<Integer> arrayList = null;
        char c = attributedCharacterIterator.first();
        while (true) {
            if (c == '\uffff') break;
            if (c == '\t') {
                if (arrayList == null) {
                    arrayList = new ArrayList<Integer>();
                }
                arrayList.add(attributedCharacterIterator.getIndex());
            }
            c = attributedCharacterIterator.next();
        }
        if (arrayList != null) {
            arrayList.add(n2 - 1);
        }
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
        int n3 = 0;
        float f2 = f;
        int n4 = n;
        while (n4 < n2) {
            Object object;
            float f3;
            boolean bl = false;
            boolean bl2 = false;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            ArrayList<Float> arrayList3 = new ArrayList<Float>();
            float f8 = this.getOverlineThickness(fontRenderContext);
            float f9 = f3 = this.wrappingWidth > 0.0f ? this.wrappingWidth : Float.MAX_VALUE;
            while (!bl) {
                int n5 = arrayList != null ? (Integer)arrayList.get(n3) + 1 : n2;
                object = lineBreakMeasurer.nextLayout(f3 - f7, n5, bl2);
                if (object != null) {
                    if (f7 + ((TextLayout)object).getAdvance() > f3) {
                        int n6 = lineBreakMeasurer.getPosition();
                        while ((double)f7 + ((TextLayout)object).getLogicalHighlightShape(0, n6 - n4).getBounds2D().getWidth() > (double)f3) {
                            --n6;
                        }
                        lineBreakMeasurer.setPosition(n4);
                        object = lineBreakMeasurer.nextLayout(f3 - f7, n6 + 1, bl2);
                        bl = true;
                    }
                    n4 = lineBreakMeasurer.getPosition();
                    arrayList2.add(object);
                    arrayList3.add(Float.valueOf(f7));
                    f7 += ((TextLayout)object).getAdvance();
                    f4 = Math.max(f4, SGText.getAscent((TextLayout)object, f8));
                    f5 = Math.max(f5, ((TextLayout)object).getDescent() + ((TextLayout)object).getLeading());
                    f6 += ((TextLayout)object).getAdvance();
                    list3.add(n4);
                } else {
                    bl = true;
                }
                bl2 = true;
                if (arrayList != null && n4 == (Integer)arrayList.get(n3) + 1) {
                    ++n3;
                }
                if (n4 == n2) {
                    bl = true;
                }
                if (bl || arrayList == null) continue;
                f7 = (float)((int)(f7 / this.tabAdvance) + 1) * this.tabAdvance;
            }
            this.maxAdvance = Math.max(this.maxAdvance, f6);
            f6 = 0.0f;
            ListIterator listIterator = arrayList2.listIterator();
            object = arrayList3.listIterator();
            while (listIterator.hasNext()) {
                TextLayout textLayout = (TextLayout)listIterator.next();
                float f10 = ((Float)object.next()).floatValue();
                list2.add(new Point2D.Float(f10, f2));
                list.add(textLayout);
            }
            f2 += f4 + f5;
        }
        return f2 - f;
    }

    private void adjustLayoutPositions(List<TextLayout> list, List<Point2D.Float> list2) {
        if (this.horizontalAlignment == HAlign.LEFT) {
            return;
        }
        int n = 0;
        while (n < list.size()) {
            float f = list2.get((int)n).y;
            float f2 = 0.0f;
            int n2 = n;
            while (n < list.size() && list2.get((int)n).y == f) {
                f2 = list2.get((int)n).x + list.get(n).getAdvance() - list2.get((int)n2).x;
                ++n;
            }
            block7: for (int i = n2; i < n; ++i) {
                switch (this.horizontalAlignment) {
                    case RIGHT: {
                        Point2D.Float float_ = list2.remove(i);
                        float_.setLocation(float_.x + this.maxAdvance - f2, f);
                        list2.add(i, float_);
                        continue block7;
                    }
                    case CENTER: {
                        Point2D.Float float_ = list2.remove(i);
                        float_.setLocation(float_.x + (this.maxAdvance - f2) / 2.0f, f);
                        list2.add(i, float_);
                        continue block7;
                    }
                    case JUSTIFY: {
                        TextLayout textLayout = list.get(i);
                        list.remove(i);
                        list.add(i, textLayout.getJustifiedLayout(this.maxAdvance));
                        continue block7;
                    }
                    default: {
                        assert (false);
                        continue block7;
                    }
                }
            }
        }
    }

    private FontRenderContext getFontRenderContext(BaseTransform baseTransform) {
        if (this.isDegradedTransform(baseTransform)) {
            baseTransform = BaseTransform.IDENTITY_TRANSFORM;
        }
        FontRenderContext fontRenderContext = null;
        if (Utils.isAtLeastJava6) {
            try {
                SGText.toAWTTransform(baseTransform, TEMP_AWT_TX);
                fontRenderContext = (FontRenderContext)FRC_CONSTRUCTOR.newInstance(TEMP_AWT_TX, this.getAntialiasingHintInt(TEMP_AWT_TX, null), this.nogridfit ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (fontRenderContext == null) {
            SGText.toAWTTransform(baseTransform, TEMP_AWT_TX);
            fontRenderContext = new FontRenderContext(TEMP_AWT_TX, this.isAntialiased(), false);
        }
        return fontRenderContext;
    }

    private float getYAdjustment(FontRenderContext fontRenderContext) {
        if (this.isTextEmpty()) {
            throw new IllegalStateException("no text specified");
        }
        if (this.verticalAlignment != VAlign.BASELINE) {
            LineMetrics lineMetrics = this.font.getLineMetrics(this.text, fontRenderContext);
            if (this.verticalAlignment == VAlign.TOP) {
                float f = lineMetrics.getAscent();
                return f;
            }
            float f = -lineMetrics.getDescent();
            if (this.useLayout) {
                this.updateTextLayouts(fontRenderContext);
                if (this.cachedPositions.length > 1) {
                    f = (float)((double)f - this.cachedPositions[this.cachedPositions.length - 1].getY());
                }
            }
            return f;
        }
        return 0.0f;
    }

    private Shape getLineOutline(FontRenderContext fontRenderContext, float f, float f2) {
        if (!this.useLayout) {
            Cloneable cloneable;
            if (this.cachedOutline == null || !SGText.isFRCCompatible(this.cachedFRC, fontRenderContext)) {
                cloneable = this.getGlyphVector(fontRenderContext);
                this.cachedOutline = ((GlyphVector)cloneable).getOutline();
                this.cachedFRC = fontRenderContext;
            }
            if (f == 0.0f && f2 == 0.0f) {
                return this.cachedOutline;
            }
            cloneable = AffineTransform.getTranslateInstance(f, f2);
            return ((AffineTransform)cloneable).createTransformedShape(this.cachedOutline);
        }
        if (!SGText.isFRCCompatible(this.cachedFRC, fontRenderContext)) {
            this.cachedOutline = null;
            this.updateTextLayouts(fontRenderContext);
            this.cachedFRC = fontRenderContext;
        }
        GeneralPath generalPath = null;
        AffineTransform affineTransform = null;
        for (int i = 0; i < this.cachedLayouts.length; ++i) {
            TextLayout textLayout = this.cachedLayouts[i];
            Point2D.Float float_ = this.cachedPositions[i];
            float f3 = (float)float_.getX();
            float f4 = (float)float_.getY();
            float f5 = f4 - textLayout.getAscent();
            float f6 = f4 + textLayout.getDescent() + textLayout.getLeading();
            if (f2 < f5 || f2 > f6) continue;
            if (affineTransform == null && (f3 != 0.0f || f4 != 0.0f)) {
                affineTransform = new AffineTransform();
            }
            if (affineTransform != null) {
                affineTransform.setToTranslation(f3, f4);
            }
            Shape shape = textLayout.getOutline(affineTransform);
            if (generalPath == null) {
                if (shape instanceof GeneralPath) {
                    generalPath = (GeneralPath)shape;
                    continue;
                }
                generalPath = new GeneralPath();
                generalPath.append(shape, false);
                continue;
            }
            generalPath.append(shape, false);
        }
        if (generalPath == null) {
            generalPath = new GeneralPath();
        }
        return generalPath;
    }

    private Shape getOutline(FontRenderContext fontRenderContext) {
        return this.getOutline(fontRenderContext, this.location.x, this.location.y + this.getYAdjustment(fontRenderContext));
    }

    private Shape getOutline(FontRenderContext fontRenderContext, float f, float f2) {
        Cloneable cloneable;
        if (this.cachedOutline == null || !SGText.isFRCCompatible(this.cachedFRC, fontRenderContext)) {
            if (this.useLayout) {
                cloneable = null;
                this.cachedOutline = null;
                AffineTransform affineTransform = null;
                this.updateTextLayouts(fontRenderContext);
                Object var6_6 = null;
                float f3 = 0.0f;
                for (int i = 0; i < this.cachedLayouts.length; ++i) {
                    TextLayout textLayout = this.cachedLayouts[i];
                    Point2D.Float float_ = this.cachedPositions[i];
                    if (affineTransform == null && (float_.getX() != 0.0 || float_.getY() != 0.0)) {
                        affineTransform = new AffineTransform();
                    }
                    if (affineTransform != null) {
                        affineTransform.setToTranslation(float_.getX(), float_.getY());
                    }
                    Shape shape = textLayout.getOutline(affineTransform);
                    if (this.cachedOutline == null) {
                        this.cachedOutline = shape;
                        continue;
                    }
                    if (cloneable == null) {
                        int n = this.text.length() * 75;
                        cloneable = new GeneralPath(1, n);
                        ((Path2D)cloneable).append(this.cachedOutline, false);
                        this.cachedOutline = cloneable;
                    }
                    ((Path2D)cloneable).append(shape, false);
                }
            } else {
                cloneable = this.getGlyphVector(fontRenderContext);
                this.cachedOutline = ((GlyphVector)cloneable).getOutline();
            }
            this.cachedFRC = fontRenderContext;
        }
        if (f == 0.0f && f2 == 0.0f) {
            return this.cachedOutline;
        }
        cloneable = AffineTransform.getTranslateInstance(f, f2);
        return ((AffineTransform)cloneable).createTransformedShape(this.cachedOutline);
    }

    private boolean isTextEmpty() {
        return this.text == null || this.text.length() == 0;
    }

    private boolean isDegradedTransform(BaseTransform baseTransform) {
        if (baseTransform != null) {
            double d;
            double d2 = baseTransform.getDeterminant();
            if (d2 == 0.0) {
                return true;
            }
            double d3 = this.font.getSize();
            if ((this.mode == PGShape.Mode.STROKE || this.mode == PGShape.Mode.STROKE_FILL) && this.getDrawStroke() instanceof BasicStroke) {
                d3 += (double)((BasicStroke)this.getDrawStroke()).getLineWidth();
            }
            return (d = 15.0 * d3 * Math.abs(d2)) <= Math.abs(baseTransform.getMxy()) + Math.abs(baseTransform.getMyy()) || d <= Math.abs(baseTransform.getMxx()) + Math.abs(baseTransform.getMyx());
        }
        return false;
    }

    private AttributedString createAttributedString(Map<AttributedCharacterIterator.Attribute, Object> map) {
        AttributedString attributedString = new AttributedString(this.text + "\t", map);
        if (this.imtext != null && this.imtext.as != null) {
            AttributedCharacterIterator attributedCharacterIterator = this.imtext.as.getIterator();
            char c = attributedCharacterIterator.first();
            while (c != '\uffff') {
                int n = attributedCharacterIterator.getIndex();
                Map<AttributedCharacterIterator.Attribute, Object> map2 = attributedCharacterIterator.getAttributes();
                int n2 = attributedCharacterIterator.getRunLimit();
                if (this.imtext.start + n >= 0 && this.imtext.start + n2 <= this.text.length()) {
                    attributedString.addAttributes(map2, this.imtext.start + n, this.imtext.start + n2);
                }
                c = attributedCharacterIterator.setIndex(n2);
            }
        }
        return attributedString;
    }

    private static boolean isTransformCompatible(AffineTransform affineTransform, AffineTransform affineTransform2) {
        if (affineTransform == affineTransform2) {
            return true;
        }
        if (affineTransform != null && affineTransform2 != null) {
            if (affineTransform.getType() <= 1 && affineTransform2.getType() <= 1) {
                return true;
            }
            if (affineTransform.getScaleX() == affineTransform2.getScaleX() && affineTransform.getScaleY() == affineTransform2.getScaleY() && affineTransform.getShearX() == affineTransform2.getShearX() && affineTransform.getShearY() == affineTransform2.getShearY()) {
                return true;
            }
        }
        return false;
    }

    private static boolean isTransformCompatible2(BaseTransform baseTransform, BaseTransform baseTransform2) {
        if (baseTransform == baseTransform2) {
            return true;
        }
        if (baseTransform != null && baseTransform2 != null) {
            if (baseTransform.isTranslateOrIdentity() && baseTransform2.isTranslateOrIdentity()) {
                return true;
            }
            if (baseTransform.getMxx() == baseTransform2.getMxx() && baseTransform.getMyy() == baseTransform2.getMyy() && baseTransform.getMxy() == baseTransform2.getMxy() && baseTransform.getMyx() == baseTransform2.getMyx()) {
                return true;
            }
        }
        return false;
    }

    private static Object getAntiAliasingHint(FontRenderContext fontRenderContext) {
        Object object;
        Object object2 = object = fontRenderContext.isAntiAliased() ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        if (FRC_GET_ANTI_ALIASING_HINT != null) {
            try {
                object = FRC_GET_ANTI_ALIASING_HINT.invoke((Object)fontRenderContext, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    private static Object getFractionalMetricsHint(FontRenderContext fontRenderContext) {
        Object object;
        Object object2 = object = fontRenderContext.usesFractionalMetrics() ? RenderingHints.VALUE_FRACTIONALMETRICS_ON : RenderingHints.VALUE_FRACTIONALMETRICS_OFF;
        if (FRC_GET_FRACTIONAL_METRICS_HINT != null) {
            try {
                object = FRC_GET_FRACTIONAL_METRICS_HINT.invoke((Object)fontRenderContext, (Object[])null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return object;
    }

    private static AffineTransform getScaleTX(AffineTransform affineTransform) {
        if (affineTransform.isIdentity()) {
            return affineTransform;
        }
        double d = affineTransform.getShearX();
        double d2 = affineTransform.getScaleY();
        if (d != 0.0) {
            d2 = Math.sqrt(d * d + d2 * d2);
        }
        double d3 = 10.0;
        d2 = (double)((int)(d2 * d3)) / d3;
        affineTransform.setTransform(d2, 0.0, 0.0, d2, 0.0, 0.0);
        return affineTransform;
    }

    private static boolean isFRCCompatible(FontRenderContext fontRenderContext, FontRenderContext fontRenderContext2) {
        if (fontRenderContext == fontRenderContext2) {
            return true;
        }
        if (fontRenderContext != null && fontRenderContext2 == null || fontRenderContext == null && fontRenderContext2 != null) {
            return false;
        }
        if (SGText.getAntiAliasingHint(fontRenderContext) != SGText.getAntiAliasingHint(fontRenderContext2) || SGText.getFractionalMetricsHint(fontRenderContext) != SGText.getFractionalMetricsHint(fontRenderContext2)) {
            return false;
        }
        return SGText.isTransformCompatible(fontRenderContext.getTransform(), fontRenderContext2.getTransform());
    }

    private static boolean isDestTranslucent(Graphics2D graphics2D) {
        if (graphics2D != null && SG2D_GET_TRANSPARENCY != null && SD_SURFACEDATA != null) {
            try {
                Object object = SD_SURFACEDATA.get(graphics2D);
                int n = (Integer)SG2D_GET_TRANSPARENCY.invoke(object, (Object[])null);
                return n != 1;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isComplexText(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c < '\u0590') continue;
            if (c <= '\u05ff') {
                return true;
            }
            if (c >= '\u0600' && c <= '\u06ff') {
                return true;
            }
            if (c >= '\u0900' && c <= '\u0d7f') {
                return true;
            }
            if (c >= '\u0e00' && c <= '\u0e7f') {
                return true;
            }
            if (c >= '\u1780' && c <= '\u17ff') {
                return true;
            }
            if (c >= '\u200c' && c <= '\u200d') {
                return true;
            }
            if (c >= '\u202a' && c <= '\u202e') {
                return true;
            }
            if (c >= '\u206a' && c <= '\u206f') {
                return true;
            }
            if (c < '\ud800' || c > '\udbff') continue;
            ++i;
        }
        return false;
    }

    private static boolean hasLayoutAttributes(Font font) {
        if (FONT_HAS_LAYOUT_ATTRIBUTES == null) {
            return false;
        }
        try {
            Object object = FONT_HAS_LAYOUT_ATTRIBUTES.invoke((Object)font, (Object[])null);
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static int[] getEols(String string) {
        int[] nArray = null;
        ArrayList<Integer> arrayList = null;
        int n = string.indexOf(10);
        while (n >= 0) {
            if (n < string.length()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Integer>();
                }
                arrayList.add(n);
            }
            n = string.indexOf(10, n + 1);
        }
        if (arrayList != null) {
            nArray = new int[arrayList.size() + 1];
            for (n = 0; n < arrayList.size(); ++n) {
                nArray[n] = (Integer)arrayList.get(n);
            }
            nArray[nArray.length - 1] = string.length();
        }
        return nArray;
    }

    private static Rectangle2D getOverlineRect(float f, float f2, TextLayout textLayout, float f3, Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Float();
        }
        rectangle2D.setFrame(f, f2 - textLayout.getAscent(), textLayout.getAdvance(), f3);
        return rectangle2D;
    }

    private static float getAscent(TextLayout textLayout, float f) {
        float f2 = textLayout.getAscent();
        if (f != 0.0f) {
            f2 = Math.max(f2, -((float)textLayout.getBounds().getY() - f));
        }
        return f2;
    }

    static {
        boolean bl;
        TEMP_BOUNDS = new Bounds2D();
        TEMP_TX = new Affine2D();
        TEMP_AWT_TX = new AffineTransform();
        temp = new Point2D.Float();
        defaultFont = new Font("SansSerif", 0, 12);
        antialiasingHintDT = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
        gammaHintDT = null;
        gammaHintKey = null;
        hintsTracker = null;
        nogridfitSupported = false;
        Field field = null;
        Method method = null;
        float f = Utils.getJavaVersionAsFloat();
        if (f == 160.1f || f == 160.11f) {
            try {
                Class clazz = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                    @Override
                    public Class run() throws Exception {
                        return Utils.platformClassForName("sun.java2d.SunGraphics2D", true);
                    }
                });
                Class clazz2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                    @Override
                    public Class run() throws Exception {
                        return Utils.platformClassForName("sun.java2d.SurfaceData", true);
                    }
                });
                method = clazz2.getMethod("getTransparency", null);
                final Field field2 = clazz.getField("surfaceData");
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        field2.setAccessible(true);
                        return null;
                    }
                });
                field = field2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SD_SURFACEDATA = field;
        SG2D_GET_TRANSPARENCY = method;
        if (Utils.isAtLeastJava6) {
            hintsTracker = new DesktopAAHintsTracker();
        }
        if (f >= 160.14f && !(bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return System.getProperty("os.name", "").toLowerCase().startsWith("mac");
            }
        }).booleanValue())) {
            nogridfitSupported = true;
        }
        Class clazz = null;
        method = null;
        try {
            clazz = Font.class;
            method = clazz.getMethod("hasLayoutAttributes", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FONT_HAS_LAYOUT_ATTRIBUTES = method;
        clazz = null;
        Constructor constructor = null;
        try {
            clazz = FontRenderContext.class;
            constructor = clazz.getConstructor(AffineTransform.class, Object.class, Object.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FRC_CONSTRUCTOR = constructor;
        method = null;
        try {
            method = FontRenderContext.class.getMethod("getAntiAliasingHint", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FRC_GET_ANTI_ALIASING_HINT = method;
        method = null;
        try {
            method = FontRenderContext.class.getMethod("getFractionalMetricsHint", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FRC_GET_FRACTIONAL_METRICS_HINT = method;
        clazz = null;
        field = null;
        Object object = null;
        RenderingHints.Key key = null;
        try {
            clazz = RenderingHints.class;
            field = clazz.getField("KEY_TEXT_LCD_CONTRAST");
            object = field.get(null);
            if (object instanceof RenderingHints.Key) {
                key = (RenderingHints.Key)object;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        KEY_TEXT_LCD_CONTRAST = key;
        clazz = null;
        field = null;
        object = null;
        try {
            clazz = RenderingHints.class;
            field = clazz.getField("VALUE_TEXT_ANTIALIAS_GASP");
            object = field.get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        VALUE_TEXT_ANTIALIAS_GASP = object;
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        g2dForMetrics = bufferedImage.createGraphics();
        useVB = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return System.getProperty("sgtext.visualbounds") != null;
            }
        });
        if (useVB) {
            System.out.println("Use visual bounds for text bounds(expensive).");
        }
        notifyLayout = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                int n = 0;
                String string = System.getProperty("sgtext.notifylayout");
                if (string == null) {
                    return n;
                }
                if ("warn".equals(string)) {
                    n = 1;
                } else if ("stack".equals(string)) {
                    n = 2;
                } else if ("exit".equals(string)) {
                    n = 4;
                }
                return n;
            }
        });
    }

    private static class DesktopAAHintsTracker
    implements PropertyChangeListener {
        private static final String propStr = "awt.font.desktophints";

        DesktopAAHintsTracker() {
            this.setHints();
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.addPropertyChangeListener(propStr, this);
            gammaHintKey = KEY_TEXT_LCD_CONTRAST;
        }

        private void setHints() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Map map = (Map)toolkit.getDesktopProperty(propStr);
            Object object = null;
            Object var4_4 = null;
            if (map != null) {
                object = map.get(RenderingHints.KEY_TEXT_ANTIALIASING);
                var4_4 = map.get(KEY_TEXT_LCD_CONTRAST);
            }
            if (object == null || object == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF || object == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                object = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
                try {
                    String string = System.getProperty("os.version", "unknown");
                    if (string.startsWith("Windows")) {
                        object = VALUE_TEXT_ANTIALIAS_GASP;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            antialiasingHintDT = object;
            gammaHintDT = var4_4;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setHints();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HAlign {
        LEFT,
        CENTER,
        RIGHT,
        JUSTIFY;

    }

    private static class InputMethodText {
        int start;
        AttributedString as;

        private InputMethodText() {
        }
    }

    private static class Selection {
        int start;
        int end;
        private Paint drawPaint;
        private Paint fillPaint;
        private Paint validDrawPaint;
        private Paint validFillPaint;
        Shape shape;

        private Selection() {
        }

        public final Paint getDrawPaint() {
            if (this.validDrawPaint == null) {
                if (this.drawPaint instanceof ProportionalPaint) {
                    Rectangle2D rectangle2D = this.shape.getBounds2D();
                    ProportionalPaint proportionalPaint = (ProportionalPaint)this.drawPaint;
                    this.validDrawPaint = proportionalPaint.getPaint(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                } else {
                    this.validDrawPaint = this.drawPaint;
                }
            }
            return this.validDrawPaint;
        }

        public void setDrawPaint(Paint paint) {
            this.drawPaint = paint;
            this.validDrawPaint = null;
        }

        public final Paint getFillPaint() {
            if (this.validFillPaint == null) {
                if (this.fillPaint instanceof ProportionalPaint) {
                    Rectangle2D rectangle2D = this.shape.getBounds2D();
                    ProportionalPaint proportionalPaint = (ProportionalPaint)this.fillPaint;
                    this.validFillPaint = proportionalPaint.getPaint(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                } else {
                    this.validFillPaint = this.fillPaint;
                }
            }
            return this.validFillPaint;
        }

        public void setFillPaint(Paint paint) {
            this.fillPaint = paint;
            this.validFillPaint = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VAlign {
        BASELINE,
        TOP,
        BOTTOM;

    }
}

