/*
 * Decompiled with CFR 0.152.
 */
package javafx.reflect;

import javafx.reflect.FXBooleanValue;
import javafx.reflect.FXClassType;
import javafx.reflect.FXDoubleValue;
import javafx.reflect.FXFloatValue;
import javafx.reflect.FXIntegerValue;
import javafx.reflect.FXLocal;
import javafx.reflect.FXLongValue;
import javafx.reflect.FXPrimitiveType;
import javafx.reflect.FXSequenceBuilder;
import javafx.reflect.FXSequenceValue;
import javafx.reflect.FXType;
import javafx.reflect.FXValue;

public abstract class FXContext {
    public static final String MIXIN_SUFFIX = "$Mixin";
    public static final String FXOBJECT_NAME = "com.sun.javafx.runtime.FXObject";
    public static final String FXMIXIN_NAME = "com.sun.javafx.runtime.FXMixin";
    public static final String FXBASE_NAME = "com.sun.javafx.runtime.FXBase";
    FXType anyType = this.findClass("java.lang.Object");

    public static FXContext getInstance() {
        return FXLocal.getContext();
    }

    protected FXContext() {
    }

    public abstract FXClassType findClass(String var1);

    public FXType getAnyType() {
        return this.anyType;
    }

    public FXPrimitiveType getPrimitiveType(String string) {
        if (string.startsWith("java.lang.")) {
            string = string.substring(10);
        } else if (string.indexOf(46) >= 0) {
            return null;
        }
        if (string.equals("Boolean")) {
            return this.getBooleanType();
        }
        if (string.equals("Character")) {
            return this.getCharacterType();
        }
        if (string.equals("Byte")) {
            return this.getByteType();
        }
        if (string.equals("Short")) {
            return this.getShortType();
        }
        if (string.equals("Integer") || string.equals("Int")) {
            return this.getIntegerType();
        }
        if (string.equals("Long")) {
            return this.getLongType();
        }
        if (string.equals("Float")) {
            return this.getFloatType();
        }
        if (string.equals("Double")) {
            return this.getDoubleType();
        }
        if (string.equals("Void")) {
            return FXPrimitiveType.voidType;
        }
        return null;
    }

    public FXPrimitiveType getBooleanType() {
        return FXPrimitiveType.booleanType;
    }

    public FXPrimitiveType getCharacterType() {
        return FXPrimitiveType.charType;
    }

    public FXPrimitiveType getByteType() {
        return FXPrimitiveType.byteType;
    }

    public FXPrimitiveType getShortType() {
        return FXPrimitiveType.shortType;
    }

    public FXPrimitiveType getIntegerType() {
        return FXPrimitiveType.integerType;
    }

    public FXPrimitiveType getLongType() {
        return FXPrimitiveType.longType;
    }

    public FXPrimitiveType getFloatType() {
        return FXPrimitiveType.floatType;
    }

    public FXPrimitiveType getDoubleType() {
        return FXPrimitiveType.doubleType;
    }

    public FXPrimitiveType getNumberType() {
        return this.getFloatType();
    }

    public FXClassType getStringType() {
        return this.findClass("java.lang.String");
    }

    public FXPrimitiveType getVoidType() {
        return FXPrimitiveType.voidType;
    }

    public FXSequenceBuilder makeSequenceBuilder(FXType fXType) {
        return new FXSequenceBuilder(this, fXType);
    }

    public FXValue makeSequence(FXType fXType, FXValue ... fXValueArray) {
        FXSequenceBuilder fXSequenceBuilder = this.makeSequenceBuilder(fXType);
        for (int i = 0; i < fXValueArray.length; ++i) {
            fXSequenceBuilder.append(fXValueArray[i]);
        }
        return fXSequenceBuilder.getSequence();
    }

    public FXValue makeSequenceValue(FXValue[] fXValueArray, int n, FXType fXType) {
        return new FXSequenceValue(fXValueArray, n, fXType);
    }

    public FXLocal.Value mirrorOf(boolean bl) {
        return new FXBooleanValue(bl, this.getBooleanType());
    }

    public FXLocal.Value mirrorOf(char c) {
        return new FXIntegerValue(c, this.getCharacterType());
    }

    public FXLocal.Value mirrorOf(byte by) {
        return new FXIntegerValue(by, this.getByteType());
    }

    public FXLocal.Value mirrorOf(short s) {
        return new FXIntegerValue(s, this.getShortType());
    }

    public FXLocal.Value mirrorOf(int n) {
        return new FXIntegerValue(n, this.getIntegerType());
    }

    public FXLocal.Value mirrorOf(long l) {
        return new FXLongValue(l, this.getLongType());
    }

    public FXLocal.Value mirrorOf(float f) {
        return new FXFloatValue(f, this.getFloatType());
    }

    public FXLocal.Value mirrorOf(double d) {
        return new FXDoubleValue(d, this.getDoubleType());
    }

    public abstract FXValue mirrorOf(String var1);
}

