/*
 * Decompiled with CFR 0.152.
 */
package javafx.reflect;

import javafx.reflect.FXType;

public class FXFunctionType
extends FXType {
    protected int minArgs;
    protected FXType[] argTypes;
    protected boolean varArgs;
    protected FXType returnType;

    FXFunctionType() {
    }

    FXFunctionType(FXType[] fXTypeArray, FXType fXType) {
        this.argTypes = fXTypeArray;
        this.minArgs = fXTypeArray.length;
        this.returnType = fXType;
    }

    public int minArgs() {
        return this.minArgs;
    }

    public boolean isVarArgs() {
        return this.varArgs;
    }

    public FXType getArgumentType(int n) {
        return this.argTypes[this.varArgs && n >= this.minArgs ? this.minArgs : n];
    }

    public FXType getReturnType() {
        return this.returnType;
    }

    public boolean equals(FXFunctionType fXFunctionType) {
        if (this.minArgs != fXFunctionType.minArgs || this.varArgs != fXFunctionType.varArgs || !this.returnType.equals(fXFunctionType.returnType)) {
            return false;
        }
        int n = this.minArgs;
        while (--n >= 0) {
            if (this.argTypes[n].equals(fXFunctionType.argTypes[n])) continue;
            return false;
        }
        return true;
    }

    public void toStringRaw(StringBuilder stringBuilder) {
        stringBuilder.append('(');
        int n = this.minArgs();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            this.getArgumentType(i).toStringTerse(stringBuilder);
        }
        stringBuilder.append(')');
        stringBuilder.append(':');
        this.returnType.toStringTerse(stringBuilder);
    }

    protected void toStringTerse(StringBuilder stringBuilder) {
        stringBuilder.append("function");
        this.toStringRaw(stringBuilder);
    }
}

