/*
 * Decompiled with CFR 0.152.
 */
package javafx.reflect;

import javafx.reflect.FXClassType;
import javafx.reflect.FXFunctionMember;
import javafx.reflect.FXMember;
import javafx.reflect.FXVarMember;

public class FXMemberFilter {
    String requiredName;
    static final int ACCEPTING_METHODS = 1;
    static final int ACCEPTING_ATTRIBUTES = 2;
    static final int ACCEPTING_CLASSES = 4;
    int flags = 7;
    private static FXMemberFilter acceptAttributes = new FXMemberFilter();
    private static FXMemberFilter acceptMethods;

    public boolean isAcceptingMethods() {
        return (this.flags & 1) != 0;
    }

    public boolean isAcceptingAttributes() {
        return (this.flags & 2) != 0;
    }

    public boolean isAcceptingClasses() {
        return (this.flags & 4) != 0;
    }

    public void setMethodsAccepted(boolean bl) {
        this.flags = bl ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public void setAttributesAccepted(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public void setClassesAccepted(boolean bl) {
        this.flags = bl ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public String getRequiredName() {
        return this.requiredName;
    }

    public void setRequiredName(String string) {
        this.requiredName = string;
    }

    public boolean accept(FXMember fXMember) {
        if (fXMember instanceof FXFunctionMember ? !this.isAcceptingMethods() : (fXMember instanceof FXVarMember ? !this.isAcceptingAttributes() : fXMember instanceof FXClassType && !this.isAcceptingClasses())) {
            return false;
        }
        if (this.requiredName != null) {
            return this.requiredName.equals(fXMember.getName());
        }
        return true;
    }

    public static FXMemberFilter acceptAttributes() {
        return acceptAttributes;
    }

    public static FXMemberFilter acceptAttributes(String string) {
        FXMemberFilter fXMemberFilter = new FXMemberFilter();
        fXMemberFilter.flags = 2;
        fXMemberFilter.requiredName = string;
        return fXMemberFilter;
    }

    public static FXMemberFilter acceptMethods() {
        return acceptMethods;
    }

    public static FXMemberFilter acceptMethods(String string) {
        FXMemberFilter fXMemberFilter = new FXMemberFilter();
        fXMemberFilter.flags = 1;
        fXMemberFilter.requiredName = string;
        return fXMemberFilter;
    }

    static {
        FXMemberFilter.acceptAttributes.flags = 2;
        acceptMethods = new FXMemberFilter();
        FXMemberFilter.acceptMethods.flags = 1;
    }
}

