/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.media;

import com.sun.media.jmc.Media;
import com.sun.media.jmc.MediaProvider;
import com.sun.media.jmc.control.AudioControl;
import com.sun.media.jmc.control.TrackControl;
import com.sun.media.jmc.control.VideoControl;
import com.sun.media.jmc.track.MediaTrack;
import java.util.List;
import java.util.Map;

class MediaHelper {
    MediaHelper() {
    }

    public static VideoControl getVideoControl(MediaProvider mediaProvider) {
        if (mediaProvider == null) {
            return null;
        }
        VideoControl videoControl = mediaProvider.getControl(VideoControl.class);
        return videoControl;
    }

    public static Object getMetadata(Media media, String string) {
        return media.getMetadata(string, Object.class);
    }

    static void getMetadataMap(Media media, MetadataListener metadataListener) {
        Map<String, Object> map = media.getMetadata();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                metadataListener.onMetadata(entry.getKey(), entry.getValue());
            }
        }
    }

    static AudioControl getAudioControl(MediaProvider mediaProvider) {
        if (mediaProvider == null) {
            return null;
        }
        return mediaProvider.getControl(AudioControl.class);
    }

    static TrackControl getTrackControl(MediaProvider mediaProvider) {
        if (mediaProvider == null) {
            return null;
        }
        return mediaProvider.getControl(TrackControl.class);
    }

    static void getEnabledTracks(MediaProvider mediaProvider, MediaTrackListener mediaTrackListener) {
        List<MediaTrack> list;
        TrackControl trackControl;
        if (mediaProvider != null && (trackControl = mediaProvider.getControl(TrackControl.class)) != null && (list = trackControl.getMediaTracks()) != null) {
            for (MediaTrack mediaTrack : list) {
                mediaTrackListener.onTrack(mediaTrack, trackControl.isEnabled(mediaTrack));
            }
        }
    }

    static interface MediaTrackListener {
        public void onTrack(MediaTrack var1, boolean var2);
    }

    static interface MetadataListener {
        public void onMetadata(String var1, Object var2);
    }
}

