/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.ConstantPool;
import java.io.IOException;
import java.util.Arrays;

class Instruction {
    protected byte[] bytes;
    protected int pc;
    protected int bc;
    protected int w;
    protected int length;
    protected boolean special;
    private static final byte[][] BC_LENGTH;
    private static final byte[][] BC_INDEX;
    private static final byte[][] BC_TAG;
    private static final byte[][] BC_BRANCH;
    private static final byte[][] BC_SLOT;
    private static final byte[][] BC_CON;
    private static final String[] BC_NAME;
    private static final String[][] BC_FORMAT;
    private static int BW;

    protected Instruction(byte[] byArray, int n, int n2, int n3, int n4) {
        this.reset(byArray, n, n2, n3, n4);
    }

    private void reset(byte[] byArray, int n, int n2, int n3, int n4) {
        this.bytes = byArray;
        this.pc = n;
        this.bc = n2;
        this.w = n3;
        this.length = n4;
    }

    public int getBC() {
        return this.bc;
    }

    public boolean isWide() {
        return this.w != 0;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getPC() {
        return this.pc;
    }

    public int getLength() {
        return this.length;
    }

    public int getNextPC() {
        return this.pc + this.length;
    }

    public Instruction next() {
        int n = this.pc + this.length;
        if (n == this.bytes.length) {
            return null;
        }
        return Instruction.at(this.bytes, n, this);
    }

    public boolean isNonstandard() {
        return Instruction.isNonstandard(this.bc);
    }

    public void setNonstandardLength(int n) {
        assert (this.isNonstandard());
        this.length = n;
    }

    public Instruction forceNextPC(int n) {
        int n2 = n - this.pc;
        return new Instruction(this.bytes, this.pc, -1, -1, n2);
    }

    public static Instruction at(byte[] byArray, int n) {
        return Instruction.at(byArray, n, null);
    }

    public static Instruction at(byte[] byArray, int n, Instruction instruction) {
        int n2 = Instruction.getByte(byArray, n);
        int n3 = -1;
        int n4 = 0;
        byte by = BC_LENGTH[n4][n2];
        if (by == 0) {
            switch (n2) {
                case 196: {
                    n2 = Instruction.getByte(byArray, n + 1);
                    n4 = 1;
                    by = BC_LENGTH[n4][n2];
                    if (by != 0) break;
                    by = 1;
                    break;
                }
                case 170: {
                    return new TableSwitch(byArray, n);
                }
                case 171: {
                    return new LookupSwitch(byArray, n);
                }
                default: {
                    by = 1;
                }
            }
        }
        assert (by > 0);
        assert (n + by <= byArray.length);
        if (instruction != null && !instruction.special) {
            instruction.reset(byArray, n, n2, n4, by);
            return instruction;
        }
        return new Instruction(byArray, n, n2, n4, by);
    }

    public byte getCPTag() {
        return BC_TAG[this.w][this.bc];
    }

    public int getCPIndex() {
        byte by = BC_INDEX[this.w][this.bc];
        if (by == 0) {
            return -1;
        }
        assert (this.w == 0);
        if (this.length == 2) {
            return Instruction.getByte(this.bytes, this.pc + by);
        }
        return Instruction.getShort(this.bytes, this.pc + by);
    }

    public void setCPIndex(int n) {
        byte by = BC_INDEX[this.w][this.bc];
        assert (by != 0);
        if (this.length == 2) {
            Instruction.setByte(this.bytes, this.pc + by, n);
        } else {
            Instruction.setShort(this.bytes, this.pc + by, n);
        }
        assert (this.getCPIndex() == n);
    }

    public ConstantPool.Entry getCPRef(ConstantPool.Entry[] entryArray) {
        int n = this.getCPIndex();
        return n < 0 ? null : entryArray[n];
    }

    public int getLocalSlot() {
        byte by = BC_SLOT[this.w][this.bc];
        if (by == 0) {
            return -1;
        }
        if (this.w == 0) {
            return Instruction.getByte(this.bytes, this.pc + by);
        }
        return Instruction.getShort(this.bytes, this.pc + by);
    }

    public int getBranchLabel() {
        byte by = BC_BRANCH[this.w][this.bc];
        if (by == 0) {
            return -1;
        }
        assert (this.w == 0);
        assert (this.length == 3 || this.length == 5);
        int n = this.length == 3 ? (int)((short)Instruction.getShort(this.bytes, this.pc + by)) : Instruction.getInt(this.bytes, this.pc + by);
        assert (n + this.pc >= 0);
        assert (n + this.pc <= this.bytes.length);
        return n + this.pc;
    }

    public void setBranchLabel(int n) {
        byte by = BC_BRANCH[this.w][this.bc];
        assert (by != 0);
        if (this.length == 3) {
            Instruction.setShort(this.bytes, this.pc + by, n - this.pc);
        } else {
            Instruction.setInt(this.bytes, this.pc + by, n - this.pc);
        }
        assert (n == this.getBranchLabel());
    }

    public int getConstant() {
        byte by = BC_CON[this.w][this.bc];
        if (by == 0) {
            return 0;
        }
        switch (this.length - by) {
            case 1: {
                return (byte)Instruction.getByte(this.bytes, this.pc + by);
            }
            case 2: {
                return (short)Instruction.getShort(this.bytes, this.pc + by);
            }
        }
        assert (false);
        return 0;
    }

    public void setConstant(int n) {
        byte by = BC_CON[this.w][this.bc];
        assert (by != 0);
        switch (this.length - by) {
            case 1: {
                Instruction.setByte(this.bytes, this.pc + by, n);
                break;
            }
            case 2: {
                Instruction.setShort(this.bytes, this.pc + by, n);
            }
        }
        assert (n == this.getConstant());
    }

    public boolean equals(Object object) {
        return object != null && object.getClass() == Instruction.class && this.equals((Instruction)object);
    }

    public int hashCode() {
        int n = 3;
        n = 11 * n + Arrays.hashCode(this.bytes);
        n = 11 * n + this.pc;
        n = 11 * n + this.bc;
        n = 11 * n + this.w;
        n = 11 * n + this.length;
        return n;
    }

    public boolean equals(Instruction instruction) {
        if (this.pc != instruction.pc) {
            return false;
        }
        if (this.bc != instruction.bc) {
            return false;
        }
        if (this.w != instruction.w) {
            return false;
        }
        if (this.length != instruction.length) {
            return false;
        }
        for (int i = 1; i < this.length; ++i) {
            if (this.bytes[this.pc + i] == instruction.bytes[instruction.pc + i]) continue;
            return false;
        }
        return true;
    }

    static String labstr(int n) {
        if (n >= 0 && n < 100000) {
            return (100000 + n + "").substring(1);
        }
        return n + "";
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(ConstantPool.Entry[] entryArray) {
        int n;
        int n2;
        int n3;
        int n4;
        String string;
        String string2 = Instruction.labstr(this.pc) + ": ";
        if (this.bc >= 202) {
            string2 = string2 + Integer.toHexString(this.bc);
            return string2;
        }
        if (this.w == 1) {
            string2 = string2 + "wide ";
        }
        String string3 = string = this.bc < BC_NAME.length ? BC_NAME[this.bc] : null;
        if (string == null) {
            return string2 + "opcode#" + this.bc;
        }
        string2 = string2 + string;
        byte by = this.getCPTag();
        if (by != 0) {
            string2 = string2 + " " + ConstantPool.tagName(by) + ":";
        }
        if ((n4 = this.getCPIndex()) >= 0) {
            string2 = string2 + (entryArray == null ? "" + n4 : "=" + entryArray[n4].stringValue());
        }
        if ((n3 = this.getLocalSlot()) >= 0) {
            string2 = string2 + " Local:" + n3;
        }
        if ((n2 = this.getBranchLabel()) >= 0) {
            string2 = string2 + " To:" + Instruction.labstr(n2);
        }
        if ((n = this.getConstant()) != 0) {
            string2 = string2 + " Con:" + n;
        }
        return string2;
    }

    public int getIntAt(int n) {
        return Instruction.getInt(this.bytes, this.pc + n);
    }

    public int getShortAt(int n) {
        return Instruction.getShort(this.bytes, this.pc + n);
    }

    public int getByteAt(int n) {
        return Instruction.getByte(this.bytes, this.pc + n);
    }

    public static int getInt(byte[] byArray, int n) {
        return (Instruction.getShort(byArray, n + 0) << 16) + (Instruction.getShort(byArray, n + 2) << 0);
    }

    public static int getShort(byte[] byArray, int n) {
        return (Instruction.getByte(byArray, n + 0) << 8) + (Instruction.getByte(byArray, n + 1) << 0);
    }

    public static int getByte(byte[] byArray, int n) {
        return byArray[n] & 0xFF;
    }

    public static void setInt(byte[] byArray, int n, int n2) {
        Instruction.setShort(byArray, n + 0, n2 >> 16);
        Instruction.setShort(byArray, n + 2, n2 >> 0);
    }

    public static void setShort(byte[] byArray, int n, int n2) {
        Instruction.setByte(byArray, n + 0, n2 >> 8);
        Instruction.setByte(byArray, n + 1, n2 >> 0);
    }

    public static void setByte(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)n2;
    }

    public static boolean isNonstandard(int n) {
        return BC_LENGTH[0][n] < 0;
    }

    public static int opLength(int n) {
        byte by = BC_LENGTH[0][n];
        assert (by > 0);
        return by;
    }

    public static int opWideLength(int n) {
        byte by = BC_LENGTH[1][n];
        assert (by > 0);
        return by;
    }

    public static boolean isLocalSlotOp(int n) {
        return n < BC_SLOT[0].length && BC_SLOT[0][n] > 0;
    }

    public static boolean isBranchOp(int n) {
        return n < BC_BRANCH[0].length && BC_BRANCH[0][n] > 0;
    }

    public static boolean isCPRefOp(int n) {
        if (n < BC_INDEX[0].length && BC_INDEX[0][n] > 0) {
            return true;
        }
        return n >= 233 && n < 240;
    }

    public static byte getCPRefOpTag(int n) {
        if (n < BC_INDEX[0].length && BC_INDEX[0][n] > 0) {
            return BC_TAG[0][n];
        }
        if (n >= 233 && n < 240) {
            return 20;
        }
        return 0;
    }

    public static boolean isFieldOp(int n) {
        return n >= 178 && n <= 181;
    }

    public static boolean isInvokeInitOp(int n) {
        return n >= 230 && n < 233;
    }

    public static boolean isSelfLinkerOp(int n) {
        return n >= 202 && n < 230;
    }

    public static String byteName(int n) {
        String string;
        if (n < BC_NAME.length && BC_NAME[n] != null) {
            string = BC_NAME[n];
        } else if (Instruction.isSelfLinkerOp(n)) {
            boolean bl;
            boolean bl2;
            int n2 = n - 202;
            boolean bl3 = bl2 = n2 >= 14;
            if (bl2) {
                n2 -= 14;
            }
            boolean bl4 = bl = n2 >= 7;
            if (bl) {
                n2 -= 7;
            }
            int n3 = 178 + n2;
            assert (n3 >= 178 && n3 <= 184);
            string = BC_NAME[n3];
            string = string + (bl2 ? "_super" : "_this");
            if (bl) {
                string = "aload_0&" + string;
            }
            string = "*" + string;
        } else if (Instruction.isInvokeInitOp(n)) {
            int n4 = n - 230;
            switch (n4) {
                case 0: {
                    string = "*invokespecial_init_this";
                    break;
                }
                case 1: {
                    string = "*invokespecial_init_super";
                    break;
                }
                default: {
                    assert (n4 == 2);
                    string = "*invokespecial_init_new";
                    break;
                }
            }
        } else {
            switch (n) {
                case 234: {
                    string = "*ildc";
                    break;
                }
                case 235: {
                    string = "*fldc";
                    break;
                }
                case 237: {
                    string = "*ildc_w";
                    break;
                }
                case 238: {
                    string = "*fldc_w";
                    break;
                }
                case 239: {
                    string = "*dldc2_w";
                    break;
                }
                case 233: {
                    string = "*cldc";
                    break;
                }
                case 236: {
                    string = "*cldc_w";
                    break;
                }
                case 254: {
                    string = "*byte_escape";
                    break;
                }
                case 253: {
                    string = "*ref_escape";
                    break;
                }
                case 255: {
                    string = "*end";
                    break;
                }
                default: {
                    string = "*bc#" + n;
                }
            }
        }
        return string;
    }

    private static void def(String string, int n) {
        Instruction.def(string, n, n);
    }

    private static void def(String string, int n, int n2) {
        String[] stringArray = new String[]{string, null};
        if (string.indexOf(119) > 0) {
            stringArray[1] = string.substring(string.indexOf(119));
            stringArray[0] = string.substring(0, string.indexOf(119));
        }
        for (int i = 0; i <= 1; ++i) {
            string = stringArray[i];
            if (string == null) continue;
            int n3 = string.length();
            int n4 = Math.max(0, string.indexOf(107));
            int n5 = 0;
            int n6 = Math.max(0, string.indexOf(111));
            int n7 = Math.max(0, string.indexOf(108));
            int n8 = Math.max(0, string.indexOf(120));
            if (n4 > 0 && n4 + 1 < n3) {
                switch (string.charAt(n4 + 1)) {
                    case 'c': {
                        n5 = 7;
                        break;
                    }
                    case 'k': {
                        n5 = 20;
                        break;
                    }
                    case 'f': {
                        n5 = 9;
                        break;
                    }
                    case 'm': {
                        n5 = 10;
                        break;
                    }
                    case 'i': {
                        n5 = 11;
                    }
                }
                assert (n5 != 0);
            } else if (n4 > 0 && n3 == 2) {
                assert (n == 18);
                n5 = 20;
            }
            for (int j = n; j <= n2; ++j) {
                Instruction.BC_FORMAT[i][j] = string;
                assert (BC_LENGTH[i][j] == -1);
                Instruction.BC_LENGTH[i][j] = (byte)n3;
                Instruction.BC_INDEX[i][j] = (byte)n4;
                Instruction.BC_TAG[i][j] = (byte)n5;
                assert (n4 != 0 || n5 == 0);
                Instruction.BC_BRANCH[i][j] = (byte)n6;
                Instruction.BC_SLOT[i][j] = (byte)n7;
                assert (n6 == 0 || n7 == 0);
                assert (n6 == 0 || n4 == 0);
                assert (n7 == 0 || n4 == 0);
                Instruction.BC_CON[i][j] = (byte)n8;
            }
        }
    }

    public static void opcodeChecker(byte[] byArray) throws FormatException {
        for (Instruction instruction = Instruction.at(byArray, 0); instruction != null; instruction = instruction.next()) {
            int n = instruction.getBC();
            if (n != 186 && n >= 0 && n <= 201) continue;
            String string = "illegal opcode: " + n + " " + instruction;
            throw new FormatException(string);
        }
    }

    static {
        int n;
        BC_LENGTH = new byte[2][256];
        BC_INDEX = new byte[2][256];
        BC_TAG = new byte[2][256];
        BC_BRANCH = new byte[2][256];
        BC_SLOT = new byte[2][256];
        BC_CON = new byte[2][256];
        BC_NAME = new String[256];
        BC_FORMAT = new String[2][202];
        for (n = 0; n < 202; ++n) {
            Instruction.BC_LENGTH[0][n] = -1;
            Instruction.BC_LENGTH[1][n] = -1;
        }
        Instruction.def("b", 0, 15);
        Instruction.def("bx", 16);
        Instruction.def("bxx", 17);
        Instruction.def("bk", 18);
        Instruction.def("bkk", 19, 20);
        Instruction.def("blwbll", 21, 25);
        Instruction.def("b", 26, 53);
        Instruction.def("blwbll", 54, 58);
        Instruction.def("b", 59, 131);
        Instruction.def("blxwbllxx", 132);
        Instruction.def("b", 133, 152);
        Instruction.def("boo", 153, 168);
        Instruction.def("blwbll", 169);
        Instruction.def("", 170, 171);
        Instruction.def("b", 172, 177);
        Instruction.def("bkf", 178, 181);
        Instruction.def("bkm", 182, 184);
        Instruction.def("bkixx", 185);
        Instruction.def("", 186);
        Instruction.def("bkc", 187);
        Instruction.def("bx", 188);
        Instruction.def("bkc", 189);
        Instruction.def("b", 190, 191);
        Instruction.def("bkc", 192, 193);
        Instruction.def("b", 194, 195);
        Instruction.def("", 196);
        Instruction.def("bkcx", 197);
        Instruction.def("boo", 198, 199);
        Instruction.def("boooo", 200, 201);
        for (n = 0; n < 202; ++n) {
            if (BC_LENGTH[0][n] == -1) {
                assert (n == 186);
                continue;
            }
            if (BC_LENGTH[1][n] != -1) continue;
            Instruction.BC_LENGTH[1][n] = (byte)(1 + BC_LENGTH[0][n]);
        }
        String string = "nop aconst_null iconst_m1 iconst_0 iconst_1 iconst_2 iconst_3 iconst_4 iconst_5 lconst_0 lconst_1 fconst_0 fconst_1 fconst_2 dconst_0 dconst_1 bipush sipush ldc ldc_w ldc2_w iload lload fload dload aload iload_0 iload_1 iload_2 iload_3 lload_0 lload_1 lload_2 lload_3 fload_0 fload_1 fload_2 fload_3 dload_0 dload_1 dload_2 dload_3 aload_0 aload_1 aload_2 aload_3 iaload laload faload daload aaload baload caload saload istore lstore fstore dstore astore istore_0 istore_1 istore_2 istore_3 lstore_0 lstore_1 lstore_2 lstore_3 fstore_0 fstore_1 fstore_2 fstore_3 dstore_0 dstore_1 dstore_2 dstore_3 astore_0 astore_1 astore_2 astore_3 iastore lastore fastore dastore aastore bastore castore sastore pop pop2 dup dup_x1 dup_x2 dup2 dup2_x1 dup2_x2 swap iadd ladd fadd dadd isub lsub fsub dsub imul lmul fmul dmul idiv ldiv fdiv ddiv irem lrem frem drem ineg lneg fneg dneg ishl lshl ishr lshr iushr lushr iand land ior lor ixor lxor iinc i2l i2f i2d l2i l2f l2d f2i f2l f2d d2i d2l d2f i2b i2c i2s lcmp fcmpl fcmpg dcmpl dcmpg ifeq ifne iflt ifge ifgt ifle if_icmpeq if_icmpne if_icmplt if_icmpge if_icmpgt if_icmple if_acmpeq if_acmpne goto jsr ret tableswitch lookupswitch ireturn lreturn freturn dreturn areturn return getstatic putstatic getfield putfield invokevirtual invokespecial invokestatic invokeinterface xxxunusedxxx new newarray anewarray arraylength athrow checkcast instanceof monitorenter monitorexit wide multianewarray ifnull ifnonnull goto_w jsr_w ";
        int n2 = 0;
        while (string.length() > 0) {
            int n3 = string.indexOf(32);
            Instruction.BC_NAME[n2] = string.substring(0, n3);
            string = string.substring(n3 + 1);
            ++n2;
        }
        BW = 4;
    }

    static class FormatException
    extends IOException {
        FormatException(String string) {
            super(string);
        }
    }

    public static class LookupSwitch
    extends Switch {
        @Override
        public int getCaseCount() {
            return this.intAt(1);
        }

        @Override
        public int getCaseValue(int n) {
            return this.intAt(2 + n * 2 + 0);
        }

        @Override
        public int getCaseLabel(int n) {
            return this.intAt(2 + n * 2 + 1) + this.pc;
        }

        @Override
        public void setCaseCount(int n) {
            this.setIntAt(1, n);
            this.length = this.getLength(n);
        }

        @Override
        public void setCaseValue(int n, int n2) {
            this.setIntAt(2 + n * 2 + 0, n2);
        }

        @Override
        public void setCaseLabel(int n, int n2) {
            this.setIntAt(2 + n * 2 + 1, n2 - this.pc);
        }

        LookupSwitch(byte[] byArray, int n) {
            super(byArray, n, 171);
        }

        @Override
        protected int getLength(int n) {
            return this.apc - this.pc + (2 + n * 2) * 4;
        }
    }

    public static abstract class Switch
    extends Instruction {
        protected int apc;

        public abstract int getCaseCount();

        public abstract int getCaseValue(int var1);

        public abstract int getCaseLabel(int var1);

        public abstract void setCaseCount(int var1);

        public abstract void setCaseValue(int var1, int var2);

        public abstract void setCaseLabel(int var1, int var2);

        protected abstract int getLength(int var1);

        public int getDefaultLabel() {
            return this.intAt(0) + this.pc;
        }

        public void setDefaultLabel(int n) {
            this.setIntAt(0, n - this.pc);
        }

        protected int intAt(int n) {
            return Switch.getInt(this.bytes, this.apc + n * 4);
        }

        protected void setIntAt(int n, int n2) {
            Switch.setInt(this.bytes, this.apc + n * 4, n2);
        }

        protected Switch(byte[] byArray, int n, int n2) {
            super(byArray, n, n2, 0, 0);
            this.apc = Switch.alignPC(n + 1);
            this.special = true;
            this.length = this.getLength(this.getCaseCount());
        }

        public int getAlignedPC() {
            return this.apc;
        }

        @Override
        public String toString() {
            String string = super.toString();
            string = string + " Default:" + Switch.labstr(this.getDefaultLabel());
            int n = this.getCaseCount();
            for (int i = 0; i < n; ++i) {
                string = string + "\n\tCase " + this.getCaseValue(i) + ":" + Switch.labstr(this.getCaseLabel(i));
            }
            return string;
        }

        public static int alignPC(int n) {
            while (n % 4 != 0) {
                ++n;
            }
            return n;
        }
    }

    public static class TableSwitch
    extends Switch {
        public int getLowCase() {
            return this.intAt(1);
        }

        public int getHighCase() {
            return this.intAt(2);
        }

        @Override
        public int getCaseCount() {
            return this.intAt(2) - this.intAt(1) + 1;
        }

        @Override
        public int getCaseValue(int n) {
            return this.getLowCase() + n;
        }

        @Override
        public int getCaseLabel(int n) {
            return this.intAt(3 + n) + this.pc;
        }

        public void setLowCase(int n) {
            this.setIntAt(1, n);
        }

        public void setHighCase(int n) {
            this.setIntAt(2, n);
        }

        @Override
        public void setCaseLabel(int n, int n2) {
            this.setIntAt(3 + n, n2 - this.pc);
        }

        @Override
        public void setCaseCount(int n) {
            this.setHighCase(this.getLowCase() + n - 1);
            this.length = this.getLength(n);
        }

        @Override
        public void setCaseValue(int n, int n2) {
            if (n != 0) {
                throw new UnsupportedOperationException();
            }
            int n3 = this.getCaseCount();
            this.setLowCase(n2);
            this.setCaseCount(n3);
        }

        TableSwitch(byte[] byArray, int n) {
            super(byArray, n, 170);
        }

        @Override
        protected int getLength(int n) {
            return this.apc - this.pc + (3 + n) * 4;
        }
    }
}

