/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.doubletcalc;

import tno.geoenergy.doubletcalc.PipeCalcDirection;
import tno.geoenergy.doubletcalc.PipeTempCalcMethod;
import tno.geoenergy.doubletcalc.TnoGeoTemperature;
import tno.geoenergy.doubletcalc.TnoGeoThermalProject;
import tno.geoenergy.doubletcalc.TnoGeoThermalWell;
import tno.geoenergy.doubletcalc.TnoInputWindowData;
import tno.geoenergy.doubletcalc.TnoWaterProperties;

public class TnoDoublet {
    public TnoGeoThermalWell producer;
    public TnoGeoThermalWell injector;
    public String[] nodeNamesAlongDoublet = new String[]{"1, Aquifer_Prod", "2, Aquifer/Prod_Bottom", "5&6, Prod_Top/Entry_HE", "7&9, Exit_HE/Inj_Top", "10, Inj_Bottom/Aquifer", "11, Aquifer_Inj", "Residue"};
    public int pressNodeTopInj = 3;
    public double[] presAlongDoublet = new double[this.nodeNamesAlongDoublet.length];
    public double[] tempAlongDoublet = new double[this.nodeNamesAlongDoublet.length];
    public String name = "Doublet";
    public int idnumber;
    public double aquiferTopDepthAtProdBaseCase;
    public double aquiferTopDepthAtInjBaseCase;
    public double aquiferTopDepthAtProd;
    public double aquiferTopDepthAtInj;
    public double aquiferThickness;
    public double aquiferNtG;
    public double aquiferK;
    public double aquiferSalinity;
    public double aquiferStaticPresProd;
    public double aquiferStaticPresInj;
    public TnoGeoTemperature GeoTemperature;
    public double surfaceTemp;
    public double geoThermalGradient;
    public double exitTempHeatExchanger;
    public double tempTopProductionAquifer;
    public double tempMidProductionAquifer;
    public PipeTempCalcMethod tempCalcOptionProducer;
    public PipeTempCalcMethod tempCalcOptionInjector;
    public double distanceWellsAtAquifer;
    public double[] depthSegmentsTVDProd;
    public double[] depthSegmentsTVDInj;
    public double[] depthSegmentsAHProd;
    public double[] depthSegmentsAHInj;
    public double segmentLength;
    public double outerDiameterInj;
    public double outerDiameterPrd;
    public double[] innerDiameterInj;
    public double[] innerDiameterPrd;
    public double[] roughnessInj;
    public double[] roughnessPrd;
    public double skinProducer;
    public double skinInjector;
    public double pumpDepth;
    public double pumpPressureDrawDown;
    public double pumpMaxRate;
    public double pumpEfficiency;
    public double geoThermalPower;
    public double[] geothermalPowerYears;
    public double geothermalPowerYearsSingle;
    public double coP;
    public double pumpPower;
    public double qmass;
    private double aquiferKHnet;
    private double qvolPump;
    public double aquiferProductTopPressure;
    public double aquiferInjectTopPressure;
    public double productDensity;
    public double heatcapacity;
    public double deltaT;

    public TnoGeoThermalWell getProducer() {
        return this.producer;
    }

    public void setProducer(TnoGeoThermalWell producer) {
        this.producer = producer;
    }

    public TnoGeoThermalWell getInjector() {
        return this.injector;
    }

    public void setInjector(TnoGeoThermalWell injector) {
        this.injector = injector;
    }

    public String[] getNodeNamesAlongDoublet() {
        return this.nodeNamesAlongDoublet;
    }

    public void setNodeNamesAlongDoublet(String[] nodeNamesAlongDoublet) {
        this.nodeNamesAlongDoublet = nodeNamesAlongDoublet;
    }

    public int getPressNodeTopInj() {
        return this.pressNodeTopInj;
    }

    public void setPressNodeTopInj(int pressNodeTopInj) {
        this.pressNodeTopInj = pressNodeTopInj;
    }

    public double[] getPresAlongDoublet() {
        return this.presAlongDoublet;
    }

    public void setPresAlongDoublet(double[] presAlongDoublet) {
        this.presAlongDoublet = presAlongDoublet;
    }

    public double[] getTempAlongDoublet() {
        return this.tempAlongDoublet;
    }

    public void setTempAlongDoublet(double[] tempAlongDoublet) {
        this.tempAlongDoublet = tempAlongDoublet;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getIdnumber() {
        return this.idnumber;
    }

    public void setIdnumber(int idnumber) {
        this.idnumber = idnumber;
    }

    public double getAquiferTopDepthAtProd() {
        return this.aquiferTopDepthAtProd;
    }

    public void setAquiferTopDepthAtProd(double aquiferTopDepthAtProd) {
        this.aquiferTopDepthAtProd = aquiferTopDepthAtProd;
    }

    public double getAquiferTopDepthAtInj() {
        return this.aquiferTopDepthAtInj;
    }

    public void setAquiferTopDepthAtInj(double aquiferTopDepthAtInj) {
        this.aquiferTopDepthAtInj = aquiferTopDepthAtInj;
    }

    public double getAquiferThickness() {
        return this.aquiferThickness;
    }

    public void setAquiferThickness(double aquiferThickness) {
        this.aquiferThickness = aquiferThickness;
    }

    public double getAquiferNtG() {
        return this.aquiferNtG;
    }

    public void setAquiferNtG(double aquiferNtG) {
        this.aquiferNtG = aquiferNtG;
    }

    public double getAquiferK() {
        return this.aquiferK;
    }

    public void setAquiferK(double aquiferK) {
        this.aquiferK = aquiferK;
    }

    public double getAquiferSalinity() {
        return this.aquiferSalinity;
    }

    public void setAquiferSalinity(double aquiferSalinity) {
        this.aquiferSalinity = aquiferSalinity;
    }

    public double getAquiferStaticPresProd() {
        return this.aquiferStaticPresProd;
    }

    public void setAquiferStaticPresProd(double aquiferStaticPresProd) {
        this.aquiferStaticPresProd = aquiferStaticPresProd;
    }

    public double getAquiferStaticPresInj() {
        return this.aquiferStaticPresInj;
    }

    public void setAquiferStaticPresInj(double aquiferStaticPresInj) {
        this.aquiferStaticPresInj = aquiferStaticPresInj;
    }

    public TnoGeoTemperature getGeoTemperature() {
        return this.GeoTemperature;
    }

    public void setGeoTemperature(TnoGeoTemperature geoTemperature) {
        this.GeoTemperature = geoTemperature;
    }

    public double getSurfaceTemp() {
        return this.surfaceTemp;
    }

    public void setSurfaceTemp(double surfaceTemp) {
        this.surfaceTemp = surfaceTemp;
    }

    public double getGeoThermalGradient() {
        return this.geoThermalGradient;
    }

    public void setGeoThermalGradient(double geoThermalGradient) {
        this.geoThermalGradient = geoThermalGradient;
    }

    public double getExitTempHeatExchanger() {
        return this.exitTempHeatExchanger;
    }

    public void setExitTempHeatExchanger(double exitTempHeatExchanger) {
        this.exitTempHeatExchanger = exitTempHeatExchanger;
    }

    public double getTempTopProductionAquifer() {
        return this.tempTopProductionAquifer;
    }

    public void setTempTopProductionAquifer(double tempTopProductionAquifer) {
        this.tempTopProductionAquifer = tempTopProductionAquifer;
    }

    public double getTempMidProductionAquifer() {
        return this.tempMidProductionAquifer;
    }

    public void setTempMidProductionAquifer(double tempMidProductionAquifer) {
        this.tempMidProductionAquifer = tempMidProductionAquifer;
    }

    public PipeTempCalcMethod getTempCalcOptionProducer() {
        return this.tempCalcOptionProducer;
    }

    public void setTempCalcOptionProducer(PipeTempCalcMethod tempCalcOptionProducer) {
        this.tempCalcOptionProducer = tempCalcOptionProducer;
    }

    public PipeTempCalcMethod getTempCalcOptionInjector() {
        return this.tempCalcOptionInjector;
    }

    public void setTempCalcOptionInjector(PipeTempCalcMethod tempCalcOptionInjector) {
        this.tempCalcOptionInjector = tempCalcOptionInjector;
    }

    public double getDistanceWellsAtAquifer() {
        return this.distanceWellsAtAquifer;
    }

    public void setDistanceWellsAtAquifer(double distanceWellsAtAquifer) {
        this.distanceWellsAtAquifer = distanceWellsAtAquifer;
    }

    public double[] getDepthSegmentsTVDProd() {
        return this.depthSegmentsTVDProd;
    }

    public void setDepthSegmentsTVDProd(double[] segmentsTVDProd) {
        this.depthSegmentsTVDProd = segmentsTVDProd;
    }

    public double[] getDepthSegmentsTVDInj() {
        return this.depthSegmentsTVDInj;
    }

    public void setDepthSegmentsTVDInj(double[] segmentsTVDInj) {
        this.depthSegmentsTVDInj = segmentsTVDInj;
    }

    public double[] getDepthSegmentsAHProd() {
        return this.depthSegmentsAHProd;
    }

    public void setDepthSegmentsAHProd(double[] segmentsAHProd) {
        this.depthSegmentsAHProd = segmentsAHProd;
    }

    public double[] getDepthSegmentsAHInj() {
        return this.depthSegmentsAHInj;
    }

    public void setDepthSegmentsAHInj(double[] segmentsAHInj) {
        this.depthSegmentsAHInj = segmentsAHInj;
    }

    public double getSegmentLength() {
        return this.segmentLength;
    }

    public void setSegmentLength(double segmentLength) {
        this.segmentLength = segmentLength;
    }

    public double getOuterDiameterInj() {
        return this.outerDiameterInj;
    }

    public void setOuterDiameterInj(double outerDiameterInj) {
        this.outerDiameterInj = outerDiameterInj;
    }

    public double[] getInnerDiameterInj() {
        return this.innerDiameterInj;
    }

    public void setInnerDiameterInj(double[] innerDiameterInj) {
        this.innerDiameterInj = innerDiameterInj;
    }

    public double getOuterDiameterPrd() {
        return this.outerDiameterPrd;
    }

    public void setOuterDiameterPrd(double outerDiameterPrd) {
        this.outerDiameterPrd = outerDiameterPrd;
    }

    public double[] getInnerDiameterPrd() {
        return this.innerDiameterPrd;
    }

    public void setInnerDiameterPrd(double[] innerDiameterPrd) {
        this.innerDiameterPrd = innerDiameterPrd;
    }

    public double[] getRoughnessInj() {
        return this.roughnessInj;
    }

    public void setRoughnessInj(double[] roughness) {
        this.roughnessInj = roughness;
    }

    public double[] getRoughnessPrd() {
        return this.roughnessPrd;
    }

    public void setRoughnessPrd(double[] roughness) {
        this.roughnessPrd = roughness;
    }

    public double getSkinProducer() {
        return this.skinProducer;
    }

    public void setSkinProducer(double skinProducer) {
        this.skinProducer = skinProducer;
    }

    public double getSkinInjector() {
        return this.skinInjector;
    }

    public void setSkinInjector(double skinInjector) {
        this.skinInjector = skinInjector;
    }

    public double getPumpDepth() {
        return this.pumpDepth;
    }

    public void setPumpDepth(double pumpDepth) {
        this.pumpDepth = pumpDepth;
    }

    public double getPumpPressureDrawDown() {
        return this.pumpPressureDrawDown;
    }

    public void setPumpPressureDrawDown(double pumpPressureDrawDown) {
        this.pumpPressureDrawDown = pumpPressureDrawDown;
    }

    public double getPumpMaxRate() {
        return this.pumpMaxRate;
    }

    public void setPumpMaxRate(double pumpMaxRate) {
        this.pumpMaxRate = pumpMaxRate;
    }

    public double getPumpEfficiency() {
        return this.pumpEfficiency;
    }

    public void setPumpEfficiency(double pumpEfficiency) {
        this.pumpEfficiency = pumpEfficiency;
    }

    public double getGeoThermalPower() {
        return this.geoThermalPower;
    }

    public void setGeoThermalPower(double geoThermalPower) {
        this.geoThermalPower = geoThermalPower;
    }

    public double getCoP() {
        return this.coP;
    }

    public void setCoP(double coP) {
        this.coP = coP;
    }

    public double getPumpPower() {
        return this.pumpPower;
    }

    public void setPumpPower(double pumpPower) {
        this.pumpPower = pumpPower;
    }

    public double getQmass() {
        return this.qmass;
    }

    public void setQmass(double qmass) {
        this.qmass = qmass;
    }

    public double getQvolInjector() {
        return this.injector.wellTubing.qVolNode[0];
    }

    public double getAquiferKHnet() {
        return this.aquiferK * this.aquiferThickness * this.aquiferNtG;
    }

    public double getQvolPump() {
        return 0.5 * (this.producer.wellTubing.qVolNode[this.producer.wellTubing.PumpSegment] + this.producer.wellTubing.qVolNode[this.producer.wellTubing.PumpSegment + 1]);
    }

    public double getProductDensity() {
        return this.productDensity;
    }

    public double getHeatCapacity() {
        return this.heatcapacity;
    }

    public double getDeltaT() {
        return this.deltaT;
    }

    public void LoadDataFromInput(TnoInputWindowData input) {
        this.aquiferTopDepthAtProdBaseCase = input.aquiferTopDepthAtProd.getDistribution().getMedian();
        this.aquiferTopDepthAtProd = input.aquiferTopDepthAtProd.getDistribution().getMedian();
        this.aquiferTopDepthAtInjBaseCase = input.aquiferTopDepthAtInj.getDistribution().getMedian();
        this.aquiferTopDepthAtInj = input.aquiferTopDepthAtInj.getDistribution().getMedian();
        this.aquiferThickness = input.aquiferThickness.getDistribution().getMedian();
        this.aquiferK = input.aquiferK.getDistribution().getMedian();
        this.aquiferNtG = input.aquiferNtG.getDistribution().getMedian();
        this.aquiferSalinity = input.aquiferSalinity.getDistribution().getMedian();
        this.surfaceTemp = input.surfaceTemp;
        this.geoThermalGradient = input.geoThermalGradient;
        this.tempTopProductionAquifer = input.tempTopProductionAquifer;
        this.exitTempHeatExchanger = input.exitTempHeatExchanger;
        this.distanceWellsAtAquifer = input.distanceWellsAtAquifer;
        this.depthSegmentsTVDProd = input.segmentsPrdTVD;
        this.depthSegmentsTVDInj = input.segmentsInjTVD;
        this.depthSegmentsAHProd = input.segmentsPrdAH;
        this.depthSegmentsAHInj = input.segmentsInjAH;
        this.segmentLength = input.segmentLength;
        this.outerDiameterInj = input.outerDiameterInject;
        this.outerDiameterPrd = input.outerDiameterProduct;
        this.innerDiameterInj = input.innerDiameterInj;
        this.innerDiameterPrd = input.innerDiameterPrd;
        this.roughnessInj = input.roughnessInj;
        this.roughnessPrd = input.roughnessPrd;
        this.skinProducer = input.skinProducer;
        this.skinInjector = input.skinInjector;
        this.pumpDepth = input.pumpDepth;
        this.pumpPressureDrawDown = input.pumpPressureDrawDown;
        this.pumpMaxRate = 0.0;
        this.pumpEfficiency = input.pumpEfficiency;
        this.tempCalcOptionProducer = input.tempCalcOptionProducer;
        this.tempCalcOptionInjector = input.tempCalcOptionInjector;
        this.aquiferProductTopPressure = input.aquiferProductTopPressure;
        this.aquiferInjectTopPressure = input.aquiferInjectTopPressure;
    }

    public void Build() {
        int iN;
        boolean pumpPresent = true;
        if (this.geoThermalGradient == 0.0 && this.tempTopProductionAquifer != 0.0) {
            this.GeoTemperature = new TnoGeoTemperature(this.surfaceTemp, this.tempTopProductionAquifer, this.aquiferTopDepthAtProd);
            this.geoThermalGradient = this.GeoTemperature.geoThermalGradient;
        } else {
            this.GeoTemperature = new TnoGeoTemperature(this.surfaceTemp, this.geoThermalGradient);
            this.tempTopProductionAquifer = this.GeoTemperature.TemperatureAt(this.aquiferTopDepthAtProd);
        }
        this.tempMidProductionAquifer = this.GeoTemperature.TemperatureAt(this.aquiferTopDepthAtProd + 0.5 * this.aquiferThickness);
        double pipeScalingPrd = this.aquiferTopDepthAtProdBaseCase - this.aquiferTopDepthAtProd;
        this.producer = new TnoGeoThermalWell("Producer", pipeScalingPrd, this.depthSegmentsTVDProd, this.depthSegmentsAHProd, this.outerDiameterPrd, this.innerDiameterPrd, this.roughnessPrd, this.segmentLength, true, -this.pumpDepth, this.pumpPressureDrawDown, this.pumpMaxRate, this.pumpEfficiency, this.skinProducer);
        double pipeScalingInj = this.aquiferTopDepthAtInjBaseCase - this.aquiferTopDepthAtInj;
        this.injector = new TnoGeoThermalWell("Injector", pipeScalingInj, this.depthSegmentsTVDInj, this.depthSegmentsAHInj, this.outerDiameterInj, this.innerDiameterInj, this.roughnessInj, this.segmentLength, false, 0.0, 0.0, 0.0, 0.0, this.skinInjector);
        double dSdZ = this.aquiferSalinity / this.aquiferTopDepthAtProd;
        for (iN = 0; iN < this.producer.wellTubing.NodesCount; ++iN) {
            this.producer.wellTubing.temperatureNode[iN] = this.GeoTemperature.TemperatureAt(-this.producer.wellTubing.zNode[iN]);
            this.producer.wellTubing.salinityNode[iN] = -dSdZ * this.producer.wellTubing.zNode[iN];
        }
        if (this.aquiferProductTopPressure == 0.0) {
            this.producer.wellTubing.CalcPressuresAlongPipe(0.0, 100000.0, 0.0, 0.0, PipeCalcDirection.BeginToEnd, PipeTempCalcMethod.Explicit);
            this.aquiferStaticPresProd = this.producer.wellTubing.pressureNode[this.producer.wellTubing.NodesCount - 1];
        } else {
            this.aquiferStaticPresProd = this.aquiferProductTopPressure;
        }
        for (iN = 0; iN < this.injector.wellTubing.NodesCount; ++iN) {
            this.injector.wellTubing.temperatureNode[iN] = this.GeoTemperature.TemperatureAt(-this.injector.wellTubing.zNode[iN]);
            this.injector.wellTubing.salinityNode[iN] = -dSdZ * this.injector.wellTubing.zNode[iN];
        }
        if (this.aquiferInjectTopPressure == 0.0) {
            this.injector.wellTubing.CalcPressuresAlongPipe(0.0, 100000.0, 0.0, 0.0, PipeCalcDirection.BeginToEnd, PipeTempCalcMethod.Explicit);
            this.aquiferStaticPresInj = this.injector.wellTubing.pressureNode[this.injector.wellTubing.NodesCount - 1];
        } else {
            this.aquiferStaticPresInj = this.aquiferInjectTopPressure;
        }
        this.producer.saveHydrostatic();
        this.injector.saveHydrostatic();
        for (iN = 0; iN < this.producer.wellTubing.NodesCount; ++iN) {
            this.producer.wellTubing.tempEnvironmentNode[iN] = this.GeoTemperature.TemperatureAt(-this.producer.wellTubing.zNode[iN]);
            this.producer.wellTubing.salinityNode[iN] = this.aquiferSalinity;
        }
        for (iN = 0; iN < this.injector.wellTubing.NodesCount; ++iN) {
            this.injector.wellTubing.tempEnvironmentNode[iN] = this.GeoTemperature.TemperatureAt(-this.injector.wellTubing.zNode[iN]);
            this.injector.wellTubing.salinityNode[iN] = this.aquiferSalinity;
        }
    }

    public double CalcMassRate(double pumpPressureDiff) {
        double tolerance = 10.0;
        double rateMass = 1.0;
        double dpWellsToAquifer = 0.0;
        double density = TnoWaterProperties.Density(this.aquiferStaticPresProd, this.tempTopProductionAquifer, this.aquiferSalinity);
        double viscosity = TnoWaterProperties.Viscosity(this.aquiferStaticPresProd, this.tempTopProductionAquifer, this.aquiferSalinity);
        dpWellsToAquifer = this.producer.DpWellAquifer(rateMass / density, this.getAquiferKHnet(), this.distanceWellsAtAquifer, viscosity);
        density = TnoWaterProperties.Density(this.aquiferStaticPresInj, this.exitTempHeatExchanger, this.aquiferSalinity);
        viscosity = TnoWaterProperties.Viscosity(this.aquiferStaticPresInj, this.exitTempHeatExchanger, this.aquiferSalinity);
        double qk = 0.8 * pumpPressureDiff / (dpWellsToAquifer += this.injector.DpWellAquifer(rateMass / density, this.getAquiferKHnet(), this.distanceWellsAtAquifer, viscosity));
        double qkm1 = qk * 0.99;
        double funckm1 = this.CalcPressureBalance(qkm1, pumpPressureDiff);
        boolean converged = false;
        int k = 0;
        while (!converged) {
            double dFuncDq;
            if (++k > 100) {
                TnoGeoThermalProject.notConverging = true;
                break;
            }
            double qkm2 = qkm1;
            double funckm2 = funckm1;
            qkm1 = qk;
            funckm1 = this.CalcPressureBalance(qkm1, pumpPressureDiff);
            if ((qk = qkm1 - funckm1 / (dFuncDq = (funckm2 - funckm1) / (qkm2 - qkm1))) <= 0.0) {
                qk = 0.5 * qkm1;
            }
            converged = Math.abs(funckm1) < 10.0;
        }
        this.CalcPressureBalance(qk, pumpPressureDiff);
        this.qmass = qk;
        return qk;
    }

    private double CalcPressureBalance(double rateMass, double pumpPressure) {
        double presAtNode = 0.0;
        double tempAtNode = 0.0;
        int iDoubletNode = 0;
        this.presAlongDoublet[iDoubletNode] = presAtNode += this.aquiferStaticPresProd;
        this.tempAlongDoublet[iDoubletNode] = tempAtNode += this.tempMidProductionAquifer;
        double density = TnoWaterProperties.Density(presAtNode, this.tempTopProductionAquifer, this.aquiferSalinity);
        double viscosity = TnoWaterProperties.Viscosity(presAtNode, this.tempTopProductionAquifer, this.aquiferSalinity);
        double dp = -this.producer.DpWellAquifer(rateMass / density, this.getAquiferKHnet(), this.distanceWellsAtAquifer, viscosity);
        double dT = 0.0;
        this.presAlongDoublet[++iDoubletNode] = presAtNode += dp;
        this.tempAlongDoublet[iDoubletNode] = tempAtNode += dT;
        this.producer.wellTubing.CalcPressuresAlongPipe(-rateMass, presAtNode, tempAtNode, pumpPressure, PipeCalcDirection.EndToBegin, this.tempCalcOptionProducer);
        dp = -this.producer.wellTubing.DpTotal;
        dT = -this.producer.wellTubing.DTTotal;
        this.presAlongDoublet[++iDoubletNode] = presAtNode += dp;
        this.tempAlongDoublet[iDoubletNode] = tempAtNode += dT;
        dp = 0.0;
        dT = this.exitTempHeatExchanger - tempAtNode;
        this.presAlongDoublet[++iDoubletNode] = presAtNode += dp;
        this.tempAlongDoublet[iDoubletNode] = tempAtNode += dT;
        this.injector.wellTubing.CalcPressuresAlongPipe(rateMass, presAtNode, tempAtNode, pumpPressure, PipeCalcDirection.BeginToEnd, this.tempCalcOptionInjector);
        dp = this.injector.wellTubing.DpTotal;
        dT = this.injector.wellTubing.DTTotal;
        this.presAlongDoublet[++iDoubletNode] = presAtNode += dp;
        this.tempAlongDoublet[iDoubletNode] = tempAtNode += dT;
        density = TnoWaterProperties.Density(presAtNode, tempAtNode, this.aquiferSalinity);
        viscosity = TnoWaterProperties.Viscosity(presAtNode, tempAtNode, this.aquiferSalinity);
        dp = -this.injector.DpWellAquifer(rateMass / density, this.getAquiferKHnet(), this.distanceWellsAtAquifer, viscosity);
        dT = this.tempMidProductionAquifer - tempAtNode;
        this.presAlongDoublet[++iDoubletNode] = presAtNode += dp;
        this.tempAlongDoublet[iDoubletNode] = tempAtNode += dT;
        dp = -this.aquiferStaticPresInj;
        dT = 0.0;
        this.presAlongDoublet[++iDoubletNode] = presAtNode += dp;
        this.tempAlongDoublet[iDoubletNode] = tempAtNode += dT;
        ++iDoubletNode;
        return presAtNode;
    }

    public void CalcPowerData() {
        double P = this.producer.wellTubing.pressureNode[0];
        double Tentry = this.producer.wellTubing.temperatureNode[0];
        double S = this.producer.wellTubing.salinityNode[0];
        double Texit = this.exitTempHeatExchanger;
        double cp = TnoWaterProperties.HeatCapacity(P, Tentry, S);
        this.geoThermalPower = this.qmass * cp * (Tentry - Texit);
        this.heatcapacity = cp;
        this.deltaT = Tentry - Texit;
        int iPumpNode1 = this.producer.wellTubing.PumpSegment;
        int iPumpNode2 = iPumpNode1 + 1;
        double densProductAvg = 0.5 * (this.producer.wellTubing.densityNode[iPumpNode1] + this.producer.wellTubing.densityNode[iPumpNode2]);
        double qVolPump = this.qmass / densProductAvg;
        this.productDensity = densProductAvg;
        this.pumpPower = qVolPump * this.pumpPressureDrawDown / this.pumpEfficiency;
        this.coP = this.geoThermalPower / this.pumpPower;
    }

    private static double[] cloneDoubleArray(double[] inputList) {
        int length = inputList.length;
        double[] outputList = new double[length];
        for (int i = 0; i < length; ++i) {
            outputList[i] = inputList[i];
        }
        return outputList;
    }

    public TnoDoublet Clone() {
        TnoDoublet c = new TnoDoublet();
        c.producer = this.producer;
        c.injector = this.injector;
        c.nodeNamesAlongDoublet = this.nodeNamesAlongDoublet;
        c.pressNodeTopInj = this.pressNodeTopInj;
        c.presAlongDoublet = TnoDoublet.cloneDoubleArray(this.presAlongDoublet);
        c.tempAlongDoublet = TnoDoublet.cloneDoubleArray(this.tempAlongDoublet);
        c.name = this.name;
        c.idnumber = this.idnumber;
        c.aquiferTopDepthAtProd = this.aquiferTopDepthAtProd;
        c.aquiferTopDepthAtProdBaseCase = this.aquiferTopDepthAtProdBaseCase;
        c.aquiferTopDepthAtInj = this.aquiferTopDepthAtInj;
        c.aquiferTopDepthAtInjBaseCase = this.aquiferTopDepthAtInjBaseCase;
        c.aquiferThickness = this.aquiferThickness;
        c.aquiferNtG = this.aquiferNtG;
        c.aquiferK = this.aquiferK;
        c.aquiferThickness = this.aquiferThickness;
        c.aquiferSalinity = this.aquiferSalinity;
        c.aquiferStaticPresProd = this.aquiferStaticPresProd;
        c.aquiferStaticPresInj = this.aquiferStaticPresInj;
        c.GeoTemperature = this.GeoTemperature;
        c.surfaceTemp = this.surfaceTemp;
        c.geoThermalGradient = this.geoThermalGradient;
        c.exitTempHeatExchanger = this.exitTempHeatExchanger;
        c.tempTopProductionAquifer = this.tempTopProductionAquifer;
        c.tempMidProductionAquifer = this.tempMidProductionAquifer;
        c.tempCalcOptionProducer = this.tempCalcOptionProducer;
        c.tempCalcOptionInjector = this.tempCalcOptionInjector;
        c.distanceWellsAtAquifer = this.distanceWellsAtAquifer;
        c.depthSegmentsTVDProd = this.depthSegmentsTVDProd;
        c.depthSegmentsTVDInj = this.depthSegmentsTVDInj;
        c.segmentLength = this.segmentLength;
        c.outerDiameterInj = this.outerDiameterInj;
        c.innerDiameterInj = this.innerDiameterInj;
        c.roughnessInj = this.roughnessInj;
        c.outerDiameterPrd = this.outerDiameterPrd;
        c.innerDiameterPrd = this.innerDiameterPrd;
        c.roughnessPrd = this.roughnessPrd;
        c.skinProducer = this.skinProducer;
        c.skinInjector = this.skinInjector;
        c.pumpDepth = this.pumpDepth;
        c.pumpPressureDrawDown = this.pumpPressureDrawDown;
        c.pumpMaxRate = this.pumpMaxRate;
        c.pumpEfficiency = this.pumpEfficiency;
        c.geoThermalPower = this.geoThermalPower;
        c.coP = this.coP;
        c.pumpPower = this.pumpPower;
        c.qmass = this.qmass;
        c.aquiferKHnet = this.aquiferKHnet;
        c.qvolPump = this.qvolPump;
        c.productDensity = this.productDensity;
        c.heatcapacity = this.heatcapacity;
        c.deltaT = this.deltaT;
        c.depthSegmentsAHProd = this.depthSegmentsAHProd;
        c.depthSegmentsAHInj = this.depthSegmentsAHInj;
        c.geothermalPowerYears = new double[this.geothermalPowerYears.length];
        for (int i = 0; i < this.geothermalPowerYears.length; ++i) {
            c.geothermalPowerYears[i] = this.geoThermalPower * 1.0E-6;
        }
        return c;
    }
}

