/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.doubletcalc;

public class TnoWaterProperties {
    public static double Density(double P, double T, double S) {
        P = Math.max(P, 1.0);
        T = Math.max(T, 0.0);
        S = Math.max(S, 0.0);
        double densityFresh = 1.0 + 1.0E-6 * (-80.0 * T - 3.3 * T * T + 0.00175 * T * T * T + 489.0 * (P *= 1.0E-6) - 2.0 * T * P + 0.016 * T * T * P - 1.3E-5 * T * T * T * P - 0.333 * P * P - 0.002 * T * P * P);
        double density = densityFresh + S * (0.668 + 0.44 * S + 1.0E-6 * (300.0 * P - 2400.0 * P * S + T * (80.0 + 3.0 * T - 3300.0 * S - 13.0 * P + 47.0 * P * S)));
        return density *= 1000.0;
    }

    public static double Viscosity(double P, double T, double S) {
        P = Math.max(P, 1.0);
        T = Math.max(T, 0.0);
        S = Math.max(S, 0.0);
        double viscosity = 0.1 + 0.333 * S + (1.65 + 91.9 * S * S * S) * Math.exp(-(0.42 * Math.pow(Math.pow(S, 0.8) - 0.17, 2.0) + 0.045) * Math.pow(T, 0.8));
        return viscosity *= 0.001;
    }

    public static double HeatCapacity(double P, double T, double S) {
        P = Math.max(P, 1.0);
        T = Math.max(T, 0.0);
        S = Math.max(S, 0.0);
        double heatCapacity = 5.328 + -0.0976 * (S *= 1000.0) + 4.04E-4 * S * S + (-0.006913000000000001 + 7.351E-4 * S - 3.15E-6 * S * S) * (T += 273.15) + (9.6E-6 - 1.927E-6 * S + 8.23E-9 * S * S) * T * T + (2.5E-9 + 1.666E-9 * S - 7.125E-12 * S * S) * T * T * T;
        return heatCapacity *= 1000.0;
    }
}

