/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.doubletcalc.io.file;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import tno.geoenergy.doubletcalc.ResultSet;
import tno.geoenergy.doubletcalc.TnoPipe;
import tno.geoenergy.doubletcalc.io.file.StringToFile;
import tno.geoenergy.doubletcalc.stochastic.TnoSingularContainer;
import tno.geoenergy.doubletcalc.stochastic.TnoStochasticContainerVar;

public class Dataexport {
    private Dataexport() {
    }

    private static double calcAverage(double[] nodeList) {
        double i = 0.0;
        double sum = 0.0;
        for (double node : nodeList) {
            sum += node;
            i += 1.0;
        }
        return sum / i;
    }

    private static double calcDiff(double[] nodeList) {
        double first = (float)nodeList[0];
        int maxIndex = nodeList.length - 1;
        double last = (float)nodeList[maxIndex];
        return last - first;
    }

    public static void createBaseCaseCSV(File filename, ResultSet rs) {
        TnoPipe PRODUCER = rs.baseCaseProducerPipe;
        TnoPipe INJECTOR = rs.baseCaseInjectorPipe;
        TnoPipe HYDROSTATICPRODUCER = rs.hydrostaticProducer;
        TnoPipe HYDROSTATICINJECTOR = rs.hydrostaticInjector;
        String SEP = ", ";
        try {
            TnoPipe[] pipes;
            TnoPipe[] aquifers;
            BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
            bw.write("Doublet Calculator 1.4 Base Case Details");
            bw.newLine();
            bw.newLine();
            for (TnoPipe pipe : aquifers = new TnoPipe[]{HYDROSTATICPRODUCER, HYDROSTATICINJECTOR}) {
                String pipeID = pipe.equals(HYDROSTATICPRODUCER) ? "HYDROSTATIC AQUIFER PROPERTIES @PRODUCER" : (pipe.equals(HYDROSTATICINJECTOR) ? "HYDROSTATIC AQUIFER PROPERTIES @INJECTOR" : pipe.Name);
                bw.write("=== " + pipeID + " ===");
                bw.newLine();
                bw.write("Z(m), P(bar), T(degC), S(ppm), Density(kg/m3), Viscosity(Pa s)");
                bw.newLine();
                int maxInd = pipe.lNode.length;
                for (int n = 0; n < maxInd; ++n) {
                    bw.write(pipe.zNode[n] + ", " + pipe.pressureNode[n] / 100000.0 + ", " + pipe.temperatureNode[n] + ", " + (int)(pipe.salinityNode[n] * 1000000.0) + ", " + pipe.densityNode[n] + ", " + pipe.viscosityNode[n]);
                    bw.newLine();
                }
                bw.newLine();
                bw.newLine();
            }
            for (TnoPipe pipe : pipes = new TnoPipe[]{PRODUCER, INJECTOR}) {
                String pipeID = pipe.equals(PRODUCER) ? "PRODUCER" : (pipe.equals(INJECTOR) ? "INJECTOR" : pipe.Name);
                bw.write("=== " + pipeID + " ===");
                bw.newLine();
                bw.write("iN, Segment, L(m), Z(m), Angle (deg), Inner diameter(inch), Roughness(milli-inch), P(bar), T(degC), S(ppm), Density(kg/m3), Viscosity(Pa s), Qvol(m3/h), dPGrav(bar), dPVisc(bar), dPpump(bar)");
                bw.newLine();
                bw.write("0, , " + pipe.lNode[0] + ", " + pipe.zNode[0] + ", " + "" + ", " + "" + ", " + "" + ", " + pipe.pressureNode[0] / 100000.0 + ", " + pipe.temperatureNode[0] + ", " + (int)(pipe.salinityNode[0] * 1000000.0) + ", " + pipe.densityNode[0] + ", " + pipe.viscosityNode[0] + ", " + pipe.qVolNode[0] * 3600.0);
                bw.newLine();
                int maxInd = pipe.lNode.length;
                for (int n = 1; n < maxInd; ++n) {
                    bw.write(n + ", " + pipe.SegmentIndex[n - 1] + ", " + pipe.lNode[n] + ", " + pipe.zNode[n] + ", " + Math.toDegrees(pipe.SegmentAngle[n - 1]) + ", " + pipe.InnerDiameterSegment[n - 1] * 39.37007874015748 + ", " + pipe.RoughnessSegment[n - 1] * 39.37007874015748 * 1000.0 + ", " + pipe.pressureNode[n] / 100000.0 + ", " + pipe.temperatureNode[n] + ", " + (int)(pipe.salinityNode[n] * 1000000.0) + ", " + pipe.densityNode[n] + ", " + pipe.viscosityNode[n] + ", " + pipe.qVolNode[n] * 3600.0 + ", " + pipe.dPgravSegment[n - 1] / 100000.0 + ", " + pipe.dPviscSegment[n - 1] / 100000.0 + ", " + pipe.dPpumpSegment[n - 1] / 100000.0);
                    bw.newLine();
                }
                bw.write("total/average/difference, " + pipe.SegmentIndex[pipe.SegmentIndex.length - 1] + ", " + Dataexport.calcDiff(pipe.lNode) + ", " + Dataexport.calcDiff(pipe.zNode) + ", " + Math.toDegrees(Dataexport.calcAverage(pipe.SegmentAngle)) + ", " + Dataexport.calcAverage(pipe.InnerDiameterSegment) * 39.37007874015748 + ", " + Dataexport.calcAverage(pipe.RoughnessSegment) * 39.37007874015748 * 1000.0 + ", " + pipe.DpTotal / 100000.0 + ", " + pipe.DTTotal + ", " + (int)(Dataexport.calcAverage(pipe.salinityNode) * 1000000.0) + ", " + Dataexport.calcAverage(pipe.densityNode) + ", " + Dataexport.calcAverage(pipe.viscosityNode) + ", " + Dataexport.calcAverage(pipe.qVolNode) * 3600.0 + ", " + pipe.DpGravTotal / 100000.0 + ", " + pipe.DpViscTotal / 100000.0 + ", " + pipe.DpPumpTotal / 100000.0);
                bw.newLine();
                bw.newLine();
                bw.newLine();
            }
            bw.write("=== DOUBLET NODES ===");
            bw.newLine();
            bw.write("Node, , P(bar), T(degC)");
            int maxIndex = rs.doubletNodes.length - 1;
            for (int i = 0; i < maxIndex; ++i) {
                bw.newLine();
                bw.write(rs.doubletNodes[i] + ", " + ResultSet.baseCasePressureAlongDoublet[i] * 1.0E-5 + ", " + ResultSet.baseCaseTemperatureAlongDoublet[i]);
            }
            bw.newLine();
            bw.newLine();
            bw.newLine();
            bw.write("=== BASE CASE RESULTS ===");
            bw.newLine();
            for (String identifier : ResultSet.getBaseGeoOutputProperties()) {
                bw.write(TnoSingularContainer.find(identifier).getTitle() + ", " + TnoSingularContainer.find(identifier).getValueForm());
                bw.newLine();
            }
            bw.newLine();
            for (String identifier : ResultSet.getBaseCaseWellProperties()) {
                bw.write(TnoSingularContainer.find(identifier).getTitle() + ", " + TnoSingularContainer.find(identifier).getValueForm());
                bw.newLine();
            }
            bw.newLine();
            bw.newLine();
            bw.write("=== STOCHASTIC RESULTS ===");
            bw.newLine();
            bw.write(", P90, P50, P10");
            bw.newLine();
            for (String identifier : ResultSet.getStochGeoOutputProperties()) {
                bw.write(TnoStochasticContainerVar.find(identifier).getTitle() + ", " + TnoStochasticContainerVar.find(identifier).calcPValueForm(90.0) + ", " + TnoStochasticContainerVar.find(identifier).calcPValueForm(50.0) + ", " + TnoStochasticContainerVar.find(identifier).calcPValueForm(10.0));
                bw.newLine();
            }
            bw.newLine();
            for (String identifier : ResultSet.getStochWellProperties()) {
                bw.write(TnoStochasticContainerVar.find(identifier).getTitle() + ", " + TnoStochasticContainerVar.find(identifier).calcPValueForm(90.0) + ", " + TnoStochasticContainerVar.find(identifier).calcPValueForm(50.0) + ", " + TnoStochasticContainerVar.find(identifier).calcPValueForm(10.0));
                bw.newLine();
            }
            bw.newLine();
            bw.write("=== end of file ===");
            bw.flush();
            bw.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            StringToFile.showNotFoundError();
        }
        catch (IOException e) {
            e.printStackTrace();
            StringToFile.showIOError();
        }
    }
}

