/*
 * Decompiled with CFR 0.152.
 */
package tno.geoenergy.doubletcalc.stochastic;

import tno.geoenergy.doubletcalc.stochastic.TnoDistributionVarTriangular;
import tno.geoenergy.doubletcalc.stochastic.TnoSingularVariable;
import tno.geoenergy.doubletcalc.stochastic.TnoStochasticVariable;

public class TnoMyStochasticObjects {
    static final int BASRES_TYPE = 0;
    static final int SF_TYPE = 1;
    static final int ECONOMICS_TYPE = 2;
    static final int KPIOUTPUT_TYPE = 3;
    public static final String SIMULATION_RUNS = "number of simulation runs";
    public static final String AQUIFER_PERMEABILITY = "aquifer permeability";
    public static final String AQUIFER_NG = "aquifer net to gross";
    public static final String AQUIFER_THICKNESS = "aquifer gross thickness";
    public static final String AQUIFER_TOPINJECTION = "aquifer top at injector";
    public static final String AQUIFER_TOPPRODUCTION = "aquifer top at producer";
    public static final String AQUIFER_SALINITY = "aquifer water salinity";
    public static final String KH_KV = "aquifer kh/kv ratio";
    public static final String TEMPERATURE_SURFACE = "surface temperature";
    public static final String GEOTHERMAL_GRADIENT = "geothermal gradient";
    public static final String AQUIFER_TEMPERATURE = "mid aquifer temperature producer";
    public static final String AQUIFER_PRESSURE_INJECTION = "initial aquifer pressure at injector";
    public static final String AQUIFER_PRESSURE_PRODUCTION = "inital aquifer pressure at producer";
    public static final String TEMPERATURE_INJECTION = "exit temperature heat exchanger";
    public static final String WELL_DISTANCE = "distance wells at aquifer level";
    public static final String PUMP_EFFICIENCY = "pump system efficiency";
    public static final String PUMP_PRODUCTIONDEPTH = "production pump depth";
    public static final String PUMP_PRESSUREDIFFERENCE = "pump pressure difference";
    public static final String SEGMENT_LENGTH = "calculation length subdivision";
    public static final String INJ_TUBING_SEGMENTS_AH = "pipe segment sections i";
    public static final String INJ_TUBING_SEGMENTS_TVD = "pipe segment depth i";
    public static final String INJ_TUBING_DIAMETER = "pipe inner diameter i ";
    public static final String INJ_TUBING_ROUGHNESS = "pipe roughness i";
    public static final String INJ_OUTERDIAMETER = "outer diameter injector";
    public static final String SKIN_INJECTION = "skin injector";
    public static final String TOTAL_SKIN_INJECTION = "total skin injector";
    public static final String INJ_AQUIFER_ANGLE = "penetration angle injector";
    public static final String INJ_ANGLE_SKIN = "skin due to penetration angle i";
    public static final String PRD_TUBING_SEGMENTS_AH = "pipe segment sections p";
    public static final String PRD_TUBING_SEGMENTS_TVD = "pipe segment depth p";
    public static final String PRD_TUBING_DIAMETER = "pipe inner diameter p";
    public static final String PRD_TUBING_ROUGHNESS = "pipe roughness p";
    public static final String PRD_OUTERDIAMETER = "outer diameter producer";
    public static final String SKIN_PRODUCTION = "skin producer";
    public static final String TOTAL_SKIN_PRODUCTION = "total skin producer";
    public static final String PRD_AQUIFER_ANGLE = "penetration angle producer";
    public static final String PRD_ANGLE_SKIN = "skin due to penetration angle p";
    public static final String AQUIFER_KH = "aquifer kH net";
    public static final String QMASS = "mass flow";
    public static final String PUMP_QVOL = "pump volume flow";
    public static final String PUMP_POWER_REQUIRED = "required pump power";
    public static final String GEOTHERMAL_POWERS = "geothermal power";
    public static final String COP = "COP";
    public static final String PRODUCT_DENSITY = "av. production density";
    public static final String HEAT_CAPACITY = "heat capacity";
    public static final String DELTA_T = "delta T";
    public static final String AQP_PRD = "aquifer pressure at producer";
    public static final String AQP_INJ = "aquifer pressure at injector";
    public static final String DP_PRD = "pressure difference at producer";
    public static final String DP_INJ = "pressure difference at injector";
    public static final String AQT_PRD = "aquifer temperature at producer *";
    public static final String T_HE = "temperature at heat exchanger";
    public static final String P_HE = "pressure at heat exchanger";
    public static final String BASECASE_AQUIFER_KH = "aquifer kH net";
    public static final String BASECASE_QMASS = "mass flow";
    public static final String BASECASE_PUMP_QVOL = "pump volume flow";
    public static final String BASECASE_PUMP_POWER_REQUIRED = "required pump power";
    public static final String BASECASE_GEOTHERMAL_POWERS = "geothermal power";
    public static final String BASECASE_COP = "COP";
    public static final String BASECASE_AQP_PRD = "aquifer pressure at producer";
    public static final String BASECASE_AQP_INJ = "aquifer pressure at injector";
    public static final String BASECASE_DP_PRD = "pressure difference at producer";
    public static final String BASECASE_DP_INJ = "pressure difference at injector";
    public static final String BASECASE_AQT_PRD = "aquifer temperature at producer *";
    public static final String BASECASE_T_HE = "temperature at heat exchanger";
    public static final String BASECASE_P_HE = "pressure at heat exchanger";

    public static void initialize() {
        TnoStochasticVariable var = null;
        var = new TnoStochasticVariable(AQUIFER_THICKNESS, "m", 0);
        var.setDistribution(new TnoDistributionVarTriangular(50.0, 70.0, 90.0));
        var = new TnoStochasticVariable(AQUIFER_PERMEABILITY, "mD", 0, 1.01325E15, 0);
        var.setDistribution(new TnoDistributionVarTriangular(350.0, 500.0, 650.0));
        var = new TnoStochasticVariable(AQUIFER_NG, "-", 0, 1.0, 2);
        var.setDistribution(new TnoDistributionVarTriangular(0.99, 1.0, 1.01));
        var = new TnoStochasticVariable(AQUIFER_TOPINJECTION, "m TVD", 0);
        var.setDistribution(new TnoDistributionVarTriangular(1350.0, 1500.0, 1650.0));
        var = new TnoStochasticVariable(AQUIFER_TOPPRODUCTION, "m TVD", 0);
        var.setDistribution(new TnoDistributionVarTriangular(1350.0, 1500.0, 1650.0));
        new TnoStochasticVariable("aquifer kH net", "Dm", 3, 1.0, 2);
        new TnoStochasticVariable(PRODUCT_DENSITY, "kg/m\u00b3", 3, 1.0, 3);
        new TnoStochasticVariable(HEAT_CAPACITY, "kJ/(kg*K)", 3, 1.0, 3);
        new TnoStochasticVariable("mass flow", "kg/s", 3, 1.0, 2);
        new TnoStochasticVariable("pump volume flow", "m\u00b3/h", 3, 1.0, 1);
        new TnoStochasticVariable(DELTA_T, "\u00b0C", 3, 1.0, 1);
        new TnoStochasticVariable("required pump power", "kW", 3, 1.0, 1);
        new TnoStochasticVariable("geothermal power", "MW", 3, 1.0, 2);
        new TnoStochasticVariable("COP", "kW/kW", 3, 1.0, 1);
        new TnoStochasticVariable("aquifer pressure at producer", "bar", 3, 1.0E-5, 2);
        new TnoStochasticVariable("aquifer pressure at injector", "bar", 3, 1.0E-5, 2);
        new TnoStochasticVariable("pressure difference at producer", "bar", 3, 1.0E-5, 2);
        new TnoStochasticVariable("pressure difference at injector", "bar", 3, 1.0E-5, 2);
        new TnoStochasticVariable("aquifer temperature at producer *", "\u00b0C", 3, 1.0, 2);
        new TnoStochasticVariable("temperature at heat exchanger", "\u00b0C", 3, 1.0, 2);
        new TnoStochasticVariable("pressure at heat exchanger", "bar", 3, 1.0E-5, 2);
        var = new TnoStochasticVariable(AQUIFER_SALINITY, "ppm", 0, 1000000.0, 0);
        var.setDistribution(new TnoDistributionVarTriangular(69000.0, 70000.0, 71000.0));
        new TnoSingularVariable(AQUIFER_TEMPERATURE, "\u00b0C", 0.0, true);
        new TnoSingularVariable(AQUIFER_PRESSURE_INJECTION, "bar", 0.0, 1.0E-5, 1, true);
        new TnoSingularVariable(AQUIFER_PRESSURE_PRODUCTION, "bar", 0.0, 1.0E-5, 1, true);
        new TnoSingularVariable(SKIN_PRODUCTION, "-", 2.0, 1.0, 2);
        new TnoSingularVariable(SKIN_INJECTION, "-", 0.5, 1.0, 2);
        new TnoSingularVariable(TOTAL_SKIN_PRODUCTION, "-", 0.0, 1.0, 2);
        new TnoSingularVariable(TOTAL_SKIN_INJECTION, "-", 0.0, 1.0, 2);
        new TnoSingularVariable(INJ_OUTERDIAMETER, "inch", 8.0, 39.37007874015748, 2);
        new TnoSingularVariable(PRD_OUTERDIAMETER, "inch", 8.0, 39.37007874015748, 2);
        new TnoSingularVariable(WELL_DISTANCE, "m", 1700.0);
        double[] depth_p = new double[]{1500.0};
        new TnoSingularVariable(PRD_TUBING_SEGMENTS_TVD, "m TVD", depth_p);
        double[] depth_i = new double[]{1500.0};
        new TnoSingularVariable(INJ_TUBING_SEGMENTS_TVD, "m TVD", depth_i);
        double[] rough = new double[]{1.38};
        new TnoSingularVariable(INJ_TUBING_ROUGHNESS, "milli-inch", rough, 39370.07874015748, 2);
        new TnoSingularVariable(PRD_TUBING_ROUGHNESS, "milli-inch", rough, 39370.07874015748, 2);
        double[] diam = new double[]{7.0};
        new TnoSingularVariable(INJ_TUBING_DIAMETER, "inch", diam, 39.37007874015748, 2);
        new TnoSingularVariable(PRD_TUBING_DIAMETER, "inch", diam, 39.37007874015748, 2);
        double[] segi = new double[]{2018.0};
        double[] segp = new double[]{2121.0};
        new TnoSingularVariable(INJ_TUBING_SEGMENTS_AH, "m AH", segi);
        new TnoSingularVariable(PRD_TUBING_SEGMENTS_AH, "m AH", segp);
        new TnoSingularVariable(TEMPERATURE_SURFACE, "\u00b0C", 10.0, 1.0, 1);
        new TnoSingularVariable(TEMPERATURE_INJECTION, "\u00b0C", 30.0, 1.0, 1);
        new TnoSingularVariable(GEOTHERMAL_GRADIENT, "\u00b0C/m", 0.031, 1.0, 4);
        new TnoSingularVariable(PUMP_EFFICIENCY, "-", 0.6, 1.0, 3);
        new TnoSingularVariable(PUMP_PRODUCTIONDEPTH, "m", 300.0);
        new TnoSingularVariable(PUMP_PRESSUREDIFFERENCE, "bar", 30.0, 1.0E-5, 2);
        new TnoSingularVariable(SIMULATION_RUNS, "-", 1000.0);
        new TnoSingularVariable(SEGMENT_LENGTH, "m", 50.0);
        new TnoSingularVariable("aquifer kH net", "Dm", 0.0, 1.0, 2);
        new TnoSingularVariable("mass flow", "kg/s", 0.0, 1.0, 2);
        new TnoSingularVariable("pump volume flow", "m\u00b3/h", 0.0, 1.0, 1);
        new TnoSingularVariable("required pump power", "kW", 0.0, 1.0, 1);
        new TnoSingularVariable("geothermal power", "MW", 0.0, 1.0, 2);
        new TnoSingularVariable("COP", "kW/kW", 0.0, 1.0, 1);
        new TnoSingularVariable(KH_KV, "-", 1.0);
        new TnoSingularVariable(INJ_AQUIFER_ANGLE, "deg", 0.0);
        new TnoSingularVariable(PRD_AQUIFER_ANGLE, "deg", 0.0);
        new TnoSingularVariable(INJ_ANGLE_SKIN, "-", 0.0, 1.0, 2);
        new TnoSingularVariable(PRD_ANGLE_SKIN, "-", 0.0, 1.0, 2);
        new TnoSingularVariable("aquifer pressure at producer", "bar", 0.0, 1.0E-5, 2);
        new TnoSingularVariable("aquifer pressure at injector", "bar", 0.0, 1.0E-5, 2);
        new TnoSingularVariable("pressure difference at producer", "bar", 0.0, 1.0E-5, 2);
        new TnoSingularVariable("pressure difference at injector", "bar", 0.0, 1.0E-5, 2);
        new TnoSingularVariable("aquifer temperature at producer *", "\u00b0C", 0.0, 1.0, 2);
        new TnoSingularVariable("temperature at heat exchanger", "\u00b0C", 0.0, 1.0, 2);
        new TnoSingularVariable("pressure at heat exchanger", "bar", 0.0, 1.0E-5, 2);
    }
}

