/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.x11;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.CommonDialogs;
import com.sun.glass.ui.Cursor;
import com.sun.glass.ui.Launchable;
import com.sun.glass.ui.Menu;
import com.sun.glass.ui.MenuBar;
import com.sun.glass.ui.Pen;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.Robot;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.Size;
import com.sun.glass.ui.Timer;
import com.sun.glass.ui.View;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.x11.X11CommonDialogs;
import com.sun.glass.ui.x11.X11Cursor;
import com.sun.glass.ui.x11.X11Pixels;
import com.sun.glass.ui.x11.X11Screen;
import com.sun.glass.ui.x11.X11Timer;
import com.sun.glass.ui.x11.X11View;
import com.sun.glass.ui.x11.X11Window;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X11Application
extends Application {
    Menu windowMenu;
    Menu editMenu;
    Menu fileMenu;
    long display = 0L;

    protected static void initLibrary() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Application.loadNativeLibrary("glass-x11");
                return null;
            }
        });
    }

    private native void _runLoop(String[] var1, Launchable var2, long var3, int var5, long var6);

    @Override
    protected void runLoop(final String[] stringArray, final Launchable launchable) {
        Thread thread = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

            @Override
            public Thread run() {
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        int n = -1;
                        long l = 0L;
                        Map map = Application.getDeviceDetails();
                        if (map != null) {
                            Object v = map.get("XDisplay");
                            if (v != null) {
                                X11Application.this.display = (Long)v;
                            }
                            if ((v = map.get("XVisualID")) != null) {
                                l = (Long)v;
                            }
                            if ((v = map.get("XScreenID")) != null) {
                                n = (Integer)v;
                            }
                        }
                        X11Application.this._runLoop(stringArray, launchable, X11Application.this.display, n, l);
                    }
                }, "X11NativeRunloopThread");
                return thread;
            }
        });
        this.setEventThread(thread);
        thread.start();
    }

    native void _terminate(boolean var1);

    @Override
    protected void finishTerminating() {
        Thread thread = this.getEventThread();
        if (thread != null) {
            this._terminate(Thread.currentThread().equals(thread));
            this.setEventThread(null);
        }
        super.finishTerminating();
    }

    @Override
    protected Object _enterNestedEventLoop() {
        return null;
    }

    @Override
    protected void _leaveNestedEventLoop(Object object) {
    }

    @Override
    public void installDefaultMenus(MenuBar menuBar) {
    }

    @Override
    public Window createWindow(Window window, Screen screen, int n) {
        return new X11Window(window, screen, n);
    }

    @Override
    public Window createWindow(long l) {
        return new X11Window(l);
    }

    @Override
    public View createView(Pen pen) {
        return new X11View(pen);
    }

    @Override
    public Cursor createCursor(int n) {
        return new X11Cursor(n);
    }

    @Override
    public Cursor createCursor(int n, int n2, Pixels pixels) {
        return new X11Cursor(n, n2, pixels);
    }

    @Override
    protected void staticCursor_setVisible(boolean bl) {
        X11Cursor.setVisible_impl(bl);
    }

    @Override
    protected Size staticCursor_getBestSize(int n, int n2) {
        return X11Cursor.getBestSize_impl(n, n2);
    }

    @Override
    public Pixels createPixels(int n, int n2, ByteBuffer byteBuffer) {
        return new X11Pixels(n, n2, byteBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer) {
        return new X11Pixels(n, n2, intBuffer);
    }

    @Override
    public Pixels createPixels(int n, int n2, IntBuffer intBuffer, float f) {
        return this.createPixels(n, n2, intBuffer);
    }

    @Override
    protected int staticPixels_getNativeFormat() {
        return X11Pixels.getNativeFormat_impl();
    }

    @Override
    public Robot createRobot() {
        throw new UnsupportedOperationException("not implmented");
    }

    @Override
    protected Screen staticScreen_getDeepestScreen() {
        return X11Screen.getDeepestScreen_impl();
    }

    @Override
    protected Screen staticScreen_getMainScreen() {
        return X11Screen.getMainScreen_impl();
    }

    @Override
    protected Screen staticScreen_getScreenForLocation(int n, int n2) {
        return X11Screen.getScreenForLocation_impl(n, n2);
    }

    @Override
    protected Screen staticScreen_getScreenForPtr(long l) {
        return X11Screen.getScreenForPtr_impl(l);
    }

    @Override
    protected List<Screen> staticScreen_getScreens() {
        return X11Screen.getScreens_impl();
    }

    @Override
    public Timer createTimer(Runnable runnable) {
        return new X11Timer(runnable);
    }

    @Override
    protected int staticTimer_getMinPeriod() {
        return X11Timer.getMinPeriod_impl();
    }

    @Override
    protected int staticTimer_getMaxPeriod() {
        return X11Timer.getMaxPeriod_impl();
    }

    @Override
    protected List<File> staticCommonDialogs_showFileChooser(Window window, String string, String string2, String string3, int n, boolean bl, CommonDialogs.ExtensionFilter[] extensionFilterArray) {
        return X11CommonDialogs.showFileChooser_impl(string, string3, n, bl, extensionFilterArray);
    }

    @Override
    protected File staticCommonDialogs_showFolderChooser(Window window, String string, String string2) {
        return X11CommonDialogs.showFolderChooser_impl();
    }

    @Override
    protected long staticView_getMultiClickTime() {
        return X11View.getMultiClickTime_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxX() {
        return X11View.getMultiClickMaxX_impl();
    }

    @Override
    protected int staticView_getMultiClickMaxY() {
        return X11View.getMultiClickMaxY_impl();
    }

    @Override
    protected native void _invokeAndWait(Runnable var1);

    @Override
    protected native void _invokeLater(Runnable var1);

    @Override
    protected native void _postOnEventQueue(Runnable var1);

    @Override
    public boolean supportsTransparentWindows() {
        return true;
    }
}

