/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx;

import com.sun.javafx.runtime.sequence.Sequence;
import java.util.ArrayList;

public class Utils {
    public static final char DOT = '.';
    private static UnicodeProcessor uni = new UnicodeProcessor();

    public static float clamp(float f, float f2, float f3) {
        if (f2 < f) {
            return f;
        }
        if (f2 > f3) {
            return f3;
        }
        return f2;
    }

    public static int clamp(int n, int n2, int n3) {
        if (n2 < n) {
            return n;
        }
        if (n2 > n3) {
            return n3;
        }
        return n2;
    }

    public static float nearest(float f, float f2, float f3) {
        float f4 = f2 - f;
        float f5 = f3 - f2;
        if (f4 < f5) {
            return f;
        }
        return f3;
    }

    public static float[] HSBtoRGB(float f, float f2, float f3) {
        float f4 = (f % 360.0f + 360.0f) % 360.0f;
        f = f4 / 360.0f;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (f2 == 0.0f) {
            n2 = n3 = (int)(f3 * 255.0f + 0.5f);
            n = n3;
        } else {
            float f5 = (f - (float)Math.floor(f)) * 6.0f;
            float f6 = f5 - (float)Math.floor(f5);
            float f7 = f3 * (1.0f - f2);
            float f8 = f3 * (1.0f - f2 * f6);
            float f9 = f3 * (1.0f - f2 * (1.0f - f6));
            switch ((int)f5) {
                case 0: {
                    n = (int)(f3 * 255.0f + 0.5f);
                    n2 = (int)(f9 * 255.0f + 0.5f);
                    n3 = (int)(f7 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    n = (int)(f8 * 255.0f + 0.5f);
                    n2 = (int)(f3 * 255.0f + 0.5f);
                    n3 = (int)(f7 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    n = (int)(f7 * 255.0f + 0.5f);
                    n2 = (int)(f3 * 255.0f + 0.5f);
                    n3 = (int)(f9 * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    n = (int)(f7 * 255.0f + 0.5f);
                    n2 = (int)(f8 * 255.0f + 0.5f);
                    n3 = (int)(f3 * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    n = (int)(f9 * 255.0f + 0.5f);
                    n2 = (int)(f7 * 255.0f + 0.5f);
                    n3 = (int)(f3 * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    n = (int)(f3 * 255.0f + 0.5f);
                    n2 = (int)(f7 * 255.0f + 0.5f);
                    n3 = (int)(f8 * 255.0f + 0.5f);
                }
            }
        }
        float[] fArray = new float[]{(float)n / 255.0f, (float)n2 / 255.0f, (float)n3 / 255.0f};
        return fArray;
    }

    public static float[] RGBtoHSB(float f, float f2, float f3) {
        float f4;
        int n;
        int n2;
        int n3 = (int)(f * 255.0f);
        int n4 = (int)(f2 * 255.0f);
        int n5 = (int)(f3 * 255.0f);
        float[] fArray = new float[3];
        int n6 = n2 = n3 > n4 ? n3 : n4;
        if (n5 > n2) {
            n2 = n5;
        }
        int n7 = n = n3 < n4 ? n3 : n4;
        if (n5 < n) {
            n = n5;
        }
        float f5 = (float)n2 / 255.0f;
        float f6 = n2 != 0 ? (float)(n2 - n) / (float)n2 : 0.0f;
        if (f6 == 0.0f) {
            f4 = 0.0f;
        } else {
            float f7 = (float)(n2 - n3) / (float)(n2 - n);
            float f8 = (float)(n2 - n4) / (float)(n2 - n);
            float f9 = (float)(n2 - n5) / (float)(n2 - n);
            f4 = n3 == n2 ? f9 - f8 : (n4 == n2 ? 2.0f + f7 - f9 : 4.0f + f8 - f7);
            if ((f4 /= 6.0f) < 0.0f) {
                f4 += 1.0f;
            }
        }
        fArray[0] = f4 * 360.0f;
        fArray[1] = f6;
        fArray[2] = f5;
        return fArray;
    }

    public static String[] makeStringArray(int n) {
        return new String[n];
    }

    public static String stripNewlines(String string) {
        if (string == null) {
            return null;
        }
        return string.replace('\n', ' ');
    }

    public static String stripQuotes(String string) {
        int n;
        if (string == null) {
            return string;
        }
        if (string.length() == 0) {
            return string;
        }
        int n2 = 0;
        if (string.charAt(n2) == '\"') {
            ++n2;
        }
        if (string.charAt((n = string.length()) - 1) == '\"') {
            --n;
        }
        if (n - n2 < 0) {
            return string;
        }
        return string.substring(n2, n);
    }

    public static String[] split(String string, String string2) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        if (string2 == null || string2.length() == 0) {
            return new String[0];
        }
        if (string2.length() > string.length()) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf(string2);
        while (n >= 0) {
            String string3 = string.substring(0, n);
            if (string3 != null && string3.length() > 0) {
                arrayList.add(string3);
            }
            string = string.substring(n + string2.length());
            n = string.indexOf(string2);
        }
        if (string != null && string.length() > 0) {
            arrayList.add(string);
        }
        return arrayList.toArray(new String[0]);
    }

    public static boolean contains(String string, String string2) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (string2.length() > string.length()) {
            return false;
        }
        return string.indexOf(string2) > -1;
    }

    public static String convertUnicode(String string) {
        return uni.process(string);
    }

    public static boolean assertionEnabled() {
        boolean bl = false;
        if (!$assertionsDisabled) {
            bl = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return bl;
    }

    public static Sequence asSequence(Object object) {
        return (Sequence)object;
    }

    private static final class UnicodeProcessor {
        private char[] buf;
        private int bp;
        private int buflen;
        private char ch;
        private int unicodeConversionBp = -1;

        private UnicodeProcessor() {
        }

        public String process(String string) {
            this.buf = string.toCharArray();
            this.buflen = this.buf.length;
            this.bp = -1;
            char[] cArray = new char[this.buflen];
            int n = 0;
            while (this.bp < this.buflen - 1) {
                this.ch = this.buf[++this.bp];
                if (this.ch == '\\') {
                    this.convertUnicode();
                }
                cArray[n++] = this.ch;
            }
            return new String(cArray, 0, n);
        }

        private void convertUnicode() {
            if (this.ch == '\\' && this.unicodeConversionBp != this.bp) {
                ++this.bp;
                this.ch = this.buf[this.bp];
                if (this.ch == 'u') {
                    do {
                        ++this.bp;
                        this.ch = this.buf[this.bp];
                    } while (this.ch == 'u');
                    int n = this.bp + 3;
                    if (n < this.buflen) {
                        int n2;
                        int n3 = n2 = this.digit(16);
                        while (this.bp < n && n2 >= 0) {
                            ++this.bp;
                            this.ch = this.buf[this.bp];
                            n2 = this.digit(16);
                            n3 = (n3 << 4) + n2;
                        }
                        if (n2 >= 0) {
                            this.ch = (char)n3;
                            this.unicodeConversionBp = this.bp;
                            return;
                        }
                    }
                } else {
                    --this.bp;
                    this.ch = (char)92;
                }
            }
        }

        private int digit(int n) {
            char c = this.ch;
            int n2 = Character.digit(c, n);
            if (n2 >= 0 && c > '\u007f') {
                this.ch = "0123456789abcdef".charAt(n2);
            }
            return n2;
        }
    }
}

