/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.async;

import com.sun.javafx.async.BackgroundTask;
import com.sun.javafx.async.TaskInterface;
import com.sun.javafx.async.TaskManager;
import com.sun.javafx.async.TaskManagerInterface;
import com.sun.javafx.functions.Function0;
import javafx.async.RunnableFuture;
import javafx.lang.FX;

public class TaskImpl
implements BackgroundTask {
    private static final TaskManagerInterface manager = TaskManager.instance();
    private static int nextRequestId = 0;
    final TaskInterface task;
    RunnableFuture runnable = null;
    int id = 0;

    private static int getNextRequestId() {
        if (0 >= ++nextRequestId) {
            nextRequestId = 1;
        }
        return nextRequestId;
    }

    public TaskImpl(TaskInterface taskInterface) {
        this.task = taskInterface;
    }

    public synchronized void start(RunnableFuture runnableFuture) {
        if (this.runnable != null) {
            throw new IllegalArgumentException("Tasks may not be restarted");
        }
        this.id = TaskImpl.getNextRequestId();
        this.runnable = runnableFuture;
        manager.schedule(this);
    }

    public void stop() {
        manager.cancel(this.id);
    }

    public int getId() {
        return this.id;
    }

    public void cancel() {
        FX.deferAction(new Function0<Void>(){

            @Override
            public Void invoke() {
                TaskImpl.this.task.setStopped();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        FX.deferAction(new Function0<Void>(){

            @Override
            public Void invoke() {
                TaskImpl.this.task.setStarted();
                return null;
            }
        });
        if (this.runnable != null) {
            try {
                this.runnable.run();
            }
            catch (Throwable throwable) {
                try {
                    FX.deferAction(new Function0<Void>(){

                        @Override
                        public Void invoke() {
                            TaskImpl.this.task.setCauseOfFailure(throwable);
                            return null;
                        }
                    });
                }
                catch (Throwable throwable2) {
                    FX.deferAction(new Function0<Void>(){

                        @Override
                        public Void invoke() {
                            TaskImpl.this.task.setDone();
                            return null;
                        }
                    });
                    throw throwable2;
                }
                FX.deferAction(new /* invalid duplicate definition of identical inner class */);
            }
            FX.deferAction(new /* invalid duplicate definition of identical inner class */);
        }
    }

    public void callDone() {
        FX.deferAction(new Function0<Void>(){

            @Override
            public Void invoke() {
                TaskImpl.this.task.setDone();
                return null;
            }
        });
    }
}

