/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.async.desktop;

import com.sun.javafx.async.BackgroundTask;
import com.sun.javafx.async.TaskManagerInterface;
import com.sun.javafx.functions.Function0;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javafx.lang.FX;

public final class DesktopTaskManager
implements TaskManagerInterface {
    private static final int CORE_POOL_SIZE = 8;
    private static final int MAX_POOL_SIZE = 64;
    private static final long KEEP_ALIVE_SECONDS = 30L;
    private static final BlockingQueue<Runnable> ioQueue = new LinkedBlockingQueue<Runnable>();
    private static final ThreadGroup threadGroup = new ThreadGroup("task thread pool");
    private static final Thread.UncaughtExceptionHandler uncaughtHandler = new Thread.UncaughtExceptionHandler(){

        public void uncaughtException(Thread thread, Throwable throwable) {
            if (!(throwable instanceof IllegalMonitorStateException)) {
                System.err.println("Uncaught throwable in " + threadGroup.getName() + " " + throwable);
            }
        }
    };
    private static final ThreadFactory threadFactory = new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(threadGroup, runnable);
            thread.setUncaughtExceptionHandler(uncaughtHandler);
            return thread;
        }
    };
    private static final ThreadPoolExecutor executor = new ThreadPoolExecutor(8, 64, 30L, TimeUnit.SECONDS, ioQueue, threadFactory, new ThreadPoolExecutor.AbortPolicy());
    private static final Queue<IOTask> activeTasks = new ConcurrentLinkedQueue<IOTask>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(BackgroundTask backgroundTask) {
        BlockingQueue<Runnable> blockingQueue = ioQueue;
        synchronized (blockingQueue) {
            executor.execute(new IOTask(backgroundTask, new IOCallable(backgroundTask)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(int n) {
        BlockingQueue<Runnable> blockingQueue = ioQueue;
        synchronized (blockingQueue) {
            Iterator object = ioQueue.iterator();
            while (object.hasNext()) {
                Runnable runnable = (Runnable)object.next();
                if (!(runnable instanceof IOTask)) continue;
                IOTask iOTask = (IOTask)runnable;
                if (iOTask.task.getId() != n) continue;
                iOTask.task.cancel();
                iOTask.cancel(true);
                object.remove();
                iOTask.task.callDone();
                break;
            }
        }
        for (IOTask iOTask : activeTasks) {
            if (iOTask.task.getId() != n) continue;
            iOTask.task.cancel();
            iOTask.cancel(true);
            break;
        }
    }

    public void shutdown() {
        executor.shutdown();
    }

    public void shutdownNow() {
        executor.shutdownNow();
    }

    public void deferTask(final Runnable runnable) {
        FX.deferAction(new Function0<Void>(){

            @Override
            public Void invoke() {
                runnable.run();
                return null;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IOCallable
    implements Callable<Object> {
        Runnable r;
        IOTask iot = null;

        IOCallable(Runnable runnable) {
            this.r = runnable;
        }

        void setTask(IOTask iOTask) {
            this.iot = iOTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            activeTasks.add(this.iot);
            try {
                Thread.currentThread().setName("task." + this.iot.task.getId());
                this.r.run();
            }
            finally {
                activeTasks.remove(this.iot);
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IOTask
    extends FutureTask<Object>
    implements Callable<Object> {
        final BackgroundTask task;

        IOTask(BackgroundTask backgroundTask, IOCallable iOCallable) {
            super(iOCallable);
            this.task = backgroundTask;
            iOCallable.setTask(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            activeTasks.add(this);
            try {
                Thread.currentThread().setName("task." + this.task.getId());
                this.task.run();
            }
            finally {
                activeTasks.remove(this);
                return null;
            }
        }
    }
}

