/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eula;

import com.sun.javafx.eula.EulaLicense;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;

public class EulaDialog {
    private static final ResourceBundle locale = ResourceBundle.getBundle("com.sun.javafx.eula.Resources");
    private final JDialog root;
    private final JPanel main;
    private boolean eulaAccepted = false;
    private static Point point = new Point();
    static final String SYSTEM_FONT_NAME = EulaDialog.isMacOS() ? "Helvetica" : "MS SansSerif";
    private JButton accept_btn;

    private static boolean isMacOS() {
        Boolean bl = Boolean.FALSE;
        try {
            bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    String string = System.getProperty("os.name").toLowerCase();
                    if (string.startsWith("mac")) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return bl;
    }

    void setEulaAccepted(boolean bl) {
        this.eulaAccepted = bl;
    }

    static JPanel getBackgroundPanel() {
        return new JPanel(new BorderLayout()){
            URL imageURL = Thread.currentThread().getContextClassLoader().getResource("com/sun/javafx/eula/eulabox_bkdg.png");
            ImageIcon image = new ImageIcon(this.imageURL);

            public void paintComponent(Graphics graphics) {
                Dimension dimension = this.getSize();
                for (int i = 0; i < dimension.width; i += this.image.getIconWidth()) {
                    for (int j = 0; j < dimension.height; j += this.image.getIconHeight()) {
                        graphics.drawImage(this.image.getImage(), i, j, null, null);
                    }
                }
            }
        };
    }

    EulaDialog() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.main = EulaDialog.getBackgroundPanel();
        this.root = new JDialog();
        EmptyBorder emptyBorder = new EmptyBorder(15, 120, 20, 25);
        this.main.setBorder(emptyBorder);
        this.main.setPreferredSize(new Dimension(509, 300));
        this.main.add((Component)EulaDialog.init_title_Panel(), "North");
        this.main.add((Component)this.init_control_area(), "Center");
        this.main.add((Component)this.init_button_Panel(), "South");
        this.main.setFocusable(false);
        this.root.setUndecorated(true);
        this.root.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                point.x = mouseEvent.getX();
                point.y = mouseEvent.getY();
            }
        });
        this.root.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                Point point = EulaDialog.this.root.getLocation();
                EulaDialog.this.root.setLocation(point.x + mouseEvent.getX() - point.x, point.y + mouseEvent.getY() - point.y);
            }
        });
        this.root.getContentPane().add((Component)this.main, "Center");
        this.root.setModal(true);
        this.root.setDefaultCloseOperation(2);
        this.root.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                EulaDialog.this.root.setVisible(false);
                EulaDialog.this.disposeDialog();
            }
        });
        this.root.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.root.getSize();
        this.root.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.accept_btn.requestFocus();
        this.root.setVisible(true);
    }

    private JPanel init_button_Panel() {
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        JButton jButton = new JButton(locale.getString("CancelBtn"));
        jButton.setMnemonic(67);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                EulaDialog.this.root.setVisible(false);
                EulaDialog.this.disposeDialog();
            }
        };
        jButton.addActionListener(abstractAction);
        this.accept_btn = new JButton(locale.getString("AcceptBtn"));
        this.accept_btn.setMnemonic(65);
        this.accept_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EulaDialog.this.setEulaAccepted(true);
                EulaDialog.this.root.setVisible(false);
                EulaDialog.this.disposeDialog();
            }
        });
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(Box.createHorizontalGlue());
        if (EulaDialog.isMacOS()) {
            jPanel.add(jButton);
            jPanel.add(Box.createHorizontalStrut(10));
            jPanel.add(this.accept_btn);
        } else {
            jPanel.add(this.accept_btn);
            jPanel.add(Box.createHorizontalStrut(10));
            jPanel.add(jButton);
        }
        this.accept_btn.setAlignmentX(0.5f);
        jPanel.add(Box.createVerticalStrut(10));
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.root.getRootPane().getInputMap(2).put(keyStroke, "cancel");
        this.root.getRootPane().getActionMap().put("cancel", abstractAction);
        return jPanel;
    }

    static JPanel init_title_Panel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(locale.getString("EulaTitle"));
        Font font = new Font(SYSTEM_FONT_NAME, 1, 13);
        jLabel.setFont(font);
        jLabel.setFocusable(false);
        jPanel.add(jLabel);
        jPanel.setFocusable(false);
        return jPanel;
    }

    private JComponent init_control_area() {
        Object object;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        JEditorPane jEditorPane = new JEditorPane();
        EmptyBorder emptyBorder = new EmptyBorder(10, 0, 0, 0);
        jEditorPane.setBorder(emptyBorder);
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jEditorPane.setOpaque(false);
        jEditorPane.setText(locale.getString("EulaMessage"));
        if (jEditorPane.getDocument() instanceof HTMLDocument) {
            object = (HTMLDocument)jEditorPane.getDocument();
            ((HTMLDocument)object).getStyleSheet().addRule("a { color:black; }");
        }
        object = ResourceBundle.getBundle("com.sun.javafx.eula.Resources");
        jEditorPane.addHyperlinkListener(new HyperlinkListener((ResourceBundle)object){
            final /* synthetic */ ResourceBundle val$locale;
            {
                this.val$locale = resourceBundle;
            }

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String string = hyperlinkEvent.getURL().toString();
                    if ("1.6.0".compareTo(System.getProperty("java.version")) <= 0) {
                        if (string.equals("http://java.com/license") || string.equals("http://java.com/javafx")) {
                            EulaDialog.this.browse(string);
                        }
                    } else if (string.equals("http://java.com/license")) {
                        new EulaLicense(EulaDialog.this.root, this.val$locale);
                    }
                }
            }
        });
        AbstractAction abstractAction = new AbstractAction((ResourceBundle)object){
            final /* synthetic */ ResourceBundle val$locale;
            {
                this.val$locale = resourceBundle;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if ("1.6.0".compareTo(System.getProperty("java.version")) <= 0) {
                    EulaDialog.this.browse("http://java.com/license");
                } else {
                    new EulaLicense(EulaDialog.this.root, this.val$locale);
                }
            }
        };
        jEditorPane.setPreferredSize(new Dimension(330, 210));
        jEditorPane.setHighlighter(null);
        jEditorPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                point.x = mouseEvent.getX();
                point.y = mouseEvent.getY();
            }
        });
        jEditorPane.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                Point point = EulaDialog.this.root.getLocation();
                EulaDialog.this.root.setLocation(point.x + mouseEvent.getX() - point.x, point.y + mouseEvent.getY() - point.y);
            }
        });
        jEditorPane.setFocusable(false);
        jPanel.add((Component)jEditorPane, "North");
        jPanel.setFocusable(true);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        jPanel.getInputMap(2).put(keyStroke, "enter");
        jPanel.getActionMap().put("enter", abstractAction);
        return jPanel;
    }

    private void browse(String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("java.awt.Desktop");
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Method method = null;
        try {
            method = clazz.getMethod("isDesktopSupported", null);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        try {
            if (!((Boolean)method.invoke(null, new Object[0])).booleanValue()) {
                return;
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Method method2 = null;
        try {
            method2 = clazz.getMethod("getDesktop", null);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        Object object = null;
        try {
            object = method2.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        if (object == null) {
            return;
        }
        Method method3 = null;
        try {
            method3 = object.getClass().getMethod("browse", URI.class);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        try {
            URI uRI = new URI(string);
            Object[] objectArray = new Object[]{uRI};
            method3.invoke(object, objectArray);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    private boolean getEulaAccepted() {
        return this.eulaAccepted;
    }

    private void disposeDialog() {
        this.root.dispose();
    }

    public static boolean askUserAcceptEULA() {
        final boolean[] blArray = new boolean[1];
        Runnable runnable = new Runnable(){

            public void run() {
                EulaDialog eulaDialog = new EulaDialog();
                blArray[0] = eulaDialog.getEulaAccepted();
                eulaDialog.disposeDialog();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                blArray[0] = false;
            }
        }
        return blArray[0];
    }

    public static void main(String[] stringArray) {
        System.out.println("EULA result: " + EulaDialog.askUserAcceptEULA());
    }
}

