/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eula;

import com.sun.javafx.eula.EulaDialog;
import com.sun.javafx.eula.Ping;
import com.sun.javafx.runtime.SystemProperties;
import com.sun.javafx.runtime.eula.Eula;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.jnlp.DownloadService;
import javax.jnlp.ServiceManager;

public class EulaImpl
implements Eula {
    private static final String EULA_ACCEPTED_FILENAME = ".javafx_eula_accepted";
    private static Boolean isCommandLine = null;

    static String getHomeDirectory() {
        String string = System.getProperty("os.name").toLowerCase();
        StringBuffer stringBuffer = new StringBuffer(System.getProperty("user.home"));
        if (string.indexOf("vista") != -1) {
            stringBuffer.append(File.separator);
            stringBuffer.append("appdata");
            stringBuffer.append(File.separator);
            stringBuffer.append("locallow");
        } else if (string.startsWith("mac")) {
            stringBuffer.append(File.separator);
            stringBuffer.append("Library");
            stringBuffer.append(File.separator);
            stringBuffer.append("Preferences");
        }
        stringBuffer.append(File.separator);
        return stringBuffer.toString();
    }

    private static boolean isCommandLine() {
        if (isCommandLine == null) {
            isCommandLine = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    if (SystemProperties.getProperty("javafx.runtime.isApplet") != null) {
                        return Boolean.FALSE;
                    }
                    try {
                        Class.forName("javax.jnlp.BasicService");
                        return Boolean.FALSE;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return Boolean.TRUE;
                    }
                }
            });
        }
        return isCommandLine;
    }

    private static String getEULAAcceptedFilePath() {
        StringBuffer stringBuffer = new StringBuffer(EulaImpl.getHomeDirectory());
        stringBuffer.append(EULA_ACCEPTED_FILENAME);
        return stringBuffer.toString();
    }

    private static boolean isEULAAlreadyAccepted() {
        Boolean bl = Boolean.FALSE;
        try {
            bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new File(EulaImpl.getEULAAcceptedFilePath()).exists();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        return bl;
    }

    private static void createEULAAcceptedFile() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    new File(EulaImpl.getEULAAcceptedFilePath()).createNewFile();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    private static int askUserAcceptEULA() {
        boolean bl = EulaDialog.askUserAcceptEULA();
        return bl ? 1 : 0;
    }

    public void accept() {
        EulaImpl.createEULAAcceptedFile();
    }

    public boolean show() {
        if (EulaImpl.isEULAAlreadyAccepted()) {
            Ping.send();
            return true;
        }
        int n = EulaImpl.askUserAcceptEULA();
        if (n == 1 || n == 2) {
            EulaImpl.createEULAAcceptedFile();
            Ping.send();
            return true;
        }
        Boolean bl = Boolean.FALSE;
        try {
            bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if ("true".equals(System.getProperty("sun.jnlp.applet.launcher"))) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        if (bl.booleanValue()) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        EulaImpl.removeLibraries();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {}
        } else if (!EulaImpl.isCommandLine()) {
            try {
                DownloadService downloadService = (DownloadService)ServiceManager.lookup((String)"javax.jnlp.DownloadService");
                Properties properties = EulaImpl.loadPropertiesFile();
                boolean bl2 = false;
                if (properties != null) {
                    int n2 = 0;
                    while (!bl2) {
                        String string = properties.getProperty("remove." + n2 + ".extUrl");
                        String string2 = properties.getProperty("remove." + n2 + ".extVersion");
                        String string3 = properties.getProperty("remove." + n2 + ".part");
                        if (string != null) {
                            ++n2;
                            downloadService.removeExtensionPart(new URL(string), string2, string3);
                            continue;
                        }
                        bl2 = true;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static void removeLibraries() {
        String string = "removeLibrary";
        Class[] classArray = new Class[]{String.class};
        try {
            Class<?> clazz = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
            Method method = clazz.getMethod("removeLibrary", classArray);
            try {
                method.invoke(null, "jmc");
                method.invoke(null, "on2_decoder");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                method.invoke(null, "jogl");
                method.invoke(null, "jogl_awt");
                method.invoke(null, "jogl_cg");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                method.invoke(null, "gluegen-rt");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                method.invoke(null, "Decora-SSE");
                method.invoke(null, "Decora-D3D");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFile() {
        Properties properties = new Properties();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = null;
        try {
            inputStream = classLoader.getResourceAsStream("com/sun/javafx/eula/removelist.properties");
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException iOException) {
            Properties properties3 = null;
            return properties3;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

