/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.ConcentricShapePair;
import com.sun.javafx.geom.GeneralShapePair;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import java.util.Arrays;

public class Stroke {
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int TYPE_CENTERED = 0;
    public static final int TYPE_INNER = 1;
    public static final int TYPE_OUTER = 2;
    static final int MAX_LEVEL = 10;
    static final float CURVE_DELTA = 16.0f;
    static final float CORNER_ANGLE = 4.0f;
    static final float CORNER_ZERO = 0.01f;
    static final float CUBIC_ARC = (float)(1.3333333730697632 * (Math.sqrt(2.0) - 1.0));
    float width;
    int type;
    int cap;
    int join;
    float miterLimit;
    float[] dash;
    float dashPhase;
    float curveDelta;
    float cornerDelta;
    float zeroDelta;
    float w2;
    boolean checkMove;
    BufferedPath dst;
    BufferedPath lp;
    BufferedPath rp;
    BufferedPath sp;
    float fmx;
    float fmy;
    Dasher dasher;
    static float SQRT_2 = (float)Math.sqrt(2.0);

    public Stroke(float f, int n, int n2, float f2) {
        this.set(f, 0, n, n2, f2);
    }

    public Stroke(float f, int n, int n2, int n3, float f2) {
        this.set(f, n, n2, n3, f2);
    }

    public Stroke(float f, int n, int n2, float f2, float[] fArray, float f3) {
        this.set(f, 0, n, n2, f2);
        this.set(fArray, f3);
    }

    public void set(float f, int n, int n2, int n3, float f2) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("negative width");
        }
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("illegal type");
        }
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("illegal cap");
        }
        if (n3 != 0 && n3 != 1 && n3 != 2) {
            throw new IllegalArgumentException("illegal join");
        }
        if (n3 == 0 && f2 < 1.0f) {
            throw new IllegalArgumentException("miter limit less than 1.0");
        }
        this.type = n;
        this.width = f;
        this.cap = n2;
        this.join = n3;
        this.miterLimit = f2;
    }

    public void set(float[] fArray, float f) {
        if (fArray != null && fArray.length > 0) {
            block7: {
                if (f < 0.0f) {
                    throw new IllegalArgumentException("negative dash phase");
                }
                if (fArray.length == 0) {
                    throw new IllegalArgumentException("zero dash length");
                }
                for (int i = 0; i < fArray.length; ++i) {
                    if (fArray[i] < 0.0f) {
                        throw new IllegalArgumentException("negative dash");
                    }
                    if (!(fArray[i] > 0.0f)) {
                        continue;
                    }
                    break block7;
                }
                throw new IllegalArgumentException("dash lengths zero");
            }
            this.dash = fArray;
            this.dashPhase = f;
        } else {
            this.dash = null;
            this.dashPhase = 0.0f;
        }
    }

    public float getLineWidth() {
        return this.width;
    }

    public int getType() {
        return this.type;
    }

    public int getEndCap() {
        return this.cap;
    }

    public int getLineJoin() {
        return this.join;
    }

    public float getMiterLimit() {
        return this.miterLimit;
    }

    public float[] getDashArray() {
        return this.dash;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }

    public boolean isDashed() {
        return this.dash != null;
    }

    public int hashCode() {
        int n = Float.floatToIntBits(this.width);
        n = n * 31 + this.type;
        n = n * 31 + this.join;
        n = n * 31 + this.cap;
        n = n * 31 + Float.floatToIntBits(this.miterLimit);
        if (this.dash != null) {
            n = n * 31 + Float.floatToIntBits(this.dashPhase);
            for (int i = 0; i < this.dash.length; ++i) {
                n = n * 31 + Float.floatToIntBits(this.dash[i]);
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Stroke)) {
            return false;
        }
        Stroke stroke = (Stroke)object;
        if (this.width != stroke.width) {
            return false;
        }
        if (this.type != stroke.type) {
            return false;
        }
        if (this.join != stroke.join) {
            return false;
        }
        if (this.cap != stroke.cap) {
            return false;
        }
        if (this.miterLimit != stroke.miterLimit) {
            return false;
        }
        if (this.dash != null) {
            if (this.dashPhase != stroke.dashPhase) {
                return false;
            }
            if (!Arrays.equals(this.dash, stroke.dash)) {
                return false;
            }
        } else if (stroke.dash != null) {
            return false;
        }
        return true;
    }

    float getCurveDelta(float f) {
        f = Math.max(f, 0.5f);
        float f2 = f + 16.0f;
        float f3 = 1.0f - 2.0f * f * f / (f2 * f2);
        float f4 = (float)Math.sqrt(1.0f - f3 * f3);
        return Math.abs(f4 / f3);
    }

    float getCornerDelta(float f) {
        return (float)((double)(f * f) * Math.sin(0.06981317007977318));
    }

    float getZeroDelta(float f) {
        return (float)((double)(f * f) * Math.sin(1.7453292129831807E-4));
    }

    public Shape createStrokedShape(Shape shape) {
        Shape shape2 = shape instanceof RoundRectangle2D ? this.strokeRoundRectangle((RoundRectangle2D)shape) : null;
        if (shape2 != null) {
            return shape2;
        }
        this.w2 = this.width;
        if (this.type == 0) {
            this.w2 /= 2.0f;
        }
        this.curveDelta = this.getCurveDelta(this.w2);
        this.cornerDelta = this.getCornerDelta(this.w2);
        this.zeroDelta = this.getZeroDelta(this.w2);
        this.dst = new BufferedPath();
        this.lp = new BufferedPath();
        this.rp = new BufferedPath();
        if (this.dash == null) {
            this.createSolidShape(shape.getPathIterator(null));
        } else {
            this.createDashedShape(shape.getPathIterator(null));
        }
        shape2 = this.dst.createGeneralPath();
        if (this.type == 1) {
            shape2 = this.makeIntersectedShape(shape2, shape);
        } else if (this.type == 2) {
            shape2 = this.makeSubtractedShape(shape2, shape);
        }
        return shape2;
    }

    protected Shape makeIntersectedShape(Shape shape, Shape shape2) {
        return new GeneralShapePair(shape, shape2, 4);
    }

    protected Shape makeSubtractedShape(Shape shape, Shape shape2) {
        return new GeneralShapePair(shape, shape2, 1);
    }

    static Shape makeBeveledRect(float f, float f2, float f3, float f4, float f5) {
        float f6 = f;
        float f7 = f2;
        float f8 = f + f3;
        float f9 = f2 + f4;
        Path2D path2D = new Path2D();
        path2D.moveTo(f6, f7 - f5);
        path2D.lineTo(f8, f7 - f5);
        path2D.lineTo(f8 + f5, f7);
        path2D.lineTo(f8 + f5, f9);
        path2D.lineTo(f8, f9 + f5);
        path2D.lineTo(f6, f9 + f5);
        path2D.lineTo(f6 - f5, f9);
        path2D.lineTo(f6 - f5, f7);
        path2D.closePath();
        return path2D;
    }

    Shape strokeRoundRectangle(RoundRectangle2D roundRectangle2D) {
        Shape shape;
        float f;
        float f2;
        int n;
        if (roundRectangle2D.width < 0.0f || roundRectangle2D.height < 0.0f) {
            return new Path2D();
        }
        if (this.isDashed()) {
            return null;
        }
        float f3 = roundRectangle2D.arcWidth;
        float f4 = roundRectangle2D.arcHeight;
        if (f3 <= 0.0f || f4 <= 0.0f) {
            f4 = 0.0f;
            f3 = 0.0f;
            if (this.type == 1) {
                n = 0;
            } else {
                n = this.join;
                if (n == 0 && this.miterLimit < SQRT_2) {
                    n = 2;
                }
            }
        } else {
            if (f3 < f4 * 0.9f || f4 < f3 * 0.9f) {
                return null;
            }
            n = 1;
        }
        if (this.type == 1) {
            f2 = 0.0f;
            f = this.width;
        } else if (this.type == 2) {
            f2 = this.width;
            f = 0.0f;
        } else {
            f2 = f = this.width / 2.0f;
        }
        switch (n) {
            case 0: {
                shape = new RoundRectangle2D(roundRectangle2D.x - f2, roundRectangle2D.y - f2, roundRectangle2D.width + f2 * 2.0f, roundRectangle2D.height + f2 * 2.0f, 0.0f, 0.0f);
                break;
            }
            case 2: {
                shape = Stroke.makeBeveledRect(roundRectangle2D.x, roundRectangle2D.y, roundRectangle2D.width, roundRectangle2D.height, f2);
                break;
            }
            case 1: {
                shape = new RoundRectangle2D(roundRectangle2D.x - f2, roundRectangle2D.y - f2, roundRectangle2D.width + f2 * 2.0f, roundRectangle2D.height + f2 * 2.0f, f3 + f2 * 2.0f, f4 + f2 * 2.0f);
                break;
            }
            default: {
                throw new InternalError("Unrecognized line join style");
            }
        }
        if (roundRectangle2D.width > f * 2.0f && roundRectangle2D.height > f * 2.0f) {
            f4 -= f * 2.0f;
            if ((f3 -= f * 2.0f) <= 0.0f || f4 <= 0.0f) {
                f4 = 0.0f;
                f3 = 0.0f;
            }
            RoundRectangle2D roundRectangle2D2 = new RoundRectangle2D(roundRectangle2D.x + f, roundRectangle2D.y + f, roundRectangle2D.width - f * 2.0f, roundRectangle2D.height - f * 2.0f, f3, f4);
            return new ConcentricShapePair(shape, roundRectangle2D2);
        }
        return shape;
    }

    void createSolidShape(PathIterator pathIterator) {
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        this.checkMove = true;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    this.finishSolidShape(f, f2, f3, f4, false);
                    f = f3 = fArray[0];
                    f2 = f4 = fArray[1];
                    break;
                }
                case 1: {
                    float f5 = f3;
                    float f6 = f4;
                    f3 = fArray[0];
                    f4 = fArray[1];
                    this.addLine(f5, f6, f3, f4, true);
                    break;
                }
                case 2: {
                    float f7 = f3;
                    float f8 = f4;
                    f3 = fArray[2];
                    f4 = fArray[3];
                    this.addQuad(f7, f8, fArray[0], fArray[1], f3, f4);
                    break;
                }
                case 3: {
                    float f9 = f3;
                    float f10 = f4;
                    f3 = fArray[4];
                    f4 = fArray[5];
                    this.addCubic(f9, f10, fArray[0], fArray[1], fArray[2], fArray[3], f3, f4);
                    break;
                }
                case 4: {
                    if (f3 != f || f4 != f2) {
                        this.addLine(f3, f4, f, f2, false);
                    }
                    this.finishSolidShape(f, f2, f3, f4, true);
                }
            }
            pathIterator.next();
        }
        this.finishSolidShape(f, f2, f3, f4, false);
        this.dst = this.lp;
    }

    void finishSolidShape(float f, float f2, float f3, float f4, boolean bl) {
        if (!this.rp.isEmpty()) {
            if (bl) {
                this.addJoin(this.lp, f, f2, this.lp.xMove, this.lp.yMove, true);
                this.addJoin(this.rp, f, f2, this.rp.xMove, this.rp.yMove, false);
                this.lp.closePath();
                this.rp.closePath();
                this.lp.appendReverse(this.rp);
                this.rp.clean();
            } else {
                this.addCap(this.lp, f3, f4, this.rp.xLast, this.rp.yLast);
                this.lp.combine(this.rp);
                this.rp.clean();
                this.addCap(this.lp, f, f2, this.lp.xMove, this.lp.yMove);
                this.lp.closePath();
            }
        }
    }

    void createDashedShape(PathIterator pathIterator) {
        float[] fArray = new float[6];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        this.checkMove = false;
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    this.finishDashedShape(false);
                    this.dasher = new Dasher(this.dash, this.dashPhase);
                    f = f3 = fArray[0];
                    f2 = f4 = fArray[1];
                    break;
                }
                case 1: {
                    float f5 = f3;
                    float f6 = f4;
                    f3 = fArray[0];
                    f4 = fArray[1];
                    this.addDashLine(f5, f6, f3, f4);
                    break;
                }
                case 2: {
                    float f7 = f3;
                    float f8 = f4;
                    f3 = fArray[2];
                    f4 = fArray[3];
                    this.addDashQuad(f7, f8, fArray[0], fArray[1], f3, f4);
                    break;
                }
                case 3: {
                    float f9 = f3;
                    float f10 = f4;
                    f3 = fArray[4];
                    f4 = fArray[5];
                    this.addDashCubic(f9, f10, fArray[0], fArray[1], fArray[2], fArray[3], f3, f4);
                    break;
                }
                case 4: {
                    if (f3 != f || f4 != f2) {
                        float f11 = f3;
                        float f12 = f4;
                        f3 = f;
                        f4 = f2;
                        this.addDashLine(f11, f12, f3, f4);
                    }
                    this.finishDashedShape(this.dasher.isConnected());
                }
            }
            pathIterator.next();
        }
        this.finishDashedShape(false);
    }

    void finishDashedShape(boolean bl) {
        if (this.sp != null) {
            if (bl) {
                this.addJoin(this.lp, this.fmx, this.fmy, this.sp.xMove, this.sp.yMove, true);
                this.lp.join(this.sp);
                this.sp = null;
                this.addJoin(this.lp, this.fmx, this.fmy, this.rp.xLast, this.rp.yLast, true);
                this.lp.combine(this.rp);
                this.rp.clean();
                this.addCap(this.lp, this.dasher.dashmx, this.dasher.dashmy, this.lp.xMove, this.lp.yMove);
                this.lp.closePath();
                this.dst.append(this.lp);
                this.lp.clean();
            } else {
                this.addCap(this.sp, this.fmx, this.fmy, this.sp.xMove, this.sp.yMove);
                this.sp.closePath();
                this.dst.append(this.sp);
                this.sp = null;
            }
        }
        if (!this.lp.isEmpty()) {
            if (!this.dasher.isClosed()) {
                this.addCap(this.lp, this.dasher.dashcx, this.dasher.dashcy, this.rp.xLast, this.rp.yLast);
                this.lp.combine(this.rp);
                this.rp.clean();
                this.addCap(this.lp, this.dasher.dashmx, this.dasher.dashmy, this.lp.xMove, this.lp.yMove);
                this.lp.closePath();
            }
            this.dst.append(this.lp);
            this.lp.clean();
        }
    }

    void addCap(BufferedPath bufferedPath, float f, float f2, float f3, float f4) {
        float f5 = bufferedPath.xLast;
        float f6 = bufferedPath.yLast;
        float f7 = f5 - f;
        float f8 = f6 - f2;
        float f9 = f3 - f;
        float f10 = f4 - f2;
        switch (this.cap) {
            case 0: {
                bufferedPath.lineTo(f3, f4);
                break;
            }
            case 1: {
                float f11 = f7 * CUBIC_ARC;
                float f12 = f8 * CUBIC_ARC;
                float f13 = f + f8;
                float f14 = f2 - f7;
                bufferedPath.cubicTo(f5 + (f8 *= CUBIC_ARC), f6 - (f7 *= CUBIC_ARC), f13 + f11, f14 + f12, f13, f14);
                bufferedPath.cubicTo(f13 - f11, f14 - f12, f3 - (f10 *= CUBIC_ARC), f4 + (f9 *= CUBIC_ARC), f3, f4);
                break;
            }
            case 2: {
                bufferedPath.lineTo(f5 + f8, f6 - f7);
                bufferedPath.lineTo(f3 - f10, f4 + f9);
                bufferedPath.lineTo(f3, f4);
            }
        }
    }

    void addJoin(BufferedPath bufferedPath, float f, float f2, float f3, float f4, boolean bl) {
        float f5 = bufferedPath.xLast;
        float f6 = f5 - f;
        float f7 = f4 - f2;
        float f8 = bufferedPath.yLast;
        float f9 = f8 - f2;
        float f10 = f3 - f;
        float f11 = f6 * f7 - f9 * f10;
        if (-this.cornerDelta < f11 && f11 < this.cornerDelta) {
            float f12 = f6 * f10 + f9 * f7;
            if (f12 > 0.0f) {
                if (-this.zeroDelta > f11 || f11 > this.zeroDelta) {
                    float f13 = f + this.w2 * this.w2 * (f7 - f9) / f11;
                    float f14 = f2 + this.w2 * this.w2 * (f6 - f10) / f11;
                    bufferedPath.setLast(f13, f14);
                }
                return;
            }
            if (-this.zeroDelta < f11 && f11 < this.zeroDelta) {
                bufferedPath.lineTo(f3, f4);
            }
            return;
        }
        if (bl ^ f11 < 0.0f) {
            bufferedPath.lineTo(f, f2);
            bufferedPath.lineTo(f3, f4);
        } else {
            switch (this.join) {
                case 2: {
                    bufferedPath.lineTo(f3, f4);
                    break;
                }
                case 0: {
                    float f15 = f5 * f6 + f8 * f9;
                    float f16 = f3 * f10 + f4 * f7;
                    float f17 = (f15 * f7 - f16 * f9) / f11;
                    float f18 = (f16 * f6 - f15 * f10) / f11;
                    float f19 = f17 - f;
                    float f20 = f18 - f2;
                    float f21 = (float)Math.sqrt(f19 * f19 + f20 * f20);
                    if (f21 < this.miterLimit * this.w2) {
                        bufferedPath.lineTo(f17, f18);
                    }
                    bufferedPath.lineTo(f3, f4);
                    break;
                }
                case 1: {
                    this.addRoundJoin(bufferedPath, f, f2, f3, f4, bl);
                }
            }
        }
    }

    void addRoundJoin(BufferedPath bufferedPath, float f, float f2, float f3, float f4, boolean bl) {
        float f5 = bufferedPath.xLast;
        float f6 = f5 - f;
        float f7 = f3 - f;
        float f8 = f6 + f7;
        float f9 = bufferedPath.yLast;
        float f10 = f9 - f2;
        float f11 = f4 - f2;
        float f12 = f10 + f11;
        float f13 = (float)Math.sqrt(f8 * f8 + f12 * f12);
        if ((double)f13 < 1.0E-5) {
            bufferedPath.lineTo(f3, f4);
            return;
        }
        float f14 = this.w2 / f13;
        float f15 = f + (f8 *= f14);
        float f16 = f2 + (f12 *= f14);
        float f17 = f6 * f7 + f10 * f11;
        float f18 = (float)Math.acos(f17 / (this.w2 * this.w2));
        if (f17 >= 0.0f) {
            float f19 = (float)(1.3333333730697632 * Math.tan(f18 / 4.0f));
            if (bl) {
                f19 = -f19;
            }
            bufferedPath.cubicTo(f5 - (f10 *= f19), f9 + (f6 *= f19), f3 + (f11 *= f19), f4 - (f7 *= f19), f3, f4);
        } else {
            float f20 = (float)(1.3333333730697632 * Math.tan(f18 / 8.0f));
            if (bl) {
                f20 = -f20;
            }
            bufferedPath.cubicTo(f5 - (f10 *= f20), f9 + (f6 *= f20), f15 + (f12 *= f20), f16 - (f8 *= f20), f15, f16);
            bufferedPath.cubicTo(f15 - f12, f16 + f8, f3 + (f11 *= f20), f4 - (f7 *= f20), f3, f4);
        }
    }

    void addLine(float f, float f2, float f3, float f4, boolean bl) {
        float f5;
        float f6 = f3 - f;
        float f7 = f4 - f2;
        if (f6 == 0.0f && f7 == 0.0f) {
            if (!bl) {
                return;
            }
            f6 = this.w2;
            f7 = 0.0f;
        } else {
            f5 = (float)((double)this.w2 / Math.sqrt(f6 * f6 + f7 * f7));
            f6 *= f5;
            f7 *= f5;
        }
        f5 = f - f7;
        float f8 = f2 + f6;
        float f9 = f + f7;
        float f10 = f2 - f6;
        if (this.checkMove) {
            if (this.rp.isEmpty()) {
                this.lp.moveTo(f5, f8);
                this.rp.moveTo(f9, f10);
            } else {
                this.addJoin(this.lp, f, f2, f5, f8, true);
                this.addJoin(this.rp, f, f2, f9, f10, false);
            }
        }
        this.lp.lineTo(f3 - f7, f4 + f6);
        this.rp.lineTo(f3 + f7, f4 - f6);
    }

    void addQuad(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f3 - f;
        float f8 = f4 - f2;
        float f9 = f3 - f5;
        float f10 = f4 - f6;
        float f11 = (float)Math.sqrt(f7 * f7 + f8 * f8);
        float f12 = (float)Math.sqrt(f9 * f9 + f10 * f10);
        if (f11 == 0.0f && f12 == 0.0f) {
            this.addLine(f, f2, f5, f6, false);
            return;
        }
        if (f11 == 0.0f) {
            this.addLine(f3, f4, f5, f6, false);
            return;
        }
        if (f12 == 0.0f) {
            this.addLine(f, f2, f3, f4, false);
            return;
        }
        float f13 = this.w2 / f11;
        float f14 = -f8 * f13;
        float f15 = f7 * f13;
        f13 = this.w2 / f12;
        float f16 = f10 * f13;
        float f17 = -f9 * f13;
        float f18 = f + f14;
        float f19 = f2 + f15;
        float f20 = f - f14;
        float f21 = f2 - f15;
        if (this.checkMove) {
            if (this.rp.isEmpty()) {
                this.lp.moveTo(f18, f19);
                this.rp.moveTo(f20, f21);
            } else {
                this.addJoin(this.lp, f, f2, f18, f19, true);
                this.addJoin(this.rp, f, f2, f20, f21, false);
            }
        }
        if (f7 * f10 - f8 * f9 == 0.0f) {
            if (f7 * f9 + f8 * f10 > 0.0f) {
                if (f11 == f12) {
                    float f22 = f + (f7 + f9) / 4.0f;
                    float f23 = f2 + (f8 + f10) / 4.0f;
                    this.lp.lineTo(f22 + f14, f23 + f15);
                    this.rp.lineTo(f22 - f14, f23 - f15);
                    this.lp.lineTo(f22 - f14, f23 - f15);
                    this.rp.lineTo(f22 + f14, f23 + f15);
                    this.lp.lineTo(f5 - f14, f6 - f15);
                    this.rp.lineTo(f5 + f14, f6 + f15);
                } else {
                    float f24 = f11 / (f11 + f12);
                    float f25 = f + (f7 + f9) * f24 * f24;
                    float f26 = f2 + (f8 + f10) * f24 * f24;
                    float f27 = (f + f25) / 2.0f;
                    float f28 = (f2 + f26) / 2.0f;
                    this.lp.quadTo(f27 + f14, f28 + f15, f25 + f14, f26 + f15);
                    this.rp.quadTo(f27 - f14, f28 - f15, f25 - f14, f26 - f15);
                    this.lp.lineTo(f25 - f14, f26 - f15);
                    this.rp.lineTo(f25 + f14, f26 + f15);
                    f27 = (f5 + f25) / 2.0f;
                    f28 = (f6 + f26) / 2.0f;
                    this.lp.quadTo(f27 - f14, f28 - f15, f5 - f14, f6 - f15);
                    this.rp.quadTo(f27 + f14, f28 + f15, f5 + f14, f6 + f15);
                }
            } else {
                this.lp.quadTo(f3 + f14, f4 + f15, f5 + f16, f6 + f17);
                this.rp.quadTo(f3 - f14, f4 - f15, f5 - f16, f6 - f17);
            }
        } else {
            this.addSubQuad(f, f2, f3, f4, f5, f6, 0);
        }
    }

    void addSubQuad(float f, float f2, float f3, float f4, float f5, float f6, int n) {
        float f7 = f3 - f;
        float f8 = f4 - f2;
        float f9 = f3 - f5;
        float f10 = f4 - f6;
        float f11 = f7 * f9 + f8 * f10;
        float f12 = f7 * f10 - f8 * f9;
        if (n < 10 && (f11 >= 0.0f || Math.abs(f12 / f11) > this.curveDelta)) {
            float f13 = (f3 + f) / 2.0f;
            float f14 = (f4 + f2) / 2.0f;
            float f15 = (f3 + f5) / 2.0f;
            float f16 = (f4 + f6) / 2.0f;
            float f17 = (f13 + f15) / 2.0f;
            float f18 = (f14 + f16) / 2.0f;
            this.addSubQuad(f, f2, f13, f14, f17, f18, n + 1);
            this.addSubQuad(f17, f18, f15, f16, f5, f6, n + 1);
        } else {
            float f19;
            float f20;
            float f21;
            float f22;
            float f23 = (float)Math.sqrt(f7 * f7 + f8 * f8);
            float f24 = (float)Math.sqrt(f9 * f9 + f10 * f10);
            if (f24 != 0.0f) {
                float f25 = this.w2 / f24;
                f22 = f10 * f25;
                f21 = -f9 * f25;
                if (f12 == 0.0f) {
                    f20 = f22;
                    f19 = f21;
                } else {
                    f25 = this.w2 / f12;
                    f20 = (f7 * f24 + f9 * f23) * f25;
                    f19 = (f8 * f24 + f10 * f23) * f25;
                }
            } else if (f23 != 0.0f) {
                float f26 = this.w2 / f23;
                f20 = f22 = f8 * f26;
                f19 = f21 = -f7 * f26;
            } else {
                return;
            }
            this.lp.quadTo(f3 + f20, f4 + f19, f5 + f22, f6 + f21);
            this.rp.quadTo(f3 - f20, f4 - f19, f5 - f22, f6 - f21);
        }
    }

    void addCubic(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        boolean bl;
        float f9;
        float f10;
        float f11;
        float f12;
        float f13;
        float f14 = f - f3;
        float f15 = f2 - f4;
        float f16 = f3 - f5;
        float f17 = f4 - f6;
        float f18 = f5 - f7;
        float f19 = f6 - f8;
        float f20 = (float)Math.sqrt(f14 * f14 + f15 * f15);
        float f21 = (float)Math.sqrt(f16 * f16 + f17 * f17);
        float f22 = (float)Math.sqrt(f18 * f18 + f19 * f19);
        if (f20 == 0.0f && f21 == 0.0f && f22 == 0.0f) {
            this.addLine(f, f2, f7, f8, false);
            return;
        }
        if (f20 == 0.0f && f21 == 0.0f) {
            this.addLine(f5, f6, f7, f8, false);
            return;
        }
        if (f21 == 0.0f && f22 == 0.0f) {
            this.addLine(f, f2, f3, f4, false);
            return;
        }
        if (f20 == 0.0f && f22 == 0.0f) {
            this.addLine(f3, f4, f5, f6, false);
            return;
        }
        if (f20 == 0.0f) {
            f13 = this.w2 / f21;
            f12 = f17 * f13;
            f11 = -f16 * f13;
            f13 = this.w2 / f22;
            f10 = f19 * f13;
            f9 = -f18 * f13;
            bl = -f16 * f19 + f17 * f18 == 0.0f;
        } else if (f22 == 0.0f) {
            f13 = this.w2 / f20;
            f12 = f15 * f13;
            f11 = -f14 * f13;
            f13 = this.w2 / f21;
            f10 = f17 * f13;
            f9 = -f16 * f13;
            bl = -f14 * f17 + f15 * f16 == 0.0f;
        } else {
            f13 = this.w2 / f20;
            f12 = f15 * f13;
            f11 = -f14 * f13;
            f13 = this.w2 / f22;
            f10 = f19 * f13;
            f9 = -f18 * f13;
            bl = f21 == 0.0f ? -f14 * f19 + f15 * f18 == 0.0f : -f14 * f19 + f15 * f18 == 0.0f && -f14 * f17 + f15 * f16 == 0.0f && -f16 * f19 + f17 * f18 == 0.0f;
        }
        float f23 = f + f12;
        float f24 = f2 + f11;
        float f25 = f - f12;
        float f26 = f2 - f11;
        if (this.checkMove) {
            if (this.rp.isEmpty()) {
                this.lp.moveTo(f23, f24);
                this.rp.moveTo(f25, f26);
            } else {
                this.addJoin(this.lp, f, f2, f23, f24, true);
                this.addJoin(this.rp, f, f2, f25, f26, false);
            }
        }
        if (bl) {
            float f27;
            float f28;
            if (f == f3 && f2 < f4 || f < f3) {
                f20 = -f20;
            }
            if (f3 == f5 && f4 < f6 || f3 < f5) {
                f21 = -f21;
            }
            if (f5 == f7 && f6 < f8 || f5 < f7) {
                f22 = -f22;
            }
            float f29 = f21 * f21 - f20 * f22;
            float[] fArray = new float[3];
            int n = 0;
            if (f29 == 0.0f) {
                f28 = (f20 - f21) / (f20 + f22 - f21 - f21);
                if (0.0f < f28 && f28 < 1.0f) {
                    fArray[n++] = f28;
                }
            } else if (f29 > 0.0f) {
                f27 = (f20 - f21 + (f29 = (float)Math.sqrt(f29))) / (f28 = f20 + f22 - f21 - f21);
                if (0.0f < f27 && f27 < 1.0f) {
                    fArray[n++] = f27;
                }
                if (0.0f < (f27 = (f20 - f21 - f29) / f28) && f27 < 1.0f) {
                    fArray[n++] = f27;
                }
            }
            if (n > 0) {
                if (n == 2 && fArray[0] > fArray[1]) {
                    f28 = fArray[0];
                    fArray[0] = fArray[1];
                    fArray[1] = f28;
                }
                fArray[n++] = 1.0f;
                f28 = -f18 - f14 + f16 + f16;
                f27 = -f19 - f15 + f17 + f17;
                float f30 = 3.0f * (-f16 + f14);
                float f31 = 3.0f * (-f17 + f15);
                float f32 = 3.0f * -f14;
                float f33 = 3.0f * -f15;
                float f34 = f;
                float f35 = f2;
                for (int i = 0; i < n; ++i) {
                    float f36 = fArray[i];
                    float f37 = f36 * (f36 * (f36 * f28 + f30) + f32) + f;
                    float f38 = f36 * (f36 * (f36 * f27 + f31) + f33) + f2;
                    float f39 = (f34 + f37) / 2.0f;
                    float f40 = (f35 + f38) / 2.0f;
                    this.lp.cubicTo(f39 + f12, f40 + f11, f39 + f12, f40 + f11, f37 + f12, f38 + f11);
                    this.rp.cubicTo(f39 - f12, f40 - f11, f39 - f12, f40 - f11, f37 - f12, f38 - f11);
                    if (i < n - 1) {
                        this.lp.lineTo(f37 - f12, f38 - f11);
                        this.rp.lineTo(f37 + f12, f38 + f11);
                    }
                    f34 = f37;
                    f35 = f38;
                    f12 = -f12;
                    f11 = -f11;
                }
            } else {
                this.lp.cubicTo(f3 + f12, f4 + f11, f5 + f10, f6 + f9, f7 + f10, f8 + f9);
                this.rp.cubicTo(f3 - f12, f4 - f11, f5 - f10, f6 - f9, f7 - f10, f8 - f9);
            }
        } else {
            this.addSubCubic(f, f2, f3, f4, f5, f6, f7, f8, 0);
        }
    }

    void addSubCubic(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, int n) {
        float f9 = f - f3;
        float f10 = f2 - f4;
        float f11 = f3 - f5;
        float f12 = f4 - f6;
        float f13 = f5 - f7;
        float f14 = f6 - f8;
        float f15 = -f9 * f11 - f10 * f12;
        float f16 = -f11 * f13 - f12 * f14;
        float f17 = -f9 * f12 + f10 * f11;
        float f18 = -f11 * f14 + f12 * f13;
        float f19 = -f9 * f14 + f10 * f13;
        float f20 = -f9 * f13 - f10 * f14;
        if (n < 10 && (f17 != 0.0f || f18 != 0.0f || f19 != 0.0f) && (f15 >= 0.0f || f16 >= 0.0f || f20 >= 0.0f || Math.abs(f17 / f15) > this.curveDelta || Math.abs(f18 / f16) > this.curveDelta || Math.abs(f19 / f20) > this.curveDelta)) {
            float f21 = (f3 + f5) / 2.0f;
            float f22 = (f4 + f6) / 2.0f;
            float f23 = (f3 + f) / 2.0f;
            float f24 = (f4 + f2) / 2.0f;
            float f25 = (f5 + f7) / 2.0f;
            float f26 = (f6 + f8) / 2.0f;
            float f27 = (f21 + f23) / 2.0f;
            float f28 = (f22 + f24) / 2.0f;
            float f29 = (f21 + f25) / 2.0f;
            float f30 = (f22 + f26) / 2.0f;
            f21 = (f27 + f29) / 2.0f;
            f22 = (f28 + f30) / 2.0f;
            this.addSubCubic(f, f2, f23, f24, f27, f28, f21, f22, n + 1);
            this.addSubCubic(f21, f22, f29, f30, f25, f26, f7, f8, n + 1);
        } else {
            float f31;
            float f32;
            float f33;
            float f34;
            float f35;
            float f36;
            float f37;
            float f38;
            float f39;
            float f40 = (float)Math.sqrt(f9 * f9 + f10 * f10);
            float f41 = (float)Math.sqrt(f11 * f11 + f12 * f12);
            float f42 = (float)Math.sqrt(f13 * f13 + f14 * f14);
            if (f40 != 0.0f) {
                f39 = this.w2 / f40;
                f38 = f10 * f39;
                f37 = -f9 * f39;
            } else if (f41 != 0.0f) {
                f39 = this.w2 / f41;
                f38 = f12 * f39;
                f37 = -f11 * f39;
            } else if (f42 != 0.0f) {
                f39 = this.w2 / f42;
                f38 = f14 * f39;
                f37 = -f13 * f39;
            } else {
                return;
            }
            if (f42 != 0.0f) {
                f39 = this.w2 / f42;
                f36 = f14 * f39;
                f35 = -f13 * f39;
            } else if (f41 != 0.0f) {
                f39 = this.w2 / f41;
                f36 = f12 * f39;
                f35 = -f11 * f39;
            } else {
                f39 = this.w2 / f40;
                f36 = f10 * f39;
                f35 = -f9 * f39;
            }
            if (f17 == 0.0f) {
                f34 = f38;
                f33 = f37;
            } else {
                f39 = this.w2 / f17;
                f34 = -(f9 * f41 - f11 * f40) * f39;
                f33 = -(f10 * f41 - f12 * f40) * f39;
            }
            if (f18 == 0.0f) {
                f32 = f36;
                f31 = f35;
            } else {
                f39 = this.w2 / f18;
                f32 = -(f11 * f42 - f13 * f41) * f39;
                f31 = -(f12 * f42 - f14 * f41) * f39;
            }
            this.lp.cubicTo(f3 + f34, f4 + f33, f5 + f32, f6 + f31, f7 + f36, f8 + f35);
            this.rp.cubicTo(f3 - f34, f4 - f33, f5 - f32, f6 - f31, f7 - f36, f8 - f35);
        }
    }

    void addDashLine(float f, float f2, float f3, float f4) {
        float f5 = f3 - f;
        float f6 = f4 - f2;
        float f7 = (float)Math.sqrt(f5 * f5 + f6 * f6);
        if (f7 == 0.0f) {
            return;
        }
        float f8 = this.w2 / f7;
        float f9 = -f6 * f8;
        float f10 = f5 * f8;
        this.dasher.init(new DashIterator.Line(f7));
        while (!this.dasher.eof()) {
            float f11 = this.dasher.getValue();
            float f12 = f + f11 * f5;
            float f13 = f2 + f11 * f6;
            if (this.dasher.isOpen()) {
                float f14 = f12 + f9;
                float f15 = f13 + f10;
                float f16 = f12 - f9;
                float f17 = f13 - f10;
                if (this.rp.isEmpty()) {
                    this.lp.moveTo(f14, f15);
                    this.rp.moveTo(f16, f17);
                    this.dasher.dashmx = f12;
                    this.dasher.dashmy = f13;
                } else {
                    this.addJoin(this.lp, f12, f13, f14, f15, true);
                    this.addJoin(this.rp, f12, f13, f16, f17, false);
                }
                this.dasher.dashcx = f12;
                this.dasher.dashcy = f13;
            } else if (this.dasher.isContinue()) {
                this.lp.lineTo(f12 + f9, f13 + f10);
                this.rp.lineTo(f12 - f9, f13 - f10);
                this.dasher.dashcx = f12;
                this.dasher.dashcy = f13;
                if (this.dasher.isClosed()) {
                    this.addCap(this.lp, f12, f13, this.rp.xLast, this.rp.yLast);
                    this.lp.combine(this.rp);
                    this.rp.clean();
                    if (this.dasher.couldBeConnected() && this.sp == null) {
                        this.fmx = this.dasher.dashmx;
                        this.fmy = this.dasher.dashmy;
                        this.sp = this.lp;
                        this.lp = new BufferedPath();
                    } else {
                        this.addCap(this.lp, this.dasher.dashmx, this.dasher.dashmy, this.lp.xMove, this.lp.yMove);
                        this.lp.closePath();
                    }
                }
            }
            this.dasher.next();
        }
    }

    void addDashQuad(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f3 - f;
        float f8 = f4 - f2;
        float f9 = f3 - f5;
        float f10 = f4 - f6;
        float f11 = (float)Math.sqrt(f7 * f7 + f8 * f8);
        float f12 = (float)Math.sqrt(f9 * f9 + f10 * f10);
        if (f11 == 0.0f && f12 == 0.0f) {
            return;
        }
        if (f11 == 0.0f) {
            this.addDashLine(f3, f4, f5, f6);
            return;
        }
        if (f12 == 0.0f) {
            this.addDashLine(f, f2, f3, f4);
            return;
        }
        float f13 = f + f5 - f3 - f3;
        float f14 = f2 + f6 - f4 - f4;
        float f15 = f3 - f;
        float f16 = f4 - f2;
        float f17 = f;
        float f18 = f2;
        float f19 = 0.0f;
        float f20 = 0.0f;
        float f21 = 0.0f;
        this.dasher.init(new DashIterator.Quad(f, f2, f3, f4, f5, f6));
        while (!this.dasher.eof()) {
            float f22;
            float f23;
            float f24;
            float f25;
            float f26;
            float f27;
            float f28;
            float f29 = this.dasher.getValue();
            float f30 = f29 * f13 + f15;
            float f31 = f29 * f14 + f16;
            float f32 = f29 * (f30 + f15) + f17;
            float f33 = f29 * (f31 + f16) + f18;
            if (this.dasher.isOpen()) {
                f19 = f32;
                f20 = f33;
                f28 = (float)((double)this.w2 / Math.sqrt(f30 * f30 + f31 * f31));
                f27 = -f31 * f28;
                f26 = f30 * f28;
                f25 = f19 + f27;
                f24 = f20 + f26;
                f23 = f19 - f27;
                f22 = f20 - f26;
                if (this.rp.isEmpty()) {
                    this.lp.moveTo(f25, f24);
                    this.rp.moveTo(f23, f22);
                    this.dasher.dashmx = f19;
                    this.dasher.dashmy = f20;
                } else {
                    this.addJoin(this.lp, f19, f20, f25, f24, true);
                    this.addJoin(this.rp, f19, f20, f23, f22, false);
                }
                this.dasher.dashcx = f19;
                this.dasher.dashcy = f20;
            } else if (this.dasher.isContinue()) {
                f28 = f32;
                f27 = f33;
                f26 = f3 - f9 * f21;
                f25 = f4 - f10 * f21;
                f24 = (f29 - f21) / (1.0f - f21);
                f23 = f19 + (f26 - f19) * f24;
                f22 = f20 + (f25 - f20) * f24;
                this.addQuad(f19, f20, f23, f22, f28, f27);
                this.dasher.dashcx = f28;
                this.dasher.dashcy = f27;
                if (this.dasher.isClosed()) {
                    this.addCap(this.lp, f28, f27, this.rp.xLast, this.rp.yLast);
                    this.lp.combine(this.rp);
                    this.rp.clean();
                    if (this.dasher.couldBeConnected() && this.sp == null) {
                        this.fmx = this.dasher.dashmx;
                        this.fmy = this.dasher.dashmy;
                        this.sp = this.lp;
                        this.lp = new BufferedPath();
                    } else {
                        this.addCap(this.lp, this.dasher.dashmx, this.dasher.dashmy, this.lp.xMove, this.lp.yMove);
                        this.lp.closePath();
                    }
                }
            }
            f21 = f29;
            this.dasher.next();
        }
    }

    void addDashCubic(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = f - f3;
        float f10 = f2 - f4;
        float f11 = f3 - f5;
        float f12 = f4 - f6;
        float f13 = f5 - f7;
        float f14 = f6 - f8;
        float f15 = (float)Math.sqrt(f9 * f9 + f10 * f10);
        float f16 = (float)Math.sqrt(f11 * f11 + f12 * f12);
        float f17 = (float)Math.sqrt(f13 * f13 + f14 * f14);
        if (f15 == 0.0f && f16 == 0.0f && f17 == 0.0f) {
            return;
        }
        if (f15 == 0.0f && f16 == 0.0f) {
            this.addDashLine(f5, f6, f7, f8);
            return;
        }
        if (f16 == 0.0f && f17 == 0.0f) {
            this.addDashLine(f, f2, f3, f4);
            return;
        }
        if (f15 == 0.0f && f17 == 0.0f) {
            this.addDashLine(f3, f4, f5, f6);
            return;
        }
        float f18 = f7 - f + 3.0f * (f3 - f5);
        float f19 = f8 - f2 + 3.0f * (f4 - f6);
        float f20 = 3.0f * (f + f5 - f3 - f3);
        float f21 = 3.0f * (f2 + f6 - f4 - f4);
        float f22 = 3.0f * (f3 - f);
        float f23 = 3.0f * (f4 - f2);
        float f24 = f;
        float f25 = f2;
        float f26 = 0.0f;
        float f27 = 0.0f;
        float f28 = 0.0f;
        this.dasher.init(new DashIterator.Cubic(f, f2, f3, f4, f5, f6, f7, f8));
        while (!this.dasher.eof()) {
            float f29;
            float f30;
            float f31;
            float f32;
            float f33;
            float f34;
            float f35;
            float f36;
            float f37;
            float f38 = this.dasher.getValue();
            float f39 = f38 * (f38 * (f38 * f18 + f20) + f22) + f24;
            float f40 = f38 * (f38 * (f38 * f19 + f21) + f23) + f25;
            if (this.dasher.isOpen()) {
                f26 = f39;
                f27 = f40;
                f37 = f38 * (f38 * (f18 + f18 + f18) + f20 + f20) + f22;
                f36 = f38 * (f38 * (f19 + f19 + f19) + f21 + f21) + f23;
                f35 = (float)((double)this.w2 / Math.sqrt(f37 * f37 + f36 * f36));
                f34 = -f36 * f35;
                f33 = f37 * f35;
                f32 = f26 + f34;
                f31 = f27 + f33;
                f30 = f26 - f34;
                f29 = f27 - f33;
                if (this.rp.isEmpty()) {
                    this.lp.moveTo(f32, f31);
                    this.rp.moveTo(f30, f29);
                    this.dasher.dashmx = f26;
                    this.dasher.dashmy = f27;
                } else {
                    this.addJoin(this.lp, f26, f27, f32, f31, true);
                    this.addJoin(this.rp, f26, f27, f30, f29, false);
                }
                this.dasher.dashcx = f26;
                this.dasher.dashcy = f27;
            } else if (this.dasher.isContinue()) {
                f37 = f3 - f11 * f28;
                f36 = f4 - f12 * f28;
                f35 = f5 - f13 * f28;
                f34 = f6 - f14 * f28;
                f33 = f37 + (f35 - f37) * f28;
                f32 = f36 + (f34 - f36) * f28;
                f31 = (f38 - f28) / (1.0f - f28);
                f30 = f33 + (f35 - f33) * f31;
                f29 = f32 + (f34 - f32) * f31;
                float f41 = f39;
                float f42 = f40;
                float f43 = f26 + (f33 - f26) * f31;
                float f44 = f27 + (f32 - f27) * f31;
                float f45 = f43 + (f30 - f43) * f31;
                float f46 = f44 + (f29 - f44) * f31;
                this.addCubic(f26, f27, f43, f44, f45, f46, f41, f42);
                this.dasher.dashcx = f41;
                this.dasher.dashcy = f42;
                if (this.dasher.isClosed()) {
                    this.addCap(this.lp, f41, f42, this.rp.xLast, this.rp.yLast);
                    this.lp.combine(this.rp);
                    this.rp.clean();
                    if (this.dasher.couldBeConnected() && this.sp == null) {
                        this.fmx = this.dasher.dashmx;
                        this.fmy = this.dasher.dashmy;
                        this.sp = this.lp;
                        this.lp = new BufferedPath();
                    } else {
                        this.addCap(this.lp, this.dasher.dashmx, this.dasher.dashmy, this.lp.xMove, this.lp.yMove);
                        this.lp.closePath();
                    }
                }
            }
            f28 = f38;
            this.dasher.next();
        }
    }

    static class BufferedPath {
        private static final int bufCapacity = 10;
        private static final int maxGrow = 131072;
        static int[] pointShift = new int[]{2, 2, 4, 6, 0};
        byte[] types = new byte[10];
        float[] points = new float[20];
        int typeSize;
        int pointSize;
        float xLast;
        float yLast;
        float xMove;
        float yMove;

        void checkBuf(int n, int n2) {
            Object[] objectArray;
            int n3;
            if (this.typeSize + n > this.types.length) {
                n3 = Math.min(this.types.length, 131072);
                n3 = Math.max(n, n3);
                objectArray = new byte[this.types.length + n3];
                System.arraycopy(this.types, 0, objectArray, 0, this.typeSize);
                this.types = objectArray;
            }
            if (this.pointSize + n2 > this.points.length) {
                n3 = Math.min(this.points.length, 262144);
                n3 = Math.max(n2, n3);
                objectArray = new float[this.points.length + n3];
                System.arraycopy(this.points, 0, objectArray, 0, this.pointSize);
                this.points = objectArray;
            }
        }

        boolean isEmpty() {
            return this.typeSize == 0;
        }

        void clean() {
            this.typeSize = 0;
            this.pointSize = 0;
        }

        void moveTo(float f, float f2) {
            this.checkBuf(1, 2);
            this.types[this.typeSize++] = 0;
            this.points[this.pointSize++] = this.xMove = f;
            this.points[this.pointSize++] = this.yMove = f2;
        }

        void lineTo(float f, float f2) {
            this.checkBuf(1, 2);
            this.types[this.typeSize++] = 1;
            this.points[this.pointSize++] = this.xLast = f;
            this.points[this.pointSize++] = this.yLast = f2;
        }

        void quadTo(float f, float f2, float f3, float f4) {
            this.checkBuf(1, 4);
            this.types[this.typeSize++] = 2;
            this.points[this.pointSize++] = f;
            this.points[this.pointSize++] = f2;
            this.points[this.pointSize++] = this.xLast = f3;
            this.points[this.pointSize++] = this.yLast = f4;
        }

        void cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
            this.checkBuf(1, 6);
            this.types[this.typeSize++] = 3;
            this.points[this.pointSize++] = f;
            this.points[this.pointSize++] = f2;
            this.points[this.pointSize++] = f3;
            this.points[this.pointSize++] = f4;
            this.points[this.pointSize++] = this.xLast = f5;
            this.points[this.pointSize++] = this.yLast = f6;
        }

        void closePath() {
            this.checkBuf(1, 0);
            this.types[this.typeSize++] = 4;
        }

        void setLast(float f, float f2) {
            this.points[this.pointSize - 2] = this.xLast = f;
            this.points[this.pointSize - 1] = this.yLast = f2;
        }

        void append(BufferedPath bufferedPath) {
            this.checkBuf(bufferedPath.typeSize, bufferedPath.pointSize);
            System.arraycopy(bufferedPath.points, 0, this.points, this.pointSize, bufferedPath.pointSize);
            System.arraycopy(bufferedPath.types, 0, this.types, this.typeSize, bufferedPath.typeSize);
            this.pointSize += bufferedPath.pointSize;
            this.typeSize += bufferedPath.typeSize;
            this.xLast = this.points[this.pointSize - 2];
            this.yLast = this.points[this.pointSize - 1];
        }

        void appendReverse(BufferedPath bufferedPath) {
            int n;
            if (bufferedPath.pointSize < 2) {
                return;
            }
            this.checkBuf(bufferedPath.typeSize, bufferedPath.pointSize);
            for (n = bufferedPath.pointSize - 2; n >= 0; n -= 2) {
                this.points[this.pointSize++] = bufferedPath.points[n + 0];
                this.points[this.pointSize++] = bufferedPath.points[n + 1];
            }
            n = 0;
            for (int i = bufferedPath.typeSize - 1; i >= 0; --i) {
                byte by = bufferedPath.types[i];
                if (by == 0) {
                    this.types[n] = 0;
                    this.types[this.typeSize++] = 4;
                    continue;
                }
                if (by == 4) {
                    n = this.typeSize;
                }
                this.types[this.typeSize++] = by;
            }
            this.xLast = this.points[this.pointSize - 2];
            this.yLast = this.points[this.pointSize - 1];
        }

        void join(BufferedPath bufferedPath) {
            this.checkBuf(bufferedPath.typeSize - 1, bufferedPath.pointSize - 2);
            System.arraycopy(bufferedPath.points, 2, this.points, this.pointSize, bufferedPath.pointSize - 2);
            System.arraycopy(bufferedPath.types, 1, this.types, this.typeSize, bufferedPath.typeSize - 1);
            this.pointSize += bufferedPath.pointSize - 2;
            this.typeSize += bufferedPath.typeSize - 1;
            this.xLast = this.points[this.pointSize - 2];
            this.yLast = this.points[this.pointSize - 1];
        }

        void combine(BufferedPath bufferedPath) {
            int n;
            this.checkBuf(bufferedPath.typeSize - 1, bufferedPath.pointSize - 2);
            for (n = bufferedPath.pointSize - 4; n >= 0; n -= 2) {
                this.points[this.pointSize++] = bufferedPath.points[n + 0];
                this.points[this.pointSize++] = bufferedPath.points[n + 1];
            }
            for (n = bufferedPath.typeSize - 1; n >= 1; --n) {
                this.types[this.typeSize++] = bufferedPath.types[n];
            }
            this.xLast = this.points[this.pointSize - 2];
            this.yLast = this.points[this.pointSize - 1];
        }

        Shape createGeneralPath() {
            return new Path2D(1, this.types, this.typeSize, this.points, this.pointSize);
        }
    }

    static abstract class DashIterator {
        static final float FLATNESS = 1.0f;
        float length;

        DashIterator() {
        }

        abstract float getNext(float var1);

        static class Cubic
        extends DashIterator {
            int valSize;
            int valPos;
            float curLen;
            float prevLen;
            float lastLen;
            float[] values;
            float step;

            Cubic(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
                float f9 = f + f5 - f3 - f3;
                float f10 = f2 + f6 - f4 - f4;
                float f11 = f3 + f7 - f5 - f5;
                float f12 = f4 + f8 - f6 - f6;
                float f13 = Math.max(Math.abs(f9) + Math.abs(f10), Math.abs(f11) + Math.abs(f12));
                int n = (int)(1.0 + Math.sqrt(0.75 * (double)f13) * 1.0);
                this.step = 1.0f / (float)n;
                float f14 = f7 - f + 3.0f * (f3 - f5);
                float f15 = f8 - f2 + 3.0f * (f4 - f6);
                float f16 = 3.0f * (f + f5 - f3 - f3);
                float f17 = 3.0f * (f2 + f6 - f4 - f4);
                float f18 = 3.0f * (f3 - f);
                float f19 = 3.0f * (f4 - f2);
                float f20 = this.step * (this.step * (this.step * f14 + f16) + f18);
                float f21 = this.step * (this.step * (this.step * f15 + f17) + f19);
                float f22 = this.step * (this.step * (this.step * f14 * 6.0f + f16 * 2.0f));
                float f23 = this.step * (this.step * (this.step * f15 * 6.0f + f17 * 2.0f));
                float f24 = this.step * (this.step * (this.step * f14 * 6.0f));
                float f25 = this.step * (this.step * (this.step * f15 * 6.0f));
                float f26 = f;
                float f27 = f2;
                this.valSize = n;
                this.values = new float[this.valSize];
                float f28 = f26;
                float f29 = f27;
                this.length = 0.0f;
                for (int i = 0; i < n; ++i) {
                    f26 += f20;
                    f27 += f21;
                    f20 += f22;
                    f21 += f23;
                    f22 += f24;
                    f23 += f25;
                    float f30 = f26 - f28;
                    float f31 = f27 - f29;
                    this.values[i] = (float)Math.sqrt(f30 * f30 + f31 * f31);
                    this.length += this.values[i];
                    f28 = f26;
                    f29 = f27;
                }
                this.valPos = 0;
                this.curLen = 0.0f;
                this.prevLen = 0.0f;
            }

            float getNext(float f) {
                float f2 = 2.0f;
                while (this.curLen <= f && this.valPos < this.valSize) {
                    this.prevLen = this.curLen;
                    this.lastLen = this.values[this.valPos++];
                    this.curLen += this.lastLen;
                }
                if (this.curLen > f) {
                    f2 = ((float)(this.valPos - 1) + (f - this.prevLen) / this.lastLen) * this.step;
                }
                return f2;
            }
        }

        static class Line
        extends DashIterator {
            Line(float f) {
                this.length = f;
            }

            float getNext(float f) {
                return f / this.length;
            }
        }

        static class Quad
        extends DashIterator {
            int valSize;
            int valPos;
            float curLen;
            float prevLen;
            float lastLen;
            float[] values;
            float step;

            Quad(float f, float f2, float f3, float f4, float f5, float f6) {
                float f7 = f + f5 - f3 - f3;
                float f8 = f2 + f6 - f4 - f4;
                int n = (int)(1.0 + Math.sqrt(0.75 * (double)(Math.abs(f7) + Math.abs(f8)) * 1.0));
                this.step = 1.0f / (float)n;
                float f9 = f + f5 - f3 - f3;
                float f10 = f2 + f6 - f4 - f4;
                float f11 = 2.0f * (f3 - f);
                float f12 = 2.0f * (f4 - f2);
                float f13 = this.step * (this.step * f9 + f11);
                float f14 = this.step * (this.step * f10 + f12);
                float f15 = this.step * (this.step * f9 * 2.0f);
                float f16 = this.step * (this.step * f10 * 2.0f);
                float f17 = f;
                float f18 = f2;
                this.valSize = n;
                this.values = new float[this.valSize];
                float f19 = f17;
                float f20 = f18;
                this.length = 0.0f;
                for (int i = 0; i < n; ++i) {
                    float f21 = (f17 += (f13 += f15)) - f19;
                    float f22 = (f18 += (f14 += f16)) - f20;
                    this.values[i] = (float)Math.sqrt(f21 * f21 + f22 * f22);
                    this.length += this.values[i];
                    f19 = f17;
                    f20 = f18;
                }
                this.valPos = 0;
                this.curLen = 0.0f;
                this.prevLen = 0.0f;
            }

            float getNext(float f) {
                float f2 = 2.0f;
                while (this.curLen <= f && this.valPos < this.valSize) {
                    this.prevLen = this.curLen;
                    this.lastLen = this.values[this.valPos++];
                    this.curLen += this.lastLen;
                }
                if (this.curLen > f) {
                    f2 = ((float)(this.valPos - 1) + (f - this.prevLen) / this.lastLen) * this.step;
                }
                return f2;
            }
        }
    }

    class Dasher {
        float pos;
        boolean close;
        boolean visible;
        boolean firstvis;
        float[] dash;
        float phase;
        int index;
        DashIterator iter;
        float dashmx;
        float dashmy;
        float dashcx;
        float dashcy;

        Dasher(float[] fArray, float f) {
            this.dash = fArray;
            this.phase = f;
            this.index = 0;
            this.pos = f;
            this.visible = true;
            while (this.pos >= fArray[this.index]) {
                this.visible = !this.visible;
                this.pos -= fArray[this.index];
                this.index = (this.index + 1) % fArray.length;
            }
            this.pos = -this.pos;
            this.firstvis = this.visible;
        }

        void init(DashIterator dashIterator) {
            this.iter = dashIterator;
            this.close = true;
        }

        boolean isOpen() {
            return this.visible && this.pos < this.iter.length;
        }

        boolean isContinue() {
            return !this.visible && this.pos > 0.0f;
        }

        boolean isClosed() {
            return this.close;
        }

        boolean isConnected() {
            return this.firstvis && !this.close;
        }

        boolean couldBeConnected() {
            return this.firstvis;
        }

        boolean eof() {
            if (!this.close) {
                this.pos -= this.iter.length;
                return true;
            }
            if (this.pos >= this.iter.length) {
                if (this.visible) {
                    this.pos -= this.iter.length;
                    return true;
                }
                this.close = this.pos == this.iter.length;
            }
            return false;
        }

        void next() {
            if (this.close) {
                this.pos += this.dash[this.index];
                this.index = (this.index + 1) % this.dash.length;
            } else {
                this.index = (this.index + this.dash.length - 1) % this.dash.length;
                this.pos -= this.dash[this.index];
            }
            this.visible = !this.visible;
        }

        float getValue() {
            float f = this.iter.getNext(this.pos);
            return f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
        }
    }
}

