/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom.transform;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.Translate2D;

public final class Identity
extends BaseTransform {
    public BaseTransform.Degree getDegree() {
        return BaseTransform.Degree.IDENTITY;
    }

    public int getType() {
        return 0;
    }

    public boolean isIdentity() {
        return true;
    }

    public boolean isTranslateOrIdentity() {
        return true;
    }

    public boolean is2D() {
        return true;
    }

    public double getDeterminant() {
        return 1.0;
    }

    public Point2D transform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = Identity.makePoint(point2D, point2D2);
        }
        point2D2.setLocation(point2D);
        return point2D2;
    }

    public Point2D inverseTransform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = Identity.makePoint(point2D, point2D2);
        }
        point2D2.setLocation(point2D);
        return point2D2;
    }

    public Vec3d transform(Vec3d vec3d, Vec3d vec3d2) {
        if (vec3d2 == null) {
            return new Vec3d(vec3d);
        }
        vec3d2.set(vec3d);
        return vec3d2;
    }

    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray != fArray2 || n != n2) {
            System.arraycopy(fArray, n, fArray2, n2, n3 * 2);
        }
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray != dArray2 || n != n2) {
            System.arraycopy(dArray, n, dArray2, n2, n3 * 2);
        }
    }

    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            dArray[n2++] = fArray[n++];
            dArray[n2++] = fArray[n++];
        }
    }

    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            fArray[n2++] = (float)dArray[n++];
            fArray[n2++] = (float)dArray[n++];
        }
    }

    public void deltaTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.transform(dArray, n, dArray2, n2, n3);
    }

    public void inverseTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.transform(dArray, n, dArray2, n2, n3);
    }

    public void transform(Bounds2D bounds2D, Bounds2D bounds2D2) {
        bounds2D2.setBounds(bounds2D);
    }

    public void inverseTransform(Bounds2D bounds2D, Bounds2D bounds2D2) {
        bounds2D2.setBounds(bounds2D);
    }

    public Shape createTransformedShape(Shape shape) {
        return new Path2D(shape);
    }

    public void setToIdentity() {
    }

    public void setTransform(BaseTransform baseTransform) {
        if (!baseTransform.isIdentity()) {
            Identity.degreeError(BaseTransform.Degree.IDENTITY);
        }
    }

    public void invert() {
    }

    public void restoreTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        if (d != 1.0 || d2 != 0.0 || d3 != 0.0 || d4 != 1.0 || d5 != 0.0 || d6 != 0.0) {
            Identity.degreeError(BaseTransform.Degree.IDENTITY);
        }
    }

    public void restoreTransform(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        if (d != 1.0 || d2 != 0.0 || d3 != 0.0 || d4 != 0.0 || d5 != 0.0 || d6 != 1.0 || d7 != 0.0 || d8 != 0.0 || d9 != 0.0 || d10 != 0.0 || d11 != 1.0 || d12 != 0.0) {
            Identity.degreeError(BaseTransform.Degree.IDENTITY);
        }
    }

    public BaseTransform deriveWithTranslation(double d, double d2) {
        return Translate2D.getInstance(d, d2);
    }

    public BaseTransform deriveWithPreTranslation(double d, double d2) {
        return Translate2D.getInstance(d, d2);
    }

    public BaseTransform deriveWithConcatenation(double d, double d2, double d3, double d4, double d5, double d6) {
        return Identity.getInstance(d, d2, d3, d4, d5, d6);
    }

    public BaseTransform deriveWithConcatenation(BaseTransform baseTransform) {
        return Identity.getInstance(baseTransform);
    }

    public BaseTransform deriveWithNewTransform(BaseTransform baseTransform) {
        return Identity.getInstance(baseTransform);
    }

    public BaseTransform createInverse() {
        return this;
    }

    public String toString() {
        return "Identity[]";
    }

    public BaseTransform copy() {
        return this;
    }

    public boolean equals(Object object) {
        return object instanceof BaseTransform && ((BaseTransform)object).isIdentity();
    }

    public int hashCode() {
        return 0;
    }
}

