/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io;

import com.sun.javafx.io.Muffin;
import com.sun.javafx.io.StorageImpl;
import com.sun.javafx.io.URLUtil;
import com.sun.javafx.io.impl.AbstractFactory;
import com.sun.javafx.io.impl.AbstractFile;
import com.sun.javafx.io.impl.AbstractFileFilter;
import com.sun.javafx.io.impl.AbstractStorage;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;

public class MuffinStore {
    private static final String DASH = "-";
    private static final String MUFFIN_FILE_EXT = ".muf";
    private static Random random = new Random(System.currentTimeMillis());
    private static AbstractFile cacheDir;
    private static AbstractFile muffinDir;
    private static final Object syncObject;
    private static AbstractStorage storage;
    private static final boolean DEBUG;

    private MuffinStore() {
    }

    public static final boolean isSupportedProtocol(String string) {
        String string2 = URLUtil.getProtocol(string);
        return string2 != null && (string2.equalsIgnoreCase("http") || string2.equalsIgnoreCase("https"));
    }

    public static boolean exists() {
        return cacheDir.exists();
    }

    public static boolean canWrite() {
        return cacheDir.canWrite();
    }

    public static AbstractFile getCacheDir() {
        return cacheDir;
    }

    private static AbstractFile[] getMatchingMuffinFiles(AbstractFile abstractFile, String string) {
        final String string2 = MuffinStore.getKey(string) + DASH;
        AbstractFile[] abstractFileArray = abstractFile.listFiles(new AbstractFileFilter(){

            public boolean accept(AbstractFile abstractFile) {
                String string = abstractFile.getName();
                return string.startsWith(string2) && !string.endsWith(MuffinStore.MUFFIN_FILE_EXT);
            }
        });
        return abstractFileArray;
    }

    private static AbstractFile[] getMatchingMuffinAttributeFiles(AbstractFile abstractFile, String string) {
        final String string2 = MuffinStore.getKey(string) + DASH;
        AbstractFile[] abstractFileArray = abstractFile.listFiles(new AbstractFileFilter(){

            public boolean accept(AbstractFile abstractFile) {
                String string = abstractFile.getName();
                return string.startsWith(string2) && string.endsWith(MuffinStore.MUFFIN_FILE_EXT);
            }
        });
        return abstractFileArray;
    }

    public static AbstractFile getMuffinFile(String string) {
        String string2 = MuffinStore.getKey(string);
        AbstractFile abstractFile = AbstractFactory.getAbstractFile(muffinDir.getPath(), string2 + MUFFIN_FILE_EXT);
        if (MuffinStore.containsURL(abstractFile, string)) {
            return AbstractFactory.getAbstractFile(muffinDir.getPath(), string2);
        }
        AbstractFile[] abstractFileArray = MuffinStore.getMatchingMuffinFiles(muffinDir, string);
        if (abstractFileArray == null || abstractFileArray.length == 0) {
            return null;
        }
        for (int i = 0; i < abstractFileArray.length; ++i) {
            abstractFile = AbstractFactory.getAbstractFile(abstractFileArray[i].getPath() + MUFFIN_FILE_EXT);
            if (!MuffinStore.containsURL(abstractFile, string)) continue;
            return abstractFileArray[i];
        }
        return null;
    }

    public static AbstractFile getMuffinAttributeFile(String string) {
        String string2 = MuffinStore.getKey(string);
        AbstractFile abstractFile = AbstractFactory.getAbstractFile(muffinDir.getPath(), string2 + MUFFIN_FILE_EXT);
        if (MuffinStore.containsURL(abstractFile, string)) {
            return abstractFile;
        }
        AbstractFile[] abstractFileArray = MuffinStore.getMatchingMuffinAttributeFiles(muffinDir, string);
        if (abstractFileArray == null || abstractFileArray.length == 0) {
            return null;
        }
        for (int i = 0; i < abstractFileArray.length; ++i) {
            if (!MuffinStore.containsURL(abstractFileArray[i], string)) continue;
            return abstractFileArray[i];
        }
        return null;
    }

    public static long[] getMuffinAttributes(String string) throws IOException {
        Muffin muffin = new Muffin(MuffinStore.getMuffinAttributeFile(string));
        if (muffin.load()) {
            return new long[]{muffin.tag, muffin.maxsize};
        }
        throw new IOException("File not found: " + string);
    }

    public static void removeMuffinEntry(String string) throws IOException {
        AbstractFile abstractFile = MuffinStore.getMuffinFile(string);
        if (abstractFile != null) {
            if (!abstractFile.delete()) {
                throw new IOException("delete failed for muffin: " + string);
            }
            AbstractFile abstractFile2 = AbstractFactory.getAbstractFile(abstractFile.getPath() + MUFFIN_FILE_EXT);
            if (!abstractFile2.delete()) {
                throw new IOException("delete failed for muffin: " + string);
            }
        } else {
            throw new IOException("Muffin for " + string + " does not exist.");
        }
    }

    public static void createMuffinEntry(String string, int n, long l) throws IOException {
        String string2 = MuffinStore.getKey(string);
        MuffinStore.print("createMuffinEntry(url=" + string + ", tag=" + n + ", maxSize=" + l + ") key=" + string2);
        String string3 = string2;
        AbstractFile abstractFile = AbstractFactory.getAbstractFile(muffinDir.getPath(), string3);
        while (!abstractFile.createNewFile()) {
            string3 = string2 + DASH + Integer.toString(MuffinStore.getRandom(), 16);
            abstractFile = AbstractFactory.getAbstractFile(muffinDir.getPath(), string3);
        }
        AbstractFile abstractFile2 = AbstractFactory.getAbstractFile(muffinDir.getPath(), string3 + MUFFIN_FILE_EXT);
        MuffinStore.print("createMuffinEntry(" + abstractFile2 + ", " + abstractFile2.getPath());
        MuffinStore.putMuffinAttributes(abstractFile2, string, n, l);
        MuffinStore.print("createMuffinEntry(url=" + string + ", tag=" + n + ", maxSize=" + l + ") filename=" + string3 + " muffinFile=" + abstractFile);
    }

    public static String[] getMuffinNames(String string) {
        Vector<String> vector = new Vector<String>();
        AbstractFile[] abstractFileArray = muffinDir.listFiles(new AbstractFileFilter(){

            public boolean accept(AbstractFile abstractFile) {
                String string = abstractFile.getName();
                return string.endsWith(MuffinStore.MUFFIN_FILE_EXT);
            }
        });
        String string2 = null;
        MuffinStore.print("getMuffinNames files.length=" + abstractFileArray.length);
        for (int i = 0; i < abstractFileArray.length; ++i) {
            try {
                string2 = MuffinStore.getCachedMuffinURL(abstractFileArray[i]);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (string2 == null) continue;
            String string3 = MuffinStore.removeQueryStringFromURL(string2);
            String string4 = string3.substring(1 + string3.lastIndexOf(47));
            if (!string2.equals(string + string4)) continue;
            vector.addElement(string4);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String[] getAccessibleMuffins(String string) throws IOException {
        Vector<String> vector = new Vector<String>();
        AbstractFile[] abstractFileArray = muffinDir.listFiles(new AbstractFileFilter(){

            public boolean accept(AbstractFile abstractFile) {
                String string = abstractFile.getName();
                return string.endsWith(MuffinStore.MUFFIN_FILE_EXT);
            }
        });
        boolean bl = false;
        for (int i = 0; i < abstractFileArray.length; ++i) {
            int n;
            String string2;
            String string3 = MuffinStore.getCachedMuffinURL(abstractFileArray[i]);
            MuffinStore.print("getAccessibleMuffins: url=" + string + " files[" + i + "]=" + abstractFileArray[i] + " u=" + string3);
            if (!URLUtil.getHost(string3).equals(URLUtil.getHost(string))) continue;
            String string4 = StorageImpl.getCodebase();
            MuffinStore.print("getAccessibleMuffins(" + string + ") u=" + string3 + " codebase host=" + URLUtil.getHost(string4));
            if (string4 != null && string3 != null && string3.startsWith("file:") && (string2 = URLUtil.getFile(string3)) != null && (n = string2.lastIndexOf(47)) >= 0 && !URLUtil.getFile(string4).startsWith(string2.substring(0, n))) continue;
            vector.addElement(string3);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    static String getCachedMuffinURL(AbstractFile abstractFile) throws IOException {
        Muffin muffin = new Muffin(abstractFile);
        try {
            muffin.load();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return muffin.uri;
    }

    public static long getMuffinSize(String string) throws IOException {
        long l = 0L;
        AbstractFile abstractFile = MuffinStore.getMuffinFile(string);
        if (abstractFile != null && abstractFile.exists()) {
            l += abstractFile.length();
        }
        return l;
    }

    public static void putMuffinAttributes(String string, int n, long l) throws IOException {
        Muffin muffin = new Muffin(MuffinStore.getMuffinAttributeFile(string));
        muffin.tag = n;
        muffin.maxsize = l;
        muffin.uri = string;
        muffin.save();
    }

    public static void putMuffinAttributes(AbstractFile abstractFile, String string, int n, long l) throws IOException {
        Muffin muffin = new Muffin(abstractFile);
        muffin.tag = n;
        muffin.maxsize = l;
        muffin.uri = string;
        muffin.save();
    }

    protected static String getKey(String string) {
        int n = MuffinStore.hashCode(MuffinStore.removeQueryStringFromURL(string));
        if (n < 0) {
            n -= Integer.MIN_VALUE;
        }
        String string2 = Integer.toString(n, 16);
        return string2;
    }

    private static boolean containsURL(AbstractFile abstractFile, String string) {
        Muffin muffin = new Muffin(abstractFile);
        return muffin.load() && string != null && string.equals(muffin.uri);
    }

    protected static int hashCode(String string) {
        int n = string.hashCode();
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    protected static final String getFileExtension(String string) {
        String string2 = "";
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string2 = string.substring(n);
        }
        return string2;
    }

    protected static final int getRandom() {
        return 0x10000000 + random.nextInt(0x6FFFFFFF);
    }

    public static void removeAllMuffins() throws IOException {
        AbstractFile[] abstractFileArray = muffinDir.listFiles();
        for (int i = 0; i < abstractFileArray.length; ++i) {
            abstractFileArray[i].delete();
        }
    }

    public static String removeQueryStringFromURL(String string) {
        int n;
        String string2 = string;
        if (string2 != null && (n = string2.lastIndexOf(63)) != -1) {
            string2 = new String(string2.substring(0, n));
        }
        return string2;
    }

    private static void print(String string) {
        if (DEBUG) {
            System.err.println("MuffinStore." + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        syncObject = new Object();
        storage = AbstractFactory.getAbstractStorage();
        Object object = syncObject;
        synchronized (object) {
            String string = storage.getStorageBase();
            String string2 = string + AbstractStorage.getSeparator() + "muffin" + AbstractStorage.getSeparator();
            MuffinStore.print("reset: cachePath=" + string + " muffinPath=" + string2);
            cacheDir = AbstractFactory.getAbstractFile(string);
            muffinDir = AbstractFactory.getAbstractFile(string2);
            boolean bl = muffinDir.mkdirs();
            MuffinStore.print("reset2: cacheDir=" + cacheDir.getPath() + " muffinDir=" + muffinDir.getPath() + " ret = " + bl);
        }
        DEBUG = StorageImpl.DEBUG;
    }
}

