/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.io.impl.file;

import com.sun.javafx.io.StorageImpl;
import com.sun.javafx.io.impl.AbstractFile;
import com.sun.javafx.io.impl.AbstractFileFilter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AbstractFileImpl
extends AbstractFile {
    private String filename;
    private File file;
    private static final boolean DEBUG = StorageImpl.DEBUG;

    private AbstractFileImpl(File file) {
        this.file = file;
        this.filename = file.getPath();
    }

    public AbstractFileImpl(String string) {
        this.filename = string;
        this.file = new File(string);
    }

    public AbstractFileImpl(String string, String string2) {
        this.file = new File(string, string2);
        this.filename = this.file.getPath();
    }

    public void create() throws IOException {
        this.file.createNewFile();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public OutputStream openOutputStream(boolean bl) throws IOException {
        AbstractFileImpl.print("openOutputStream: file=" + this.file.getAbsolutePath() + " overwrite=" + bl);
        return new FileOutputStream(this.file.getAbsolutePath(), !bl);
    }

    public String getAbsolutePath() {
        return this.file.getAbsolutePath();
    }

    public AbstractFile[] listFiles() {
        File[] fileArray = this.file.listFiles();
        AbstractFile[] abstractFileArray = new AbstractFile[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            abstractFileArray[i] = new AbstractFileImpl(fileArray[i]);
        }
        return abstractFileArray;
    }

    public AbstractFile[] listFiles(final AbstractFileFilter abstractFileFilter) {
        File[] fileArray = this.file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                AbstractFileImpl abstractFileImpl = new AbstractFileImpl(file);
                return abstractFileFilter.accept(abstractFileImpl);
            }
        });
        AbstractFile[] abstractFileArray = new AbstractFile[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            abstractFileArray[i] = new AbstractFileImpl(fileArray[i]);
        }
        return abstractFileArray;
    }

    public boolean mkdirs() {
        return this.file.mkdirs();
    }

    public boolean createNewFile() throws IOException {
        return this.file.createNewFile();
    }

    public boolean delete() throws IOException {
        return this.file.delete();
    }

    public long length() throws IOException {
        return this.file.length();
    }

    public boolean canRead() {
        return this.file.canRead();
    }

    public boolean canWrite() {
        return this.file.canWrite();
    }

    public String getPath() {
        return this.file.getPath();
    }

    public String getName() {
        return this.file.getName();
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public String toString() {
        return this.file.getPath();
    }

    private static void print(String string) {
        if (DEBUG) {
            System.err.println("AbstractFileImpl." + string);
        }
    }
}

