/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.date;

import com.sun.javafx.runtime.date.CalendarUtils;
import java.util.TimeZone;

abstract class CalendarDate
implements Cloneable {
    public static final int FIELD_UNDEFINED = Integer.MIN_VALUE;
    public static final long TIME_UNDEFINED = Long.MIN_VALUE;
    private int year;
    private int month;
    private int dayOfMonth;
    private int dayOfWeek = Integer.MIN_VALUE;
    private boolean leapYear;
    private int hours;
    private int minutes;
    private int seconds;
    private int millis;
    private long fraction;
    private boolean normalized;
    private TimeZone zoneinfo;
    private int zoneOffset;
    private int daylightSaving;
    private boolean forceDaylightTime;

    protected CalendarDate() {
        this(TimeZone.getDefault());
    }

    protected CalendarDate(TimeZone timeZone) {
        this.zoneinfo = timeZone;
    }

    public int getYear() {
        return this.year;
    }

    public CalendarDate setYear(int n) {
        if (this.year != n) {
            this.year = n;
            this.normalized = false;
        }
        return this;
    }

    public CalendarDate addYear(int n) {
        if (n != 0) {
            this.year += n;
            this.normalized = false;
        }
        return this;
    }

    public boolean isLeapYear() {
        return this.leapYear;
    }

    void setLeapYear(boolean bl) {
        this.leapYear = bl;
    }

    public int getMonth() {
        return this.month;
    }

    public CalendarDate setMonth(int n) {
        if (this.month != n) {
            this.month = n;
            this.normalized = false;
        }
        return this;
    }

    public CalendarDate addMonth(int n) {
        if (n != 0) {
            this.month += n;
            this.normalized = false;
        }
        return this;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public CalendarDate setDayOfMonth(int n) {
        if (this.dayOfMonth != n) {
            this.dayOfMonth = n;
            this.normalized = false;
        }
        return this;
    }

    public CalendarDate addDayOfMonth(int n) {
        if (n != 0) {
            this.dayOfMonth += n;
            this.normalized = false;
        }
        return this;
    }

    public int getDayOfWeek() {
        return this.dayOfWeek;
    }

    public int getHours() {
        return this.hours;
    }

    public CalendarDate setHours(int n) {
        if (this.hours != n) {
            this.hours = n;
            this.normalized = false;
        }
        return this;
    }

    public CalendarDate addHours(int n) {
        if (n != 0) {
            this.hours += n;
            this.normalized = false;
        }
        return this;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public CalendarDate setMinutes(int n) {
        if (this.minutes != n) {
            this.minutes = n;
            this.normalized = false;
        }
        return this;
    }

    public CalendarDate addMinutes(int n) {
        if (n != 0) {
            this.minutes += n;
            this.normalized = false;
        }
        return this;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public CalendarDate setSeconds(int n) {
        if (this.seconds != n) {
            this.seconds = n;
            this.normalized = false;
        }
        return this;
    }

    public CalendarDate addSeconds(int n) {
        if (n != 0) {
            this.seconds += n;
            this.normalized = false;
        }
        return this;
    }

    public int getMillis() {
        return this.millis;
    }

    public CalendarDate setMillis(int n) {
        if (this.millis != n) {
            this.millis = n;
            this.normalized = false;
        }
        return this;
    }

    public CalendarDate addMillis(int n) {
        if (n != 0) {
            this.millis += n;
            this.normalized = false;
        }
        return this;
    }

    public long getTimeOfDay() {
        if (!this.isNormalized()) {
            this.fraction = Long.MIN_VALUE;
            return Long.MIN_VALUE;
        }
        return this.fraction;
    }

    public CalendarDate setDate(int n, int n2, int n3) {
        this.setYear(n);
        this.setMonth(n2);
        this.setDayOfMonth(n3);
        return this;
    }

    public CalendarDate addDate(int n, int n2, int n3) {
        this.addYear(n);
        this.addMonth(n2);
        this.addDayOfMonth(n3);
        return this;
    }

    public CalendarDate setTimeOfDay(int n, int n2, int n3, int n4) {
        this.setHours(n);
        this.setMinutes(n2);
        this.setSeconds(n3);
        this.setMillis(n4);
        return this;
    }

    public CalendarDate addTimeOfDay(int n, int n2, int n3, int n4) {
        this.addHours(n);
        this.addMinutes(n2);
        this.addSeconds(n3);
        this.addMillis(n4);
        return this;
    }

    protected void setTimeOfDay(long l) {
        this.fraction = l;
    }

    public boolean isNormalized() {
        return this.normalized;
    }

    public boolean forceDaylightTime() {
        return this.forceDaylightTime;
    }

    public void setDaylightTime(boolean bl) {
        this.forceDaylightTime = bl;
    }

    public boolean isDaylightTime() {
        return this.daylightSaving != 0;
    }

    public TimeZone getZone() {
        return this.zoneinfo;
    }

    public CalendarDate setZone(TimeZone timeZone) {
        this.zoneinfo = timeZone;
        return this;
    }

    public boolean isSameDate(CalendarDate calendarDate) {
        return this.getDayOfWeek() == calendarDate.getDayOfWeek() && this.getMonth() == calendarDate.getMonth() && this.getYear() == calendarDate.getYear();
    }

    public boolean equals(Object object) {
        boolean bl;
        if (!(object instanceof CalendarDate)) {
            return false;
        }
        CalendarDate calendarDate = (CalendarDate)object;
        if (this.isNormalized() != calendarDate.isNormalized()) {
            return false;
        }
        boolean bl2 = this.zoneinfo != null;
        boolean bl3 = bl = calendarDate.zoneinfo != null;
        if (bl2 != bl) {
            return false;
        }
        if (bl2 && !this.zoneinfo.equals(calendarDate.zoneinfo)) {
            return false;
        }
        return this.year == calendarDate.year && this.month == calendarDate.month && this.dayOfMonth == calendarDate.dayOfMonth && this.hours == calendarDate.hours && this.minutes == calendarDate.minutes && this.seconds == calendarDate.seconds && this.millis == calendarDate.millis && this.zoneOffset == calendarDate.zoneOffset;
    }

    public int hashCode() {
        long l = ((((long)this.year - 1970L) * 12L + (long)(this.month - 1)) * 30L + (long)this.dayOfMonth) * 24L;
        l = (((l + (long)this.hours) * 60L + (long)this.minutes) * 60L + (long)this.seconds) * 1000L + (long)this.millis;
        int n = this.isNormalized() ? 1 : 0;
        int n2 = this.zoneinfo != null ? this.zoneinfo.hashCode() : 0;
        return (int)(l -= (long)this.zoneOffset) * (int)(l >> 32) ^ n ^ n2;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.year > 0) {
            CalendarUtils.sprintf0d(stringBuilder, this.year, 4).append('-');
        } else {
            CalendarUtils.sprintf0d(stringBuilder, this.year - 1, 5).append('-');
        }
        CalendarUtils.sprintf0d(stringBuilder, this.month, 2).append('-');
        CalendarUtils.sprintf0d(stringBuilder, this.dayOfMonth, 2).append('T');
        CalendarUtils.sprintf0d(stringBuilder, this.hours, 2).append(':');
        CalendarUtils.sprintf0d(stringBuilder, this.minutes, 2).append(':');
        CalendarUtils.sprintf0d(stringBuilder, this.seconds, 2);
        if (this.millis != 0) {
            stringBuilder.append('.');
            if (this.millis % 10 == 0) {
                if (this.millis % 100 == 0) {
                    stringBuilder.append(this.millis / 100);
                } else {
                    CalendarUtils.sprintf0d(stringBuilder, this.millis / 10, 2);
                }
            } else {
                CalendarUtils.sprintf0d(stringBuilder, this.millis, 3);
            }
        }
        if (this.zoneinfo != null) {
            if (this.zoneOffset == 0) {
                stringBuilder.append('Z');
            } else if (this.zoneOffset != Integer.MIN_VALUE) {
                char c;
                int n;
                if (this.zoneOffset > 0) {
                    n = this.zoneOffset;
                    c = '+';
                } else {
                    n = -this.zoneOffset;
                    c = '-';
                }
                stringBuilder.append(c);
                CalendarUtils.sprintf0d(stringBuilder, (n /= 60000) / 60, 2).append(':');
                CalendarUtils.sprintf0d(stringBuilder, n % 60, 2);
            }
        }
        return stringBuilder.toString();
    }

    public void setDayOfWeek(int n) {
        this.dayOfWeek = n;
    }

    public void setNormalized(boolean bl) {
        this.normalized = bl;
    }

    public int getZoneOffset() {
        return this.zoneOffset;
    }

    public void setZoneOffset(int n) {
        this.zoneOffset = n;
    }

    public int getDaylightSaving() {
        return this.daylightSaving;
    }

    public void setDaylightSaving(int n) {
        this.daylightSaving = n;
    }
}

