/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.provider;

import com.sun.javafx.runtime.FXExit;
import com.sun.javafx.runtime.RuntimeProvider;
import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.Sequences;
import com.sun.javafx.tk.desktop.PerformanceTrackerHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javafx.reflect.FXClassType;
import javafx.reflect.FXContext;
import javafx.reflect.FXFunctionMember;
import javafx.reflect.FXLocal;

public class GUIRuntimeProvider
implements RuntimeProvider {
    public GUIRuntimeProvider() {
        PerformanceTrackerHelper.logEvent("GUIRuntimeProvider constructor");
        try {
            Class.forName("com.sun.javafx.runtime.DefaultSystemProperties");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean usesRuntimeLibrary(Class clazz) {
        return true;
    }

    private Object getToolkit() throws Exception {
        return Class.forName("com.sun.javafx.tk.Toolkit").getMethod("getToolkit", null).invoke(null, (Object[])null);
    }

    public Object run(final Method method, final String ... stringArray) throws Throwable {
        Object object = this.getToolkit();
        PerformanceTrackerHelper.logEvent("GUIRuntimeProvider.run called");
        object.getClass().getMethod("startup", Runnable.class).invoke(object, new Runnable(){

            public void run() {
                try {
                    Object object = method.invoke(null, Sequences.make(TypeInfo.String, stringArray));
                    if (object == null) {
                        return;
                    }
                    FXContext fXContext = FXContext.getInstance();
                    FXClassType fXClassType = fXContext.findClass("com.sun.javafx.runtime.provider.AutoWrapper");
                    FXLocal.ObjectValue objectValue = FXLocal.getContext().mirrorOf(object);
                    FXLocal.Value value = FXLocal.getContext().mirrorOf(true);
                    List<FXFunctionMember> list = fXClassType.getFunctions(true);
                    list.get(1).invoke(null, objectValue, value);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getCause();
                    if (throwable instanceof FXExit) {
                        return;
                    }
                    StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                    int n = 0;
                    while (n < stackTraceElementArray.length && !stackTraceElementArray[n++].getMethodName().equals(method.getName())) {
                    }
                    StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[n];
                    System.arraycopy(stackTraceElementArray, 0, stackTraceElementArray2, 0, n);
                    throwable.setStackTrace(stackTraceElementArray2);
                    throwable.printStackTrace();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new AssertionError();
                }
            }
        });
        return null;
    }

    public void deferAction(Runnable runnable) {
        try {
            Object object = this.getToolkit();
            object.getClass().getMethod("defer", Runnable.class).invoke(object, runnable);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new AssertionError();
        }
    }

    public void exit() {
        try {
            Object object = this.getToolkit();
            object.getClass().getMethod("exit", null).invoke(object, (Object[])null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new FXExit();
    }
}

