/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.AbstractSequence;
import com.sun.javafx.runtime.sequence.ObjectArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArraySequence<T>
extends AbstractSequence<T> {
    int gapStart;
    int gapEnd;
    protected static final int DEFAULT_SIZE = 16;
    private int sharing;

    protected ArraySequence(TypeInfo<T> typeInfo) {
        super(typeInfo);
    }

    @Override
    public void incrementSharing() {
        int n = this.sharing + 1;
        if (n >= 0) {
            this.sharing = n;
        }
    }

    @Override
    public void decrementSharing() {
        int n = this.sharing;
        if (n > 0) {
            this.sharing = n - 1;
        }
    }

    public void setMaxShared() {
        this.sharing = Integer.MAX_VALUE;
    }

    public boolean isShared() {
        return this.sharing > 1;
    }

    protected abstract Object getRawArray();

    protected abstract Object newRawArray(int var1);

    protected abstract void setRawArray(Object var1);

    protected abstract int getRawArrayLength();

    protected abstract T getRawArrayElementAsObject(int var1);

    public ArraySequence<T> makeNew(int n) {
        return new ObjectArraySequence(n, this.getElementType());
    }

    protected abstract ArraySequence extractOldValue(int var1, int var2);

    public abstract void add(Sequence<? extends T> var1);

    public void addFromArray(Object object, int n, int n2) {
        int n3 = n2 - n;
        int n4 = this.size();
        this.gapReserve(n4, n3);
        System.arraycopy(object, n, this.getRawArray(), n4, n3);
        this.gapStart += n3;
    }

    protected void shiftGap(int n) {
        int n2 = n - this.gapStart;
        Object object = this.getRawArray();
        if (n2 > 0) {
            System.arraycopy(object, this.gapEnd, object, this.gapStart, n2);
        } else if (n2 < 0) {
            System.arraycopy(object, n, object, this.gapEnd + n2, -n2);
        }
        this.gapEnd += n2;
        this.gapStart = n;
        int n3 = this.gapEnd - this.gapStart;
        if (n2 > 0) {
            if (n3 < n2) {
                this.clearOldValues(n3);
            } else {
                this.clearOldValues(n2);
            }
        } else if (n3 < -n2) {
            this.clearOldValues(n3);
        } else {
            int n4 = this.gapEnd;
            this.gapEnd = this.gapStart - n2;
            this.clearOldValues(-n2);
            this.gapEnd = n4;
        }
    }

    protected void gapReserve(int n, int n2) {
        if (n2 > this.gapEnd - this.gapStart) {
            int n3;
            int n4;
            int n5 = this.getRawArrayLength();
            int n6 = n5 < 16 ? 16 : 2 * n5;
            if (n6 < (n4 = n5 - (this.gapEnd - this.gapStart) + n2)) {
                n6 = n4;
            }
            Object object = this.newRawArray(n6);
            int n7 = this.gapEnd - this.gapStart;
            int n8 = n5 - n7;
            int n9 = n6 - n8 + n;
            int n10 = this.gapStart - n;
            Object object2 = this.getRawArray();
            if (n10 >= 0) {
                n3 = n;
                int n11 = n5 - this.gapEnd;
                System.arraycopy(object2, this.gapEnd, object, n6 - n11, n11);
                if (n10 > 0) {
                    System.arraycopy(object2, n, object, n9, n10);
                }
            } else {
                n3 = this.gapStart;
                int n12 = n6 - n9;
                System.arraycopy(object2, n5 - n12, object, n9, n12);
                System.arraycopy(object2, this.gapEnd, object, this.gapStart, -n10);
            }
            System.arraycopy(object2, 0, object, 0, n3);
            this.setRawArray(object);
            this.gapStart = n;
            this.gapEnd = n9;
        } else if (n != this.gapStart) {
            this.shiftGap(n);
        }
    }

    @Override
    public int size() {
        return this.getRawArrayLength() - (this.gapEnd - this.gapStart);
    }

    @Override
    public T get(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.getRawArrayLength()) {
            return this.getDefaultValue();
        }
        return this.getRawArrayElementAsObject(n);
    }

    public void replace(int n, int n2, Sequence<? extends T> sequence, int n3, int n4, boolean bl) {
        int n5 = this.size();
        int n6 = n4 - n3;
        int n7 = n6 - (n2 - n);
        this.gapReserve(n, bl ? n6 : (n7 >= 0 ? n7 : 0));
        if (n6 != 0) {
            this.replaceRaw(sequence, n3, n6, n);
        }
        this.gapStart = n += n6;
        this.gapEnd = n + (this.getRawArrayLength() - n5 - n7);
    }

    protected abstract void replaceRaw(Sequence<? extends T> var1, int var2, int var3, int var4);

    public void clearOldValues(int n) {
    }
}

