/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleArraySequence
extends ArraySequence<Double> {
    double[] array;

    public DoubleArraySequence(int n, TypeInfo<Double> typeInfo) {
        super(typeInfo);
        this.array = new double[n];
        this.gapStart = 0;
        this.gapEnd = n;
    }

    public DoubleArraySequence(int n) {
        this(n, TypeInfo.Double);
    }

    public DoubleArraySequence() {
        this(16, TypeInfo.Double);
    }

    public DoubleArraySequence(TypeInfo<Double> typeInfo, double ... dArray) {
        this(typeInfo, dArray, false);
    }

    public DoubleArraySequence(TypeInfo<Double> typeInfo, double[] dArray, boolean bl) {
        super(typeInfo);
        if (bl) {
            this.array = dArray;
        } else {
            this.array = new double[dArray.length];
            System.arraycopy(dArray, 0, this.array, 0, dArray.length);
        }
        this.gapStart = this.gapEnd = dArray.length;
    }

    public DoubleArraySequence(double[] dArray, int n, int n2) {
        super(TypeInfo.Double);
        this.array = new double[n2];
        System.arraycopy(dArray, n, this.array, 0, n2);
        this.gapStart = this.gapEnd = n2;
    }

    public DoubleArraySequence(Sequence<? extends Double> sequence) {
        super(TypeInfo.Double);
        int n = sequence.size();
        this.array = new double[n];
        sequence.toArray(0, n, this.array, 0);
        this.gapStart = this.gapEnd = n;
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int n) {
        return new double[n];
    }

    @Override
    protected void setRawArray(Object object) {
        this.array = (double[])object;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected Double getRawArrayElementAsObject(int n) {
        return this.array[n];
    }

    public DoubleArraySequence makeNew(int n) {
        return new DoubleArraySequence(n, this.getElementType());
    }

    @Override
    public double getAsDouble(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return 0.0;
        }
        return this.array[n];
    }

    public void add(double d) {
        this.gapReserve(this.size(), 1);
        this.array[this.gapStart++] = d;
    }

    @Override
    public void add(Sequence<? extends Double> sequence) {
        int n = Sequences.size(sequence);
        if (n > 0) {
            int n2 = this.size();
            this.gapReserve(n2, n);
            sequence.toArray(0, n, this.array, n2);
            this.gapStart += n;
        }
    }

    @Override
    public void toArray(int n, int n2, double[] dArray, int n3) {
        int n4 = this.gapStart - n;
        if (n4 >= 0) {
            if (n2 <= n4) {
                n4 = n2;
            }
            System.arraycopy(this.array, n, dArray, n3, n4);
            n2 -= n4;
            n3 += n4;
            n = this.gapEnd;
        } else {
            n += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, n, dArray, n3, n2);
    }

    @Override
    protected DoubleArraySequence extractOldValue(int n, int n2) {
        int n3 = this.array.length - this.gapEnd + n2;
        DoubleArraySequence doubleArraySequence = new DoubleArraySequence(n3, this.getElementType());
        doubleArraySequence.addFromArray(this.array, 0, n);
        doubleArraySequence.addFromArray(this.array, this.gapEnd - n2 + n, this.array.length);
        return doubleArraySequence;
    }

    public void replace(int n, double d) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return;
        }
        this.array[n] = d;
    }

    public void replace(int n, int n2, double d, boolean bl) {
        if (n2 == n + 1 && !bl) {
            this.replace(n, d);
            return;
        }
        int n3 = this.size();
        int n4 = n2 - n;
        this.gapReserve(n, n4 == 0 || bl ? 1 : 0);
        this.gapEnd = n + this.array.length - n3 + n4;
        this.array[n++] = d;
        this.gapStart = n;
    }

    @Override
    protected void replaceRaw(Sequence<? extends Double> sequence, int n, int n2, int n3) {
        sequence.toArray(n, n2, this.array, n3);
    }

    public static double extractOldElement(ArraySequence<Double> arraySequence, Sequence<? extends Double> sequence, int n, int n2, int n3) {
        if (sequence != null) {
            return sequence.get(n3);
        }
        if (n3 >= 0) {
            int n4;
            if (n3 >= n) {
                n3 += arraySequence.gapEnd - n2;
            }
            if (n3 < (n4 = arraySequence.getRawArrayLength())) {
                return arraySequence.getRawArrayElementAsObject(n3);
            }
        }
        return (Double)arraySequence.getDefaultValue();
    }

    public static double extractNewElement(ArraySequence<Double> arraySequence, int n, Sequence<? extends Double> sequence, int n2) {
        if (sequence != null) {
            return sequence.get(n2);
        }
        if (n2 >= 0 && (n2 += n) < arraySequence.gapStart) {
            return arraySequence.get(n2);
        }
        return (Double)arraySequence.getDefaultValue();
    }
}

