/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.runtime.sequence;

import com.sun.javafx.runtime.TypeInfo;
import com.sun.javafx.runtime.sequence.ArraySequence;
import com.sun.javafx.runtime.sequence.Sequence;
import com.sun.javafx.runtime.sequence.Sequences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongArraySequence
extends ArraySequence<Long> {
    long[] array;

    public LongArraySequence(int n, TypeInfo<Long> typeInfo) {
        super(typeInfo);
        this.array = new long[n];
        this.gapStart = 0;
        this.gapEnd = n;
    }

    public LongArraySequence(int n) {
        this(n, TypeInfo.Long);
    }

    public LongArraySequence() {
        this(16, TypeInfo.Long);
    }

    public LongArraySequence(TypeInfo<Long> typeInfo, long ... lArray) {
        this(typeInfo, lArray, false);
    }

    public LongArraySequence(TypeInfo<Long> typeInfo, long[] lArray, boolean bl) {
        super(typeInfo);
        if (bl) {
            this.array = lArray;
        } else {
            this.array = new long[lArray.length];
            System.arraycopy(lArray, 0, this.array, 0, lArray.length);
        }
        this.gapStart = this.gapEnd = lArray.length;
    }

    public LongArraySequence(long[] lArray, int n, int n2) {
        super(TypeInfo.Long);
        this.array = new long[n2];
        System.arraycopy(lArray, n, this.array, 0, n2);
        this.gapStart = this.gapEnd = n2;
    }

    public LongArraySequence(Sequence<? extends Long> sequence) {
        super(TypeInfo.Long);
        int n = sequence.size();
        this.array = new long[n];
        sequence.toArray(0, n, this.array, 0);
        this.gapStart = this.gapEnd = n;
    }

    @Override
    protected Object getRawArray() {
        return this.array;
    }

    @Override
    protected Object newRawArray(int n) {
        return new long[n];
    }

    @Override
    protected void setRawArray(Object object) {
        this.array = (long[])object;
    }

    @Override
    protected int getRawArrayLength() {
        return this.array.length;
    }

    @Override
    protected Long getRawArrayElementAsObject(int n) {
        return this.array[n];
    }

    public LongArraySequence makeNew(int n) {
        return new LongArraySequence(n, this.getElementType());
    }

    @Override
    public long getAsLong(int n) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return 0L;
        }
        return this.array[n];
    }

    public void add(long l) {
        this.gapReserve(this.size(), 1);
        this.array[this.gapStart++] = l;
    }

    @Override
    public void add(Sequence<? extends Long> sequence) {
        int n = Sequences.size(sequence);
        if (n > 0) {
            int n2 = this.size();
            this.gapReserve(n2, n);
            sequence.toArray(0, n, this.array, n2);
            this.gapStart += n;
        }
    }

    @Override
    public void toArray(int n, int n2, long[] lArray, int n3) {
        int n4 = this.gapStart - n;
        if (n4 >= 0) {
            if (n2 <= n4) {
                n4 = n2;
            }
            System.arraycopy(this.array, n, lArray, n3, n4);
            n2 -= n4;
            n3 += n4;
            n = this.gapEnd;
        } else {
            n += this.gapEnd - this.gapStart;
        }
        System.arraycopy(this.array, n, lArray, n3, n2);
    }

    @Override
    protected LongArraySequence extractOldValue(int n, int n2) {
        int n3 = this.array.length - this.gapEnd + n2;
        LongArraySequence longArraySequence = new LongArraySequence(n3, this.getElementType());
        longArraySequence.addFromArray(this.array, 0, n);
        longArraySequence.addFromArray(this.array, this.gapEnd - n2 + n, this.array.length);
        return longArraySequence;
    }

    public void replace(int n, long l) {
        if (n >= this.gapStart) {
            n += this.gapEnd - this.gapStart;
        }
        if (n < 0 || n >= this.array.length) {
            return;
        }
        this.array[n] = l;
    }

    public void replace(int n, int n2, long l, boolean bl) {
        if (n2 == n + 1 && !bl) {
            this.replace(n, l);
            return;
        }
        int n3 = this.size();
        int n4 = n2 - n;
        this.gapReserve(n, n4 == 0 || bl ? 1 : 0);
        this.gapEnd = n + this.array.length - n3 + n4;
        this.array[n++] = l;
        this.gapStart = n;
    }

    @Override
    protected void replaceRaw(Sequence<? extends Long> sequence, int n, int n2, int n3) {
        sequence.toArray(n, n2, this.array, n3);
    }

    public static long extractOldElement(ArraySequence<Long> arraySequence, Sequence<? extends Long> sequence, int n, int n2, int n3) {
        if (sequence != null) {
            return sequence.get(n3);
        }
        if (n3 >= 0) {
            int n4;
            if (n3 >= n) {
                n3 += arraySequence.gapEnd - n2;
            }
            if (n3 < (n4 = arraySequence.getRawArrayLength())) {
                return arraySequence.getRawArrayElementAsObject(n3);
            }
        }
        return (Long)arraySequence.getDefaultValue();
    }

    public static long extractNewElement(ArraySequence<Long> arraySequence, int n, Sequence<? extends Long> sequence, int n2) {
        if (sequence != null) {
            return sequence.get(n2);
        }
        if (n2 >= 0 && (n2 += n) < arraySequence.gapStart) {
            return arraySequence.get(n2);
        }
        return (Long)arraySequence.getDefaultValue();
    }
}

