/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.Utils;
import javafx.scene.input.KeyCode;

public class KeyCodeUtils {
    public static String getAccelerator(KeyCode keyCode) {
        String[] stringArray;
        char c = KeyCodeUtils.getSingleChar(keyCode);
        if (c != '\u0000') {
            return String.valueOf(c);
        }
        String string = keyCode.toString().substring(3);
        if (string.length() == 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray = Utils.split(string, "_")) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string2.charAt(0));
            stringBuilder.append(string2.substring(1).toLowerCase());
        }
        return stringBuilder.toString();
    }

    private static char getSingleChar(KeyCode keyCode) {
        switch (keyCode) {
            case VK_ENTER: {
                return '\u21b5';
            }
            case VK_BACK_SPACE: {
                return '\u232b';
            }
            case VK_ESCAPE: {
                return '\u238b';
            }
            case VK_LEFT: {
                return '\u2190';
            }
            case VK_UP: {
                return '\u2191';
            }
            case VK_RIGHT: {
                return '\u2192';
            }
            case VK_DOWN: {
                return '\u2193';
            }
            case VK_COMMA: {
                return ',';
            }
            case VK_MINUS: {
                return '-';
            }
            case VK_PERIOD: {
                return '.';
            }
            case VK_SLASH: {
                return '/';
            }
            case VK_SEMICOLON: {
                return ';';
            }
            case VK_EQUALS: {
                return '=';
            }
            case VK_OPEN_BRACKET: {
                return '[';
            }
            case VK_BACK_SLASH: {
                return '\\';
            }
            case VK_CLOSE_BRACKET: {
                return ']';
            }
            case VK_MULTIPLY: {
                return '*';
            }
            case VK_ADD: {
                return '+';
            }
            case VK_SUBTRACT: {
                return '-';
            }
            case VK_DECIMAL: {
                return '.';
            }
            case VK_DIVIDE: {
                return '/';
            }
            case VK_DELETE: {
                return '\u2326';
            }
            case VK_BACK_QUOTE: {
                return '`';
            }
            case VK_QUOTE: {
                return '\"';
            }
            case VK_AMPERSAND: {
                return '&';
            }
            case VK_ASTERISK: {
                return '*';
            }
            case VK_LESS: {
                return '<';
            }
            case VK_GREATER: {
                return '>';
            }
            case VK_BRACELEFT: {
                return '{';
            }
            case VK_BRACERIGHT: {
                return '}';
            }
            case VK_AT: {
                return '@';
            }
            case VK_COLON: {
                return ':';
            }
            case VK_CIRCUMFLEX: {
                return '^';
            }
            case VK_DOLLAR: {
                return '$';
            }
            case VK_EURO_SIGN: {
                return '\u20ac';
            }
            case VK_EXCLAMATION_MARK: {
                return '!';
            }
            case VK_LEFT_PARENTHESIS: {
                return '(';
            }
            case VK_NUMBER_SIGN: {
                return '#';
            }
            case VK_PLUS: {
                return '+';
            }
            case VK_RIGHT_PARENTHESIS: {
                return ')';
            }
            case VK_UNDERSCORE: {
                return '_';
            }
        }
        return '\u0000';
    }
}

