/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.swing;

import com.sun.javafx.tk.swing.WindowStage;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javafx.lang.FX;
import javafx.stage.StageStyle;
import javax.swing.JFrame;

public class FrameStage
extends WindowStage {
    protected static final Set<FrameStage> STAGES = new HashSet<FrameStage>();
    protected JFrame frame;

    protected FrameStage(final JFrame jFrame, StageStyle stageStyle) {
        super(jFrame, stageStyle, false);
        this.frame = jFrame;
        jFrame.addPropertyChangeListener("resizable", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (FrameStage.this.listener != null) {
                    FrameStage.this.listener.changedResizable(jFrame.isResizable());
                }
            }
        });
        jFrame.addWindowStateListener(new WindowStateListener(){

            public void windowStateChanged(WindowEvent windowEvent) {
                int n = jFrame.getExtendedState();
                if (FrameStage.this.listener != null) {
                    FrameStage.this.listener.changedIconified((n & 1) != 0);
                }
            }
        });
        STAGES.add(this);
    }

    protected void initializeStyle(Window window, StageStyle stageStyle) {
        JFrame jFrame = (JFrame)window;
        if (stageStyle == StageStyle.TRANSPARENT || stageStyle == StageStyle.UNDECORATED) {
            jFrame.setUndecorated(true);
        }
        super.initializeStyle(window, stageStyle);
    }

    public void setIconified(boolean bl) {
        int n = this.frame.getExtendedState();
        n = bl ? (n |= 1) : (n &= 0xFFFFFFFE);
        this.frame.setExtendedState(n);
    }

    public void setResizable(boolean bl) {
        if (this.frame.isResizable() != bl) {
            this.frame.setResizable(bl);
        }
    }

    public void setTitle(String string) {
        super.setTitle(string);
        this.frame.setTitle(string);
    }

    public void close() {
        super.close();
        STAGES.remove(this);
        if (STAGES.size() == 0) {
            FX.exit();
        }
    }
}

