/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.swing;

import com.sun.javafx.scene.paint.LinearGradientPaint;
import com.sun.javafx.scene.paint.MultipleGradientPaint;
import com.sun.javafx.scene.paint.RadialGradientPaint;
import com.sun.scenario.paint.ProportionalPaint;
import com.sun.scenario.utils.Utils;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.lang.reflect.Constructor;

class SwingPaints {
    private static Factory factory;

    SwingPaints() {
    }

    static Paint createLinearGradientPaint(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, int n, boolean bl) {
        if (bl) {
            return new LGP_Prop_Paint(point2D, point2D2, fArray, colorArray, n);
        }
        return factory.createLinearGradientPaint(point2D, point2D2, fArray, colorArray, n);
    }

    static Paint createRadialGradientPaint(Point2D point2D, float f, Point2D point2D2, float[] fArray, Color[] colorArray, int n, boolean bl) {
        if (bl) {
            return new RGP_Prop_Paint(point2D, f, point2D2, fArray, colorArray, n);
        }
        return factory.createRadialGradientPaint(point2D, f, point2D2, fArray, colorArray, n, null);
    }

    static Paint createTexturePaint(BufferedImage bufferedImage, float f, float f2, float f3, float f4, boolean bl) {
        if (bl) {
            return new PropTexturePaint(bufferedImage, f, f2, f3, f4);
        }
        return new TexturePaint(bufferedImage, new Rectangle2D.Float(f, f2, f3, f4));
    }

    static {
        try {
            factory = new Factory6();
        }
        catch (ClassNotFoundException classNotFoundException) {
            factory = new Factory5();
        }
    }

    private static interface Factory {
        public Paint createLinearGradientPaint(Point2D var1, Point2D var2, float[] var3, Color[] var4, int var5);

        public Paint createRadialGradientPaint(Point2D var1, float var2, Point2D var3, float[] var4, Color[] var5, int var6, AffineTransform var7);
    }

    private static class Factory5
    implements Factory {
        private Factory5() {
        }

        private MultipleGradientPaint.CycleMethod cm(int n) {
            if (n == 1) {
                return MultipleGradientPaint.CycleMethod.REFLECT;
            }
            if (n == 2) {
                return MultipleGradientPaint.CycleMethod.REPEAT;
            }
            return MultipleGradientPaint.CycleMethod.NO_CYCLE;
        }

        static boolean GPcompatible(float[] fArray, int n) {
            return fArray.length == 2 && fArray[0] == 0.0f && fArray[1] == 1.0f && n != 2;
        }

        public Paint createLinearGradientPaint(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, int n) {
            if (Factory5.GPcompatible(fArray, n)) {
                return new GradientPaint(point2D, colorArray[0], point2D2, colorArray[1], n == 1);
            }
            return new LinearGradientPaint(point2D, point2D2, fArray, colorArray, this.cm(n));
        }

        public Paint createRadialGradientPaint(Point2D point2D, float f, Point2D point2D2, float[] fArray, Color[] colorArray, int n, AffineTransform affineTransform) {
            if (affineTransform == null) {
                return new RadialGradientPaint(point2D, f, point2D2, fArray, colorArray, this.cm(n));
            }
            return new RadialGradientPaint(point2D, f, point2D2, fArray, colorArray, this.cm(n), MultipleGradientPaint.ColorSpaceType.SRGB, affineTransform);
        }
    }

    private static class Factory6
    implements Factory {
        private Constructor linearConstructor;
        private Constructor radialConstructor;
        private Class cycleMethod;
        private Object REFLECT;
        private Object REPEAT;
        private Object NO_CYCLE;
        private Object SRGB;
        private static AffineTransform IDENTITY = new AffineTransform();

        Factory6() throws ClassNotFoundException {
            Utils.platformClassForName("java.awt.MultipleGradientPaint", true);
        }

        private Object cm(int n) {
            try {
                if (n == 1) {
                    if (this.REFLECT == null) {
                        this.REFLECT = this.cycleMethod.getField("REFLECT").get(null);
                    }
                    return this.REFLECT;
                }
                if (n == 2) {
                    if (this.REPEAT == null) {
                        this.REPEAT = this.cycleMethod.getField("REPEAT").get(null);
                    }
                    return this.REPEAT;
                }
                if (this.NO_CYCLE == null) {
                    this.NO_CYCLE = this.cycleMethod.getField("NO_CYCLE").get(null);
                }
                return this.NO_CYCLE;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public Paint createLinearGradientPaint(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, int n) {
            try {
                if (this.cycleMethod == null) {
                    this.cycleMethod = Utils.platformClassForName("java.awt.MultipleGradientPaint$CycleMethod", true);
                }
                if (this.linearConstructor == null) {
                    Class clazz = Utils.platformClassForName("java.awt.LinearGradientPaint", true);
                    this.linearConstructor = clazz.getConstructor(Point2D.class, Point2D.class, float[].class, Color[].class, this.cycleMethod);
                }
                return (Paint)this.linearConstructor.newInstance(point2D, point2D2, fArray, colorArray, this.cm(n));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public Paint createRadialGradientPaint(Point2D point2D, float f, Point2D point2D2, float[] fArray, Color[] colorArray, int n, AffineTransform affineTransform) {
            try {
                if (this.cycleMethod == null) {
                    this.cycleMethod = Utils.platformClassForName("java.awt.MultipleGradientPaint$CycleMethod", true);
                }
                if (this.radialConstructor == null) {
                    Class clazz = Utils.platformClassForName("java.awt.RadialGradientPaint", true);
                    Class clazz2 = Utils.platformClassForName("java.awt.MultipleGradientPaint$ColorSpaceType", true);
                    this.SRGB = clazz2.getField("SRGB").get(null);
                    this.radialConstructor = clazz.getConstructor(Point2D.class, Float.TYPE, Point2D.class, float[].class, Color[].class, this.cycleMethod, clazz2, AffineTransform.class);
                }
                if (affineTransform == null) {
                    affineTransform = IDENTITY;
                }
                return (Paint)this.radialConstructor.newInstance(point2D, Float.valueOf(f), point2D2, fArray, colorArray, this.cm(n), this.SRGB, affineTransform);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    static class LGP_Prop_Paint
    extends ProportionalGradientDelegate {
        private Point2D start;
        private Point2D end;
        private float[] fractions;
        private int cycleMethodInt;

        LGP_Prop_Paint(Point2D point2D, Point2D point2D2, float[] fArray, Color[] colorArray, int n) {
            super(colorArray);
            this.start = point2D;
            this.end = point2D2;
            this.fractions = fArray;
            this.cycleMethodInt = n;
        }

        public Paint getPaint(double d, double d2, double d3, double d4) {
            Point2D point2D = LGP_Prop_Paint.boxscale(this.start, d, d2, d3, d4);
            Point2D point2D2 = LGP_Prop_Paint.boxscale(this.end, d, d2, d3, d4);
            LGP_Prop_Paint.adjust(point2D, point2D2);
            return factory.createLinearGradientPaint(point2D, point2D2, this.fractions, this.colors, this.cycleMethodInt);
        }
    }

    static class PropTexturePaint
    implements ProportionalPaint {
        private final BufferedImage image;
        private final float anchorX;
        private final float anchorY;
        private final float anchorWidth;
        private final float anchorHeight;

        PropTexturePaint(BufferedImage bufferedImage, float f, float f2, float f3, float f4) {
            this.image = bufferedImage;
            this.anchorX = f;
            this.anchorY = f2;
            this.anchorWidth = f3;
            this.anchorHeight = f4;
        }

        public Paint getPaint(double d, double d2, double d3, double d4) {
            double d5 = d + (double)this.anchorX * d3;
            double d6 = d2 + (double)this.anchorY * d4;
            double d7 = (double)this.anchorWidth * d3;
            double d8 = (double)this.anchorHeight * d4;
            return new TexturePaint(this.image, new Rectangle2D.Double(d5, d6, d7, d8));
        }

        public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
            throw new UnsupportedOperationException("ProportionalPaint is not designed to be used directly by rendering operations");
        }

        public int getTransparency() {
            return this.image.getTransparency();
        }
    }

    static abstract class ProportionalGradientDelegate
    implements ProportionalPaint {
        protected Color[] colors;
        private int transparency;

        protected static void adjust(Point2D point2D, Point2D point2D2) {
            if (point2D.equals(point2D2)) {
                point2D.setLocation(point2D.getX() - 1.0E-6, point2D.getY());
                point2D2.setLocation(point2D2.getX() + 1.0E-6, point2D2.getY());
            }
        }

        protected static Point2D boxscale(Point2D point2D, double d, double d2, double d3, double d4) {
            return new Point2D.Double(point2D.getX() * d3 + d, point2D.getY() * d4 + d2);
        }

        protected static Point2D radscale(Point2D point2D, double d, double d2, double d3) {
            return new Point2D.Double((point2D.getX() - 0.5) * d3 + d, (point2D.getY() - 0.5) * d3 + d2);
        }

        protected ProportionalGradientDelegate(Color[] colorArray) {
            this.colors = colorArray;
            this.transparency = 2;
        }

        public int getTransparency() {
            if (this.transparency == 2) {
                this.transparency = 1;
                for (int i = 0; i < this.colors.length; ++i) {
                    int n = this.colors[i].getTransparency();
                    if (n == 1) continue;
                    this.transparency = 3;
                    break;
                }
            }
            return this.transparency;
        }

        public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
            throw new UnsupportedOperationException("ProportionalPaint is not designed to be used directly by rendering operations");
        }
    }

    static class RGP_Prop_Paint
    extends ProportionalGradientDelegate {
        private Point2D center;
        private float radius;
        private Point2D focus;
        private float[] fractions;
        private int cycleMethodInt;

        RGP_Prop_Paint(Point2D point2D, float f, Point2D point2D2, float[] fArray, Color[] colorArray, int n) {
            super(colorArray);
            this.center = point2D;
            this.radius = f;
            this.focus = point2D2;
            this.fractions = fArray;
            this.cycleMethodInt = n;
        }

        public Paint getPaint(double d, double d2, double d3, double d4) {
            double d5 = Math.min(d3, d4);
            double d6 = d + d3 / 2.0;
            double d7 = d2 + d4 / 2.0;
            Point2D point2D = RGP_Prop_Paint.radscale(this.center, d6, d7, d5);
            Point2D point2D2 = RGP_Prop_Paint.radscale(this.focus, d6, d7, d5);
            AffineTransform affineTransform = null;
            if (d3 != d4 && d3 != 0.0 && d4 != 0.0) {
                affineTransform = AffineTransform.getTranslateInstance(d6, d7);
                affineTransform.scale(d3 / d5, d4 / d5);
                affineTransform.translate(-d6, -d7);
            }
            return factory.createRadialGradientPaint(point2D, (float)(d5 *= (double)this.radius), point2D2, this.fractions, this.colors, this.cycleMethodInt, affineTransform);
        }
    }
}

