/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.swing;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKSceneListener;
import com.sun.javafx.tk.desktop.PerformanceTrackerHelper;
import com.sun.javafx.tk.swing.BackgroundSupport;
import com.sun.javafx.tk.swing.FullScreenFrame;
import com.sun.javafx.tk.swing.WindowImpl;
import com.sun.javafx.tk.swing.WindowStage;
import com.sun.scenario.paint.ProportionalPaint;
import com.sun.scenario.scenegraph.JSGPanel;
import com.sun.scenario.scenegraph.PGComponentPicker;
import com.sun.scenario.scenegraph.SGComponent;
import com.sun.scenario.scenegraph.SGNode;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.TextHitInfo;
import java.awt.geom.Point2D;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class SwingScene
implements TKScene {
    protected TKSceneListener listener;
    protected Object scene;
    public SwingScenePanel scenePanel;
    private Object fillPaint;
    private Object lastImage;
    private float lastScaleFactor;
    WindowStage windowStage = null;
    Color bgColor = null;

    public SwingScene() {
        PerformanceTrackerHelper.logEvent("SwingScene constructor");
        this.scenePanel = new SwingScenePanel();
        this.scenePanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (SwingScene.this.listener != null) {
                    Dimension dimension = SwingScene.this.scenePanel.getSize();
                    SwingScene.this.listener.changedSize(dimension.width, dimension.height);
                    SwingScene.this.updateSceneLocation();
                }
            }

            public void componentMoved(ComponentEvent componentEvent) {
                SwingScene.this.updateSceneLocation();
            }
        });
        PerformanceTrackerHelper.logEvent("SwingScene constructor: (Swing panel created) - finished");
    }

    public void setTKSceneListener(TKSceneListener tKSceneListener) {
        this.listener = tKSceneListener;
    }

    public void setScene(Object object) {
        this.scene = object;
    }

    public void setContentSize(float f, float f2) {
        if (f <= 0.0f || f2 <= 0.0f) {
            this.scenePanel.setPreferredSize(null);
        } else {
            this.scenePanel.setPreferredSize(new Dimension((int)f, (int)f2));
        }
    }

    public void setCursor(Object object) {
        if (object instanceof Cursor) {
            this.scenePanel.setCursor((Cursor)object);
        }
    }

    public void setRoot(PGNode pGNode) {
        this.scenePanel.setScene((SGNode)pGNode);
    }

    public void markDirty() {
        this.scenePanel.markDirty();
    }

    public void setFillPaint(Object object) {
        if (object == null || object instanceof Paint) {
            this.fillPaint = object;
            this.scenePanel.setBackgroundPaint((Paint)object);
        }
    }

    public void setCamera(boolean bl) {
    }

    public PickRay computePickRay(float f, float f2, PickRay pickRay) {
        return null;
    }

    void updateSceneLocation() {
        if (this.listener != null && this.scenePanel != null) {
            Point point = SwingUtilities.convertPoint(this.scenePanel, 0, 0, SwingUtilities.getWindowAncestor(this.scenePanel));
            this.listener.changedLocation(point.x, point.y);
        }
    }

    public void reapplyFillPaint() {
        this.setFillPaint(this.fillPaint);
    }

    public void requestFocus() {
        this.scenePanel.requestFocus();
    }

    private void invalidateLastImage() {
        this.lastImage = null;
    }

    public Object renderToImage(Object object, float f) {
        if (this.lastImage != null && object == this.lastImage && f == this.lastScaleFactor) {
            return null;
        }
        Dimension dimension = this.scenePanel.getPreferredSize();
        if (object == null) {
            int n = (int)Math.ceil((float)dimension.width * f);
            int n2 = (int)Math.ceil((float)dimension.height * f);
            object = new BufferedImage(n, n2, 3);
        }
        BufferedImage bufferedImage = (BufferedImage)object;
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.setPaint(new Color(0, 0, 0, 0));
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setComposite(AlphaComposite.SrcOver);
        Affine2D affine2D = new Affine2D();
        if (f != 1.0f) {
            graphics2D.scale(f, f);
            affine2D.scale(f, f);
        }
        Bounds2D bounds2D = new Bounds2D(0.0f, 0.0f, dimension.width, dimension.height);
        graphics2D.setClip(0, 0, dimension.width, dimension.height);
        Paint paint = this.scenePanel.getBackgroundPaint();
        if (paint instanceof ProportionalPaint) {
            ProportionalPaint proportionalPaint = (ProportionalPaint)paint;
            paint = proportionalPaint.getPaint(0.0, 0.0, dimension.width, dimension.height);
        }
        graphics2D.setPaint(paint);
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        this.scenePanel.getSceneGroup().render(graphics2D, bounds2D, affine2D);
        graphics2D.dispose();
        this.lastImage = bufferedImage;
        this.lastScaleFactor = f;
        return bufferedImage;
    }

    public void inputMethodStateChange(boolean bl, Number number, Number number2) {
        this.scenePanel.inputMethodStateChange(bl, number, number2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FocusTraversalDirection {
        FORWARD,
        BACKWARD,
        UNDEFINED;

    }

    class IMRequests
    implements InputMethodRequests {
        int x;
        int y;

        public IMRequests(Number number, Number number2) {
            this.x = number.intValue();
            this.y = number2.intValue();
        }

        public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            return null;
        }

        public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
            return null;
        }

        public int getCommittedTextLength() {
            return 0;
        }

        public int getInsertPositionOffset() {
            return 0;
        }

        public TextHitInfo getLocationOffset(int n, int n2) {
            return TextHitInfo.beforeOffset(0);
        }

        public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
            return null;
        }

        public Rectangle getTextLocation(TextHitInfo textHitInfo) {
            return new Rectangle(this.x, this.y, 0, 0);
        }
    }

    public class SwingScenePanel
    extends JSGPanel
    implements BackgroundSupport.BackgroundSupportable,
    MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    KeyListener,
    FocusListener,
    InputMethodListener {
        private FocusTraversalDirection focusTraversalDirection = FocusTraversalDirection.UNDEFINED;
        private BackgroundSupport bgs = new BackgroundSupport(this);
        private boolean inputMethodEventEnabled = false;
        private Number popupX = 0;
        private Number popupY = 0;

        public void requestFocus() {
            super.requestFocus();
        }

        public SwingScenePanel() {
            this.setOpaque(true);
            this.setLayout(new LayoutManager(){

                public Dimension preferredLayoutSize(Container container) {
                    return new Dimension();
                }

                public Dimension minimumLayoutSize(Container container) {
                    return this.preferredLayoutSize(container);
                }

                public void layoutContainer(Container container) {
                }

                public void addLayoutComponent(String string, Component component) {
                }

                public void removeLayoutComponent(Component component) {
                }
            });
            this.setFocusTraversalKeysEnabled(false);
            this.setFocusTraversalPolicyProvider(true);
            this.setFocusTraversalPolicy(new FocusTraversalPolicy(){
                private final FocusTraversalPolicy policy = new DefaultFocusTraversalPolicy();
                private boolean isFirstGetDefaultComponentInvocation = true;

                public Component getComponentAfter(Container container, Component component) {
                    if (container == SwingScenePanel.this) {
                        SwingScenePanel.this.focusTraversalDirection;
                        SwingScenePanel.this.focusTraversalDirection = FocusTraversalDirection.FORWARD;
                        return null;
                    }
                    return this.policy.getComponentAfter(container, component);
                }

                public Component getComponentBefore(Container container, Component component) {
                    if (container == SwingScenePanel.this) {
                        SwingScenePanel.this.focusTraversalDirection;
                        SwingScenePanel.this.focusTraversalDirection = FocusTraversalDirection.BACKWARD;
                        return null;
                    }
                    return this.policy.getComponentBefore(container, component);
                }

                public Component getFirstComponent(Container container) {
                    return this.policy.getFirstComponent(container);
                }

                public Component getLastComponent(Container container) {
                    return this.policy.getLastComponent(container);
                }

                private Component getChildWithClientProperity(Component component, Object object) {
                    if (component instanceof JComponent && ((JComponent)component).getClientProperty(object) != null) {
                        return component;
                    }
                    if (component instanceof Container) {
                        Container container = (Container)component;
                        for (int i = 0; i < container.getComponentCount(); ++i) {
                            Component component2 = this.getChildWithClientProperity(container.getComponent(i), object);
                            if (component2 == null) continue;
                            return component2;
                        }
                    }
                    return null;
                }

                public Component getDefaultComponent(Container container) {
                    if (container == SwingScenePanel.this) {
                        if (this.isFirstGetDefaultComponentInvocation) {
                            this.isFirstGetDefaultComponentInvocation = false;
                            Component component = this.getChildWithClientProperity(container, "fx_focus_requested");
                            return component;
                        }
                        return container;
                    }
                    return this.policy.getDefaultComponent(container);
                }
            });
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
            this.addKeyListener(this);
            this.addFocusListener(this);
            this.addInputMethodListener(this);
        }

        public void setBackgroundPaint(Paint paint) {
            this.bgs.setBackgroundPaint(paint);
            if (paint instanceof Color) {
                SwingScene.this.bgColor = (Color)paint;
                if (SwingScene.this.windowStage != null) {
                    SwingScene.this.windowStage.setBackground(SwingScene.this.bgColor);
                }
            }
        }

        public Paint getBackgroundPaint() {
            return this.bgs.getBackgroundPaint();
        }

        public void inputMethodStateChange(boolean bl, Number number, Number number2) {
            if (bl != this.inputMethodEventEnabled) {
                this.enableInputMethods(false);
                this.inputMethodEventEnabled = bl;
                this.enableInputMethods(true);
            }
            this.popupX = number;
            this.popupY = number2;
        }

        public InputMethodRequests getInputMethodRequests() {
            if (this.inputMethodEventEnabled) {
                return new IMRequests(this.popupX, this.popupY);
            }
            return null;
        }

        protected void paintBackground(Graphics graphics) {
            this.bgs.paintBackground(graphics);
        }

        public void fireBackgroundPaintChange(Paint paint, Paint paint2) {
            this.firePropertyChange("backgroundPaint", paint, paint2);
        }

        protected void markDirty() {
            super.markDirty();
            SwingScene.this.invalidateLastImage();
        }

        public boolean isOpaque() {
            Window window = SwingUtilities.getWindowAncestor(SwingScene.this.scenePanel);
            return window instanceof FullScreenFrame || !(window instanceof JFrame) && !(window instanceof JWindow) && !(window instanceof JDialog);
        }

        public SGComponent pickSGComponent(Point2D point2D) {
            SGComponent sGComponent = super.pickSGComponent(point2D);
            if (sGComponent == null) {
                sGComponent = (SGComponent)PGComponentPicker.getInstance().pick(SwingScene.this.scene, point2D.getX(), point2D.getY());
            }
            return sGComponent;
        }

        public void doMouseEvent(MouseEvent mouseEvent) {
            if (SwingScene.this.listener != null) {
                SwingScene.this.listener.mouseEvent(mouseEvent);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (WindowImpl.isApplet && !this.hasFocus()) {
                this.requestFocus();
            }
            this.doMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.doMouseEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.doMouseEvent(mouseEvent);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            WindowStage.checkPopupStack();
            WindowStage.showPopup = false;
            this.doMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.doMouseEvent(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.doMouseEvent(mouseEvent);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.doMouseEvent(mouseEvent);
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.doMouseEvent(mouseWheelEvent);
        }

        void doKeyEvent(KeyEvent keyEvent) {
            if (SwingScene.this.listener != null) {
                SwingScene.this.listener.keyEvent(keyEvent);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.doKeyEvent(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.doKeyEvent(keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            this.doKeyEvent(keyEvent);
        }

        void doInputMethodEvent(InputMethodEvent inputMethodEvent) {
            if (SwingScene.this.listener != null) {
                SwingScene.this.listener.inputMethodEvent(inputMethodEvent);
            }
        }

        public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
            this.doInputMethodEvent(inputMethodEvent);
        }

        public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
            this.doInputMethodEvent(inputMethodEvent);
        }

        public void focusGained(FocusEvent focusEvent) {
            if (SwingScene.this.listener == null) {
                return;
            }
            switch (this.focusTraversalDirection) {
                case FORWARD: {
                    SwingScene.this.listener.transferFocusForward();
                    break;
                }
                case BACKWARD: {
                    SwingScene.this.listener.transferFocusBackward();
                    break;
                }
            }
            this.focusTraversalDirection = FocusTraversalDirection.UNDEFINED;
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

