/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd;

import com.sun.javafx.tools.fxd.FXDElement;
import com.sun.javafx.tools.fxd.FXDObjectElement;
import com.sun.javafx.tools.fxd.FXDRootElement;
import com.sun.javafx.tools.fxd.container.ContainerEntry;
import com.sun.javafx.tools.fxd.container.FXDContainerFactory;
import com.sun.javafx.tools.fxd.container.doc.DocumentParser;
import com.sun.javafx.tools.fxd.container.doc.GlobalReference;
import com.sun.javafx.tools.fxd.container.doc.LocalReference;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDException;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDSyntaxErrorException;
import java.io.IOException;

public final class FXDReference {
    public static final String REF_PREFIX_WITHOUT_COLON = "$ref";
    public static final String REF_PREFIX = "$ref:";
    public static final String BIND_PREFIX = "bind";
    public static final int REF_SEPARATOR = 35;
    protected final String m_refStr;
    protected final GlobalReference m_global;
    protected final LocalReference m_local;
    protected final Type m_refType;
    protected final FXDElement m_context;
    protected ResolutionListener m_resolutionListener = null;
    protected volatile LocalReference.FXDReferenced m_referenced = null;
    protected volatile Throwable m_error = null;

    protected FXDReference(String string, FXDElement fXDElement, boolean bl, Type type) throws FXDSyntaxErrorException {
        this.m_refStr = string;
        if (bl) {
            this.m_global = null;
            this.m_local = LocalReference.createLocalReference(string, 0);
            this.m_refType = type;
        } else {
            int n = string.lastIndexOf(35);
            this.m_local = n != -1 ? LocalReference.createLocalReference(string, n + 1) : LocalReference.createLocalRoot();
            if (n > 0 && string.charAt(n - 1) == '#') {
                this.m_refType = Type.ELEM_COPY_REFERENCE;
                --n;
            } else {
                this.m_refType = Type.ELEM_REFERENCE;
            }
            this.m_global = n == 0 ? null : new GlobalReference(string.substring(0, n));
        }
        this.m_context = fXDElement;
        if (this.m_refType == null) {
            throw new IllegalArgumentException("No type defined for reference " + string);
        }
    }

    public String getText() {
        return this.m_refStr;
    }

    public FXDElement getContext() {
        return this.m_context;
    }

    public Type getType() {
        return this.m_refType;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FXDReference{");
        stringBuffer.append("ref='");
        stringBuffer.append(this.m_refStr);
        stringBuffer.append("'");
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public boolean isCopyRef() {
        return this.m_refType == Type.ELEM_COPY_REFERENCE;
    }

    public boolean isLocal() {
        return this.m_global == null;
    }

    public boolean isLocal(ContainerEntry containerEntry) throws IOException {
        return this.m_global == null || this.m_global.isLocal(containerEntry);
    }

    public LocalReference getLocal() {
        return this.m_local;
    }

    public boolean resolveReference(ContainerEntry containerEntry, DocumentParser documentParser) throws IOException, FXDException {
        ContainerEntry containerEntry2 = FXDContainerFactory.create(this.m_global, containerEntry.getContainer(), documentParser.getRootParser().getLoadContext());
        FXDRootElement fXDRootElement = containerEntry2.getContainer().getRoot(containerEntry2.getEntryName(), documentParser);
        return this.resolveRerefence(fXDRootElement);
    }

    public synchronized boolean resolveRerefence(FXDRootElement fXDRootElement) throws FXDSyntaxErrorException {
        this.m_referenced = this.m_local.resolve(fXDRootElement, this.m_context);
        if (this.m_resolutionListener != null) {
            this.m_resolutionListener.resolved(this);
        }
        return this.m_referenced != null;
    }

    public synchronized void resolutionFailed(Throwable throwable) {
        this.m_error = throwable;
    }

    public synchronized boolean isResolved() {
        return this.m_referenced != null;
    }

    public synchronized FXDObjectElement getReferencedElement() {
        if (this.m_referenced != null) {
            return this.m_referenced.getElement();
        }
        throw new IllegalStateException("The reference " + this.toString() + " is not resolved yet.");
    }

    public synchronized String getProperty() {
        if (this.m_referenced != null) {
            return this.m_referenced.getProperty();
        }
        throw new IllegalStateException("The reference " + this.toString() + " is not resolved yet.");
    }

    public synchronized Throwable getError() {
        return this.m_error;
    }

    public void setResolutionListener(ResolutionListener resolutionListener) {
        this.m_resolutionListener = resolutionListener;
    }

    public static FXDReference parse(String string, FXDElement fXDElement) throws FXDSyntaxErrorException {
        FXDReference fXDReference;
        String string2;
        if (string == null || string.length() < 2) {
            throw new FXDSyntaxErrorException("Illegal reference '" + string + "'");
        }
        boolean bl = false;
        int n = 0;
        if (string.startsWith(BIND_PREFIX)) {
            n = BIND_PREFIX.length();
            bl = true;
        }
        if ((string2 = n != 0 ? string.substring(n) : string).charAt(0) == '#') {
            fXDReference = string2.charAt(1) == '#' ? FXDReference.create(string2.substring(2), fXDElement, true, true, bl) : FXDReference.create(string2.substring(1), fXDElement, true, false, bl);
        } else if (string2.startsWith(REF_PREFIX)) {
            fXDReference = FXDReference.create(string2.substring(REF_PREFIX.length()), fXDElement, false, false, bl);
        } else {
            throw new FXDSyntaxErrorException("Invalid reference: " + string2);
        }
        return fXDReference;
    }

    private static FXDReference create(String string, FXDElement fXDElement, boolean bl, boolean bl2, boolean bl3) throws FXDSyntaxErrorException {
        if (bl3) {
            throw new FXDSyntaxErrorException("Invalid reference: " + string + " - bind is not allowed in this reference!");
        }
        return new FXDReference(string, fXDElement, bl, bl2 ? Type.ELEM_COPY_REFERENCE : Type.ELEM_REFERENCE);
    }

    public static interface ResolutionListener {
        public void resolved(FXDReference var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ELEM_REFERENCE,
        ELEM_COPY_REFERENCE,
        PROP_BIND,
        PROP_INVERSE_BIND;

    }
}

