/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container;

import com.sun.javafx.tools.fxd.container.AbstractFXDContainer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

abstract class AbstractDesktopFXDContainer
extends AbstractFXDContainer {
    protected final URL m_url;

    protected AbstractDesktopFXDContainer(URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("Container path cannot be null!");
        }
        this.m_url = uRL;
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getName(), this.m_url.toString());
    }

    protected String getContainerURL() throws IOException {
        return this.m_url.toString();
    }

    protected static String getParentPath(URL uRL) {
        String string = uRL.getPath();
        int n = string.lastIndexOf(47);
        if (n == -1) {
            n = string.lastIndexOf(92);
        }
        string = n != -1 ? string.substring(0, n) : "";
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteArrayOutputStream getRaw(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            bufferedInputStream = new BufferedInputStream(inputStream);
            while ((n = ((InputStream)bufferedInputStream).read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            return byteArrayOutputStream2;
        }
        finally {
            if (bufferedInputStream != null) {
                ((InputStream)bufferedInputStream).close();
            }
        }
    }
}

