/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container;

import com.sun.javafx.tools.fxd.container.AbstractDesktopFXDContainer;
import com.sun.javafx.tools.fxd.container.AbstractFXDContainer;
import com.sun.javafx.tools.fxd.container.FXDBrowsableContainer;
import com.sun.javafx.tools.fxd.container.FXDContainerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;

final class DirectoryContainerImpl
extends AbstractDesktopFXDContainer
implements FXDBrowsableContainer {
    protected final File m_dir;
    public static final FXDContainerFactory.ContainerCreator CREATOR = new FXDContainerFactory.ContainerCreator(){

        public AbstractFXDContainer create(Object object) throws IOException {
            return new DirectoryContainerImpl((File)object);
        }
    };

    public DirectoryContainerImpl(File file) throws IOException, MalformedURLException {
        super(file.getCanonicalFile().toURI().toURL());
        this.m_dir = file.getCanonicalFile();
        if (!file.exists()) {
            throw new FileNotFoundException("The directory " + file.getAbsolutePath() + " not found.");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is not a directory.");
        }
    }

    public InputStream open(String string) throws FileNotFoundException {
        return new FileInputStream(this.getFile(string));
    }

    protected int getSize(String string) {
        return (int)this.getFile(string).length();
    }

    public String[] getEntryNames() {
        return this.m_dir.list();
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getName(), this.m_dir.toString());
    }

    protected final File getFile(String string) {
        string = DirectoryContainerImpl.removeMagicDirVar(string);
        return new File(this.m_dir, string);
    }

    public String getRelativeURL(String string) throws IOException {
        File file = new File(this.m_dir.getParentFile(), string);
        return file.getCanonicalFile().toURI().toString();
    }
}

