/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container;

import com.sun.javafx.tools.fxd.container.AbstractDesktopFXDContainer;
import com.sun.javafx.tools.fxd.container.AbstractFXDContainer;
import com.sun.javafx.tools.fxd.container.FXDBrowsableContainer;
import com.sun.javafx.tools.fxd.container.FXDContainerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;

final class FXDContainerImpl
extends AbstractDesktopFXDContainer
implements FXDBrowsableContainer {
    protected final File m_file;
    public static final FXDContainerFactory.ContainerCreator CREATOR = new FXDContainerFactory.ContainerCreator(){

        public AbstractFXDContainer create(Object object) throws FileNotFoundException, MalformedURLException {
            return new FXDContainerImpl((File)object);
        }
    };

    public FXDContainerImpl(File file) throws FileNotFoundException, MalformedURLException {
        super(file.getParentFile().toURI().toURL());
        this.m_file = file;
        if (!file.exists()) {
            throw new FileNotFoundException("The file " + file.getAbsolutePath() + " not found.");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " is not a file.");
        }
    }

    public InputStream open(String string) throws FileNotFoundException {
        return new FileInputStream(this.getFile(string));
    }

    public String[] getEntryNames() {
        return this.m_file.getParentFile().list();
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getName(), this.m_file.toString());
    }

    protected int getSize(String string) {
        return (int)this.getFile(string).length();
    }

    protected final File getFile(String string) {
        if ("content.fxd".equals(string = FXDContainerImpl.removeMagicDirVar(string))) {
            string = this.m_file.getName();
        }
        return new File(this.m_file.getParent(), string);
    }

    public String getRelativeURL(String string) throws IOException {
        File file = new File(this.m_file, string);
        return file.getCanonicalPath();
    }
}

