/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container;

import com.sun.javafx.tools.fxd.container.AbstractDesktopFXDContainer;
import com.sun.javafx.tools.fxd.container.AbstractFXDContainer;
import com.sun.javafx.tools.fxd.container.FXDContainerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

final class FXZURLContainerImpl
extends AbstractDesktopFXDContainer {
    private byte[][] m_data = null;
    private String[] m_entryNames = null;
    public static final FXDContainerFactory.ContainerCreator CREATOR = new FXDContainerFactory.ContainerCreator(){

        public AbstractFXDContainer create(Object object) throws IOException {
            return new FXZURLContainerImpl((URL)object);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FXZURLContainerImpl(URL uRL) throws IOException {
        super(uRL);
        InputStream inputStream = null;
        try {
            inputStream = this.m_url.openStream();
            if (inputStream == null) {
                throw new IOException("Could not open stream from url " + uRL);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        InputStream inputStream = null;
        ZipInputStream zipInputStream = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<byte[]> arrayList2 = new ArrayList<byte[]>();
        try {
            ZipEntry zipEntry;
            inputStream = this.m_url.openStream();
            zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = zipInputStream.read()) != -1) {
                    byteArrayOutputStream.write(n);
                }
                arrayList.add(zipEntry.getName());
                arrayList2.add(byteArrayOutputStream.toByteArray());
                zipInputStream.closeEntry();
            }
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        this.m_entryNames = new String[arrayList.size()];
        arrayList.toArray(this.m_entryNames);
        byte[][] byArrayArray = new byte[arrayList2.size()][];
        this.m_data = byArrayArray;
        arrayList2.toArray((T[])byArrayArray);
    }

    public InputStream open(String string) throws FileNotFoundException, MalformedURLException, IOException {
        return new ByteArrayInputStream(this.getData(string));
    }

    protected int getSize(String string) throws IOException {
        return this.getData(string).length;
    }

    protected synchronized byte[] getData(String string) throws IOException {
        if (this.m_data == null) {
            this.load();
        }
        string = FXZURLContainerImpl.removeMagicDirVar(string);
        for (int i = 0; i < this.m_entryNames.length; ++i) {
            if (!this.m_entryNames[i].equals(string)) continue;
            return this.m_data[i];
        }
        throw new FileNotFoundException("The file " + string + " not found.");
    }

    protected String getArchiveSeparator() {
        return "!";
    }

    protected String getContainerURL() throws IOException {
        String string = super.getContainerURL();
        assert (string.startsWith("file:"));
        return "jar:" + string;
    }

    public String getRelativeURL(String string) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

