/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.container.scene.fxd;

import com.sun.javafx.tools.fxd.container.misc.ContainerUtils;
import com.sun.javafx.tools.fxd.container.misc.ProgressHandler;
import com.sun.javafx.tools.fxd.container.scene.fxd.FXDSyntaxErrorException;
import java.io.IOException;
import java.io.Reader;

public class FXDReader {
    protected static final String VERSION_LABEL = "@version";
    protected static final int DEFAULT_BUFFER_SIZE = 1024;
    protected final Reader m_reader;
    protected final char[] m_buffer;
    protected final ProgressHandler m_notifier;
    protected int m_position;
    protected int m_bufferPos;
    protected int m_rowNum;
    protected int m_lastRowStartPos;
    protected int m_startTextPos = -1;
    protected int m_droppedChars = 0;
    protected int m_tabsOnLine = 0;
    protected int m_valueSepPosition = -1;
    protected boolean m_eof = false;
    protected String m_textFragment = null;
    protected boolean m_separatorFound = false;
    protected boolean m_scanVersion = false;
    protected String m_versionText = null;

    public FXDReader(Reader reader) throws IOException {
        this(reader, null);
    }

    public FXDReader(Reader reader, ProgressHandler progressHandler) throws IOException {
        this.m_reader = reader;
        this.m_buffer = new char[1024];
        this.m_notifier = progressHandler;
        this.m_bufferPos = 0;
        this.m_position = 0;
        this.m_rowNum = 1;
        this.m_lastRowStartPos = 0;
        this.readChar();
    }

    public boolean check(char c) throws IOException {
        char c2 = this.peek();
        if (c2 == c) {
            this.advance(c2);
            return true;
        }
        return false;
    }

    public boolean checkClean(char c) throws IOException, FXDSyntaxErrorException {
        char c2 = this.peekClean();
        if (c2 == c) {
            this.advance(c2);
            return true;
        }
        return false;
    }

    public boolean findClean(char ... cArray) throws IOException, FXDSyntaxErrorException {
        char c;
        while ((c = this.peekClean()) != '\u0000') {
            if (this.arrayContains(c, cArray)) {
                this.advance(c);
                return true;
            }
            this.advance(c);
        }
        return false;
    }

    private boolean arrayContains(char c, char[] cArray) {
        for (char c2 : cArray) {
            if (c != c2) continue;
            return true;
        }
        return false;
    }

    protected void commentFound(int n, int n2) {
    }

    protected void lineCommentFound(int n, int n2) {
    }

    protected void errorFound(int n, int n2, FXDSyntaxErrorException fXDSyntaxErrorException) {
    }

    private int getStartTextForError() {
        if (this.m_startTextPos == -1) {
            if (this.m_eof && this.m_textFragment != null) {
                return this.getPosition() - this.m_textFragment.length();
            }
            return this.getPosition();
        }
        if (this.m_textFragment == null) {
            int n = this.m_bufferPos - this.m_startTextPos;
            if (n > 0) {
                return this.getPosition() - n;
            }
            return this.getPosition();
        }
        return this.getPosition() - (this.m_textFragment.length() + this.m_bufferPos);
    }

    private void startText() {
        if (this.m_startTextPos != -1) {
            throw new IllegalStateException("StartText called twice!");
        }
        this.m_startTextPos = this.m_bufferPos;
        this.m_textFragment = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String endText() {
        String string;
        if (this.m_startTextPos == -1) {
            if (!this.m_eof || this.m_textFragment == null) throw new IllegalStateException("endText without start");
            String string2 = this.m_textFragment;
            this.m_textFragment = null;
            return string2;
        }
        if (this.m_textFragment == null) {
            int n = this.m_bufferPos - this.m_startTextPos;
            if (n > 0) {
                string = new String(this.m_buffer, this.m_startTextPos, n);
            } else {
                if (n != 0) throw new IllegalStateException("Negative string length: " + n);
                string = "";
            }
        } else {
            string = this.m_textFragment.concat(new String(this.m_buffer, 0, this.m_bufferPos));
            this.m_textFragment = null;
        }
        this.m_startTextPos = -1;
        return string;
    }

    protected void advance(char c) throws IOException {
        if (!this.m_eof) {
            if (++this.m_bufferPos >= this.m_buffer.length) {
                this.m_bufferPos = 0;
                if (this.m_startTextPos != -1) {
                    String string = new String(this.m_buffer, this.m_startTextPos, this.m_buffer.length - this.m_startTextPos);
                    this.m_textFragment = this.m_textFragment == null ? string : this.m_textFragment.concat(string);
                    this.m_startTextPos = 0;
                }
            }
            this.readChar();
            ++this.m_position;
            if (this.m_notifier != null) {
                this.m_notifier.event();
            }
            if (c == '\n') {
                ++this.m_rowNum;
                this.m_lastRowStartPos = this.m_position;
                this.m_tabsOnLine = 0;
            } else if (c == '\t') {
                ++this.m_tabsOnLine;
            }
        }
    }

    protected void readChar() throws IOException {
        int n = this.m_reader.read();
        if (n == -1) {
            if (this.m_startTextPos != -1) {
                this.m_textFragment = this.endText();
            }
            this.m_bufferPos = 0;
            this.m_buffer[0] = '\u0000';
            this.m_eof = true;
        } else {
            this.m_buffer[this.m_bufferPos] = (char)n;
        }
    }

    public char fetch() throws IOException {
        char c = this.peek();
        this.advance(c);
        return c;
    }

    public char peek() throws IOException {
        return this.m_buffer[this.m_bufferPos];
    }

    public String fetch(int n) throws IOException {
        this.startText();
        for (int i = 0; i < n && !this.m_eof; ++i) {
            this.fetch();
        }
        return this.endText();
    }

    public char peekClean() throws IOException, FXDSyntaxErrorException {
        block9: while (true) {
            char c = this.peek();
            switch (c) {
                default: {
                    if (c > ' ') {
                        return c;
                    }
                    this.advance(c);
                    continue block9;
                }
                case '\u0000': {
                    return '\u0000';
                }
                case '/': {
                    int n = this.getPosition();
                    this.advance(c);
                    c = this.peek();
                    switch (c) {
                        case '/': {
                            String string;
                            if (this.m_scanVersion) {
                                this.startText();
                            }
                            do {
                                this.advance(c);
                            } while ((c = this.peek()) != '\n' && c != '\r' && c != '\u0000');
                            if (this.m_scanVersion && (string = this.endText()) != null && string.indexOf(VERSION_LABEL) != -1) {
                                this.m_versionText = string;
                                this.m_scanVersion = false;
                            }
                            this.lineCommentFound(n, this.getPosition());
                            if (c != '\u0000') continue block9;
                            return '\u0000';
                        }
                        case '*': {
                            while (true) {
                                this.advance(c);
                                c = this.peek();
                                if (c == '\u0000') {
                                    throw this.syntaxError("Unclosed comment", n);
                                }
                                if (c != '*') continue;
                                this.advance(c);
                                if (this.check('/')) break;
                            }
                            this.commentFound(n, this.getPosition());
                            continue block9;
                        }
                    }
                    return '/';
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
            }
            if (!this.m_separatorFound) {
                this.m_separatorFound = true;
                this.m_valueSepPosition = this.getPosition();
            }
            this.advance(c);
        }
    }

    public char fetchClean() throws IOException, FXDSyntaxErrorException {
        char c = this.peekClean();
        this.advance(c);
        return c;
    }

    protected String nextID() throws FXDSyntaxErrorException, IOException {
        char c = this.peekClean();
        if (!FXDReader.isJavaIdentifierStart(c)) {
            return null;
        }
        this.startText();
        do {
            this.advance(c);
        } while (FXDReader.isJavaIdentifierPart(c = this.peek()));
        return this.endText();
    }

    protected static boolean isAllowedInReference(char c, boolean bl) {
        if (bl) {
            return c != '\n';
        }
        switch (c) {
            case ',': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return false;
            }
        }
        return c > ' ';
    }

    protected static boolean isAllowedInText(char c, boolean bl) {
        switch (c) {
            case ':': 
            case ';': 
            case '=': 
            case '[': 
            case ']': {
                return false;
            }
            case ' ': 
            case '\"': 
            case ',': 
            case '/': 
            case '\\': 
            case '{': 
            case '}': {
                return bl;
            }
        }
        return c > ' ';
    }

    protected String nextText() throws IOException {
        char c;
        this.startText();
        boolean bl = false;
        while (FXDReader.isAllowedInText(c = this.peek(), bl)) {
            if (c == '(') {
                bl = true;
            } else if (c == ')') {
                bl = false;
            }
            this.advance(c);
        }
        return this.endText();
    }

    protected String nextReference() throws IOException {
        char c;
        this.m_droppedChars = 0;
        this.startText();
        boolean bl = false;
        while (!this.m_eof && FXDReader.isAllowedInReference(c = this.peek(), bl)) {
            if (c == '\"') {
                bl = !bl;
            }
            this.advance(c);
        }
        String string = this.endText();
        if (string != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    protected String nextString(char c) throws FXDSyntaxErrorException, IOException {
        this.m_buffer[this.m_bufferPos] = 34;
        this.m_droppedChars = 0;
        this.startText();
        this.advance(c);
        while (true) {
            char c2 = this.peek();
            switch (c2) {
                case '\u0000': {
                    throw this.syntaxError("Unterminated string", this.getStartTextForError());
                }
                case '\\': {
                    return this.nextEscapedString(c);
                }
                case '\"': {
                    if (c2 == c) {
                        this.advance(c2);
                        return this.endText();
                    }
                }
                case '\'': {
                    if (c2 != c) break;
                    this.m_buffer[this.m_bufferPos] = 34;
                    this.advance(c2);
                    return this.endText();
                }
            }
            this.advance(c2);
        }
    }

    protected void lookForVersion(boolean bl) {
        this.m_versionText = null;
        this.m_scanVersion = bl;
    }

    protected String getVersionInfo() {
        return this.m_versionText;
    }

    private String nextEscapedString(char c) throws FXDSyntaxErrorException, IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.endText());
        block13: while (true) {
            char c2 = this.fetch();
            switch (c2) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string", this.getStartTextForError());
                }
                case '\\': {
                    c2 = this.fetch();
                    switch (c2) {
                        case 'b': {
                            stringBuilder.append('\b');
                            ++this.m_droppedChars;
                            continue block13;
                        }
                        case 't': {
                            stringBuilder.append('\t');
                            ++this.m_droppedChars;
                            continue block13;
                        }
                        case 'n': {
                            stringBuilder.append('\n');
                            ++this.m_droppedChars;
                            continue block13;
                        }
                        case 'f': {
                            stringBuilder.append('\f');
                            ++this.m_droppedChars;
                            continue block13;
                        }
                        case 'r': {
                            stringBuilder.append('\r');
                            ++this.m_droppedChars;
                            continue block13;
                        }
                        case 'u': {
                            stringBuilder.append((char)Integer.parseInt(this.fetch(4), 16));
                            this.m_droppedChars += 5;
                            continue block13;
                        }
                        case 'x': {
                            stringBuilder.append((char)Integer.parseInt(this.fetch(2), 16));
                            this.m_droppedChars += 3;
                            continue block13;
                        }
                    }
                    ++this.m_droppedChars;
                    stringBuilder.append(c2);
                    continue block13;
                }
            }
            if (c2 == c) {
                stringBuilder.append("\"");
                return stringBuilder.toString();
            }
            stringBuilder.append(c2);
        }
    }

    public int getPosition() {
        return this.m_position;
    }

    public int[] getLocation() {
        return new int[]{this.m_rowNum, this.m_position - this.m_lastRowStartPos};
    }

    public int getTabsInCurrentLine() {
        return this.m_tabsOnLine;
    }

    public FXDSyntaxErrorException syntaxError(String string) throws FXDSyntaxErrorException {
        throw new FXDSyntaxErrorException(string, this.m_position, this.m_tabsOnLine);
    }

    public FXDSyntaxErrorException syntaxError(String string, int n) throws FXDSyntaxErrorException {
        throw new FXDSyntaxErrorException(string, n, this.m_tabsOnLine);
    }

    public static boolean isJavaIdentifierStart(char c) {
        return ContainerUtils.isLetter(c) || c == '_' || c == '$';
    }

    public static boolean isJavaIdentifierPart(char c) {
        return FXDReader.isJavaIdentifierStart(c) || Character.isDigit(c);
    }

    public static boolean isJavaIdentifier(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (!FXDReader.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < n; ++i) {
            if (FXDReader.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

