/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.fxd.loader;

import com.sun.javafx.runtime.FXObject;
import com.sun.javafx.tools.fxd.FXDObjectElement;
import com.sun.javafx.tools.fxd.FXDReference;
import com.sun.javafx.tools.fxd.FXDRootElement;
import com.sun.javafx.tools.fxd.container.Context;
import com.sun.javafx.tools.fxd.container.FXDContainer;
import com.sun.javafx.tools.fxd.container.misc.ContainerUtils;
import com.sun.javafx.tools.fxd.loader.AbstractFunction;
import com.sun.javafx.tools.fxd.loader.Creator;
import com.sun.javafx.tools.fxd.loader.ElementCache;
import com.sun.javafx.tools.fxd.loader.FXClassReflector;
import com.sun.javafx.tools.fxd.loader.Profile;
import com.sun.javafx.tools.fxd.loader.ProfileUtils;
import com.sun.javafx.tools.fxd.loader.misc.FXDLogger;
import com.sun.javafx.tools.fxd.pool.CreationConnector;
import com.sun.javafx.tools.fxd.pool.DelayedValue;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.KeyValueTarget;

public abstract class CreationContext
extends Context {
    public static final Creator creator = Creator.INSTANCE;
    private static final long YIELD_INTERVAL_MILLIS = 20L;
    protected final ElementCache m_refCache = new ElementCache(8);
    private final List<CreationConnector> m_connectors = new ArrayList<CreationConnector>();
    protected long m_millisTime = -1L;
    private boolean m_isCreationBlocked = false;
    private boolean m_isYieldAllowed = false;

    public CreationContext() {
        if (this.m_pool != null) {
            // empty if block
        }
    }

    public Object createFunction(Object object) {
        if (object instanceof FXDReference) {
            FXDReference fXDReference = (FXDReference)object;
            try {
                if (fXDReference.getProperty() != null) {
                    return new PropertyFunction(fXDReference);
                }
                return new ElementFunction(fXDReference);
            }
            catch (Exception exception) {
                FXDLogger.error("Cannot create function for reference: " + fXDReference, exception);
                throw new RuntimeException("Cannot create function for reference: " + fXDReference);
            }
        }
        return new ConstantFunction(object);
    }

    public Profile getTargetProfile() {
        return ProfileUtils.CURRENT_PROFILE;
    }

    public void report(String string) {
    }

    public Object resolveReference(FXDReference fXDReference, boolean bl, Class clazz) {
        FXDObjectElement fXDObjectElement = fXDReference.getReferencedElement();
        String string = fXDReference.getProperty();
        if (string == null) {
            switch (fXDReference.getType()) {
                case ELEM_REFERENCE: {
                    if (!bl) {
                        return this.create(fXDObjectElement, true);
                    }
                }
                case ELEM_COPY_REFERENCE: {
                    return this.create(fXDObjectElement, false);
                }
            }
            throw new RuntimeException("Unknown reference type: " + (Object)((Object)fXDReference.getType()));
        }
        if (clazz == KeyValueTarget.class) {
            FXObject fXObject = (FXObject)this.create(fXDObjectElement, true);
            return creator.getKeyValueTarget(fXObject, string);
        }
        return fXDObjectElement.getAttrValue(string);
    }

    public FXObject createRoot(FXDRootElement fXDRootElement) {
        this.m_millisTime = ContainerUtils.currentTimeMillis();
        if (fXDRootElement != null) {
            String string = fXDRootElement.getTypeName();
            if (!"FXD".equals(string)) {
                if ("Group".equals(string)) {
                    string = "FXD";
                } else {
                    throw new RuntimeException("The element " + string + " is not valid FXD root. Please use FXD {} instead.");
                }
            }
            return (FXObject)this.create(fXDRootElement, true, string);
        }
        return null;
    }

    Object create(FXDObjectElement fXDObjectElement, boolean bl) {
        return this.create(fXDObjectElement, bl, fXDObjectElement.getTypeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object create(FXDObjectElement fXDObjectElement, boolean bl, String string) {
        if (this.m_isYieldAllowed) {
            this.checkYield();
        }
        FXClassReflector fXClassReflector = (FXClassReflector)creator.getReflectorByTypeName(string);
        if (this.getTargetProfile().contains(fXClassReflector.profile)) {
            FXObject fXObject;
            int n;
            boolean bl2 = true;
            if (bl && (n = fXDObjectElement.getReferenceID()) != -1) {
                ElementCache elementCache = this.m_refCache;
                synchronized (elementCache) {
                    fXObject = this.m_refCache.get(n);
                    if (fXObject == null) {
                        Object object = fXClassReflector.create(fXDObjectElement, this);
                        if (!(object instanceof FXObject)) {
                            return object;
                        }
                        fXObject = (FXObject)object;
                        this.m_refCache.put(n, fXObject);
                    } else {
                        bl2 = false;
                    }
                }
            } else {
                Object object = fXClassReflector.create(fXDObjectElement, this);
                if (object instanceof FXObject) {
                    fXObject = (FXObject)object;
                } else {
                    return object;
                }
            }
            if (bl2) {
                this.objectCreated(fXDObjectElement, fXObject);
            }
            return fXObject;
        }
        return null;
    }

    public void setYieldAllowed() {
        this.m_isYieldAllowed = true;
    }

    public void setCreationBlocked(boolean bl) {
        if (bl && !this.m_isYieldAllowed) {
            throw new IllegalStateException("Yield is not allowed");
        }
        this.m_isCreationBlocked = bl;
    }

    public boolean isCreationBlocked() {
        return this.m_isCreationBlocked;
    }

    CreationConnector createConnector(FXClassReflector fXClassReflector, FXObject fXObject, FXClassReflector.FXProperty fXProperty, Object object) {
        return new CreationConnectorImpl(fXClassReflector, fXObject, fXProperty, object);
    }

    CreationConnector addConnector(FXClassReflector fXClassReflector, FXObject fXObject, FXClassReflector.FXProperty fXProperty, Object object) {
        CreationConnector creationConnector = this.createConnector(fXClassReflector, fXObject, fXProperty, object);
        this.m_connectors.add(creationConnector);
        return creationConnector;
    }

    public boolean isCreationDone() {
        return this.m_connectors.size() == 0;
    }

    public boolean continueCreate() throws Throwable {
        this.m_millisTime = ContainerUtils.currentTimeMillis();
        this.setCreationBlocked(false);
        while (this.m_connectors.size() > 0 && !this.isCreationBlocked()) {
            CreationConnector creationConnector = this.m_connectors.remove(0);
            creationConnector.connect();
        }
        return this.isCreationDone();
    }

    public abstract FXDContainer getCurrentContainer();

    protected abstract void objectCreated(FXDObjectElement var1, FXObject var2);

    private void checkYield() {
        if (!this.isCreationBlocked() && ContainerUtils.currentTimeMillis() - this.m_millisTime > 20L) {
            this.setCreationBlocked(true);
        }
    }

    protected static final class ConstantFunction
    extends AbstractFunction {
        private final Object m_value;

        public ConstantFunction(Object object) {
            this.m_value = object;
        }

        public Object invoke() {
            return this.m_value;
        }
    }

    public final class CreationConnectorImpl
    implements CreationConnector {
        private final FXClassReflector reflector;
        private final FXObject fxObj;
        private final FXClassReflector.FXProperty prop;
        private Object value;

        public CreationConnectorImpl(FXClassReflector fXClassReflector, FXObject fXObject, FXClassReflector.FXProperty fXProperty, Object object) {
            this.reflector = fXClassReflector;
            this.fxObj = fXObject;
            this.prop = fXProperty;
            this.value = object;
        }

        public void connect() throws Throwable {
            if (this.value instanceof DelayedValue) {
                DelayedValue delayedValue = (DelayedValue)this.value;
                if (delayedValue.isReady()) {
                    this.value = delayedValue.getValue();
                } else {
                    throw new IllegalStateException("The DelayedValue " + delayedValue + " is not ready yet, could not connect " + this.fxObj + " " + this.prop);
                }
            }
            this.reflector.connectProperty(this.fxObj, this.prop, this.value, CreationContext.this);
        }
    }

    protected final class ElementFunction
    extends AbstractFunction {
        private final FXObject m_fxObject;

        public ElementFunction(FXDReference fXDReference) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            this.m_fxObject = (FXObject)CreationContext.this.create(fXDReference.getReferencedElement(), true);
        }

        public Object invoke() {
            return this.m_fxObject;
        }
    }

    protected final class PropertyFunction
    extends AbstractFunction {
        private final FXClassReflector.FXProperty m_property;
        private final FXObject m_fxObject;

        public PropertyFunction(FXDReference fXDReference) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            this.m_fxObject = (FXObject)CreationContext.this.create(fXDReference.getReferencedElement(), true);
            FXClassReflector fXClassReflector = creator.getReflector(this.m_fxObject);
            this.m_property = fXClassReflector.getProperty(fXDReference.getProperty());
        }

        public Object invoke() {
            return this.m_property.getValue(this.m_fxObject);
        }
    }
}

