/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl;

import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class Logger {
    protected String logPrefix;
    protected boolean error = false;
    protected boolean warning = false;
    protected boolean info = false;
    protected boolean debug = false;
    StringBuilder sb = new StringBuilder();

    public Logger(TraceLevel traceLevel, String string) {
        this.logPrefix = string == null ? "" : string;
        switch (traceLevel) {
            case Debug: {
                this.debug = true;
            }
            case Info: {
                this.info = true;
            }
            case Warning: {
                this.warning = true;
            }
            case Error: {
                this.error = true;
            }
        }
    }

    public Logger(String string, String string2) {
        this(Logger.getTraceLevel(string), string2);
    }

    private static TraceLevel getTraceLevel(final String string) {
        String string2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(string, "");
            }
        });
        if (string2.compareToIgnoreCase("error") == 0) {
            return TraceLevel.Error;
        }
        if (string2.compareToIgnoreCase("warning") == 0) {
            return TraceLevel.Warning;
        }
        if (string2.compareToIgnoreCase("info") == 0) {
            return TraceLevel.Info;
        }
        if (string2.compareToIgnoreCase("debug") == 0) {
            return TraceLevel.Debug;
        }
        return TraceLevel.None;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(TraceLevel traceLevel, PrintStream printStream, String string) {
        String string2;
        StringBuilder stringBuilder = this.sb;
        synchronized (stringBuilder) {
            this.sb.append(this.logPrefix);
            this.sb.append(" (");
            this.sb.append(traceLevel.toString());
            this.sb.append("):");
            this.sb.append(string);
            string2 = this.sb.toString();
            this.sb.setLength(0);
        }
        printStream.println(string2);
    }

    private void log(TraceLevel traceLevel, PrintStream printStream, String string, Throwable throwable) {
        if (string == null) {
            string = "exception thrown: ";
        }
        this.log(traceLevel, printStream, string);
        throwable.printStackTrace(printStream);
    }

    public void err(String string) {
        if (this.error) {
            this.log(TraceLevel.Error, System.out, string);
        }
    }

    public void err(String string, Throwable throwable) {
        if (this.error) {
            this.log(TraceLevel.Error, System.out, string, throwable);
        }
    }

    public void warn(String string) {
        if (this.warning) {
            this.log(TraceLevel.Warning, System.out, string);
        }
    }

    public void warn(String string, Throwable throwable) {
        if (this.warning) {
            this.log(TraceLevel.Warning, System.out, string, throwable);
        }
    }

    public void info(String string) {
        if (this.info) {
            this.log(TraceLevel.Info, System.out, string);
        }
    }

    public void info(String string, Throwable throwable) {
        if (this.info) {
            this.log(TraceLevel.Info, System.out, string, throwable);
        }
    }

    public void debug(String string) {
        if (this.debug) {
            this.log(TraceLevel.Debug, System.out, string);
        }
    }

    public void debug(String string, Throwable throwable) {
        if (this.debug) {
            this.log(TraceLevel.Debug, System.out, string, throwable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TraceLevel {
        None,
        Error,
        Warning,
        Info,
        Debug;

    }
}

