/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.corevideo;

import com.sun.media.jmc.MediaException;
import com.sun.media.jmc.MediaUnavailableException;
import com.sun.media.jmc.control.VideoDataBuffer;
import com.sun.media.jmc.track.AudioTrack;
import com.sun.media.jmc.track.MediaTrack;
import com.sun.media.jmc.track.VideoTrack;
import com.sun.media.jmc.type.ContainerType;
import com.sun.media.jmc.type.EncodingType;
import com.sun.media.jmcimpl.MediaPeer;
import com.sun.media.jmcimpl.NativeLibLoader;
import com.sun.media.jmcimpl.PlayerPeer;
import com.sun.media.jmcimpl.plugins.corevideo.CoreVideoBuffer;
import com.sun.media.jmcimpl.plugins.corevideo.CoreVideoPlayer;
import com.sun.media.jmcimpl.plugins.corevideo.CoreVideoProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CoreVideoMedia
implements MediaPeer {
    private static final int UNKNOWN_TRACK_TYPE = 0;
    private static final int AUDIO_TRACK_TYPE = 1;
    private static final int VIDEO_TRACK_TYPE = 2;
    private static final int TEXT_TRACK_TYPE = 3;
    private static final int MPEG_TRACK_TYPE = 4;
    private static final int MUSIC_TRACK_TYPE = 5;
    private static final int TIME_CODE_TRACK_TYPE = 6;
    public static final int CVLoadStateError = -1;
    public static final int CVLoadStateInvalid = 0;
    public static final int CVLoadStateLoading = 1000;
    public static final int CVLoadStateLoaded = 2000;
    public static final int CVLoadStatePlayable = 10000;
    public static final int CVLoadStatePlaythroughOK = 20000;
    public static final int CVLoadStateComplete = 100000;
    private long moviePtr = 0L;
    private CoreVideoPlayer player = null;
    private float fps = 0.0f;
    private URI uri = null;
    private int totalTracks = 0;
    private List<MediaTrack> mediaTracks = null;
    private VideoDataBuffer.Format[] pixelFormats = new VideoDataBuffer.Format[]{VideoDataBuffer.Format.XRGB};
    private int[] nativePixelFormats = new int[]{32};
    private static boolean initialized = false;

    public static synchronized boolean init() {
        if (initialized) {
            return true;
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    NativeLibLoader.loadLibrary("CoreVideoMedia");
                    return null;
                }
            });
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
        catch (Exception exception) {
            System.err.println("Fatal exception while initializing CoreVideoMedia: " + exception);
            exception.printStackTrace(System.err);
            return false;
        }
        initialized = CoreVideoMedia.cvInit();
        return initialized;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public CoreVideoMedia() throws MediaException {
        throw new MediaException("No media URL provided!");
    }

    private static void validateMediaURL(String string) throws MediaException {
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            if (null != inputStream) {
                inputStream.close();
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new MediaException("Invalid Media URL");
        }
        catch (IOException iOException) {
            throw new MediaUnavailableException("Media URL unavailable");
        }
    }

    public CoreVideoMedia(URI uRI, VideoDataBuffer.Format[] formatArray) throws MediaException {
        if (!initialized) {
            CoreVideoMedia.init();
            if (!initialized) {
                throw new MediaException("CoreVideoPeer native components are unable to initialize!");
            }
        }
        this.pixelFormats = formatArray;
        this.parsePixelFormats();
        this.uri = uRI;
        if (!this.open(this.uri)) {
            throw new MediaException("Unsupported media");
        }
        this.initMediaTracks();
    }

    public CoreVideoMedia(URI uRI, CoreVideoPlayer coreVideoPlayer) throws MediaException {
        this(uRI, coreVideoPlayer.getPixelFormats());
        this.player = coreVideoPlayer;
    }

    private void initMediaTracks() throws MediaException {
        if (0L != this.moviePtr) {
            this.totalTracks = this.getNumTracks();
            this.mediaTracks = new ArrayList<MediaTrack>(this.totalTracks);
            for (int i = 0; i < this.totalTracks; ++i) {
                EncodingType encodingType;
                int n = this.getTrackType(i);
                String string = this.getTrackFormat(i);
                boolean bl = this.getTrackIsEnabled(i);
                if (n == 2) {
                    encodingType = string.contains("H.263") ? new EncodingType(EncodingType.Encoding.H263, string) : (string.startsWith("H.264") ? new EncodingType(EncodingType.Encoding.H264, string) : (string.startsWith("Windows Media Video 9") ? new EncodingType(EncodingType.Encoding.WMVIDEO9, string) : (string.contains("Theora") ? new EncodingType(EncodingType.Encoding.THEORA, string) : (string.contains("JPEG") ? new EncodingType(EncodingType.Encoding.MJPEG, string) : new EncodingType(EncodingType.Encoding.CUSTOM, string)))));
                    VideoTrack videoTrack = new VideoTrack(encodingType, "Video Track", this.getFrameWidth(), this.getFrameHeight(), this.fps, false);
                    this.mediaTracks.add(videoTrack);
                    continue;
                }
                if (n == 1) {
                    encodingType = string.equals("mp4a") ? new EncodingType(EncodingType.Encoding.MPEG4AUDIO, "MPEG-4 Audio") : (string.contains("Vorbis") ? new EncodingType(EncodingType.Encoding.VORBIS, string) : (string.contains("AAC") ? new EncodingType(EncodingType.Encoding.AAC, string) : (string.contains("mp3") || string.contains("MPEG Layer 3") ? new EncodingType(EncodingType.Encoding.MPEG1LAYER3, string) : (string.equals("WMA2") ? new EncodingType(EncodingType.Encoding.WMAUDIO8, string) : (string.contains("Windows Media Audio 9") ? new EncodingType(EncodingType.Encoding.WMAUDIO9, string) : (string.contains("16-bit Integer (Little Endian)") ? new EncodingType(EncodingType.Encoding.PCM, string) : new EncodingType(EncodingType.Encoding.CUSTOM, string)))))));
                    int n2 = this.getTrackChannels(i);
                    long l = this.getTrackSampleRate(i);
                    AudioTrack audioTrack = new AudioTrack(encodingType, "Audio Track", n2, Locale.US, l);
                    this.mediaTracks.add(audioTrack);
                    continue;
                }
                if (n != 3 && n != 4 && n != 5 && n != 6) continue;
            }
        }
    }

    @Override
    public ContainerType getContainerType() {
        ContainerType[] containerTypeArray = CoreVideoProvider.getSupportedContainerTypes();
        String string = this.uri.toASCIIString();
        for (int i = 0; i < containerTypeArray.length; ++i) {
            String[] stringArray = containerTypeArray[i].getExtensions();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!string.endsWith(stringArray[j])) continue;
                return containerTypeArray[i];
            }
        }
        return null;
    }

    @Override
    public double getDuration() {
        return this.getMovieDuration();
    }

    @Override
    public int getFrameWidth() {
        return this.getMovieWidth();
    }

    @Override
    public int getFrameHeight() {
        return this.getMovieHeight();
    }

    @Override
    public Map<String, Object> getMetadata() {
        return null;
    }

    @Override
    public List<MediaTrack> getMediaTracks() {
        return this.mediaTracks;
    }

    @Override
    public synchronized PlayerPeer getPlayerPeer() {
        if (null == this.player) {
            this.player = new CoreVideoPlayer(this, this.pixelFormats);
        }
        return this.player;
    }

    private static native boolean cvInit();

    private static native boolean cvCanPlay(String var0);

    private native long cvOpen(String var1);

    private native void cvClose(long var1);

    private native void cvUpdateMovieProperties(long var1);

    private native int cvGetLoadState(long var1);

    private native double cvGetAvailableDuration(long var1);

    private native double cvGetDuration(long var1);

    private native int cvGetMovieWidth(long var1);

    private native int cvGetMovieHeight(long var1);

    private native int cvGetNumTracks(long var1);

    private native int cvGetTrackType(long var1, int var3);

    private native String cvGetTrackFormat(long var1, int var3);

    private native boolean cvGetTrackIsEnabled(long var1, int var3);

    private native long cvGetTrackSampleRate(long var1, int var3);

    private native int cvGetTrackChannels(long var1, int var3);

    private native void cvPlay(long var1);

    private native void cvStop(long var1);

    private native void cvSetSupportedPixelFormats(long var1, int[] var3);

    private native CoreVideoBuffer cvGetNextFrame(long var1);

    private native boolean cvNewFrame(long var1);

    private native double cvGetMediaTime(long var1);

    private native void cvSetMediaTime(long var1, double var3);

    private native void cvSetRate(long var1, double var3);

    private native double cvGetRate(long var1);

    private native float cvGetVolume(long var1);

    private native void cvSetVolume(long var1, float var3);

    private native float cvGetBalance(long var1);

    private native void cvSetBalance(long var1, float var3);

    public static boolean canPlay(String string) {
        if (initialized) {
            try {
                CoreVideoMedia.validateMediaURL(string);
            }
            catch (MediaException mediaException) {
                return false;
            }
            return CoreVideoMedia.cvCanPlay(string);
        }
        return false;
    }

    public synchronized boolean open(String string) throws MediaException {
        if (initialized) {
            if (0L != this.moviePtr) {
                this.close();
            }
            CoreVideoMedia.validateMediaURL(string);
            this.moviePtr = this.cvOpen(string);
            if (0L == this.moviePtr) {
                throw new MediaException("Unsupported media");
            }
            this.cvSetSupportedPixelFormats(this.moviePtr, this.nativePixelFormats);
            return true;
        }
        return false;
    }

    public synchronized boolean open(URI uRI) throws MediaException {
        return this.open(uRI.toASCIIString());
    }

    public synchronized void close() {
        if (initialized && 0L != this.moviePtr) {
            this.cvClose(this.moviePtr);
            this.moviePtr = 0L;
        }
    }

    public void updateMovieProperties() {
        if (initialized && 0L != this.moviePtr) {
            this.cvUpdateMovieProperties(this.moviePtr);
        }
    }

    public int getLoadState() {
        if (initialized && 0L != this.moviePtr) {
            return this.cvGetLoadState(this.moviePtr);
        }
        return 0;
    }

    public double getAvailableDuration() {
        if (initialized && 0L != this.moviePtr) {
            return this.cvGetAvailableDuration(this.moviePtr);
        }
        return 0.0;
    }

    public double getMovieDuration() {
        if (initialized && 0L != this.moviePtr) {
            return this.cvGetDuration(this.moviePtr);
        }
        return Double.NEGATIVE_INFINITY;
    }

    public int getMovieWidth() {
        if (initialized && 0L != this.moviePtr) {
            return this.cvGetMovieWidth(this.moviePtr);
        }
        return 0;
    }

    public int getMovieHeight() {
        if (initialized && 0L != this.moviePtr) {
            return this.cvGetMovieHeight(this.moviePtr);
        }
        return 0;
    }

    public int getNumTracks() {
        if (initialized && 0L != this.moviePtr) {
            return this.cvGetNumTracks(this.moviePtr);
        }
        return 0;
    }

    public int getTrackType(int n) {
        if (initialized && 0L != this.moviePtr) {
            return this.cvGetTrackType(this.moviePtr, n);
        }
        return 0;
    }

    public String getTrackFormat(int n) {
        if (initialized && 0L != this.moviePtr) {
            return this.cvGetTrackFormat(this.moviePtr, n);
        }
        return null;
    }

    public boolean getTrackIsEnabled(int n) {
        if (initialized && 0L != this.moviePtr) {
            return this.cvGetTrackIsEnabled(this.moviePtr, n);
        }
        return false;
    }

    public long getTrackSampleRate(int n) {
        if (initialized && 0L != this.moviePtr) {
            return this.cvGetTrackSampleRate(this.moviePtr, n);
        }
        return 0L;
    }

    public int getTrackChannels(int n) {
        if (initialized && 0L != this.moviePtr) {
            return this.cvGetTrackChannels(this.moviePtr, n);
        }
        return 0;
    }

    public synchronized void play() {
        if (initialized && 0L != this.moviePtr) {
            this.cvPlay(this.moviePtr);
        }
    }

    public synchronized void stop() {
        if (initialized && 0L != this.moviePtr) {
            this.cvStop(this.moviePtr);
        }
    }

    private void parsePixelFormats() {
        int n;
        int n2 = 0;
        this.nativePixelFormats = new int[this.pixelFormats.length];
        block5: for (n = 0; n < this.pixelFormats.length; ++n) {
            switch (this.pixelFormats[n]) {
                case XRGB: {
                    this.nativePixelFormats[n2++] = 32;
                    continue block5;
                }
                case XBGR: {
                    this.nativePixelFormats[n2++] = 1111970369;
                    continue block5;
                }
                case APPLE_422: {
                    this.nativePixelFormats[n2++] = 846624121;
                    continue block5;
                }
            }
        }
        if (n2 < n) {
            int[] nArray = new int[n2];
            System.arraycopy(this.nativePixelFormats, 0, nArray, 0, n2);
            this.nativePixelFormats = nArray;
        }
    }

    public CoreVideoBuffer getNextFrame() {
        if (initialized && 0L != this.moviePtr) {
            return this.cvGetNextFrame(this.moviePtr);
        }
        return null;
    }

    public boolean newFrame() {
        if (initialized && 0L != this.moviePtr) {
            return this.cvNewFrame(this.moviePtr);
        }
        return false;
    }

    public double getMediaTime() {
        if (initialized && 0L != this.moviePtr) {
            return this.cvGetMediaTime(this.moviePtr);
        }
        return Double.NEGATIVE_INFINITY;
    }

    public void setMediaTime(double d) {
        if (initialized && 0L != this.moviePtr) {
            this.cvSetMediaTime(this.moviePtr, d);
        }
    }

    public void setRate(double d) {
        if (initialized && 0L != this.moviePtr) {
            this.cvSetRate(this.moviePtr, d);
        }
    }

    public double getRate() {
        if (initialized && 0L != this.moviePtr) {
            return this.cvGetRate(this.moviePtr);
        }
        return 0.0;
    }

    public float getVolume() {
        if (initialized && 0L != this.moviePtr) {
            return this.cvGetVolume(this.moviePtr);
        }
        return 0.0f;
    }

    public void setVolume(float f) {
        if (initialized && 0L != this.moviePtr) {
            this.cvSetVolume(this.moviePtr, f);
        }
    }

    public float getBalance() {
        if (initialized && 0L != this.moviePtr) {
            return this.cvGetBalance(this.moviePtr);
        }
        return 0.0f;
    }

    public void setBalance(float f) {
        if (initialized && 0L != this.moviePtr) {
            this.cvSetBalance(this.moviePtr, f);
        }
    }
}

