/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jmcimpl.plugins.gstreamer;

abstract class GSTStreamInfo {
    static final int VALUE_UNDEFINED = -1;
    private StreamType streamType;
    private String mimeType;
    private int version;
    private int layer;

    private GSTStreamInfo(StreamType streamType, String string, int n, int n2) {
        this.streamType = streamType;
        this.mimeType = string;
        this.version = n;
        this.layer = n2;
    }

    StreamType getStreamType() {
        return this.streamType;
    }

    String getMimeType() {
        return this.mimeType;
    }

    int getVersion() {
        return this.version;
    }

    int getLayer() {
        return this.layer;
    }

    static class Audio
    extends GSTStreamInfo {
        private int rate;
        private int channels;

        Audio(String string, int n, int n2, int n3, int n4) {
            super(StreamType.AUDIO, string, n, n2);
            this.rate = n3;
            this.channels = n4;
        }

        int getChannels() {
            return this.channels;
        }

        int getRate() {
            return this.rate;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StreamType {
        AUDIO,
        VIDEO,
        SUBTITLES;

    }

    static class Subtitles
    extends GSTStreamInfo {
        Subtitles(String string) {
            super(StreamType.SUBTITLES, string, -1, -1);
        }
    }

    static class Video
    extends GSTStreamInfo {
        private int width;
        private int height;
        private double framerate;

        Video(String string, int n, int n2, int n3, int n4, double d) {
            super(StreamType.VIDEO, string, n, n2);
            this.width = n3;
            this.height = n4;
            this.framerate = d;
        }

        int getWidth() {
            return this.width;
        }

        int getHeight() {
            return this.height;
        }

        boolean isSizeValid() {
            return this.width > 0 && this.height > 0;
        }

        double getFramerate() {
            return this.framerate;
        }
    }
}

