/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nativewindow.impl.jawt;

import com.sun.nativewindow.impl.Debug;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;

public abstract class JAWTWindow
implements NativeWindow {
    protected static final boolean DEBUG = Debug.debug("JAWT");
    private static boolean headlessMode = GraphicsEnvironment.isHeadless();
    protected Component component;
    protected AbstractGraphicsConfiguration config;
    protected long drawable;
    private volatile Exception lockedStack = null;

    public JAWTWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        if (abstractGraphicsConfiguration == null) {
            throw new NativeWindowException("Error: AbstractGraphicsConfiguration is null");
        }
        this.config = abstractGraphicsConfiguration;
        this.init((Component)object);
    }

    protected void init(Component component) throws NativeWindowException {
        this.invalidate();
        this.component = component;
        this.initNative();
    }

    protected abstract void initNative() throws NativeWindowException;

    public synchronized void invalidate() {
        this.component = null;
        this.drawable = 0L;
    }

    public synchronized void destroy() {
        if (null != this.component && this.component instanceof Window) {
            ((Window)this.component).dispose();
        }
        this.invalidate();
    }

    public synchronized int lockSurface() throws NativeWindowException {
        NativeWindowFactory.getDefaultFactory().getToolkitLock().lock();
        if (null != this.lockedStack) {
            this.lockedStack.printStackTrace();
            throw new NativeWindowException("JAWT Surface already locked - " + Thread.currentThread().getName() + " " + this);
        }
        this.lockedStack = new Exception("JAWT Surface previously locked by " + Thread.currentThread().getName());
        return 3;
    }

    public synchronized void unlockSurface() {
        if (null == this.lockedStack) {
            throw new NativeWindowException("JAWT Surface not locked");
        }
        this.lockedStack = null;
        NativeWindowFactory.getDefaultFactory().getToolkitLock().unlock();
    }

    public synchronized boolean isSurfaceLocked() {
        return null != this.lockedStack;
    }

    public Exception getLockedStack() {
        return this.lockedStack;
    }

    public boolean surfaceSwap() {
        return false;
    }

    public void surfaceUpdated(Object object, NativeWindow nativeWindow, long l) {
    }

    public long getDisplayHandle() {
        return this.config.getScreen().getDevice().getHandle();
    }

    public int getScreenIndex() {
        return this.config.getScreen().getIndex();
    }

    public long getWindowHandle() {
        return this.drawable;
    }

    public long getSurfaceHandle() {
        return this.drawable;
    }

    public AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config;
    }

    public Object getWrappedWindow() {
        return this.component;
    }

    public void setSize(int n, int n2) {
        this.component.setSize(n, n2);
    }

    public int getWidth() {
        return this.component.getWidth();
    }

    public int getHeight() {
        return this.component.getHeight();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JAWT-Window[windowHandle 0x" + Long.toHexString(this.getWindowHandle()) + ", surfaceHandle 0x" + Long.toHexString(this.getSurfaceHandle()));
        if (null != this.component) {
            stringBuffer.append(", pos " + this.component.getX() + "/" + this.component.getY() + ", size " + this.getWidth() + "x" + this.getHeight() + ", visible " + this.component.isVisible());
        } else {
            stringBuffer.append(", component NULL");
        }
        stringBuffer.append(", locked " + this.isSurfaceLocked() + ",\n\tconfig " + this.config + ",\n\twrappedWindow " + this.getWrappedWindow() + "]");
        return stringBuffer.toString();
    }
}

