/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.opengl.impl.Debug;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL;

public class GLBufferStateTracker {
    private static final boolean DEBUG = Debug.debug("GLBufferStateTracker");
    private static final Integer arrayBufferEnum = new Integer(34962);
    private static final Integer elementArrayBufferEnum = new Integer(34963);
    private static final Integer pixelPackBufferEnum = new Integer(35051);
    private static final Integer pixelUnpackBufferEnum = new Integer(35052);
    private static final Integer zero = new Integer(0);
    private Map bindingMap = new HashMap();
    private int[] bufTmp = new int[1];

    public GLBufferStateTracker() {
        this.bindingMap.put(arrayBufferEnum, zero);
        this.bindingMap.put(elementArrayBufferEnum, zero);
        this.bindingMap.put(pixelPackBufferEnum, zero);
        this.bindingMap.put(pixelUnpackBufferEnum, zero);
    }

    public void setBoundBufferObject(int n, int n2) {
        this.bindingMap.put(GLBufferStateTracker.box(n), GLBufferStateTracker.box(n2));
    }

    public int getBoundBufferObject(int n, GL gL) {
        Integer n2 = (Integer)this.bindingMap.get(GLBufferStateTracker.box(n));
        if (n2 == null) {
            boolean bl = true;
            int n3 = 0;
            switch (n) {
                case 34962: {
                    n3 = 34964;
                    break;
                }
                case 34963: {
                    n3 = 34965;
                    break;
                }
                case 35051: {
                    n3 = 35053;
                    break;
                }
                case 35052: {
                    n3 = 35055;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (bl) {
                gL.glGetIntegerv(n3, this.bufTmp, 0);
                if (DEBUG) {
                    System.err.println("GLBufferStateTracker.getBoundBufferObject(): queried bound buffer " + this.bufTmp[0] + " for query target 0x" + Integer.toHexString(n3));
                }
                this.setBoundBufferObject(n, this.bufTmp[0]);
                return this.getBoundBufferObject(n, gL);
            }
            return 0;
        }
        return n2;
    }

    public boolean isBoundBufferObjectKnown(int n) {
        return this.bindingMap.get(GLBufferStateTracker.box(n)) != null;
    }

    public void clearBufferObjectState() {
        this.bindingMap.clear();
    }

    private static Integer box(int n) {
        switch (n) {
            case 0: {
                return zero;
            }
            case 34962: {
                return arrayBufferEnum;
            }
            case 34963: {
                return elementArrayBufferEnum;
            }
            case 35051: {
                return pixelPackBufferEnum;
            }
            case 35052: {
                return pixelUnpackBufferEnum;
            }
        }
        return new Integer(n);
    }
}

