/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.gluegen.runtime.ProcAddressTable;
import com.sun.gluegen.runtime.opengl.GLExtensionNames;
import com.sun.gluegen.runtime.opengl.GLProcAddressHelper;
import com.sun.nativewindow.impl.NWReflection;
import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.ExtensionAvailabilityCache;
import com.sun.opengl.impl.GLBufferSizeTracker;
import com.sun.opengl.impl.GLBufferStateTracker;
import com.sun.opengl.impl.GLContextLock;
import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.GLStateTracker;
import com.sun.opengl.impl.GLWorkerThread;
import java.nio.ByteBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public abstract class GLContextImpl
extends GLContext {
    protected GLContextLock lock = new GLContextLock();
    protected static final boolean DEBUG = Debug.debug("GLContext");
    protected static final boolean VERBOSE = Debug.verbose();
    protected boolean optimizationEnabled = Debug.isPropertyDefined("jogl.GLContext.optimize", true);
    protected ExtensionAvailabilityCache extensionAvailability;
    private ProcAddressTable glProcAddressTable;
    private GLBufferSizeTracker bufferSizeTracker;
    private GLBufferStateTracker bufferStateTracker = new GLBufferStateTracker();
    private GLStateTracker glStateTracker = new GLStateTracker();
    protected GLDrawableImpl drawable;
    protected GLDrawableImpl drawableRead;
    protected GL gl;
    protected int currentSwapInterval = -1;

    public GLContextImpl(GLDrawableImpl gLDrawableImpl, GLDrawableImpl gLDrawableImpl2, GLContext gLContext) {
        this.extensionAvailability = new ExtensionAvailabilityCache(this);
        if (gLContext != null) {
            GLContextShareSet.registerSharing(this, gLContext);
        }
        GLContextShareSet.registerForBufferObjectSharing(gLContext, this);
        this.setGL(this.createGL(gLDrawableImpl.getGLProfile()));
        this.drawable = gLDrawableImpl;
        this.setGLDrawableRead(gLDrawableImpl2);
    }

    public GLContextImpl(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        this(gLDrawableImpl, null, gLContext);
    }

    public void setGLDrawableRead(GLDrawable gLDrawable) {
        boolean bl = this.lock.isHeld();
        if (bl) {
            this.release();
        }
        GLDrawableImpl gLDrawableImpl = this.drawableRead = null != gLDrawable ? (GLDrawableImpl)gLDrawable : this.drawable;
        if (bl) {
            this.makeCurrent();
        }
    }

    public GLDrawable getGLDrawable() {
        return this.drawable;
    }

    public GLDrawable getGLDrawableRead() {
        return this.drawableRead;
    }

    public GLDrawableImpl getDrawableImpl() {
        return (GLDrawableImpl)this.getGLDrawable();
    }

    public int makeCurrent() throws GLException {
        GLContext gLContext = GLContextImpl.getCurrent();
        if (gLContext != null) {
            if (gLContext == this) {
                this.update();
                return 1;
            }
            gLContext.release();
        }
        if (GLWorkerThread.isStarted() && !GLWorkerThread.isWorkerThread()) {
            GLWorkerThread.invokeLater(new Runnable(){

                public void run() {
                }
            });
        }
        this.lock.lock();
        int n = 0;
        try {
            n = this.makeCurrentImpl();
        }
        catch (GLException gLException) {
            this.lock.unlock();
            throw gLException;
        }
        if (n == 0) {
            this.lock.unlock();
        } else {
            if (n == 2) {
                this.getGLDrawable().getGLProfile().verifyEquality(this.gl.getGLProfile());
            }
            GLContextImpl.setCurrent(this);
        }
        return n;
    }

    protected abstract int makeCurrentImpl() throws GLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws GLException {
        if (!this.lock.isHeld()) {
            throw new GLException("Context not current on current thread");
        }
        GLContextImpl.setCurrent(null);
        try {
            this.releaseImpl();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void releaseImpl() throws GLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.lock.isHeld()) {
            this.release();
        }
        this.lock.lock();
        try {
            if (this.bufferSizeTracker != null) {
                this.bufferSizeTracker.clearCachedBufferSizes();
            }
            if (this.bufferStateTracker != null) {
                this.bufferStateTracker.clearBufferObjectState();
            }
            if (this.glStateTracker != null) {
                this.glStateTracker.clearStates();
            }
            this.destroyImpl();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void destroyImpl() throws GLException;

    protected void update() throws GLException {
    }

    public boolean isSynchronized() {
        return !this.lock.getFailFastMode();
    }

    public void setSynchronized(boolean bl) {
        this.lock.setFailFastMode(!bl);
    }

    public final GL getGL() {
        return this.gl;
    }

    public GL setGL(GL gL) {
        if (DEBUG) {
            String string = null != this.gl ? this.gl.getClass().toString() + ", " + this.gl.toString() : new String("<null>");
            String string2 = null != gL ? gL.getClass().toString() + ", " + gL.toString() : new String("<null>");
            Exception exception = new Exception("setGL: " + Thread.currentThread() + ", " + string + " -> " + string2);
            exception.printStackTrace();
        }
        this.gl = gL;
        return gL;
    }

    public abstract Object getPlatformGLExtensions();

    private Object createInstance(GLProfile gLProfile, String string, Class[] classArray, Object[] objectArray) {
        return NWReflection.createInstance(gLProfile.getGLImplBaseClassName() + string, classArray, objectArray);
    }

    protected GL createGL(GLProfile gLProfile) {
        GL gL = (GL)this.createInstance(gLProfile, "Impl", new Class[]{GLProfile.class, GLContextImpl.class}, new Object[]{gLProfile, this});
        return gL;
    }

    public final ProcAddressTable getGLProcAddressTable() {
        return this.glProcAddressTable;
    }

    public abstract ProcAddressTable getPlatformExtProcAddressTable();

    public abstract void bindPbufferToTexture();

    public abstract void releasePbufferFromTexture();

    public abstract ByteBuffer glAllocateMemoryNV(int var1, float var2, float var3, float var4);

    public void setSwapInterval(int n) {
        GLContext gLContext = GLContextImpl.getCurrent();
        if (gLContext != this) {
            throw new GLException("This context is not current. Current context: " + gLContext + ", this context " + this);
        }
        this.setSwapIntervalImpl(n);
    }

    public int getSwapInterval() {
        return this.currentSwapInterval;
    }

    protected void setSwapIntervalImpl(int n) {
    }

    protected abstract String mapToRealGLFunctionName(String var1);

    protected abstract String mapToRealGLExtensionName(String var1);

    protected void resetProcAddressTable(Object object) {
        GLProcAddressHelper.resetProcAddressTable(object, this.getDrawableImpl().getDynamicLookupHelper());
    }

    public abstract boolean isCreated();

    protected void setGLFunctionAvailability(boolean bl) {
        if (null != this.gl && null != this.glProcAddressTable && !bl) {
            return;
        }
        if (null == this.gl || bl) {
            this.setGL(this.createGL(this.getGLDrawable().getGLProfile()));
        }
        this.updateGLProcAddressTable();
    }

    protected void updateGLProcAddressTable() {
        if (null == this.gl) {
            throw new GLException("setGLFunctionAvailability not called yet");
        }
        if (DEBUG) {
            System.err.println(GLContextImpl.getThreadName() + ": !!! Initializing OpenGL extension address table for " + this);
        }
        if (this.glProcAddressTable == null) {
            this.glProcAddressTable = (ProcAddressTable)this.createInstance(this.gl.getGLProfile(), "ProcAddressTable", new Class[0], null);
        }
        this.resetProcAddressTable(this.getGLProcAddressTable());
        this.extensionAvailability.reset();
    }

    public boolean isFunctionAvailable(String string) {
        Object object;
        if (this.isCreated()) {
            object = this.getGLProcAddressTable();
            try {
                if (0L != object.getAddressFor(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            object = this.getPlatformExtProcAddressTable();
            try {
                if (0L != object.getAddressFor(string)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = this.getDrawableImpl().getDynamicLookupHelper();
        String string2 = GLExtensionNames.normalizeVEN(GLExtensionNames.normalizeARB(string, true), true);
        long l = 0L;
        int n = GLExtensionNames.getFuncNamePermutationNumber(string2);
        for (int i = 0; 0L == l && i < n; ++i) {
            String string3 = GLExtensionNames.getFuncNamePermutation(string2, i);
            try {
                l = object.dynamicLookupFunction(string3);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L != l;
    }

    public boolean isExtensionAvailable(String string) {
        return this.extensionAvailability.isExtensionAvailable(this.mapToRealGLExtensionName(string));
    }

    public String getPlatformExtensionsString() {
        return this.extensionAvailability.getPlatformExtensionsString();
    }

    public String getGLExtensions() {
        return this.extensionAvailability.getGLExtensions();
    }

    public int getMajorVersion() {
        return this.extensionAvailability.getMajorVersion();
    }

    public int getMinorVersion() {
        return this.extensionAvailability.getMinorVersion();
    }

    public boolean isExtensionCacheInitialized() {
        return this.extensionAvailability.isInitialized();
    }

    public int getFloatingPointMode() throws GLException {
        throw new GLException("Not supported on non-pbuffer contexts");
    }

    public abstract boolean offscreenImageNeedsVerticalFlip();

    public abstract int getOffscreenContextPixelDataType();

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    public static String toHexString(long l) {
        return "0x" + Long.toHexString(l);
    }

    public void setBufferSizeTracker(GLBufferSizeTracker gLBufferSizeTracker) {
        this.bufferSizeTracker = gLBufferSizeTracker;
    }

    public GLBufferSizeTracker getBufferSizeTracker() {
        return this.bufferSizeTracker;
    }

    public GLBufferStateTracker getBufferStateTracker() {
        return this.bufferStateTracker;
    }

    public GLStateTracker getGLStateTracker() {
        return this.glStateTracker;
    }

    public boolean isOptimizable() {
        return this.optimizationEnabled;
    }

    public boolean hasWaiters() {
        return this.lock.hasWaiters();
    }
}

