/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.macosx.cgl;

import com.sun.gluegen.runtime.ProcAddressTable;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.macosx.cgl.CGL;
import com.sun.opengl.impl.macosx.cgl.CGLExt;
import com.sun.opengl.impl.macosx.cgl.CGLExtImpl;
import com.sun.opengl.impl.macosx.cgl.CGLExtProcAddressTable;
import com.sun.opengl.impl.macosx.cgl.MacOSXCGLGraphicsConfiguration;
import java.nio.ByteBuffer;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public abstract class MacOSXCGLContext
extends GLContextImpl {
    protected long nsContext;
    protected long cglContext;
    private CGLExt cglExt;
    private CGLExtProcAddressTable cglExtProcAddressTable;

    public MacOSXCGLContext(GLDrawableImpl gLDrawableImpl, GLDrawableImpl gLDrawableImpl2, GLContext gLContext) {
        super(gLDrawableImpl, gLDrawableImpl2, gLContext);
    }

    public MacOSXCGLContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        this(gLDrawableImpl, null, gLContext);
    }

    public Object getPlatformGLExtensions() {
        return this.getCGLExt();
    }

    public CGLExt getCGLExt() {
        if (this.cglExt == null) {
            this.cglExt = new CGLExtImpl(this);
        }
        return this.cglExt;
    }

    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.getCGLExtProcAddressTable();
    }

    public final CGLExtProcAddressTable getCGLExtProcAddressTable() {
        return this.cglExtProcAddressTable;
    }

    protected String mapToRealGLFunctionName(String string) {
        return string;
    }

    protected String mapToRealGLExtensionName(String string) {
        return string;
    }

    protected abstract boolean create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean create(boolean bl, boolean bl2) {
        MacOSXCGLContext macOSXCGLContext = (MacOSXCGLContext)GLContextShareSet.getShareContext(this);
        long l = 0L;
        if (macOSXCGLContext != null && (l = macOSXCGLContext.getNSContext()) == 0L) {
            throw new GLException("GLContextShareSet returned an invalid OpenGL context");
        }
        MacOSXCGLGraphicsConfiguration macOSXCGLGraphicsConfiguration = (MacOSXCGLGraphicsConfiguration)this.drawable.getNativeWindow().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        GLCapabilities gLCapabilities = (GLCapabilities)macOSXCGLGraphicsConfiguration.getRequestedCapabilities();
        GLProfile gLProfile = gLCapabilities.getGLProfile();
        if (gLProfile.isGL3()) {
            throw new GLException("GL3 profile currently not supported on MacOSX, due to the lack of a OpenGL 3.1 implementation");
        }
        GLCapabilities gLCapabilities2 = (GLCapabilities)gLCapabilities.clone();
        gLCapabilities2.setPBuffer(bl);
        gLCapabilities2.setPbufferFloatingPointBuffers(bl2);
        long l2 = MacOSXCGLGraphicsConfiguration.GLCapabilities2NSPixelFormat(gLCapabilities2);
        if (l2 == 0L) {
            throw new GLException("Unable to allocate pixel format with requested GLCapabilities");
        }
        macOSXCGLGraphicsConfiguration.setChosenPixelFormat(l2);
        try {
            int[] nArray = new int[1];
            this.nsContext = CGL.createContext(l, this.drawable.getNativeWindow().getSurfaceHandle(), l2, nArray, 0);
            if (this.nsContext == 0L) {
                if (nArray[0] == 1) {
                    if (DEBUG) {
                        System.err.println("!!! View not ready for " + this.getClass().getName());
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                throw new GLException("Error creating NSOpenGLContext with requested pixel format");
            }
            if (!bl && !gLCapabilities2.isBackgroundOpaque()) {
                CGL.setContextOpacity(this.nsContext, 0);
            }
            GLCapabilities gLCapabilities3 = MacOSXCGLGraphicsConfiguration.NSPixelFormat2GLCapabilities(gLProfile, l2);
            macOSXCGLGraphicsConfiguration.setChosenCapabilities(gLCapabilities3);
        }
        finally {
            CGL.deletePixelFormat(l2);
        }
        if (!CGL.makeCurrentContext(this.nsContext)) {
            throw new GLException("Error making nsContext current");
        }
        this.setGLFunctionAvailability(true);
        GLContextShareSet.contextCreated(this);
        return true;
    }

    protected int makeCurrentImpl() throws GLException {
        if (0L == this.cglContext && this.drawable.getNativeWindow().getSurfaceHandle() == 0L) {
            if (DEBUG) {
                System.err.println("drawable not properly initialized");
            }
            return 0;
        }
        boolean bl = false;
        if (0L == this.cglContext && 0L == this.nsContext) {
            if (!this.create()) {
                return 0;
            }
            if (DEBUG) {
                System.err.println("!!! Created OpenGL context " + MacOSXCGLContext.toHexString(this.nsContext) + " for " + this.getClass().getName());
            }
            bl = true;
        }
        if (0L != this.cglContext) {
            if (0 != CGL.CGLSetCurrentContext(this.cglContext)) {
                throw new GLException("Error making cglContext current");
            }
        } else if (!CGL.makeCurrentContext(this.nsContext)) {
            throw new GLException("Error making nsContext current");
        }
        if (bl) {
            this.setGLFunctionAvailability(false);
            return 2;
        }
        return 1;
    }

    protected void releaseImpl() throws GLException {
        if (0L != this.cglContext) {
            CGL.CGLReleaseContext(this.cglContext);
        } else if (!CGL.clearCurrentContext(this.nsContext)) {
            throw new GLException("Error freeing OpenGL nsContext");
        }
    }

    protected void destroyImpl() throws GLException {
        boolean bl = this.isCreated();
        if (0L != this.cglContext) {
            if (0 != CGL.CGLDestroyContext(this.cglContext)) {
                throw new GLException("Unable to delete OpenGL cglContext");
            }
            if (DEBUG) {
                System.err.println("!!! Destroyed OpenGL cglContext " + this.cglContext);
            }
            this.cglContext = 0L;
            GLContextShareSet.contextDestroyed(this);
        } else if (0L != this.nsContext) {
            if (!CGL.deleteContext(this.nsContext)) {
                throw new GLException("Unable to delete OpenGL nsContext");
            }
            if (DEBUG) {
                System.err.println("!!! Destroyed OpenGL nsContext " + this.nsContext);
            }
            this.nsContext = 0L;
        }
        if (bl) {
            GLContextShareSet.contextDestroyed(this);
        }
    }

    public boolean isCreated() {
        return 0L != this.cglContext || 0L != this.nsContext;
    }

    public void copy(GLContext gLContext, int n) throws GLException {
        long l = this.getCGLContext();
        long l2 = 0L;
        if (0L != l) {
            l2 = ((MacOSXCGLContext)gLContext).getCGLContext();
            if (l2 == 0L) {
                throw new GLException("Source OpenGL cglContext has not been created ; Destination has a cglContext.");
            }
            CGL.CGLCopyContext(l2, l, n);
        } else {
            l = this.getNSContext();
            l2 = ((MacOSXCGLContext)gLContext).getNSContext();
            if (l2 == 0L) {
                throw new GLException("Source OpenGL nsContext has not been created");
            }
            if (l == 0L) {
                throw new GLException("Destination OpenGL nsContext has not been created");
            }
            CGL.copyContext(l, l2, n);
        }
    }

    protected void updateGLProcAddressTable() {
        if (DEBUG) {
            System.err.println("!!! Initializing CGL extension address table");
        }
        if (this.cglExtProcAddressTable == null) {
            this.cglExtProcAddressTable = new CGLExtProcAddressTable();
        }
        this.resetProcAddressTable(this.getCGLExtProcAddressTable());
        super.updateGLProcAddressTable();
    }

    public String getPlatformExtensionsString() {
        return "";
    }

    protected void setSwapIntervalImpl(int n) {
        if (0L != this.cglContext) {
            int[] nArray = new int[]{n};
            CGL.CGLSetParameter(this.cglContext, 222, nArray, 0);
        } else if (0L != this.nsContext) {
            CGL.setSwapInterval(this.nsContext, n);
        } else {
            throw new GLException("OpenGL context not current");
        }
        this.currentSwapInterval = n;
    }

    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        throw new GLException("Not yet implemented");
    }

    public boolean isFunctionAvailable(String string) {
        return super.isFunctionAvailable(string);
    }

    public boolean isExtensionAvailable(String string) {
        if (string.equals("GL_ARB_pbuffer") || string.equals("GL_ARB_pixel_format")) {
            return true;
        }
        return super.isExtensionAvailable(string);
    }

    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    public abstract void setOpenGLMode(int var1);

    public abstract int getOpenGLMode();

    public long getCGLContext() {
        return this.cglContext;
    }

    public long getNSContext() {
        return this.nsContext;
    }
}

