/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.macosx.cgl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.macosx.cgl.CGL;
import com.sun.opengl.impl.macosx.cgl.MacOSXCGLContext;
import com.sun.opengl.impl.macosx.cgl.MacOSXPbufferCGLDrawable;
import java.security.AccessController;
import java.util.StringTokenizer;
import javax.media.nativewindow.DefaultGraphicsConfiguration;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class MacOSXPbufferCGLContext
extends MacOSXCGLContext {
    protected MacOSXPbufferCGLDrawable drawable;
    private int textureTarget;
    private int texture;
    private static boolean isTigerOrLater;
    private boolean haveSetOpenGLMode = false;
    private int openGLMode = 1;
    protected Impl impl;

    public MacOSXPbufferCGLContext(MacOSXPbufferCGLDrawable macOSXPbufferCGLDrawable, GLContext gLContext) {
        super(macOSXPbufferCGLDrawable, gLContext);
        this.drawable = macOSXPbufferCGLDrawable;
        this.initOpenGLImpl();
    }

    public void bindPbufferToTexture() {
        GL gL = this.getGL();
        gL.glBindTexture(this.textureTarget, this.texture);
        CGL.setContextTextureImageToPBuffer(this.nsContext, this.drawable.getPbuffer(), 1028);
    }

    public void releasePbufferFromTexture() {
    }

    protected int makeCurrentImpl() throws GLException {
        if (this.drawable.getPbuffer() == 0L) {
            if (DEBUG) {
                System.err.println("Pbuffer not instantiated yet for " + this);
            }
            return 0;
        }
        if (this.getOpenGLMode() != this.drawable.getOpenGLMode()) {
            this.setOpenGLMode(this.drawable.getOpenGLMode());
        }
        boolean bl = false;
        if (this.nsContext == 0L) {
            if (!this.create()) {
                return 0;
            }
            if (DEBUG) {
                System.err.println("!!! Created OpenGL context " + MacOSXPbufferCGLContext.toHexString(this.nsContext) + " for " + this.getClass().getName());
            }
            bl = true;
        }
        if (!this.impl.makeCurrent(this.nsContext)) {
            throw new GLException("Error making nsContext current");
        }
        if (bl) {
            boolean bl2;
            this.setGLFunctionAvailability(false);
            DefaultGraphicsConfiguration defaultGraphicsConfiguration = (DefaultGraphicsConfiguration)this.drawable.getNativeWindow().getGraphicsConfiguration().getNativeGraphicsConfiguration();
            GLCapabilities gLCapabilities = (GLCapabilities)defaultGraphicsConfiguration.getChosenCapabilities();
            GL gL = this.getGL();
            boolean bl3 = bl2 = gL.isGL2() && gLCapabilities.getPbufferRenderToTextureRectangle();
            if (bl2 && !gL.isExtensionAvailable("GL_EXT_texture_rectangle")) {
                System.err.println("MacOSXPbufferCGLContext: WARNING: GL_EXT_texture_rectangle extension not supported; skipping requested render_to_texture_rectangle support for pbuffer");
                bl2 = false;
            }
            this.textureTarget = bl2 ? 34037 : 3553;
            int[] nArray = new int[1];
            gL.glGenTextures(1, nArray, 0);
            this.texture = nArray[0];
            gL.glBindTexture(this.textureTarget, this.texture);
            gL.glTexParameteri(this.textureTarget, 10241, 9728);
            gL.glTexParameteri(this.textureTarget, 10240, 9728);
            gL.glTexParameteri(this.textureTarget, 10242, 33071);
            gL.glTexParameteri(this.textureTarget, 10243, 33071);
            gL.glCopyTexImage2D(this.textureTarget, 0, 6407, 0, 0, this.drawable.getWidth(), this.drawable.getHeight(), 0);
            return 2;
        }
        return 1;
    }

    protected void releaseImpl() throws GLException {
        if (!this.impl.release(this.nsContext)) {
            throw new GLException("Error releasing OpenGL nsContext");
        }
    }

    protected void destroyImpl() throws GLException {
        if (this.nsContext != 0L) {
            if (!this.impl.destroy(this.nsContext)) {
                throw new GLException("Unable to delete OpenGL context");
            }
            if (DEBUG) {
                System.err.println("!!! Destroyed OpenGL context " + this.nsContext);
            }
            this.nsContext = 0L;
            GLContextShareSet.contextDestroyed(this);
        }
    }

    protected void setSwapIntervalImpl(int n) {
        if (this.nsContext == 0L) {
            throw new GLException("OpenGL context not current");
        }
        this.impl.setSwapInterval(this.nsContext, n);
        this.currentSwapInterval = this.impl.getSwapInterval();
    }

    public int getFloatingPointMode() {
        return 1;
    }

    protected boolean create() {
        DefaultGraphicsConfiguration defaultGraphicsConfiguration = (DefaultGraphicsConfiguration)this.drawable.getNativeWindow().getGraphicsConfiguration().getNativeGraphicsConfiguration();
        GLCapabilities gLCapabilities = (GLCapabilities)defaultGraphicsConfiguration.getChosenCapabilities();
        if (gLCapabilities.getPbufferFloatingPointBuffers() && !isTigerOrLater) {
            throw new GLException("Floating-point pbuffers supported only on OS X 10.4 or later");
        }
        MacOSXCGLContext macOSXCGLContext = (MacOSXCGLContext)GLContextShareSet.getShareContext(this);
        if (macOSXCGLContext != null) {
            this.setOpenGLMode(macOSXCGLContext.getOpenGLMode());
        }
        this.nsContext = this.impl.create();
        if (!this.impl.makeCurrent(this.nsContext)) {
            throw new GLException("Error making nsContext current");
        }
        this.setGLFunctionAvailability(true);
        return true;
    }

    public void setOpenGLMode(int n) {
        if (n == this.openGLMode) {
            return;
        }
        if (this.haveSetOpenGLMode) {
            throw new GLException("Can't switch between using NSOpenGLPixelBuffer and CGLPBufferObj more than once");
        }
        this.destroyImpl();
        this.drawable.setOpenGLMode(n);
        this.openGLMode = n;
        this.haveSetOpenGLMode = true;
        if (DEBUG) {
            System.err.println("Switching PBuffer context mode to " + (n == 1 ? "NSOPENGL_MODE" : "CGL_MODE"));
        }
        this.initOpenGLImpl();
    }

    public int getOpenGLMode() {
        return this.openGLMode;
    }

    private void initOpenGLImpl() {
        switch (this.openGLMode) {
            case 1: {
                this.impl = new NSOpenGLImpl();
                break;
            }
            case 2: {
                this.impl = new CGLImpl();
                break;
            }
            default: {
                throw new InternalError("Illegal implementation mode " + this.openGLMode);
            }
        }
    }

    static {
        String string = Debug.getProperty("os.version", false, AccessController.getContext());
        StringTokenizer stringTokenizer = new StringTokenizer(string, ". ");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        isTigerOrLater = n > 10 || n2 > 3;
    }

    class CGLImpl
    implements Impl {
        CGLImpl() {
        }

        public long create() {
            long[] lArray;
            long[] lArray2;
            int n;
            Object object;
            MacOSXCGLContext macOSXCGLContext = (MacOSXCGLContext)GLContextShareSet.getShareContext(MacOSXPbufferCGLContext.this);
            long l = 0L;
            if (macOSXCGLContext != null) {
                if (macOSXCGLContext instanceof MacOSXPbufferCGLContext) {
                    object = (MacOSXPbufferCGLContext)macOSXCGLContext;
                    ((MacOSXPbufferCGLContext)object).setOpenGLMode(2);
                } else if (macOSXCGLContext.getOpenGLMode() != 2) {
                    throw new GLException("Can't share between NSOpenGLContexts and CGLContextObjs");
                }
                l = macOSXCGLContext.getNSContext();
            }
            object = new int[256];
            int n2 = 0;
            object[n2++] = 90;
            DefaultGraphicsConfiguration defaultGraphicsConfiguration = (DefaultGraphicsConfiguration)MacOSXPbufferCGLContext.this.drawable.getNativeWindow().getGraphicsConfiguration().getNativeGraphicsConfiguration();
            GLCapabilities gLCapabilities = (GLCapabilities)defaultGraphicsConfiguration.getChosenCapabilities();
            if (gLCapabilities.getPbufferFloatingPointBuffers()) {
                object[n2++] = 58;
            }
            if (gLCapabilities.getDoubleBuffered()) {
                object[n2++] = 5;
            }
            if (gLCapabilities.getStereo()) {
                object[n2++] = 6;
            }
            object[n2++] = 8;
            object[n2++] = gLCapabilities.getRedBits() + gLCapabilities.getGreenBits() + gLCapabilities.getBlueBits();
            object[n2++] = 11;
            object[n2++] = gLCapabilities.getAlphaBits();
            object[n2++] = 12;
            object[n2++] = gLCapabilities.getDepthBits();
            object[n2++] = 13;
            object[n2++] = gLCapabilities.getStencilBits();
            object[n2++] = 14;
            object[n2++] = gLCapabilities.getAccumRedBits() + gLCapabilities.getAccumGreenBits() + gLCapabilities.getAccumBlueBits() + gLCapabilities.getAccumAlphaBits();
            if (gLCapabilities.getSampleBuffers()) {
                object[n2++] = 55;
                object[n2++] = true;
                object[n2++] = 56;
                object[n2++] = gLCapabilities.getNumSamples();
            }
            if ((n = CGL.CGLChoosePixelFormat((int[])object, 0, lArray2 = new long[1], 0, lArray = new long[1], 0)) != 0) {
                throw new GLException("Error code " + n + " while choosing pixel format");
            }
            long[] lArray3 = new long[1];
            if (DEBUG) {
                System.err.println("Share context for CGL-based pbuffer context is " + GLContextImpl.toHexString(l));
            }
            n = CGL.CGLCreateContext(lArray2[0], l, lArray3, 0);
            CGL.CGLDestroyPixelFormat(lArray2[0]);
            if (n != 0) {
                throw new GLException("Error code " + n + " while creating context");
            }
            n = CGL.CGLSetPBuffer(lArray3[0], MacOSXPbufferCGLContext.this.drawable.getPbuffer(), 0L, 0L, 0L);
            if (n != 0) {
                throw new GLException("Error code " + n + " while attaching context to pbuffer");
            }
            return lArray3[0];
        }

        public boolean destroy(long l) {
            return CGL.CGLDestroyContext(l) == 0;
        }

        public boolean makeCurrent(long l) {
            return CGL.CGLSetCurrentContext(l) == 0;
        }

        public boolean release(long l) {
            return CGL.CGLSetCurrentContext(0L) == 0;
        }

        public void setSwapInterval(long l, int n) {
        }

        public int getSwapInterval() {
            return 0;
        }
    }

    static interface Impl {
        public long create();

        public boolean destroy(long var1);

        public boolean makeCurrent(long var1);

        public boolean release(long var1);

        public void setSwapInterval(long var1, int var3);

        public int getSwapInterval();
    }

    class NSOpenGLImpl
    implements Impl {
        private int currentSwapInterval = 0;

        NSOpenGLImpl() {
        }

        public long create() {
            DefaultGraphicsConfiguration defaultGraphicsConfiguration = (DefaultGraphicsConfiguration)MacOSXPbufferCGLContext.this.drawable.getNativeWindow().getGraphicsConfiguration().getNativeGraphicsConfiguration();
            GLCapabilities gLCapabilities = (GLCapabilities)defaultGraphicsConfiguration.getChosenCapabilities();
            if (gLCapabilities.getPbufferFloatingPointBuffers() && !isTigerOrLater) {
                throw new GLException("Floating-point pbuffers supported only on OS X 10.4 or later");
            }
            if (!MacOSXPbufferCGLContext.this.create(true, gLCapabilities.getPbufferFloatingPointBuffers())) {
                throw new GLException("Error creating context for pbuffer");
            }
            CGL.setContextPBuffer(MacOSXPbufferCGLContext.this.nsContext, MacOSXPbufferCGLContext.this.drawable.getPbuffer());
            return MacOSXPbufferCGLContext.this.nsContext;
        }

        public boolean destroy(long l) {
            return CGL.deleteContext(l);
        }

        public boolean makeCurrent(long l) {
            return CGL.makeCurrentContext(l);
        }

        public boolean release(long l) {
            return CGL.clearCurrentContext(l);
        }

        public void setSwapInterval(long l, int n) {
            CGL.setSwapInterval(l, n);
            this.currentSwapInterval = n;
        }

        public int getSwapInterval() {
            return this.currentSwapInterval;
        }
    }
}

