/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.macosx.cgl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.macosx.cgl.CGL;
import com.sun.opengl.impl.macosx.cgl.MacOSXCGLDrawable;
import com.sun.opengl.impl.macosx.cgl.MacOSXPbufferCGLContext;
import javax.media.nativewindow.DefaultGraphicsConfiguration;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.SurfaceChangeable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class MacOSXPbufferCGLDrawable
extends MacOSXCGLDrawable {
    private static final boolean DEBUG = Debug.debug("MacOSXPbufferCGLDrawable");
    private int textureTarget;
    private int texture;
    protected long pBuffer;
    private boolean haveSetOpenGLMode = false;
    private int openGLMode = 1;
    protected Impl impl;

    public MacOSXPbufferCGLDrawable(GLDrawableFactory gLDrawableFactory, NativeWindow nativeWindow) {
        super(gLDrawableFactory, nativeWindow, true);
        if (DEBUG) {
            System.out.println("Pbuffer config: " + this.getNativeWindow().getGraphicsConfiguration().getNativeGraphicsConfiguration());
        }
        this.initOpenGLImpl();
        this.createPbuffer();
        if (DEBUG) {
            System.err.println("Created pbuffer " + this);
        }
    }

    protected void setRealizedImpl() {
        if (this.realized) {
            this.createPbuffer();
        } else {
            this.destroy();
        }
    }

    public GLContext createContext(GLContext gLContext) {
        return new MacOSXPbufferCGLContext(this, gLContext);
    }

    public void destroy() {
        if (this.pBuffer != 0L) {
            NativeWindow nativeWindow = this.getNativeWindow();
            this.impl.destroy(this.pBuffer);
            this.pBuffer = 0L;
            ((SurfaceChangeable)((Object)nativeWindow)).setSurfaceHandle(0L);
            if (DEBUG) {
                System.err.println("Destroyed pbuffer: " + this.pBuffer);
            }
        }
    }

    public long getPbuffer() {
        return this.pBuffer;
    }

    protected void swapBuffersImpl() {
        if (DEBUG) {
            System.err.println("unhandled swapBuffersImpl() called for: " + this);
        }
    }

    private void createPbuffer() {
        int n;
        int n2;
        NativeWindow nativeWindow;
        block7: {
            block8: {
                nativeWindow = this.getNativeWindow();
                DefaultGraphicsConfiguration defaultGraphicsConfiguration = (DefaultGraphicsConfiguration)nativeWindow.getGraphicsConfiguration().getNativeGraphicsConfiguration();
                GLCapabilities gLCapabilities = (GLCapabilities)defaultGraphicsConfiguration.getChosenCapabilities();
                GLProfile gLProfile = gLCapabilities.getGLProfile();
                if (gLProfile.isGL2() && gLCapabilities.getPbufferRenderToTextureRectangle()) {
                    n2 = 34037;
                } else {
                    n = this.getNextPowerOf2(this.getWidth());
                    int n3 = this.getNextPowerOf2(this.getHeight());
                    ((SurfaceChangeable)((Object)nativeWindow)).setSize(n, n3);
                    n2 = 3553;
                }
                n = 6408;
                if (!gLCapabilities.getPbufferFloatingPointBuffers()) break block7;
                if (!gLProfile.isGL2()) break block8;
                switch (gLCapabilities.getRedBits()) {
                    case 16: {
                        n = 34842;
                        break block7;
                    }
                    case 32: {
                        n = 34836;
                        break block7;
                    }
                    default: {
                        throw new GLException("Invalid floating-point bit depth (only 16 and 32 supported)");
                    }
                }
            }
            n = 6408;
        }
        this.pBuffer = this.impl.create(n2, n, this.getWidth(), this.getHeight());
        if (this.pBuffer == 0L) {
            throw new GLException("pbuffer creation error: CGL.createPBuffer() failed");
        }
        ((SurfaceChangeable)((Object)nativeWindow)).setSurfaceHandle(this.pBuffer);
    }

    private int getNextPowerOf2(int n) {
        if ((n - 1 & n) == 0) {
            return n;
        }
        int n2 = 0;
        while (n > 0) {
            n >>= 1;
            ++n2;
        }
        return 1 << n2;
    }

    public void setOpenGLMode(int n) {
        if (n == this.openGLMode) {
            return;
        }
        if (this.haveSetOpenGLMode) {
            throw new GLException("Can't switch between using NSOpenGLPixelBuffer and CGLPBufferObj more than once");
        }
        this.destroy();
        this.openGLMode = n;
        this.haveSetOpenGLMode = true;
        if (DEBUG) {
            System.err.println("Switching PBuffer drawable mode to " + (n == 1 ? "NSOPENGL_MODE" : "CGL_MODE"));
        }
        this.initOpenGLImpl();
        this.createPbuffer();
    }

    public int getOpenGLMode() {
        return this.openGLMode;
    }

    private void initOpenGLImpl() {
        switch (this.openGLMode) {
            case 1: {
                this.impl = new NSOpenGLImpl();
                break;
            }
            case 2: {
                this.impl = new CGLImpl();
                break;
            }
            default: {
                throw new InternalError("Illegal implementation mode " + this.openGLMode);
            }
        }
    }

    class CGLImpl
    implements Impl {
        CGLImpl() {
        }

        public long create(int n, int n2, int n3, int n4) {
            long[] lArray = new long[1];
            int n5 = CGL.CGLCreatePBuffer(n3, n4, n, n2, 0L, lArray, 0);
            if (n5 != 0) {
                throw new GLException("Error creating CGL-based pbuffer: error code " + n5);
            }
            return lArray[0];
        }

        public void destroy(long l) {
            int n = CGL.CGLDestroyPBuffer(l);
            if (n != 0) {
                throw new GLException("Error destroying CGL-based pbuffer: error code " + n);
            }
        }
    }

    static interface Impl {
        public long create(int var1, int var2, int var3, int var4);

        public void destroy(long var1);
    }

    class NSOpenGLImpl
    implements Impl {
        NSOpenGLImpl() {
        }

        public long create(int n, int n2, int n3, int n4) {
            return CGL.createPBuffer(n, n2, n3, n4);
        }

        public void destroy(long l) {
            CGL.destroyPBuffer(l);
        }
    }
}

